/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Lifecycle;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.logging.Log;
import org.jgroups.protocols.TP;
import org.jgroups.util.DirectExecutor;
import org.jgroups.util.ShutdownRejectedExecutionHandler;
import org.jgroups.util.ThreadCreator;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class ThreadPool
implements Lifecycle {
    protected Executor thread_pool;
    protected final TP tp;
    protected final AtomicInteger thread_dumps = new AtomicInteger();
    @Property(description="Whether or not the thread pool is enabled. If false, tasks will be run on the caller's thread")
    protected boolean enabled = true;
    @Property(description="Minimum thread pool size for the thread pool")
    protected int min_threads;
    @Property(description="Maximum thread pool size for the thread pool")
    protected int max_threads = 100;
    @Property(description="Timeout (ms) to remove idle threads from the pool", type=AttributeType.TIME)
    protected long keep_alive_time = 30000L;
    @Property(description="The number of times a thread pool needs to be full before a thread dump is logged")
    protected int thread_dumps_threshold = 1;
    @Property(description="Path to which the thread dump will be written. Ignored if null", systemProperty={"jgroups.threaddump.path"})
    protected String thread_dump_path;
    @Property(description="Increases max_threads by the view size + delta if enabled (https://issues.redhat.com/browse/JGRP-2655)")
    protected boolean increase_max_size_dynamically = true;
    @Property(description="Added to the view size when the pool is increased dynamically")
    protected int delta = 10;

    public ThreadPool(TP tp) {
        this.tp = Objects.requireNonNull(tp);
    }

    public Executor getThreadPool() {
        return this.thread_pool;
    }

    public ThreadPool setThreadPool(Executor thread_pool) {
        if (this.thread_pool != null) {
            this.destroy();
        }
        this.thread_pool = thread_pool;
        return this;
    }

    public ThreadPool setThreadFactory(ThreadFactory factory) {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setThreadFactory(factory);
        }
        return this;
    }

    public boolean isShutdown() {
        return this.thread_pool instanceof ExecutorService && ((ExecutorService)this.thread_pool).isShutdown();
    }

    public int getMinThreads() {
        return this.min_threads;
    }

    public ThreadPool setMinThreads(int size) {
        this.min_threads = size;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setCorePoolSize(size);
        }
        return this;
    }

    public int getMaxThreads() {
        return this.max_threads;
    }

    public ThreadPool setMaxThreads(int size) {
        this.max_threads = size;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setMaximumPoolSize(size);
        }
        return this;
    }

    public long getKeepAliveTime() {
        return this.keep_alive_time;
    }

    public ThreadPool setKeepAliveTime(long time) {
        this.keep_alive_time = time;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setKeepAliveTime(time, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public int getThreadDumpsThreshold() {
        return this.thread_dumps_threshold;
    }

    public ThreadPool setThreadDumpsThreshold(int t) {
        this.thread_dumps_threshold = t;
        return this;
    }

    public boolean getIncreaseMaxSizeDynamically() {
        return this.increase_max_size_dynamically;
    }

    public ThreadPool setIncreaseMaxSizeDynamically(boolean b) {
        this.increase_max_size_dynamically = b;
        return this;
    }

    public int getDelta() {
        return this.delta;
    }

    public ThreadPool setDelta(int d) {
        this.delta = d;
        return this;
    }

    @ManagedAttribute(description="Number of thread dumps")
    public int getNumberOfThreadDumps() {
        return this.thread_dumps.get();
    }

    @ManagedOperation(description="Resets the thread_dumps counter")
    public void resetThreadDumps() {
        this.thread_dumps.set(0);
    }

    @ManagedAttribute(description="Current number of threads in the thread pool")
    public int getThreadPoolSize() {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.thread_pool).getPoolSize();
        }
        return 0;
    }

    @ManagedAttribute(description="Current number of active threads in the thread pool")
    public int getThreadPoolSizeActive() {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.thread_pool).getActiveCount();
        }
        return 0;
    }

    @ManagedAttribute(description="Largest number of threads in the thread pool")
    public int getLargestSize() {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.thread_pool).getLargestPoolSize();
        }
        return 0;
    }

    @Override
    public void init() throws Exception {
        this.thread_pool = this.enabled ? ThreadCreator.createThreadPool(this.min_threads, this.max_threads, this.keep_alive_time, "abort", new SynchronousQueue<Runnable>(), this.tp.getThreadFactory(), this.tp.useVirtualThreads(), this.tp.getLog()) : new DirectExecutor();
    }

    @Override
    public void destroy() {
        if (this.thread_pool instanceof ExecutorService) {
            ExecutorService service = (ExecutorService)this.thread_pool;
            service.shutdownNow();
            try {
                service.awaitTermination(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean execute(Runnable task) {
        try {
            this.thread_pool.execute(task);
            return true;
        }
        catch (RejectedExecutionException ex) {
            this.tp.getMessageStats().incrNumRejectedMsgs(1);
            if (this.thread_dumps.incrementAndGet() == this.thread_dumps_threshold) {
                String thread_dump = Util.dumpThreads();
                Log l = this.tp.getLog();
                if (this.thread_dump_path != null) {
                    File file = new File(this.thread_dump_path, "jgroups_threaddump_" + System.currentTimeMillis() + ".txt");
                    try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                        writer.write(thread_dump);
                        l.fatal("%s: thread pool is full (max=%d, active=%d); thread dump (dumped once, until thread_dump is reset): %s", this.tp.getAddress(), this.max_threads, this.getThreadPoolSize(), file.getAbsolutePath());
                    }
                    catch (IOException e) {
                        l.warn("%s: cannot generate the thread dump to %s: %s", this.tp.getAddress(), file.getAbsolutePath(), e);
                        l.fatal("%s: thread pool is full (max=%d, active=%d); thread dump (dumped once, until thread_dump is reset):\n%s", this.tp.getAddress(), this.max_threads, this.getThreadPoolSize(), thread_dump);
                    }
                } else {
                    l.fatal("%s: thread pool is full (max=%d, active=%d); thread dump (dumped once, until thread_dump is reset):\n%s", this.tp.getAddress(), this.max_threads, this.getThreadPoolSize(), thread_dump);
                }
            }
            return false;
        }
        catch (Throwable t) {
            this.tp.getLog().error("failure submitting task to thread pool", t);
            this.tp.getMessageStats().incrNumRejectedMsgs(1);
            return false;
        }
    }

    public String toString() {
        return this.thread_pool != null ? this.thread_pool.toString() : "n/a";
    }

    protected static ExecutorService createThreadPool(int min_threads, int max_threads, long keep_alive_time, String rejection_policy, BlockingQueue<Runnable> queue, ThreadFactory factory) {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(min_threads, max_threads, keep_alive_time, TimeUnit.MILLISECONDS, queue, factory);
        RejectedExecutionHandler handler = Util.parseRejectionPolicy(rejection_policy);
        pool.setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(handler));
        return pool;
    }
}

