/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.nats.streaming;

import io.debezium.DebeziumException;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.server.BaseChangeConsumer;
import io.debezium.server.CustomConsumerBuilder;
import io.nats.client.Connection;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.streaming.NatsStreaming;
import io.nats.streaming.Options;
import io.nats.streaming.StreamingConnection;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="nats-streaming")
@Dependent
public class NatsStreamingChangeConsumer
extends BaseChangeConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NatsStreamingChangeConsumer.class);
    private static final String PROP_PREFIX = "debezium.sink.nats-streaming.";
    private static final String PROP_URL = "debezium.sink.nats-streaming.url";
    private static final String PROP_CLUSTER_ID = "debezium.sink.nats-streaming.cluster.id";
    private static final String PROP_CLIENT_ID = "debezium.sink.nats-streaming.client.id";
    private String url;
    private String clusterId;
    private String clientId;
    private Connection nc;
    private StreamingConnection sc;
    @Inject
    @CustomConsumerBuilder
    Instance<StreamingConnection> customStreamingConnection;

    @PostConstruct
    void connect() {
        if (this.customStreamingConnection.isResolvable()) {
            this.sc = (StreamingConnection)this.customStreamingConnection.get();
            LOGGER.info("Obtained custom configured StreamingConnection '{}'", (Object)this.sc);
            return;
        }
        Config config = ConfigProvider.getConfig();
        this.url = (String)config.getValue(PROP_URL, String.class);
        this.clusterId = (String)config.getValue(PROP_CLUSTER_ID, String.class);
        this.clientId = (String)config.getValue(PROP_CLIENT_ID, String.class);
        try {
            io.nats.client.Options natsOptions = new Options.Builder().server(this.url).noReconnect().build();
            this.nc = Nats.connect((io.nats.client.Options)natsOptions);
            Options stanOptions = new Options.Builder().natsConn(this.nc).build();
            this.sc = NatsStreaming.connect((String)this.clusterId, (String)this.clientId, (Options)stanOptions);
        }
        catch (Exception e) {
            throw new DebeziumException((Throwable)e);
        }
        LOGGER.info("Using default StreamingConnection '{}'", (Object)this.sc);
    }

    @PreDestroy
    void close() {
        try {
            if (this.sc != null) {
                this.sc.close();
                LOGGER.info("NATS Streaming connection closed.");
            }
            if (this.nc != null) {
                this.nc.close();
                LOGGER.info("NATS connection closed.");
            }
        }
        catch (Exception e) {
            throw new DebeziumException((Throwable)e);
        }
    }

    public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
        for (ChangeEvent<Object, Object> record : records) {
            if (record.value() != null) {
                String subject = this.streamNameMapper.map(record.destination());
                byte[] recordBytes = this.getBytes(record.value());
                LOGGER.trace("Received event @ {} = '{}'", (Object)subject, (Object)this.getString(record.value()));
                try {
                    this.sc.publish(subject, recordBytes);
                }
                catch (Exception e) {
                    throw new DebeziumException((Throwable)e);
                }
            }
            committer.markProcessed(record);
        }
        committer.markBatchFinished();
    }
}

