/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.vitess.Module;
import io.debezium.connector.vitess.Vgtid;
import io.debezium.connector.vitess.VitessSourceInfoStructMaker;
import io.debezium.connector.vitess.connection.VitessTabletType;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VitessConnectorConfig
extends RelationalDatabaseConnectorConfig {
    public static final List<String> EMPTY_GTID_LIST = List.of("");
    public static final List<String> DEFAULT_GTID_LIST = List.of("current");
    public static final String CSV_DELIMITER = ",";
    private static final Logger LOGGER = LoggerFactory.getLogger(VitessConnectorConfig.class);
    private static final String VITESS_CONFIG_GROUP_PREFIX = "vitess.";
    private static final int DEFAULT_VTGATE_PORT = 15991;
    public static final Field VTGATE_HOST = Field.create((String)("database." + JdbcConfiguration.HOSTNAME)).withDisplayName("Vitess database hostname").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Resolvable hostname or IP address of the Vitess VTGate gRPC server.");
    public static final Field VTGATE_PORT = Field.create((String)("database." + JdbcConfiguration.PORT)).withDisplayName("Vitess database port").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withDefault(15991).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("Port of the Vitess VTGate gRPC server.");
    public static final Field VTGATE_USER = Field.create((String)("database." + JdbcConfiguration.USER)).withDisplayName("User").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Name of the user to be used when connecting the Vitess VTGate gRPC server.");
    public static final Field VTGATE_PASSWORD = Field.create((String)("database." + JdbcConfiguration.PASSWORD)).withDisplayName("Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Password of the user to be used when connecting the Vitess VTGate gRPC server.");
    public static final Field KEYSPACE = Field.create((String)"vitess.keyspace").withDisplayName("Keyspace").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Vitess Keyspace is equivalent to MySQL database (a.k.a schema). E.p. \"commerce\"");
    public static final Field SHARD = Field.create((String)"vitess.shard").withDisplayName("Shard").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("Single shard of which keyspace to read data from.E.p. \"0\" for an unsharded keyspace. Or \"-80\" for the -80 shard of the sharded keyspace.");
    public static final Field GTID = Field.create((String)"vitess.gtid").withDisplayName("gtid").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withDefault("current").withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{VitessConnectorConfig::validateGtids}).withDescription("Single GTID from where to start reading from for a given shard. It has to be set together with vitess.shard. If not configured, the connector streams changes from the latest position for the given shard. If snapshot.mode is INITIAL (default), the connector starts copying the tables for the given shard first regardless of gtid value.");
    public static final Field TABLET_TYPE = Field.create((String)"vitess.tablet.type").withDisplayName("Tablet type to get data-changes").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDefault(VitessTabletType.MASTER.name()).withDescription("Tablet type used to get latest vgtid from Vtctld and get data-changes from Vtgate. Value can be MASTER, REPLICA, and RDONLY.");
    public static final Field STOP_ON_RESHARD_FLAG = Field.create((String)"vitess.stop_on_reshard").withDisplayName("VStream flag stop_on_reshard").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Control StopOnReshard VStream flag. If set true, the old VStream will be stopped after a reshard operation.");
    public static final Field KEEPALIVE_INTERVAL_MS = Field.create((String)"vitess.keepalive.interval.ms").withDisplayName("VStream gRPC keepalive interval (ms)").withType(ConfigDef.Type.LONG).withDefault(Long.MAX_VALUE).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Control the interval between periodic gPRC keepalive pings for VStream. Defaults to Long.MAX_VALUE (disabled).");
    public static final Field GRPC_HEADERS = Field.create((String)"vitess.grpc.headers").withDisplayName("VStream gRPC headers").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify a comma-separated list of gRPC headers. Defaults to empty");
    public static final Field GRPC_MAX_INBOUND_MESSAGE_SIZE = Field.create((String)"vitess.grpc.max_inbound_message_size").withDisplayName("VStream gRPC maxInboundMessageSize").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withDefault(0x400000).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("Specify the maximum message size in bytes allowed to be received on the channel.");
    public static final Field INCLUDE_UNKNOWN_DATATYPES = Field.create((String)"include.unknown.datatypes").withDisplayName("Include unknown datatypes").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify whether the fields of data type not supported by Debezium should be processed:'false' (the default) omits the fields; 'true' converts the field into an implementation dependent binary representation.");
    public static final Field OFFSET_STORAGE_PER_TASK = Field.create((String)"vitess.offset.storage.per.task").withDisplayName("Store offsets per task").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Whether to store the offsets in Kafka's offset storage topic by task id. You must set offset.storage.per.task to true if tasks.max > 1'false' (the default) offsets are stored as a single unit under the database name. 'true' stores the offsets per task id");
    public static final Field OFFSET_STORAGE_TASK_KEY_GEN = Field.create((String)"vitess.offset.storage.task.key.gen").withDisplayName("Offset storage task key generation number").withType(ConfigDef.Type.INT).withDefault(-1).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Offset storage task key generation number. The partition key in the offset storage will be in the form of <taskId>_<numTasks>_<gen>. You will increase the <gen> number when the parallelism of your tasks are changing. \nThis will make each generation of task parallelism leaves different sets of partition keys in the offset storage. E.g. you were using 2 tasks for the connector previously and now you want to use 4 tasks. Previously you might specify <gen> as 1 and now you will specify <gen> as 2. Previously the partition key in the offset storage will be task0_2_1, task1_2_1, And now the partition key in the offset storage will be task0_4_2, task1_4_2, task2_4_2, task3_4_2. \nNote that for generation number lineage tracking purpose, generation number starts with 0.  If your installation previously did not use offset.storage.per.task, the offset storage  key will be in the form of server=db_1, this will implicitly be treated as generation 0. And when you switch to use offset.storage.per.task mode, you should specify task.key.gen=1 so we can establish the offset generation lineage for offset migration. \nIf your installation starts with offset.storage.per.task mode upfront (which means you don't have any previous key in offset storage, you should start with specifying task.key.gen = 0 explicitly So we know this run is the origin.");
    public static final Field PREV_NUM_TASKS = Field.create((String)"vitess.prev.num.tasks").withDisplayName("Previous number of tasks").withType(ConfigDef.Type.INT).withDefault(-1).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Previous number of tasks used for the previous generation of task parallelism. \nThis param is only used when your tasks parallelism is changing and We will use prev.num.tasks to fetch the existing offset from offset storage associated with your previous run to keep the offset progression continuously. \nE.g. Previously you were using 2 tasks for the connector and offset.storage.task.key.gen = 1, The partition keys in the offset storage were task0_2_1, task1_2_1, \nNow you want to use 4 tasks. You will specify prev.num.tasks = 2 and offset.storage.task.key.gen = 2, We will use this information to fetch the offsets through partition keys from previous run, Previous run's partition keys will be calculated using <taskId>_<prev.num.task>_<offset.storage.task.key.gen - 1>. \nNote this param is only used once the first time when we detect task parallelism change. Once we persist the new offsets in offset storage using new partition key based on current <numTasks> and <gen>, we will no longer read prev.num.tasks param");
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should always perform an initial sync when required; 'never' to specify the connector should never perform an initial sync ");
    public static final Field BIGINT_UNSIGNED_HANDLING_MODE = Field.create((String)"bigint.unsigned.handling.mode").withDisplayName("BIGINT UNSIGNED Handling").withEnum(BigIntUnsignedHandlingMode.class, (Enum)BigIntUnsignedHandlingMode.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify how BIGINT UNSIGNED columns should be represented in change events, including: 'string' (the default) represent values using Java's 'string'; 'precise' represents values as precise (Java's 'BigDecimal') values;'long' represents values using Java's 'long', which may not offer the precision but will be far easier to use in consumers.");
    protected static final ConfigDefinition CONFIG_DEFINITION = RelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().name("Vitess").type(new Field[]{KEYSPACE, SHARD, GTID, VTGATE_HOST, VTGATE_PORT, VTGATE_USER, VTGATE_PASSWORD, TABLET_TYPE, STOP_ON_RESHARD_FLAG, KEEPALIVE_INTERVAL_MS, GRPC_HEADERS, GRPC_MAX_INBOUND_MESSAGE_SIZE, BINARY_HANDLING_MODE, SCHEMA_NAME_ADJUSTMENT_MODE, OFFSET_STORAGE_PER_TASK, OFFSET_STORAGE_TASK_KEY_GEN, PREV_NUM_TASKS}).events(new Field[]{INCLUDE_UNKNOWN_DATATYPES}).connector(new Field[]{SNAPSHOT_MODE, BIGINT_UNSIGNED_HANDLING_MODE}).excluding(new Field[]{SCHEMA_EXCLUDE_LIST, SCHEMA_INCLUDE_LIST}).create();
    protected static final String TASKS_MAX_CONFIG = "tasks.max";
    protected static final String VITESS_TASK_KEY_CONFIG = "vitess.task.key";
    protected static final String VITESS_TASK_SHARDS_CONFIG = "vitess.task.shards";
    protected static final String VITESS_TASK_VGTID_CONFIG = "vitess.task.vgtid";
    public static Field.Set ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());

    public static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public VitessConnectorConfig(Configuration config) {
        super(config, null, x -> x.schema() + "." + x.table(), -1, ColumnFilterMode.CATALOG, true);
    }

    public String getContextName() {
        return Module.contextName();
    }

    public String getConnectorName() {
        return Module.name();
    }

    protected SourceInfoStructMaker<?> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return new VitessSourceInfoStructMaker(Module.name(), Module.version(), this);
    }

    public String getKeyspace() {
        return this.getConfig().getString(KEYSPACE);
    }

    public List<String> getShard() {
        return this.getConfig().getStrings(SHARD, CSV_DELIMITER);
    }

    public List<String> getGtid() {
        if (this.getSnapshotMode() == SnapshotMode.INITIAL) {
            return EMPTY_GTID_LIST;
        }
        List value = this.getConfig().getStrings(GTID, CSV_DELIMITER);
        return value != null && !GTID.defaultValueAsString().equals(value) ? value : DEFAULT_GTID_LIST;
    }

    private static int validateGtids(Configuration config, Field field, Field.ValidationOutput problems) {
        String gtid = config.getString(GTID);
        List<String> gtids = List.of(gtid.split(CSV_DELIMITER));
        if (gtids.equals(DEFAULT_GTID_LIST) || gtids.equals(EMPTY_GTID_LIST)) {
            return 0;
        }
        List shards = config.getStrings(SHARD, CSV_DELIMITER);
        if (shards == null && gtids != null) {
            problems.accept(field, gtids, "If GTIDs are specified, there must be shards specified");
            return 1;
        }
        if (shards != null && shards.size() != gtids.size()) {
            problems.accept(field, gtids, "If GTIDs are specified must be specified for all shards");
            return 1;
        }
        return 0;
    }

    public String getVtgateHost() {
        return this.getConfig().getString(VTGATE_HOST);
    }

    public int getVtgatePort() {
        return this.getConfig().getInteger(VTGATE_PORT);
    }

    public String getVtgateUsername() {
        return this.getConfig().getString(VTGATE_USER);
    }

    public String getVtgatePassword() {
        return this.getConfig().getString(VTGATE_PASSWORD);
    }

    public String getTabletType() {
        return this.getConfig().getString(TABLET_TYPE);
    }

    public boolean getStopOnReshard() {
        return this.getConfig().getBoolean(STOP_ON_RESHARD_FLAG);
    }

    public Duration getKeepaliveInterval() {
        return this.getConfig().getDuration(KEEPALIVE_INTERVAL_MS, (TemporalUnit)ChronoUnit.MILLIS);
    }

    public Map<String, String> getGrpcHeaders() {
        String grpcHeaders = this.getConfig().getString(GRPC_HEADERS);
        if (grpcHeaders == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> grpcHeadersMap = new HashMap<String, String>();
        for (String header : grpcHeaders.split(CSV_DELIMITER)) {
            String[] keyAndValue = header.split(":");
            if (keyAndValue.length == 2) {
                grpcHeadersMap.put(keyAndValue[0], keyAndValue[1]);
                continue;
            }
            LOGGER.warn("The following gRPC header is invalid: {}", (Object)header);
        }
        return Collections.unmodifiableMap(grpcHeadersMap);
    }

    public int getGrpcMaxInboundMessageSize() {
        return this.getConfig().getInteger(GRPC_MAX_INBOUND_MESSAGE_SIZE);
    }

    public boolean includeUnknownDatatypes() {
        return this.getConfig().getBoolean(INCLUDE_UNKNOWN_DATATYPES);
    }

    public boolean offsetStoragePerTask() {
        return this.getConfig().getBoolean(OFFSET_STORAGE_PER_TASK);
    }

    public int getOffsetStorageTaskKeyGen() {
        return this.getConfig().getInteger(OFFSET_STORAGE_TASK_KEY_GEN);
    }

    public int getPrevNumTasks() {
        return this.getConfig().getInteger(PREV_NUM_TASKS);
    }

    public String getVitessTaskKey() {
        return this.getConfig().getString(VITESS_TASK_KEY_CONFIG);
    }

    public List<String> getVitessTaskKeyShards() {
        return this.getConfig().getStrings(VITESS_TASK_SHARDS_CONFIG, CSV_DELIMITER);
    }

    public Vgtid getVitessTaskVgtid() {
        String vgtidStr = this.getConfig().getString(VITESS_TASK_VGTID_CONFIG);
        return vgtidStr == null ? null : Vgtid.of(vgtidStr);
    }

    public SnapshotMode getSnapshotMode() {
        return SnapshotMode.parse(this.getConfig().getString(SNAPSHOT_MODE), SNAPSHOT_MODE.defaultValueAsString());
    }

    public BigIntUnsignedHandlingMode getBigIntUnsgnedHandlingMode() {
        return BigIntUnsignedHandlingMode.parse(this.getConfig().getString(BIGINT_UNSIGNED_HANDLING_MODE), BIGINT_UNSIGNED_HANDLING_MODE.defaultValueAsString());
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        INITIAL("initial"),
        NEVER("never");

        private final String value;

        private SnapshotMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum BigIntUnsignedHandlingMode implements EnumeratedValue
    {
        STRING("string"),
        PRECISE("precise"),
        LONG("long");

        private final String value;

        private BigIntUnsignedHandlingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static BigIntUnsignedHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (BigIntUnsignedHandlingMode option : BigIntUnsignedHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static BigIntUnsignedHandlingMode parse(String value, String defaultValue) {
            BigIntUnsignedHandlingMode mode = BigIntUnsignedHandlingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = BigIntUnsignedHandlingMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

