/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess.connection;

import binlogdata.Binlogdata;
import io.debezium.DebeziumException;
import io.debezium.connector.vitess.Vgtid;
import io.debezium.connector.vitess.VitessConnector;
import io.debezium.connector.vitess.VitessConnectorConfig;
import io.debezium.connector.vitess.VitessDatabaseSchema;
import io.debezium.connector.vitess.connection.MessageDecoder;
import io.debezium.connector.vitess.connection.ReplicationConnection;
import io.debezium.connector.vitess.connection.ReplicationMessageProcessor;
import io.debezium.connector.vitess.connection.VStreamOutputMessageDecoder;
import io.debezium.connector.vitess.connection.VitessTabletType;
import io.debezium.util.Strings;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import io.vitess.client.Proto;
import io.vitess.client.grpc.StaticAuthCredentials;
import io.vitess.proto.Topodata;
import io.vitess.proto.Vtgate;
import io.vitess.proto.grpc.VitessGrpc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VitessReplicationConnection
implements ReplicationConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitessReplicationConnection.class);
    private final MessageDecoder messageDecoder;
    private final VitessConnectorConfig config;
    private final AtomicReference<ManagedChannel> managedChannel = new AtomicReference();

    public VitessReplicationConnection(VitessConnectorConfig config, VitessDatabaseSchema schema) {
        this.messageDecoder = new VStreamOutputMessageDecoder(schema);
        this.config = config;
    }

    public Vtgate.ExecuteResponse execute(String sqlStatement) {
        LOGGER.info("Executing sqlStament {}", (Object)sqlStatement);
        ManagedChannel channel = this.newChannel(this.config.getVtgateHost(), this.config.getVtgatePort(), this.config.getGrpcMaxInboundMessageSize());
        this.managedChannel.compareAndSet(null, channel);
        Vtgate.ExecuteRequest request = Vtgate.ExecuteRequest.newBuilder().setQuery(Proto.bindQuery((String)sqlStatement, Collections.emptyMap())).build();
        return this.newBlockingStub(channel).execute(request);
    }

    @Override
    public void startStreaming(Vgtid vgtid, final ReplicationMessageProcessor processor, final AtomicReference<Throwable> error) {
        Objects.requireNonNull(vgtid);
        ManagedChannel channel = this.newChannel(this.config.getVtgateHost(), this.config.getVtgatePort(), this.config.getGrpcMaxInboundMessageSize());
        this.managedChannel.compareAndSet(null, channel);
        VitessGrpc.VitessStub stub = this.newStub(channel);
        Map<String, String> grpcHeaders = this.config.getGrpcHeaders();
        if (!grpcHeaders.isEmpty()) {
            LOGGER.info("Setting VStream gRPC headers: {}", grpcHeaders);
            Metadata metadata = new Metadata();
            for (Map.Entry<String, String> entry : grpcHeaders.entrySet()) {
                metadata.put(Metadata.Key.of((String)entry.getKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)entry.getValue());
            }
            stub = (VitessGrpc.VitessStub)MetadataUtils.attachHeaders((AbstractStub)stub, (Metadata)metadata);
        }
        StreamObserver<Vtgate.VStreamResponse> responseObserver = new StreamObserver<Vtgate.VStreamResponse>(){
            private List<Binlogdata.VEvent> bufferedEvents = new ArrayList<Binlogdata.VEvent>();
            private Vgtid newVgtid;
            private boolean beginEventSeen;
            private boolean commitEventSeen;
            private int numOfRowEvents;
            private int numResponses;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(Vtgate.VStreamResponse response) {
                LOGGER.debug("Received {} VEvents in the VStreamResponse:", (Object)response.getEventsCount());
                boolean sendNow = false;
                for (Binlogdata.VEvent event : response.getEventsList()) {
                    LOGGER.debug("VEvent: {}", (Object)event);
                    switch (event.getType()) {
                        case ROW: {
                            ++this.numOfRowEvents;
                            break;
                        }
                        case VGTID: {
                            if (this.newVgtid != null) {
                                if (this.newVgtid.getRawVgtid().getShardGtidsList().stream().findFirst().map(s -> s.getTablePKsCount() == 0).orElse(false).booleanValue() && event.getVgtid().getShardGtidsList().stream().findFirst().map(s -> 0 < s.getTablePKsCount()).orElse(false).booleanValue()) {
                                    LOGGER.info("Received more than one VGTID events during a copy operation and the previous one is {}. Using the latest: {}", (Object)this.newVgtid.toString(), (Object)event.getVgtid().toString());
                                } else {
                                    LOGGER.warn("Received more than one VGTID events and the previous one is {}. Using the latest: {}", (Object)this.newVgtid.toString(), (Object)event.getVgtid().toString());
                                }
                            }
                            this.newVgtid = Vgtid.of(event.getVgtid());
                            break;
                        }
                        case BEGIN: {
                            Object msg;
                            if (this.commitEventSeen) {
                                msg = "Received BEGIN event after receiving COMMIT event";
                                this.setError((String)msg);
                                return;
                            }
                            if (this.beginEventSeen) {
                                msg = "Received duplicate BEGIN events";
                                String eventTypes = this.bufferedEvents.stream().map(Binlogdata.VEvent::getType).map(Objects::toString).collect(Collectors.joining(", "));
                                if (eventTypes.equals("BEGIN, FIELD") || eventTypes.equals("BEGIN, FIELD, VGTID")) {
                                    msg = (String)msg + String.format(" during a copy operation. No harm to skip the buffered events. Buffered event types: %s", eventTypes);
                                    LOGGER.info((String)msg);
                                    this.reset();
                                } else {
                                    this.setError((String)msg);
                                    return;
                                }
                            }
                            this.beginEventSeen = true;
                            break;
                        }
                        case COMMIT: {
                            Object msg;
                            if (!this.beginEventSeen) {
                                msg = "Received COMMIT event before receiving BEGIN event";
                                this.setError((String)msg);
                                return;
                            }
                            if (this.commitEventSeen) {
                                msg = "Received duplicate COMMIT events";
                                this.setError((String)msg);
                                return;
                            }
                            this.commitEventSeen = true;
                            break;
                        }
                        case DDL: 
                        case OTHER: {
                            sendNow = true;
                        }
                    }
                    this.bufferedEvents.add(event);
                }
                ++this.numResponses;
                if (!(this.beginEventSeen && this.commitEventSeen || sendNow)) {
                    LOGGER.info("Received partial transaction: number of responses so far is {}", (Object)this.numResponses);
                    return;
                }
                if (this.numResponses > 1) {
                    LOGGER.info("Processing multi-response transaction: number of responses is {}", (Object)this.numResponses);
                }
                if (this.newVgtid == null) {
                    LOGGER.warn("Skipping because no vgtid is found in buffered event types: {}", (Object)this.bufferedEvents.stream().map(Binlogdata.VEvent::getType).map(Objects::toString).collect(Collectors.joining(", ")));
                    this.reset();
                    return;
                }
                try {
                    int rowEventSeen = 0;
                    for (int i = 0; i < this.bufferedEvents.size(); ++i) {
                        Binlogdata.VEvent event = this.bufferedEvents.get(i);
                        if (event.getType() == Binlogdata.VEventType.ROW) {
                            ++rowEventSeen;
                        }
                        boolean isLastRowEventOfTransaction = this.newVgtid != null && this.numOfRowEvents != 0 && rowEventSeen == this.numOfRowEvents;
                        VitessReplicationConnection.this.messageDecoder.processMessage(this.bufferedEvents.get(i), processor, this.newVgtid, isLastRowEventOfTransaction);
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.error("Message processing is interrupted", (Throwable)e);
                    error.compareAndSet(null, e);
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.reset();
                }
            }

            public void onError(Throwable t) {
                Status status = Status.fromThrowable((Throwable)t);
                if (status.getCode().equals((Object)Status.Code.RESOURCE_EXHAUSTED) && status.getDescription().matches("gRPC message exceeds maximum size.*")) {
                    switch (VitessReplicationConnection.this.config.getEventProcessingFailureHandlingMode()) {
                        case FAIL: {
                            LOGGER.error("VStream streaming onError. Status: {}", (Object)status, (Object)t);
                            error.compareAndSet(null, t);
                            this.reset();
                            break;
                        }
                        case WARN: {
                            LOGGER.warn("VStream streaming onError. Status: {}", (Object)status, (Object)t);
                            break;
                        }
                        case SKIP: 
                        case IGNORE: {
                            LOGGER.debug("VStream streaming onError. Status: {}", (Object)status, (Object)t);
                        }
                    }
                } else {
                    LOGGER.error("VStream streaming onError. Status: {}", (Object)status, (Object)t);
                    error.compareAndSet(null, t);
                    this.reset();
                }
            }

            public void onCompleted() {
                LOGGER.info("VStream streaming completed.");
                this.reset();
            }

            private void reset() {
                this.bufferedEvents.clear();
                this.newVgtid = null;
                this.beginEventSeen = false;
                this.commitEventSeen = false;
                this.numOfRowEvents = 0;
                this.numResponses = 0;
            }

            private void setError(String msg) {
                msg = (String)msg + String.format(". Buffered event types: %s", this.bufferedEvents.stream().map(Binlogdata.VEvent::getType).map(Objects::toString).collect(Collectors.joining(", ")));
                LOGGER.error((String)msg);
                error.compareAndSet(null, new DebeziumException((String)msg));
                this.reset();
            }
        };
        Vtgate.VStreamFlags vStreamFlags = Vtgate.VStreamFlags.newBuilder().setStopOnReshard(this.config.getStopOnReshard()).build();
        Binlogdata.Filter.Builder filterBuilder = Binlogdata.Filter.newBuilder();
        if (!Strings.isNullOrEmpty((String)this.config.tableIncludeList())) {
            String keyspace = this.config.getKeyspace();
            List<String> allTables = VitessConnector.getKeyspaceTables(this.config);
            List<String> includedTables = VitessConnector.getIncludedTables(this.config.getKeyspace(), this.config.tableIncludeList(), allTables);
            for (String table : includedTables) {
                String sql = "select * from " + table;
                Binlogdata.Rule rule = Binlogdata.Rule.newBuilder().setMatch(table).setFilter(sql).build();
                LOGGER.info("Add vstream table filtering: {}", (Object)rule.getMatch());
                filterBuilder.addRules(rule);
            }
        }
        Vtgate.VStreamRequest.Builder vstreamBuilder = Vtgate.VStreamRequest.newBuilder().setVgtid(vgtid.getRawVgtid()).setTabletType(VitessReplicationConnection.toTopodataTabletType(VitessTabletType.valueOf(this.config.getTabletType()))).setFlags(vStreamFlags);
        if (filterBuilder.getRulesCount() > 0) {
            vstreamBuilder.setFilter(filterBuilder);
        }
        stub.vStream(vstreamBuilder.build(), (StreamObserver)responseObserver);
        LOGGER.info("Started VStream");
    }

    private VitessGrpc.VitessStub newStub(ManagedChannel channel) {
        VitessGrpc.VitessStub stub = VitessGrpc.newStub((Channel)channel);
        return this.withCredentials(stub);
    }

    private VitessGrpc.VitessBlockingStub newBlockingStub(ManagedChannel channel) {
        VitessGrpc.VitessBlockingStub stub = VitessGrpc.newBlockingStub((Channel)channel);
        return this.withCredentials(stub);
    }

    private <T extends AbstractStub<T>> T withCredentials(T stub) {
        if (this.config.getVtgateUsername() != null && this.config.getVtgatePassword() != null) {
            LOGGER.info("Use authenticated vtgate grpc.");
            stub = stub.withCallCredentials((CallCredentials)new StaticAuthCredentials(this.config.getVtgateUsername(), this.config.getVtgatePassword()));
        }
        return stub;
    }

    private ManagedChannel newChannel(String vtgateHost, int vtgatePort, int maxInboundMessageSize) {
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)vtgateHost, (int)vtgatePort).usePlaintext().maxInboundMessageSize(maxInboundMessageSize).keepAliveTime(this.config.getKeepaliveInterval().toMillis(), TimeUnit.MILLISECONDS).build();
        return channel;
    }

    @Override
    public void close() throws Exception {
        LOGGER.info("Closing replication connection");
        this.managedChannel.get().shutdownNow();
        LOGGER.trace("VStream GRPC channel shutdownNow is invoked.");
        if (this.managedChannel.get().awaitTermination(5L, TimeUnit.SECONDS)) {
            LOGGER.info("VStream GRPC channel is shutdown in time.");
        } else {
            LOGGER.warn("VStream GRPC channel is not shutdown in time. Give up waiting.");
        }
    }

    public static Vgtid buildVgtid(String keyspace, List<String> shards, List<String> gtids) {
        Vgtid vgtid;
        Binlogdata.VGtid.Builder builder = Binlogdata.VGtid.newBuilder();
        if (shards == null || shards.isEmpty()) {
            vgtid = Vgtid.of(builder.addShardGtids(Binlogdata.ShardGtid.newBuilder().setKeyspace(keyspace).setGtid("current").build()).build());
        } else {
            for (int i = 0; i < shards.size(); ++i) {
                String shard = shards.get(i);
                String gtid = gtids.get(i);
                builder.addShardGtids(Binlogdata.ShardGtid.newBuilder().setKeyspace(keyspace).setShard(shard).setGtid(gtid).build());
            }
            vgtid = Vgtid.of(builder.build());
        }
        LOGGER.info("Default VGTID '{}' for keyspace {}, shards: {}, gtids {}", new Object[]{vgtid, keyspace, shards, gtids});
        return vgtid;
    }

    public static Vgtid defaultVgtid(VitessConnectorConfig config) {
        Vgtid vgtid;
        if (config.offsetStoragePerTask()) {
            List<String> shards = config.getVitessTaskKeyShards();
            vgtid = config.getVitessTaskVgtid();
            LOGGER.info("VGTID '{}' is set for the keyspace: {} shards: {}", new Object[]{vgtid, config.getKeyspace(), shards});
        } else if (config.getShard() == null || config.getShard().isEmpty()) {
            if (config.getGtid() == VitessConnectorConfig.EMPTY_GTID_LIST) {
                List<String> shards = VitessConnector.getVitessShards(config);
                List<String> gtids = Collections.nCopies(shards.size(), config.getGtid().get(0));
                vgtid = VitessReplicationConnection.buildVgtid(config.getKeyspace(), shards, gtids);
            } else {
                vgtid = VitessReplicationConnection.buildVgtid(config.getKeyspace(), Collections.emptyList(), Collections.emptyList());
            }
            LOGGER.info("Default VGTID '{}' is set to the current gtid of all shards from keyspace: {}", (Object)vgtid, (Object)config.getKeyspace());
        } else {
            List<String> shards = config.getShard();
            List<String> gtids = config.getGtid();
            if (gtids == VitessConnectorConfig.DEFAULT_GTID_LIST || gtids == VitessConnectorConfig.EMPTY_GTID_LIST) {
                gtids = Collections.nCopies(shards.size(), gtids.get(0));
            }
            vgtid = VitessReplicationConnection.buildVgtid(config.getKeyspace(), shards, gtids);
            LOGGER.info("VGTID '{}' is set to the GTID {} for keyspace: {} shard: {}", new Object[]{vgtid, gtids, config.getKeyspace(), shards});
        }
        return vgtid;
    }

    public String connectionString() {
        return String.format("vtgate gRPC connection %s:%s", this.config.getVtgateHost(), this.config.getVtgatePort());
    }

    public String username() {
        return this.config.getVtgateUsername();
    }

    private static Topodata.TabletType toTopodataTabletType(VitessTabletType tabletType) {
        switch (tabletType) {
            case MASTER: {
                return Topodata.TabletType.MASTER;
            }
            case REPLICA: {
                return Topodata.TabletType.REPLICA;
            }
            case RDONLY: {
                return Topodata.TabletType.RDONLY;
            }
        }
        LOGGER.warn("Unknown tabletType {}", (Object)tabletType);
        return null;
    }
}

