/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleTriggerAdapter;
import org.jboss.byteman.agent.adapter.RuleTriggerMethodAdapter;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;

public class EntryTriggerAdapter
extends RuleTriggerAdapter {
    public EntryTriggerAdapter(ClassVisitor cv, TransformContext transformContext) {
        super(cv, transformContext);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.injectIntoMethod(name, desc)) {
            if (name.equals("<init>")) {
                return new EntryTriggerConstructorAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
            }
            return new EntryTriggerMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class EntryTriggerConstructorAdapter
    extends EntryTriggerMethodAdapter {
        EntryTriggerConstructorAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, EntryTriggerAdapter.this.getTransformContext(), access, name, descriptor, signature, exceptions);
            this.unlatched = false;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            this.unlatched |= EntryTriggerAdapter.this.isSuperOrSiblingConstructorCall(opcode, owner, name);
        }
    }

    private class EntryTriggerMethodAdapter
    extends RuleTriggerMethodAdapter {
        protected boolean unlatched;
        private boolean visited;
        private Label startMarker;
        private Label offsetMarker;

        EntryTriggerMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.unlatched = true;
            this.visited = false;
            this.startMarker = null;
            this.offsetMarker = null;
        }

        @Override
        public void visitCode() {
            super.visitCode();
            if (this.unlatched && !this.visited) {
                this.startMarker = new Label();
                this.visitLabel(this.startMarker);
                this.visited = true;
                this.injectTriggerPoint();
                this.offsetMarker = new Label();
                this.visitLabel(this.offsetMarker);
            }
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (this.offsetMarker != null && this.offsetMarker.getOffset() == start.getOffset()) {
                start = this.startMarker;
            }
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }

        @Override
        public void visitInsn(int opcode) {
            if (this.unlatched && !this.visited) {
                this.visited = true;
                this.injectTriggerPoint();
            }
            super.visitInsn(opcode);
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            if (this.unlatched && !this.visited) {
                this.visited = true;
                this.injectTriggerPoint();
            }
            super.visitIincInsn(var, increment);
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            if (this.unlatched && !this.visited) {
                this.visited = true;
                this.injectTriggerPoint();
            }
            super.visitIntInsn(opcode, operand);
        }

        @Override
        public void visitLdcInsn(Object cst) {
            if (this.unlatched && !this.visited) {
                this.visited = true;
                this.injectTriggerPoint();
            }
            super.visitLdcInsn(cst);
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            if (this.unlatched && !this.visited) {
                this.visited = true;
                this.injectTriggerPoint();
            }
            super.visitVarInsn(opcode, var);
        }

        @Override
        public void visitTypeInsn(int opcode, String desc) {
            if (this.unlatched && !this.visited) {
                this.visited = true;
                this.injectTriggerPoint();
            }
            super.visitTypeInsn(opcode, desc);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (this.unlatched && !this.visited) {
                this.visited = true;
                this.injectTriggerPoint();
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (this.unlatched && !this.visited) {
                this.visited = true;
                this.injectTriggerPoint();
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            if (this.unlatched && !this.visited) {
                this.visited = true;
                this.injectTriggerPoint();
            }
            super.visitJumpInsn(opcode, label);
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
            if (this.unlatched && !this.visited) {
                this.visited = true;
                this.injectTriggerPoint();
            }
            super.visitTableSwitchInsn(min, max, dflt, labels);
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            if (this.unlatched && !this.visited) {
                this.visited = true;
                this.injectTriggerPoint();
            }
            super.visitLookupSwitchInsn(dflt, keys, labels);
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            if (this.unlatched && !this.visited) {
                this.visited = true;
                this.injectTriggerPoint();
            }
            super.visitMultiANewArrayInsn(desc, dims);
        }
    }
}

