/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter.cfg;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.byteman.agent.adapter.OpcodesHelper;
import org.jboss.byteman.agent.adapter.cfg.CFG;
import org.jboss.byteman.agent.adapter.cfg.CodeLocation;
import org.jboss.byteman.agent.adapter.cfg.FanOut;
import org.jboss.byteman.agent.adapter.cfg.InstructionSequence;
import org.jboss.byteman.agent.adapter.cfg.TryCatchDetails;
import org.jboss.byteman.objectweb.asm.Label;

public class BBlock {
    private CFG cfg;
    private InstructionSequence instructions;
    private FanOut outGoing;
    private int blockIdx;
    private List<TryCatchDetails> activeTryStarts;
    private List<TryCatchDetails> tryStarts;
    private List<TryCatchDetails> tryEnds;
    private List<TryCatchDetails> handlerStarts;
    private LinkedList<CodeLocation> monitorEnters;
    private LinkedList<CodeLocation> monitorExits;

    public BBlock(CFG cfg, Label start, int blockIdx) {
        this.cfg = cfg;
        this.instructions = new InstructionSequence();
        this.outGoing = new FanOut(start);
        this.blockIdx = blockIdx;
        this.activeTryStarts = null;
        this.tryStarts = new LinkedList<TryCatchDetails>();
        this.tryEnds = new LinkedList<TryCatchDetails>();
        this.handlerStarts = new LinkedList<TryCatchDetails>();
        this.monitorEnters = new LinkedList();
        this.monitorExits = new LinkedList();
    }

    public CFG getCFG() {
        return this.cfg;
    }

    public Label getLabel() {
        return this.outGoing.getFrom();
    }

    public int getBlockIdx() {
        return this.blockIdx;
    }

    public int append(int instruction) {
        int index = this.instructions.add(instruction);
        if (instruction == 194) {
            this.monitorEnters.push(new CodeLocation(this, index));
        } else if (instruction == 195) {
            CodeLocation exit = new CodeLocation(this, index);
            this.monitorExits.add(exit);
            if (!this.monitorEnters.isEmpty()) {
                CodeLocation enter = this.monitorEnters.pop();
                this.cfg.addMonitorPair(enter, exit);
            }
        }
        return index;
    }

    public int append(int instruction, int operand) {
        return this.instructions.add(instruction, operand);
    }

    public int append(int instruction, int operand1, int operand2) {
        return this.instructions.add(instruction, operand1, operand2);
    }

    public int append(int instruction, int operand1, int operand2, int operand3) {
        return this.instructions.add(instruction, operand1, operand2, operand3);
    }

    public int append(int instruction, int operand1, int operand2, int operand3, int operand4) {
        return this.instructions.add(instruction, operand1, operand2, operand3, operand4);
    }

    public int append(int instruction, int[] operands) {
        return this.instructions.add(instruction, operands);
    }

    public void addTryStarts(List<TryCatchDetails> details) {
        this.tryStarts.addAll(details);
    }

    public void addTryEnds(List<TryCatchDetails> details) {
        this.tryEnds.addAll(details);
    }

    public void addHandlerStarts(List<TryCatchDetails> details) {
        this.handlerStarts.addAll(details);
    }

    public void setActiveTryStarts(List<TryCatchDetails> active) {
        this.activeTryStarts = active;
    }

    public Iterator<TryCatchDetails> getTryEnds() {
        return this.tryEnds.iterator();
    }

    public Iterator<TryCatchDetails> getHandlerStarts() {
        return this.handlerStarts.iterator();
    }

    public List<TryCatchDetails> getActiveTryStarts() {
        return this.activeTryStarts;
    }

    public Iterator<CodeLocation> getMonitorEnters() {
        return this.monitorEnters.iterator();
    }

    public Iterator<CodeLocation> getMonitorExits() {
        return this.monitorExits.iterator();
    }

    public int getMonitorEnterCount() {
        return this.monitorEnters.size();
    }

    public int getMonitorExitCount() {
        return this.monitorExits.size();
    }

    public int getInstructionCount() {
        return this.instructions.size();
    }

    public int getInstruction(int index) {
        return this.instructions.get(index);
    }

    public int getInstructionArg(int index, int argIndex) {
        return this.instructions.getArg(index, argIndex);
    }

    public void append(Label label) {
        this.outGoing.append(label);
    }

    public Label next() {
        return this.outGoing.getTo(0);
    }

    public Label firstOut() {
        return this.outGoing.getTo(1);
    }

    public Label secondOut() {
        return this.outGoing.getTo(2);
    }

    public Label nthOut(int n) {
        return this.outGoing.getTo(n);
    }

    public int nOuts() {
        return this.outGoing.getToCount() - 1;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.printTo(buf);
        return buf.toString();
    }

    public void printLabelOffset(StringBuffer buf, Label l, boolean appendBlockPos, Object altText) {
        CodeLocation loc = this.cfg.getLocation(l);
        if (loc != null) {
            buf.append(l.getOffset());
            if (appendBlockPos) {
                buf.append(" BB");
                buf.append(loc.getBlockIdx());
                buf.append('.');
                buf.append(loc.getInstructionIdx());
            }
        } else if (altText != null) {
            buf.append(altText);
        }
    }

    void printTo(StringBuffer buf) {
        int containedPosition;
        Label containedLabel;
        Iterator<Label> containsIter;
        int blockIdx = this.getBlockIdx();
        int bcpos = 0;
        buf.append(this.getLabel().getOffset());
        buf.append(": BB ");
        buf.append(blockIdx);
        buf.append("\n");
        FanOut containsFanOut = this.cfg.getContains(this);
        if (containsFanOut != null) {
            containsIter = containsFanOut.iterator();
            if (containsIter.hasNext()) {
                containedLabel = containsIter.next();
                containedPosition = this.cfg.getBlockInstructionIdx(containedLabel);
                bcpos = containedLabel.getOffset();
            } else {
                containedLabel = null;
                containedPosition = -1;
            }
        } else {
            containsIter = null;
            containedLabel = null;
            containedPosition = -1;
        }
        int instructionCount = this.getInstructionCount();
        for (int i = 0; i < instructionCount; ++i) {
            while (containedPosition == i) {
                int openCount;
                List<CodeLocation> openEnters;
                Label handlerLabel;
                TryCatchDetails details;
                int j;
                int detailsCount;
                List<TryCatchDetails> detailsList;
                bcpos = containedLabel.getOffset();
                buf.append(bcpos);
                buf.append(": ");
                buf.append(containedLabel);
                if (this.cfg.tryCatchStart(containedLabel)) {
                    detailsList = this.cfg.tryCatchStartDetails(containedLabel);
                    detailsCount = detailsList.size();
                    for (j = 0; j < detailsCount; ++j) {
                        details = detailsList.get(j);
                        handlerLabel = details.getHandler();
                        buf.append("\n  ");
                        buf.append(" try ");
                        buf.append(details.getType());
                        buf.append(" -> ");
                        this.printLabelOffset(buf, handlerLabel, false, "??");
                        buf.append(" ");
                        buf.append(handlerLabel);
                    }
                }
                if (this.cfg.tryCatchEnd(containedLabel)) {
                    detailsList = this.cfg.tryCatchEndDetails(containedLabel);
                    detailsCount = detailsList.size();
                    for (j = 0; j < detailsCount; ++j) {
                        details = detailsList.get(j);
                        handlerLabel = details.getHandler();
                        buf.append("\n  ");
                        buf.append(" catch ");
                        buf.append(details.getType());
                        buf.append(" -> ");
                        this.printLabelOffset(buf, handlerLabel, false, "??");
                        buf.append(" ");
                        buf.append(handlerLabel);
                    }
                }
                if (this.cfg.tryCatchHandlerStart(containedLabel)) {
                    detailsList = this.cfg.tryCatchHandlerStartDetails(containedLabel);
                    detailsCount = detailsList.size();
                    for (j = 0; j < detailsCount; ++j) {
                        details = detailsList.get(j);
                        buf.append("\n  ");
                        buf.append(" handle ");
                        buf.append(details.getType());
                        buf.append(" <- ");
                        Label start = details.getStart();
                        Label end = details.getEnd();
                        this.printLabelOffset(buf, start, false, start);
                        buf.append(":");
                        this.printLabelOffset(buf, end, false, end);
                    }
                }
                if (this.cfg.triggerStart(containedLabel)) {
                    buf.append("\n  ");
                    buf.append(" trigger start");
                }
                if (this.cfg.triggerEnd(containedLabel)) {
                    buf.append("\n  ");
                    buf.append(" trigger end");
                }
                if ((openEnters = this.cfg.getOpenMonitorEnters(containedLabel)) != null && (openCount = openEnters.size()) > 0) {
                    buf.append("\n  ");
                    buf.append("open monitors: ");
                    for (j = 0; j < openCount; ++j) {
                        CodeLocation l = openEnters.get(j);
                        buf.append(" BB");
                        buf.append(l.getBlockIdx());
                        buf.append(".");
                        buf.append(l.getInstructionIdx());
                    }
                }
                buf.append("\n");
                containedLabel = containsIter.hasNext() ? containsIter.next() : null;
                containedPosition = containedLabel != null ? this.cfg.getBlockInstructionIdx(containedLabel) : -1;
            }
            buf.append(bcpos);
            buf.append(":\t");
            buf.append(blockIdx);
            buf.append(".");
            buf.append(i);
            buf.append(": ");
            int opcode = this.getInstruction(i);
            int insnType = OpcodesHelper.insnType(opcode);
            switch (insnType) {
                case 0: {
                    buf.append(OpcodesHelper.insnName(opcode));
                    if (opcode == 195) {
                        CodeLocation exit = new CodeLocation(this, i);
                        CodeLocation enter = this.cfg.getPairedEnter(exit);
                        buf.append(" (enter: ");
                        buf.append(enter);
                        buf.append(")");
                    }
                    buf.append("\n");
                    break;
                }
                case 1: {
                    int intValue = this.getInstructionArg(i, 0);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(intValue);
                    buf.append("\n");
                    break;
                }
                case 2: {
                    int nameIdx = this.getInstructionArg(i, 0);
                    String name = this.cfg.getName(nameIdx);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(name);
                    buf.append("\n");
                    break;
                }
                case 3: {
                    int varIdx = this.getInstructionArg(i, 0);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(varIdx);
                    buf.append("\n");
                    break;
                }
                case 4: {
                    int increment = this.getInstructionArg(i, 0);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(increment);
                    buf.append("\n");
                    break;
                }
                case 5: {
                    Label targetLabel = this.firstOut();
                    switch (opcode) {
                        case 153: {
                            buf.append("IFEQ ");
                            break;
                        }
                        case 154: {
                            buf.append("IFNE ");
                            break;
                        }
                        case 155: {
                            buf.append("IFLT ");
                            break;
                        }
                        case 156: {
                            buf.append("IFGE ");
                            break;
                        }
                        case 157: {
                            buf.append("IFGT ");
                            break;
                        }
                        case 158: {
                            buf.append("IFLE ");
                            break;
                        }
                        case 159: {
                            buf.append("IF_ICMPEQ ");
                            break;
                        }
                        case 160: {
                            buf.append("IF_ICMPNE ");
                            break;
                        }
                        case 161: {
                            buf.append("IF_ICMPLT ");
                            break;
                        }
                        case 162: {
                            buf.append("IF_ICMPGE ");
                            break;
                        }
                        case 163: {
                            buf.append("IF_ICMPGT ");
                            break;
                        }
                        case 164: {
                            buf.append("IF_ICMPLE ");
                            break;
                        }
                        case 165: {
                            break;
                        }
                        case 166: {
                            buf.append("IF_ACMPNE ");
                            break;
                        }
                        case 167: {
                            buf.append("GOTO ");
                            break;
                        }
                        case 168: {
                            buf.append("JSR ");
                            break;
                        }
                        case 198: {
                            buf.append("IFNULL ");
                            break;
                        }
                        case 199: {
                            buf.append("IFNONNULL ");
                        }
                    }
                    this.printLabelOffset(buf, targetLabel, true, "??");
                    buf.append(" ");
                    buf.append(targetLabel);
                    buf.append("\n");
                    break;
                }
                case 6: {
                    int min = this.getInstructionArg(i, 0);
                    int max = this.getInstructionArg(i, 1);
                    int count = max + 1 - min;
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(min);
                    buf.append(" ");
                    buf.append(max);
                    buf.append("\n");
                    for (int j = 1; j <= count; ++j) {
                        Label targetLabel = this.nthOut(j);
                        buf.append("    ");
                        buf.append(min + j);
                        buf.append(" : ");
                        this.printLabelOffset(buf, targetLabel, true, "??");
                        buf.append(" ");
                    }
                    Label targetLabel = this.firstOut();
                    buf.append("    dflt : ");
                    this.printLabelOffset(buf, targetLabel, true, "??");
                    buf.append(" ");
                    break;
                }
                case 7: {
                    int count = this.getInstructionArg(i, 0);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append("\n");
                    for (int j = 1; j <= count; ++j) {
                        Label targetLabel = this.nthOut(j);
                        buf.append("    ");
                        buf.append(this.getInstructionArg(i, j));
                        buf.append(" : ");
                        this.printLabelOffset(buf, targetLabel, true, "??");
                        buf.append(" ");
                    }
                    Label targetLabel = this.firstOut();
                    buf.append("    dflt : ");
                    this.printLabelOffset(buf, targetLabel, true, "??");
                    buf.append(" ");
                    break;
                }
                case 8: 
                case 9: {
                    int idx1 = this.getInstructionArg(i, 0);
                    int idx2 = this.getInstructionArg(i, 1);
                    int idx3 = this.getInstructionArg(i, 2);
                    String owner = this.cfg.getName(idx1);
                    String name = this.cfg.getName(idx2);
                    String desc = this.cfg.getName(idx3);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(owner);
                    buf.append(" ");
                    buf.append(name);
                    buf.append(" ");
                    buf.append(desc);
                    buf.append("\n");
                    break;
                }
                case 12: {
                    int idx1 = this.getInstructionArg(i, 0);
                    int idx2 = this.getInstructionArg(i, 1);
                    String owner = this.cfg.getName(idx1);
                    String name = this.cfg.getName(idx2);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(owner);
                    buf.append(" ");
                    buf.append(name);
                    buf.append("\n");
                    break;
                }
                case 10: {
                    int idx = this.getInstructionArg(i, 0);
                    String name = this.cfg.getName(idx);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(name);
                    buf.append("\n");
                    break;
                }
                case 11: {
                    int idx = this.getInstructionArg(i, 0);
                    int dims = this.getInstructionArg(i, 1);
                    String name = this.cfg.getName(idx);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(name);
                    buf.append(" ");
                    buf.append(dims);
                    buf.append("\n");
                    break;
                }
                case 99: {
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append("!!!\n");
                }
            }
            bcpos = this.nextBCPos(opcode, i, bcpos);
        }
        if (this.activeTryStarts != null) {
            Iterator<TryCatchDetails> activeStartsIter = this.activeTryStarts.iterator();
            buf.append("active try starts:\n");
            while (activeStartsIter.hasNext()) {
                TryCatchDetails details = activeStartsIter.next();
                buf.append("  try: ");
                buf.append(details.getType());
                buf.append(" ");
                Label label = details.getStart();
                this.printLabelOffset(buf, label, true, label);
                buf.append(" catch: ");
                label = details.getEnd();
                this.printLabelOffset(buf, label, true, label);
                buf.append(" handle: ");
                label = details.getHandler();
                this.printLabelOffset(buf, label, true, label);
                buf.append("\n");
            }
        }
    }

    private int nextBCPos(int opcode, int insnIdx, int currentPos) {
        int size = OpcodesHelper.insnsSize(opcode);
        if (size < 0) {
            size = -size;
            switch (opcode) {
                case 171: {
                    ++currentPos;
                    currentPos = (currentPos + 3) / 4 * 4;
                    currentPos += 8;
                    int count = this.getInstructionArg(insnIdx, 0);
                    currentPos += count * 8;
                    break;
                }
                case 170: {
                    ++currentPos;
                    currentPos = (currentPos + 3) / 4 * 4;
                    currentPos += 12;
                    int hi = this.getInstructionArg(insnIdx, 0);
                    int lo = this.getInstructionArg(insnIdx, 1);
                    int count = hi + 1 - lo;
                    currentPos += count * 4;
                    break;
                }
                default: {
                    if (opcode == 132) {
                        int slot = this.getInstructionArg(insnIdx, 0);
                        int value = this.getInstructionArg(insnIdx, 1);
                        if (slot > 255 || value > 127 || value < -128) {
                            currentPos += 6;
                            break;
                        }
                        currentPos += 3;
                        break;
                    }
                    if (opcode >= 21 && opcode <= 25 || opcode >= 54 && opcode <= 58) {
                        int slot = this.getInstructionArg(insnIdx, 0);
                        if (slot < 4) {
                            ++currentPos;
                            break;
                        }
                        if (slot > 255) {
                            currentPos += 4;
                            break;
                        }
                        currentPos += 2;
                        break;
                    }
                    if (opcode == 18) {
                        int offset = this.getInstructionArg(insnIdx, 0);
                        if (offset > 255) {
                            currentPos += 3;
                            break;
                        }
                        currentPos += 2;
                        break;
                    }
                    currentPos += size + 2;
                    break;
                }
            }
        } else {
            currentPos += size;
        }
        return currentPos;
    }
}

