/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.rocketmq;

import io.debezium.DebeziumException;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.server.BaseChangeConsumer;
import io.debezium.server.CustomConsumerBuilder;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.selector.SelectMessageQueueByHash;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.protocol.LanguageCode;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="rocketmq")
@Dependent
public class RocketMqChangeConsumer
extends BaseChangeConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocketMqChangeConsumer.class);
    private static final String PROP_PREFIX = "debezium.sink.rocketmq.";
    private static final String PROP_PRODUCER_PREFIX = "debezium.sink.rocketmq.producer.";
    private static final String PROP_PRODUCER_ACL_ENABLE = "debezium.sink.rocketmq.producer.acl.enabled";
    private static final String PROP_PRODUCER_ACCESS_KEY = "debezium.sink.rocketmq.producer.access.key";
    private static final String PROP_PRODUCER_SECRET_KEY = "debezium.sink.rocketmq.producer.secret.key";
    private static final String PROP_PRODUCER_NAME_SRV_ADDR = "debezium.sink.rocketmq.producer.name.srv.addr";
    private static final String PROP_PRODUCER_GROUP = "debezium.sink.rocketmq.producer.group";
    private static final String PROP_PRODUCER_MAX_MESSAGE_SIZE = "debezium.sink.rocketmq.producer.max.message.size";
    private static final String PROP_PRODUCER_SEND_MSG_TIMEOUT = "debezium.sink.rocketmq.producer.send.msg.timeout";
    @Inject
    @CustomConsumerBuilder
    Instance<DefaultMQProducer> customRocketMqProducer;
    private DefaultMQProducer mqProducer;

    @PostConstruct
    void connect() {
        if (this.customRocketMqProducer.isResolvable()) {
            this.mqProducer = (DefaultMQProducer)this.customRocketMqProducer.get();
            this.startProducer();
            LOGGER.info("Obtained custom configured RocketMqProducer '{}'", (Object)this.mqProducer);
            return;
        }
        Config config = ConfigProvider.getConfig();
        AclClientRPCHook rpcHook = null;
        Optional aclEnable = config.getOptionalValue(PROP_PRODUCER_ACL_ENABLE, Boolean.class);
        if (aclEnable.isPresent() && ((Boolean)aclEnable.get()).booleanValue()) {
            if (config.getOptionalValue(PROP_PRODUCER_ACCESS_KEY, String.class).isEmpty() || config.getOptionalValue(PROP_PRODUCER_SECRET_KEY, String.class).isEmpty()) {
                throw new DebeziumException("When acl.enabled is true, access key and secret key cannot be empty");
            }
            rpcHook = new AclClientRPCHook(new SessionCredentials((String)config.getValue(PROP_PRODUCER_ACCESS_KEY, String.class), (String)config.getValue(PROP_PRODUCER_SECRET_KEY, String.class)));
        }
        this.mqProducer = new DefaultMQProducer(rpcHook);
        this.mqProducer.setNamesrvAddr((String)config.getValue(PROP_PRODUCER_NAME_SRV_ADDR, String.class));
        this.mqProducer.setInstanceName(this.createUniqInstance((String)config.getValue(PROP_PRODUCER_NAME_SRV_ADDR, String.class)));
        this.mqProducer.setProducerGroup((String)config.getValue(PROP_PRODUCER_GROUP, String.class));
        if (config.getOptionalValue(PROP_PRODUCER_SEND_MSG_TIMEOUT, Integer.class).isPresent()) {
            this.mqProducer.setSendMsgTimeout(((Integer)config.getValue(PROP_PRODUCER_SEND_MSG_TIMEOUT, Integer.class)).intValue());
        }
        if (config.getOptionalValue(PROP_PRODUCER_MAX_MESSAGE_SIZE, Integer.class).isPresent()) {
            this.mqProducer.setMaxMessageSize(((Integer)config.getValue(PROP_PRODUCER_MAX_MESSAGE_SIZE, Integer.class)).intValue());
        }
        this.mqProducer.setLanguage(LanguageCode.JAVA);
        this.startProducer();
    }

    private void startProducer() {
        try {
            this.mqProducer.start();
            LOGGER.info("Consumer started...");
        }
        catch (MQClientException e) {
            throw new DebeziumException((Throwable)e);
        }
    }

    private String createUniqInstance(String prefix) {
        return prefix.concat("-").concat(UUID.randomUUID().toString());
    }

    @PreDestroy
    void close() {
        LOGGER.info("Consumer destroy...");
        if (this.mqProducer != null) {
            this.mqProducer.shutdown();
        }
    }

    public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(records.size());
        for (final ChangeEvent<Object, Object> record : records) {
            try {
                String topicName = this.streamNameMapper.map(record.destination());
                String key = this.getString(record.key());
                Message message = new Message(topicName, null, key, this.getBytes(record.value()));
                Map headers = this.convertHeaders(record);
                for (Map.Entry entry : headers.entrySet()) {
                    message.putUserProperty((String)entry.getKey(), (String)entry.getValue());
                }
                this.mqProducer.send(message, (MessageQueueSelector)new SelectMessageQueueByHash(), (Object)key, new SendCallback(){

                    public void onSuccess(SendResult sendResult) {
                        LOGGER.debug("Sent message with offset: {}", (Object)sendResult.getQueueOffset());
                        latch.countDown();
                    }

                    public void onException(Throwable throwable) {
                        LOGGER.error("Failed to send record to {}:", (Object)record.destination(), (Object)throwable);
                        throw new DebeziumException(throwable);
                    }
                });
            }
            catch (Exception e) {
                throw new DebeziumException((Throwable)e);
            }
        }
        latch.await();
        for (final ChangeEvent<Object, Object> record : records) {
            committer.markProcessed(record);
        }
        committer.markBatchFinished();
    }
}

