/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.cassandra.CassandraOffsetContext;
import io.debezium.connector.cassandra.CassandraPartition;
import io.debezium.connector.cassandra.Emitter;
import io.debezium.connector.cassandra.KeyspaceTable;
import io.debezium.connector.cassandra.Record;
import io.debezium.connector.cassandra.SourceInfo;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorTaskException;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.Sizeable;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.spi.topic.TopicNamingStrategy;
import org.apache.kafka.connect.source.SourceRecord;

public class SourceRecordEmitter
implements Emitter {
    private final ChangeEventQueue<DataChangeEvent> queue;
    private final TopicNamingStrategy<KeyspaceTable> topicNamingStrategy;
    private final CassandraPartition partition;
    private final CassandraOffsetContext offset;

    public SourceRecordEmitter(ChangeEventQueue<DataChangeEvent> queue, TopicNamingStrategy<KeyspaceTable> topicNamingStrategy, CassandraPartition partition, CassandraOffsetContext offset) {
        this.queue = queue;
        this.topicNamingStrategy = topicNamingStrategy;
        this.partition = partition;
        this.offset = offset;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void emit(Record record) {
        SourceInfo source = record.getSource();
        this.offset.putOffset(source.keyspaceTable.name(), source.snapshot, source.offsetPosition.serialize());
        SourceRecord sourceRecord = new SourceRecord(this.partition.getSourcePartition(), this.offset.getOffset(), this.topicNamingStrategy.dataChangeTopic((DataCollectionId)source.keyspaceTable), null, record.getKeySchema(), (Object)record.buildKey(), record.getValueSchema(), (Object)record.buildValue(), null, null);
        DataChangeEvent event = new DataChangeEvent(sourceRecord);
        try {
            this.queue.enqueue((Sizeable)event);
        }
        catch (InterruptedException e) {
            throw new CassandraConnectorTaskException(e);
        }
    }
}

