/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.core.type.DefaultMapType;
import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.DebeziumTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.AbstractTupleTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.AbstractUserDefinedTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.CollectionTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.LogicalTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TypeDeserializer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Values;

public abstract class AbstractMapTypeDeserializer
extends CollectionTypeDeserializer {
    public AbstractMapTypeDeserializer(DebeziumTypeDeserializer deserializer, Integer dataType, Class<?> abstractTypeClass) {
        super(deserializer, dataType, abstractTypeClass);
    }

    @Override
    public Object deserialize(Object abstractType, ByteBuffer bb) {
        Map<?, ?> deserializedMap = (Map<?, ?>)super.deserialize(abstractType, bb);
        deserializedMap = this.processKeyValueInDeserializedMap(abstractType, deserializedMap);
        return Values.convertToMap((Schema)this.getSchemaBuilder(abstractType).build(), deserializedMap);
    }

    @Override
    public SchemaBuilder getSchemaBuilder(Object abstractType) {
        Object keysType = this.getKeysType(abstractType);
        Object valuesType = this.getValuesType(abstractType);
        Schema keySchema = CassandraTypeDeserializer.getSchemaBuilder(keysType).build();
        Schema valuesSchema = CassandraTypeDeserializer.getSchemaBuilder(valuesType).build();
        return SchemaBuilder.map((Schema)keySchema, (Schema)valuesSchema).optional();
    }

    @Override
    public Object deserialize(Object abstractType, List<ByteBuffer> bbList) {
        Object keysType = this.getKeysType(abstractType);
        Object valuesType = this.getValuesType(abstractType);
        HashMap<Object, Object> deserializedMap = new HashMap<Object, Object>();
        int i = 0;
        while (i < bbList.size()) {
            ByteBuffer kbb = bbList.get(i++);
            ByteBuffer vbb = bbList.get(i++);
            deserializedMap.put(CassandraTypeDeserializer.deserialize(keysType, kbb), CassandraTypeDeserializer.deserialize(valuesType, vbb));
        }
        return Values.convertToMap((Schema)this.getSchemaBuilder(abstractType).build(), deserializedMap);
    }

    private Map<?, ?> processKeyValueInDeserializedMap(Object abstractType, Map<?, ?> deserializedMap) {
        Object keysType = this.getKeysType(abstractType);
        Object valuesType = this.getValuesType(abstractType);
        TypeDeserializer keysTypeDeserializer = CassandraTypeDeserializer.getTypeDeserializer(keysType);
        TypeDeserializer valuesTypeDeserializer = CassandraTypeDeserializer.getTypeDeserializer(valuesType);
        HashMap resultedMap = new HashMap();
        for (Map.Entry<?, ?> entry : deserializedMap.entrySet()) {
            Object key = entry.getKey();
            if (keysTypeDeserializer instanceof LogicalTypeDeserializer) {
                key = ((LogicalTypeDeserializer)keysTypeDeserializer).formatDeserializedValue(keysType, key);
            } else if (keysTypeDeserializer instanceof AbstractUserDefinedTypeDeserializer || keysTypeDeserializer instanceof AbstractTupleTypeDeserializer) {
                key = keysTypeDeserializer.deserialize(keysType, (ByteBuffer)key);
            }
            Object value = entry.getValue();
            if (valuesTypeDeserializer instanceof LogicalTypeDeserializer) {
                value = ((LogicalTypeDeserializer)valuesTypeDeserializer).formatDeserializedValue(valuesType, value);
            } else if (valuesTypeDeserializer instanceof AbstractUserDefinedTypeDeserializer || valuesTypeDeserializer instanceof AbstractTupleTypeDeserializer) {
                value = valuesTypeDeserializer.deserialize(valuesType, (ByteBuffer)value);
            }
            resultedMap.put(key, value);
        }
        return resultedMap;
    }

    @Override
    public Object getAbstractType(DataType dataType) {
        DefaultMapType mapType = (DefaultMapType)dataType;
        DataType innerKeyType = mapType.getKeyType();
        Object innerKeyAbstractType = CassandraTypeDeserializer.getTypeDeserializer(innerKeyType).getAbstractType(innerKeyType);
        DataType innerValueType = mapType.getValueType();
        Object innerValueAbstractType = CassandraTypeDeserializer.getTypeDeserializer(innerValueType).getAbstractType(innerValueType);
        return this.getAbstractTypeInstance(innerKeyAbstractType, innerValueAbstractType, !mapType.isFrozen());
    }

    protected abstract Object getKeysType(Object var1);

    protected abstract Object getValuesType(Object var1);

    protected abstract Object getAbstractTypeInstance(Object var1, Object var2, boolean var3);
}

