/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.core.type.DefaultUserDefinedType;
import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.DebeziumTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.AbstractTypeDeserializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public abstract class AbstractUserDefinedTypeDeserializer
extends AbstractTypeDeserializer {
    public AbstractUserDefinedTypeDeserializer(DebeziumTypeDeserializer deserializer, Integer dataType, Class<?> abstractTypeClass) {
        super(deserializer, dataType, abstractTypeClass);
    }

    @Override
    public Object deserialize(Object abstractType, ByteBuffer bb) {
        List<ByteBuffer> elements = this.bbList(abstractType, bb);
        Struct struct = new Struct(this.getSchemaBuilder(abstractType).build());
        List<String> fieldNames = this.fieldNames(abstractType);
        List<?> fieldTypes = this.fieldTypes(abstractType);
        for (int i = 0; i < fieldNames.size(); ++i) {
            String fieldName = fieldNames.get(i);
            Object fieldType = fieldTypes.get(i);
            struct.put(fieldName, CassandraTypeDeserializer.deserialize(fieldType, elements.get(i)));
        }
        return struct;
    }

    @Override
    public SchemaBuilder getSchemaBuilder(Object abstractType) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().name(this.structName(abstractType));
        List<String> fieldNames = this.fieldNames(abstractType);
        List<?> fieldTypes = this.fieldTypes(abstractType);
        for (int i = 0; i < fieldNames.size(); ++i) {
            Schema fieldSchema = CassandraTypeDeserializer.getSchemaBuilder(fieldTypes.get(i)).build();
            schemaBuilder.field(fieldNames.get(i), fieldSchema);
        }
        return schemaBuilder.optional();
    }

    @Override
    public Object getAbstractType(DataType dataType) {
        DefaultUserDefinedType userType = (DefaultUserDefinedType)dataType;
        List<String> fieldNames = userType.getFieldNames().stream().map(CqlIdentifier::toString).collect(Collectors.toList());
        List fieldTypes = userType.getFieldTypes();
        ArrayList<Object> innerAbstractTypes = new ArrayList<Object>(fieldNames.size());
        for (int i = 0; i < fieldNames.size(); ++i) {
            DataType innerDataType = (DataType)fieldTypes.get(i);
            Object innerAbstractType = CassandraTypeDeserializer.getTypeDeserializer(innerDataType).getAbstractType(innerDataType);
            innerAbstractTypes.add(innerAbstractType);
        }
        return this.getAbstractTypeInstance(userType, fieldNames, innerAbstractTypes);
    }

    protected abstract List<String> fieldNames(Object var1);

    protected abstract List<?> fieldTypes(Object var1);

    protected abstract List<ByteBuffer> bbList(Object var1, ByteBuffer var2);

    protected abstract String structName(Object var1);

    protected abstract Object getAbstractTypeInstance(DefaultUserDefinedType var1, List<String> var2, List<?> var3);
}

