/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.continuoustesting;

import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.testing.ContinuousTestingSharedStateManager;
import io.quarkus.vertx.http.runtime.devmode.Json;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Map;
import java.util.function.Consumer;

@ApplicationScoped
public class ContinuousTestingJsonRPCService
implements Consumer<ContinuousTestingSharedStateManager.State> {
    private final BroadcastProcessor<String> stateBroadcaster = BroadcastProcessor.create();
    private final BroadcastProcessor<String> resultBroadcaster = BroadcastProcessor.create();
    private String lastKnownState = "";
    private String lastKnownResults = "";
    private static final String NAMESPACE = "devui-continuous-testing";
    private static final String DASH = "-";

    @Override
    public void accept(ContinuousTestingSharedStateManager.State state) {
        Json.JsonObjectBuilder response = Json.object();
        response.put("running", state.running);
        response.put("inProgress", state.inProgress);
        response.put("run", state.run);
        response.put("passed", state.passed);
        response.put("failed", state.failed);
        response.put("skipped", state.skipped);
        response.put("isBrokenOnly", state.isBrokenOnly);
        response.put("isTestOutput", state.isTestOutput);
        response.put("isInstrumentationBasedReload", state.isInstrumentationBasedReload);
        response.put("isLiveReload", state.isLiveReload);
        this.lastKnownState = response.build();
        this.stateBroadcaster.onNext((Object)this.lastKnownState);
        this.lastKnownResults = this.getResults();
        if (this.lastKnownResults != null) {
            this.resultBroadcaster.onNext((Object)this.lastKnownResults);
        }
    }

    public Multi<String> streamTestState() {
        return this.stateBroadcaster;
    }

    public Multi<String> streamTestResults() {
        return this.resultBroadcaster;
    }

    @NonBlocking
    public String lastKnownState() {
        return this.lastKnownState;
    }

    @NonBlocking
    public String lastKnownResults() {
        return this.lastKnownResults;
    }

    @NonBlocking
    public boolean start() {
        return (Boolean)this.invokeAction("start");
    }

    @NonBlocking
    public boolean stop() {
        return (Boolean)this.invokeAction("stop");
    }

    @NonBlocking
    public boolean runAll() {
        return (Boolean)this.invokeAction("runAll");
    }

    @NonBlocking
    public boolean runFailed() {
        return (Boolean)this.invokeAction("runFailed");
    }

    @NonBlocking
    public boolean toggleBrokenOnly() {
        return (Boolean)this.invokeAction("toggleBrokenOnly");
    }

    public String getResults() {
        return (String)this.invokeAction("getResults");
    }

    private <T> T invokeAction(String action) {
        try {
            return (T)DevConsoleManager.invoke((String)("devui-continuous-testing-" + action), Map.of());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

