/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch;

import com.datadoghq.sketch.ddsketch.DDSketch;
import com.datadoghq.sketch.ddsketch.mapping.CubicallyInterpolatedMapping;
import com.datadoghq.sketch.ddsketch.mapping.LogarithmicMapping;
import com.datadoghq.sketch.ddsketch.store.CollapsingHighestDenseStore;
import com.datadoghq.sketch.ddsketch.store.CollapsingLowestDenseStore;
import com.datadoghq.sketch.ddsketch.store.SparseStore;
import com.datadoghq.sketch.ddsketch.store.UnboundedSizeDenseStore;

public interface DDSketches {
    public static DDSketch unboundedDense(double relativeAccuracy) {
        return new DDSketch(new CubicallyInterpolatedMapping(relativeAccuracy), UnboundedSizeDenseStore::new);
    }

    public static DDSketch collapsingLowestDense(double relativeAccuracy, int maxNumBins) {
        return new DDSketch(new CubicallyInterpolatedMapping(relativeAccuracy), () -> new CollapsingLowestDenseStore(maxNumBins));
    }

    public static DDSketch collapsingHighestDense(double relativeAccuracy, int maxNumBins) {
        return new DDSketch(new CubicallyInterpolatedMapping(relativeAccuracy), () -> new CollapsingHighestDenseStore(maxNumBins));
    }

    public static DDSketch sparse(double relativeAccuracy) {
        return new DDSketch(new CubicallyInterpolatedMapping(relativeAccuracy), SparseStore::new);
    }

    public static DDSketch logarithmicUnboundedDense(double relativeAccuracy) {
        return new DDSketch(new LogarithmicMapping(relativeAccuracy), UnboundedSizeDenseStore::new);
    }

    public static DDSketch logarithmicCollapsingLowestDense(double relativeAccuracy, int maxNumBins) {
        return new DDSketch(new LogarithmicMapping(relativeAccuracy), () -> new CollapsingLowestDenseStore(maxNumBins));
    }

    public static DDSketch logarithmicCollapsingHighestDense(double relativeAccuracy, int maxNumBins) {
        return new DDSketch(new LogarithmicMapping(relativeAccuracy), () -> new CollapsingHighestDenseStore(maxNumBins));
    }
}

