/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.combined.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasResponse;
import java.util.ArrayList;
import java.util.List;

public abstract class RenameResponseDefinitionCommand
extends AbstractCommand {
    public String _oldName;
    public String _newName;
    public List<NodePath> _references;

    RenameResponseDefinitionCommand() {
    }

    RenameResponseDefinitionCommand(String oldName, String newName) {
        this._oldName = oldName;
        this._newName = newName;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[RenameResponseDefinitionCommand] Executing.", new Object[0]);
        this._references = new ArrayList<NodePath>();
        if (this._renameResponseDefinition((OasDocument)document, this._oldName, this._newName)) {
            String oldRef = this._nameToReference(this._oldName);
            String newRef = this._nameToReference(this._newName);
            ResponseRefFinder responseFinder = new ResponseRefFinder(oldRef);
            List<OasResponse> responses = responseFinder.findIn(document);
            for (OasResponse response : responses) {
                this._references.add(Library.createNodePath(response));
                response.$ref = newRef;
            }
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[RenameResponseDefinitionCommand] Reverting.", new Object[0]);
        if (this._renameResponseDefinition((OasDocument)document, this._newName, this._oldName)) {
            String oldRef = this._nameToReference(this._oldName);
            if (ModelUtils.isDefined(this._references)) {
                this._references.forEach(ref -> {
                    OasResponse response = (OasResponse)ref.resolve(document);
                    response.$ref = oldRef;
                });
            }
        }
    }

    protected abstract String _nameToReference(String var1);

    protected abstract boolean _renameResponseDefinition(OasDocument var1, String var2, String var3);

    private static class ResponseRefFinder
    extends CombinedVisitorAdapter {
        private String _reference;
        private List<OasResponse> _responses = new ArrayList<OasResponse>();

        public ResponseRefFinder(String reference) {
            this._reference = reference;
        }

        public List<OasResponse> findIn(Document document) {
            VisitorUtil.visitTree(document, this, TraverserDirection.down);
            return this._responses;
        }

        protected boolean _accept(OasResponse response) {
            return ModelUtils.isDefined(response.$ref) && NodeCompat.equals(response.$ref, this._reference);
        }

        @Override
        public void visitResponse(OasResponse node) {
            if (this._accept(node)) {
                this._responses.add(node);
            }
        }
    }
}

