/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.impl.AbstractInvocationContext;
import io.quarkus.arc.impl.ContextDataMap;
import io.quarkus.arc.impl.InterceptorInvocation;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;

class LifecycleCallbackInvocationContext
extends AbstractInvocationContext {
    protected final Set<Annotation> bindings;
    protected final List<InterceptorInvocation> chain;
    private int position = 0;

    LifecycleCallbackInvocationContext(Object target, Object[] parameters, Set<Annotation> bindings, List<InterceptorInvocation> chain) {
        super(target, parameters, new ContextDataMap(bindings));
        this.chain = chain;
        this.bindings = bindings;
    }

    public Object proceed() throws Exception {
        try {
            if (this.position < this.chain.size()) {
                this.invokeNext();
            } else {
                this.interceptorChainCompleted();
            }
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    @Override
    public Set<Annotation> getInterceptorBindings() {
        return this.bindings;
    }

    public Object[] getParameters() {
        throw new IllegalStateException();
    }

    public void setParameters(Object[] params) {
        throw new IllegalStateException();
    }

    protected void interceptorChainCompleted() throws Exception {
    }

    private Object invokeNext() throws Exception {
        try {
            Object object = this.chain.get(this.position++).invoke(this);
            return object;
        }
        finally {
            --this.position;
        }
    }
}

