/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.mysql;

import com.google.common.math.IntMath;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class DateTime {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final long SECONDS_TO_MILLIS = 1000L;
    private static final long MINUTES_TO_MILLIS = 60000L;
    private static final long HOURS_TO_MILLIS = 3600000L;

    public static Date parseDate(String value) throws ParseException {
        return DateTime.parseDate(value, Calendar.getInstance());
    }

    public static Date parseDate(String value, Calendar cal) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setCalendar(cal);
        return new Date(dateFormat.parse(value).getTime());
    }

    public static String formatDate(Date value) {
        return DateTime.formatDate(value, Calendar.getInstance());
    }

    public static String formatDate(Date value, Calendar cal) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setCalendar(cal);
        return dateFormat.format(value);
    }

    public static Time parseTime(String value) throws ParseException {
        return DateTime.parseTime(value, Calendar.getInstance());
    }

    public static Time parseTime(String value, Calendar cal) throws ParseException {
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        long millis = 0L;
        try {
            int sepIndex1 = value.indexOf(58);
            if (sepIndex1 == -1) {
                throw new ParseException("Invalid MySQL TIME format: " + value, value.length());
            }
            hours = Long.parseLong(value.substring(0, sepIndex1));
            int sepIndex2 = value.indexOf(58, sepIndex1 + 1);
            if (sepIndex2 == -1) {
                minutes = Long.parseLong(value.substring(sepIndex1 + 1));
            } else {
                minutes = Long.parseLong(value.substring(sepIndex1 + 1, sepIndex2));
                int dotIndex = value.lastIndexOf(46);
                if (dotIndex == -1) {
                    seconds = Long.parseLong(value.substring(sepIndex2 + 1));
                } else {
                    seconds = Long.parseLong(value.substring(sepIndex2 + 1, dotIndex));
                    String fraction = value.substring(dotIndex + 1, value.length());
                    if (fraction.length() > 0) {
                        if (fraction.length() > 3) {
                            fraction = fraction.substring(0, 3);
                        }
                        millis = Long.parseLong(fraction) * (long)IntMath.pow((int)10, (int)(3 - fraction.length()));
                    }
                }
            }
        }
        catch (NumberFormatException exc) {
            throw new ParseException("Invalid MYSQL TIME format: " + value, 0);
        }
        if (hours < 0L) {
            minutes = -minutes;
            seconds = -seconds;
            millis = -millis;
        }
        long time = hours * 3600000L + minutes * 60000L + seconds * 1000L + millis;
        return new Time(time -= (long)cal.get(15));
    }

    public static String formatTime(Time value) {
        return DateTime.formatTime(value, Calendar.getInstance());
    }

    public static String formatTime(Time value, Calendar cal) {
        long seconds;
        long millis = value.getTime();
        String sign = "";
        if ((millis += (long)cal.get(15)) < 0L) {
            sign = "-";
            millis = -millis;
        }
        long hours = millis / 3600000L;
        long minutes = (millis -= hours * 3600000L) / 60000L;
        millis -= minutes * 60000L;
        if ((millis -= (seconds = millis / 1000L) * 1000L) == 0L) {
            return String.format("%s%02d:%02d:%02d", sign, hours, minutes, seconds);
        }
        return String.format("%s%02d:%02d:%02d.%03d", sign, hours, minutes, seconds, millis);
    }

    public static Timestamp parseTimestamp(String value) throws ParseException {
        return DateTime.parseTimestamp(value, Calendar.getInstance());
    }

    public static Timestamp parseTimestamp(String value, Calendar cal) throws ParseException {
        int nanos = 0;
        int dotIndex = value.lastIndexOf(46);
        if (dotIndex != -1) {
            String fraction = value.substring(dotIndex + 1, value.length());
            if (fraction.length() > 0) {
                if (fraction.length() > 9) {
                    fraction = fraction.substring(0, 9);
                }
                try {
                    nanos = Integer.parseInt(fraction) * IntMath.pow((int)10, (int)(9 - fraction.length()));
                }
                catch (NumberFormatException exc) {
                    throw new ParseException("Invalid MySQL TIMESTAMP format: " + value, dotIndex + 1);
                }
            }
            value = value.substring(0, dotIndex);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATETIME_FORMAT);
        dateFormat.setCalendar(cal);
        Timestamp result = new Timestamp(dateFormat.parse(value).getTime());
        result.setNanos(nanos);
        return result;
    }

    public static String formatTimestamp(Timestamp value) {
        return DateTime.formatTimestamp(value, Calendar.getInstance());
    }

    public static String formatTimestamp(Timestamp value, Calendar cal) {
        int end;
        long millis = value.getNanos() / 1000;
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATETIME_FORMAT);
        dateFormat.setCalendar(cal);
        String dateString = dateFormat.format(value);
        if (millis == 0L) {
            return dateString + ".0";
        }
        String result = String.format("%s.%06d", dateString, millis);
        for (end = result.length(); end > 0 && result.charAt(end - 1) == '0'; --end) {
        }
        return result.substring(0, end);
    }
}

