/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.spanner.SpannerConnector;
import io.debezium.connector.spanner.SpannerConnectorTask;
import io.debezium.pipeline.ErrorHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.RetriableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpannerErrorHandler
extends ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpannerErrorHandler.class);
    private final AtomicReference<Throwable> producerThrowable = new AtomicReference<Object>(null);
    private final ChangeEventQueue<?> queue;
    private final SpannerConnectorTask task;

    public SpannerErrorHandler(SpannerConnectorTask task, ChangeEventQueue<?> queue) {
        super(SpannerConnector.class, null, queue);
        this.task = task;
        this.queue = queue;
    }

    protected boolean isRetriable(Throwable throwable) {
        return true;
    }

    public void setProducerThrowable(Throwable producerThrowable) {
        boolean first = this.producerThrowable.compareAndSet(null, producerThrowable);
        if (first) {
            LOGGER.error("Task failure, taskUid: {}, {}", (Object)this.task.getTaskUid(), (Object)SpannerErrorHandler.getStackTrace(producerThrowable));
        } else {
            LOGGER.warn("Follow-up failure exception, taskUid: {}, {}", (Object)this.task.getTaskUid(), (Object)SpannerErrorHandler.getStackTrace(producerThrowable));
        }
        boolean retriable = this.isRetriable(producerThrowable);
        if (first) {
            if (retriable) {
                this.queue.producerException((RuntimeException)new RetriableException("An exception occurred in the change event producer. This connector will be restarted.", producerThrowable));
            } else {
                this.queue.producerException((RuntimeException)((Object)new ConnectException("An exception occurred in the change event producer. This connector will be stopped.", producerThrowable)));
            }
        }
    }

    public Throwable getProducerThrowable() {
        return this.producerThrowable.get();
    }

    public static String getStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }
}

