/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver.config;

import io.apicurio.registry.resolver.SchemaResolverConfig;
import io.apicurio.registry.resolver.strategy.DynamicArtifactReferenceResolverStrategy;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DefaultSchemaResolverConfig {
    private static final Map<String, Object> DEFAULTS = Map.of("apicurio.registry.artifact-resolver-strategy", DynamicArtifactReferenceResolverStrategy.class.getName(), "apicurio.registry.auto-register", false, "apicurio.registry.auto-register.if-exists", SchemaResolverConfig.AUTO_REGISTER_ARTIFACT_IF_EXISTS_DEFAULT, "apicurio.registry.find-latest", false, "apicurio.registry.check-period-ms", 30000L, "apicurio.registry.retry-count", 3L, "apicurio.registry.retry-backoff-ms", 300L);
    private Map<String, ?> originals;

    public DefaultSchemaResolverConfig(Map<String, ?> originals) {
        this.originals = originals;
    }

    public String getRegistryUrl() {
        return this.getString("apicurio.registry.url");
    }

    public String getTokenEndpoint() {
        return this.getString("apicurio.auth.service.token.endpoint");
    }

    public String getAuthServiceUrl() {
        return this.getString("apicurio.auth.service.url");
    }

    public String getAuthRealm() {
        return this.getString("apicurio.auth.realm");
    }

    public String getAuthClientId() {
        return this.getString("apicurio.auth.client.id");
    }

    public String getAuthClientSecret() {
        return this.getString("apicurio.auth.client.secret");
    }

    public String getAuthUsername() {
        return this.getString("apicurio.auth.username");
    }

    public String getAuthPassword() {
        return this.getString("apicurio.auth.password");
    }

    public Object getArtifactResolverStrategy() {
        return this.get("apicurio.registry.artifact-resolver-strategy");
    }

    public boolean autoRegisterArtifact() {
        return this.getBoolean("apicurio.registry.auto-register");
    }

    public String autoRegisterArtifactIfExists() {
        return this.getString("apicurio.registry.auto-register.if-exists");
    }

    public boolean findLatest() {
        return this.getBoolean("apicurio.registry.find-latest");
    }

    public Duration getCheckPeriod() {
        return this.extractDurationMillis(this.get("apicurio.registry.check-period-ms"), "apicurio.registry.check-period-ms");
    }

    public long getRetryCount() {
        long result = this.extractLong(this.get("apicurio.registry.retry-count"), "apicurio.registry.retry-count");
        if (result < 0L) {
            throw new IllegalArgumentException("Config param 'apicurio.registry.retry-count' must be non-negative. Got '" + result + "'.");
        }
        return result;
    }

    public Duration getRetryBackoff() {
        return this.extractDurationMillis(this.get("apicurio.registry.retry-backoff-ms"), "apicurio.registry.retry-backoff-ms");
    }

    public String getExplicitArtifactGroupId() {
        return this.getString("apicurio.registry.artifact.group-id");
    }

    public String getExplicitArtifactId() {
        return this.getString("apicurio.registry.artifact.artifact-id");
    }

    public String getExplicitArtifactVersion() {
        Object version = this.originals.get("apicurio.registry.artifact.version");
        if (version == null) {
            return null;
        }
        return version.toString();
    }

    private Duration extractDurationMillis(Object value, String configurationName) {
        long result;
        Objects.requireNonNull(value);
        Objects.requireNonNull(configurationName);
        if (value instanceof Number) {
            result = ((Number)value).longValue();
        } else if (value instanceof String) {
            result = Long.parseLong((String)value);
        } else if (value instanceof Duration) {
            result = ((Duration)value).toMillis();
        } else {
            throw new IllegalArgumentException("Config param '" + configurationName + "' type unsupported. Expected a Number, String, or Duration. Got '" + value + "'.");
        }
        if (result < 0L) {
            throw new IllegalArgumentException("Config param '" + configurationName + "' represents a duration, which must be non-negative. Got '" + value + "'.");
        }
        return Duration.ofMillis(result);
    }

    private long extractLong(Object value, String configurationName) {
        long result;
        Objects.requireNonNull(value);
        Objects.requireNonNull(configurationName);
        if (value instanceof Number) {
            result = ((Number)value).longValue();
        } else if (value instanceof String) {
            result = Long.parseLong((String)value);
        } else {
            throw new IllegalArgumentException("Config param '" + configurationName + "' type unsupported. Expected a Number or String. Got '" + value + "'.");
        }
        return result;
    }

    public Map<String, Object> originals() {
        return new HashMap<String, Object>(this.originals);
    }

    private Object get(String key) {
        if (!this.originals.containsKey(key) && DEFAULTS.containsKey(key)) {
            return DEFAULTS.get(key);
        }
        return this.originals.get(key);
    }

    private String getString(String key) {
        return (String)this.returnAs(key, this.get(key), String.class);
    }

    private Boolean getBoolean(String key) {
        return (Boolean)this.returnAs(key, this.get(key), Boolean.class);
    }

    private Object returnAs(String key, Object value, Class<?> type) {
        if (value == null) {
            return null;
        }
        String trimmed = null;
        if (value instanceof String) {
            trimmed = ((String)value).trim();
        }
        if (type == Boolean.class) {
            if (value instanceof String) {
                if (trimmed.equalsIgnoreCase("true")) {
                    return true;
                }
                if (trimmed.equalsIgnoreCase("false")) {
                    return false;
                }
                throw new IllegalStateException("Wrong configuration. Expected value to be either true or false for key " + key + " received value " + value);
            }
            if (value instanceof Boolean) {
                return value;
            }
            throw new IllegalStateException("Wrong configuration. Expected value to be either true or false for key " + key + " received value " + value);
        }
        if (type == String.class) {
            if (value instanceof String) {
                return trimmed;
            }
            throw new IllegalStateException("Expected value to be a string for key " + key + ", but it was a " + value.getClass().getName());
        }
        throw new IllegalStateException("Unknown type to return config as" + type);
    }
}

