/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.azure.blob.history;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.relational.history.AbstractFileBasedSchemaHistory;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.SchemaHistoryException;
import io.debezium.relational.history.SchemaHistoryListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureBlobSchemaHistory
extends AbstractFileBasedSchemaHistory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureBlobSchemaHistory.class);
    public static final String ACCOUNT_CONNECTION_STRING_CONFIG = "azure.storage.account.connectionstring";
    public static final String CONTAINER_NAME_CONFIG = "azure.storage.account.container.name";
    public static final String BLOB_NAME_CONFIG = "azure.storage.blob.name";
    public static final Field ACCOUNT_CONNECTION_STRING = Field.create((String)"schema.history.internal.azure.storage.account.connectionstring").withDisplayName("storage connection string").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH);
    public static final Field CONTAINER_NAME = Field.create((String)"schema.history.internal.azure.storage.account.container.name").withDisplayName("container name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).required();
    public static final Field BLOB_NAME = Field.create((String)"schema.history.internal.azure.storage.blob.name").withDisplayName("blob name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).required();
    public static final Field.Set ALL_FIELDS = Field.setOf((Field[])new Field[]{ACCOUNT_CONNECTION_STRING, CONTAINER_NAME, BLOB_NAME});
    private volatile BlobServiceClient blobServiceClient = null;
    private volatile BlobClient blobClient = null;
    private String container;
    private String blobName;

    public void configure(Configuration config, HistoryRecordComparator comparator, SchemaHistoryListener listener, boolean useCatalogBeforeSchema) {
        super.configure(config, comparator, listener, useCatalogBeforeSchema);
        if (!config.validateAndRecord((Iterable)ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new DebeziumException("Error configuring an instance of " + ((Object)((Object)this)).getClass().getSimpleName() + "; check the logs for details");
        }
        this.container = config.getString(CONTAINER_NAME);
        this.blobName = config.getString(BLOB_NAME);
    }

    protected void doPreStart() {
        if (this.blobServiceClient == null) {
            this.blobServiceClient = new BlobServiceClientBuilder().connectionString(this.config.getString(ACCOUNT_CONNECTION_STRING)).buildClient();
        }
        if (this.blobClient == null) {
            this.blobClient = this.blobServiceClient.getBlobContainerClient(this.container).getBlobClient(this.blobName);
        }
    }

    protected void doStart() {
        if (this.blobClient.exists().booleanValue()) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.blobClient.downloadStream((OutputStream)outputStream);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            this.toHistoryRecord(inputStream);
        }
    }

    protected void doPreStoreRecord(HistoryRecord record) {
        if (this.blobClient == null) {
            throw new SchemaHistoryException("No Blob client is available. Ensure that 'start()' is called before storing database history records.");
        }
    }

    protected void doStoreRecord(HistoryRecord record) {
        this.blobClient.upload((InputStream)new ByteArrayInputStream(this.fromHistoryRecord(record)), true);
    }

    public boolean storageExists() {
        boolean containerExists = this.blobServiceClient.getBlobContainerClient(this.container).exists();
        if (containerExists) {
            LOGGER.info("Container '{}' used to store database history exists", (Object)this.container);
        } else {
            LOGGER.info("Container '{}' used to store database history does not exist yet", (Object)this.container);
        }
        return containerExists;
    }

    public void initializeStorage() {
        LOGGER.info("Creating Azure Blob container '{}' used to store database history", (Object)this.container);
        this.blobServiceClient.createBlobContainer(this.container);
    }

    public String toString() {
        return "Azure Blob Storage";
    }
}

