/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.s3.history;

import io.debezium.DebeziumException;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.relational.history.AbstractFileBasedSchemaHistory;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.SchemaHistoryException;
import io.debezium.relational.history.SchemaHistoryListener;
import java.io.InputStream;
import java.net.URI;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;

@NotThreadSafe
public class S3SchemaHistory
extends AbstractFileBasedSchemaHistory {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3SchemaHistory.class);
    public static final String ACCESS_KEY_ID_CONFIG = "s3.access.key.id";
    public static final String SECRET_ACCESS_KEY_CONFIG = "s3.secret.access.key";
    public static final String REGION_CONFIG = "schema.history.internal.s3.region.name";
    public static final String BUCKET_CONFIG = "schema.history.internal.s3.bucket.name";
    public static final String OBJECT_NAME_CONFIG = "schema.history.internal.s3.object.name";
    public static final String ENDPOINT_CONFIG = "schema.history.internal.s3.endpoint";
    public static final String OBJECT_CONTENT_TYPE = "text/plain";
    public static final Field ACCESS_KEY_ID = Field.create((String)"schema.history.internal.s3.access.key.id").withDisplayName("S3 access key id").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH);
    public static final Field SECRET_ACCESS_KEY = Field.create((String)"schema.history.internal.s3.secret.access.key").withDisplayName("S3 secret access key").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH);
    public static final Field REGION = Field.create((String)"schema.history.internal.s3.region.name").withDisplayName("S3 region").withWidth(ConfigDef.Width.LONG).withType(ConfigDef.Type.STRING).withImportance(ConfigDef.Importance.MEDIUM).required();
    public static final Field BUCKET = Field.create((String)"schema.history.internal.s3.bucket.name").withDisplayName("S3 bucket").withType(ConfigDef.Type.STRING).withImportance(ConfigDef.Importance.HIGH).required();
    public static final Field OBJECT_NAME = Field.create((String)"schema.history.internal.s3.object.name").withDisplayName("S3 Object name").withType(ConfigDef.Type.STRING).withImportance(ConfigDef.Importance.HIGH).required().withDescription("The name of the object under which the history is stored.");
    public static final Field ENDPOINT = Field.create((String)"schema.history.internal.s3.endpoint").withDisplayName("S3 endpoint").withType(ConfigDef.Type.STRING).withImportance(ConfigDef.Importance.LOW);
    public static final Field.Set ALL_FIELDS = Field.setOf((Field[])new Field[]{ACCESS_KEY_ID, SECRET_ACCESS_KEY, REGION, BUCKET, ENDPOINT});
    private String bucket;
    private String objectName;
    private Region region;
    private URI endpoint = null;
    private AwsCredentialsProvider credentialsProvider = null;
    private volatile S3Client client = null;

    public void configure(Configuration config, HistoryRecordComparator comparator, SchemaHistoryListener listener, boolean useCatalogBeforeSchema) {
        super.configure(config, comparator, listener, useCatalogBeforeSchema);
        if (!config.validateAndRecord((Iterable)ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new DebeziumException("Error configuring an instance of " + ((Object)((Object)this)).getClass().getSimpleName() + "; check the logs for details");
        }
        this.bucket = config.getString(BUCKET);
        this.objectName = config.getString(OBJECT_NAME);
        String regionName = config.getString(REGION);
        this.region = Region.of((String)regionName);
        LOGGER.info("Database history will be stored in bucket '{}' under key '{}' using region '{}'", new Object[]{this.bucket, this.objectName, this.region});
        String uriString = config.getString(ENDPOINT);
        if (uriString != null) {
            LOGGER.info("Using explicitly configured endpoint " + uriString);
            this.endpoint = URI.create(uriString);
        }
        if (config.getString(ACCESS_KEY_ID) == null && config.getString(SECRET_ACCESS_KEY) == null) {
            LOGGER.info("DefaultCredentialsProvider is used for authentication");
            this.credentialsProvider = DefaultCredentialsProvider.create();
        } else {
            LOGGER.info("StaticCredentialsProvider is used for authentication");
            AwsBasicCredentials credentials = AwsBasicCredentials.create((String)config.getString(ACCESS_KEY_ID), (String)config.getString(SECRET_ACCESS_KEY));
            this.credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)credentials);
        }
    }

    protected void doPreStart() {
        if (this.client == null) {
            S3ClientBuilder clientBuilder = (S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider(this.credentialsProvider)).region(this.region);
            if (this.endpoint != null) {
                clientBuilder.endpointOverride(this.endpoint);
            }
            this.client = (S3Client)clientBuilder.build();
        }
    }

    protected void doStart() {
        InputStream objectInputStream = null;
        try {
            GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket).key(this.objectName).responseContentType(OBJECT_CONTENT_TYPE).build();
            objectInputStream = (InputStream)this.client.getObject(request, ResponseTransformer.toInputStream());
        }
        catch (NoSuchKeyException request) {
        }
        catch (S3Exception e) {
            throw new SchemaHistoryException("Can't retrieve history object from S3", (Throwable)e);
        }
        if (objectInputStream != null) {
            this.toHistoryRecord(objectInputStream);
        }
    }

    public void doStop() {
        if (this.client != null) {
            this.client.close();
        }
    }

    protected void doPreStoreRecord(HistoryRecord record) {
        if (this.client == null) {
            throw new SchemaHistoryException("No S3 client is available. Ensure that 'start()' is called before storing database history records.");
        }
    }

    protected void doStoreRecord(HistoryRecord record) {
        try {
            PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucket).key(this.objectName).contentType(OBJECT_CONTENT_TYPE).build();
            this.client.putObject(request, RequestBody.fromBytes((byte[])this.fromHistoryRecord(record)));
        }
        catch (S3Exception e) {
            throw new SchemaHistoryException("Can not store record to S3", (Throwable)e);
        }
    }

    public boolean storageExists() {
        boolean bucketExists = this.client.listBuckets().buckets().stream().map(Bucket::name).anyMatch(this.bucket::equals);
        if (bucketExists) {
            LOGGER.info("Bucket '{}' used to store database history exists", (Object)this.bucket);
        } else {
            LOGGER.info("Bucket '{}' used to store database history does not exist yet", (Object)this.bucket);
        }
        return bucketExists;
    }

    public void initializeStorage() {
        LOGGER.info("Creating S3 bucket '{}' used to store database history", (Object)this.bucket);
        this.client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(this.bucket).build());
    }

    public String toString() {
        return "S3";
    }
}

