/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve;

import com.ibm.as400.access.AS400;
import io.debezium.ibmi.db2.journal.retrieve.JournalInfo;
import io.debezium.ibmi.db2.journal.retrieve.JournalInfoRetrieval;
import io.debezium.ibmi.db2.journal.retrieve.JournalPosition;
import io.debezium.ibmi.db2.journal.retrieve.JournalProcessedPosition;
import io.debezium.ibmi.db2.journal.retrieve.JournalReceiver;
import io.debezium.ibmi.db2.journal.retrieve.PositionRange;
import io.debezium.ibmi.db2.journal.retrieve.ReceiverPagination;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.DetailedJournalReceiver;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.JournalReceiverInfo;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.JournalStatus;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ReceiverPaginationTest {
    ReceiverPagination receivers;
    @Mock
    JournalInfoRetrieval journalInfoRetrieval;
    JournalInfo journalInfo = new JournalInfo("journal", "journallib");
    @Mock
    AS400 as400;
    DetailedJournalReceiver dr3 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j3", "jlib"), new Date(3L), JournalStatus.Attached, Optional.of(1)), BigInteger.valueOf(9L), BigInteger.valueOf(17L), Optional.empty(), 1L, 1L);
    DetailedJournalReceiver dr2 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j2", "jlib"), new Date(2L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(3L), BigInteger.valueOf(8L), Optional.of(this.dr3.info().receiver()), 1L, 1L);
    DetailedJournalReceiver dr1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.ONE, BigInteger.TWO, Optional.of(this.dr2.info().receiver()), 1L, 1L);

    ReceiverPaginationTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
    }

    @Test
    void findRangeWithinCurrentPosistion() throws Exception {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        List<DetailedJournalReceiver> list = Arrays.asList(this.dr1);
        Mockito.when((Object)this.journalInfoRetrieval.getReceivers((AS400)ArgumentMatchers.any(), (JournalInfo)ArgumentMatchers.any())).thenReturn(list);
        Mockito.when((Object)this.journalInfoRetrieval.getCurrentDetailedJournalReceiver((AS400)ArgumentMatchers.any(), (JournalInfo)ArgumentMatchers.any())).thenReturn((Object)this.dr1);
        JournalProcessedPosition startPosition = new JournalProcessedPosition(BigInteger.ONE, new JournalReceiver("j1", "jlib"), Instant.ofEpochSecond(0L), true);
        PositionRange result = jreceivers.findRange(this.as400, startPosition);
        PositionRange rangeAnswer = new PositionRange(false, startPosition, new JournalPosition(this.dr1.end(), this.dr1.info().receiver()));
        Assertions.assertEquals((Object)rangeAnswer, (Object)result);
    }

    @Test
    void findRangeInList() throws Exception {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        List<DetailedJournalReceiver> list = Arrays.asList(this.dr1, this.dr2);
        Mockito.when((Object)this.journalInfoRetrieval.getReceivers((AS400)ArgumentMatchers.any(), (JournalInfo)ArgumentMatchers.any())).thenReturn(list);
        Mockito.when((Object)this.journalInfoRetrieval.getCurrentDetailedJournalReceiver((AS400)ArgumentMatchers.any(), (JournalInfo)ArgumentMatchers.any())).thenReturn((Object)this.dr2);
        JournalProcessedPosition startPosition = new JournalProcessedPosition(BigInteger.ONE, new JournalReceiver("j1", "jlib"), Instant.ofEpochSecond(0L), true);
        PositionRange result = jreceivers.findRange(this.as400, startPosition);
        PositionRange rangeAnswer = new PositionRange(false, startPosition, new JournalPosition(this.dr2.end(), this.dr2.info().receiver()));
        Assertions.assertEquals((Object)rangeAnswer, (Object)result);
    }

    @Test
    void findRangeReFetchList() throws Exception {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 15, this.journalInfo);
        DetailedJournalReceiver detailedEnd = this.dr2;
        List<DetailedJournalReceiver> list = Arrays.asList(this.dr1, detailedEnd);
        DetailedJournalReceiver detailedEnd2 = this.dr3;
        List<DetailedJournalReceiver> list2 = Arrays.asList(this.dr1, this.dr2, detailedEnd2);
        Mockito.when((Object)this.journalInfoRetrieval.getReceivers((AS400)ArgumentMatchers.any(), (JournalInfo)ArgumentMatchers.any())).thenReturn(list).thenReturn(list2);
        Mockito.when((Object)this.journalInfoRetrieval.getCurrentDetailedJournalReceiver((AS400)ArgumentMatchers.any(), (JournalInfo)ArgumentMatchers.any())).thenReturn((Object)detailedEnd).thenReturn((Object)detailedEnd2);
        JournalProcessedPosition startPosition = new JournalProcessedPosition(BigInteger.ONE, new JournalReceiver("j1", "jlib"), Instant.ofEpochSecond(0L), true);
        PositionRange result = jreceivers.findRange(this.as400, startPosition);
        PositionRange rangeAnswer = new PositionRange(false, startPosition, new JournalPosition(BigInteger.valueOf(8L), detailedEnd.info().receiver()));
        Assertions.assertEquals((Object)rangeAnswer, (Object)result);
        JournalProcessedPosition startPosition2 = new JournalProcessedPosition(BigInteger.valueOf(2L), new JournalReceiver("j2", "jlib"), Instant.ofEpochSecond(0L), true);
        PositionRange result2 = jreceivers.findRange(this.as400, startPosition2);
        PositionRange rangeAnswer2 = new PositionRange(false, startPosition2, new JournalPosition(BigInteger.valueOf(17L), detailedEnd2.info().receiver()));
        Assertions.assertEquals((Object)rangeAnswer2, (Object)result2);
    }

    @Test
    void testFindRangeMidFirstEntry() {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        DetailedJournalReceiver j1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(5L), Optional.of(new JournalReceiver("j2", "jlib")), 1L, 1L);
        DetailedJournalReceiver j2 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j2", "jlib"), new Date(2L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(6L), BigInteger.valueOf(20L), Optional.of(new JournalReceiver("j3", "jlib")), 1L, 1L);
        DetailedJournalReceiver j3 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j3", "jlib"), new Date(3L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(21L), BigInteger.valueOf(22L), Optional.empty(), 1L, 1L);
        List<DetailedJournalReceiver> list = Arrays.asList(j1, j2, j3);
        Optional position = jreceivers.findPosition(new JournalProcessedPosition(BigInteger.ONE, j1.info().receiver(), Instant.ofEpochSecond(0L), true), BigInteger.valueOf(3L), list, j3);
        Assertions.assertTrue((boolean)position.isPresent());
        Assertions.assertEquals((Object)"j1", (Object)((PositionRange)position.get()).end().getReceiver().name());
        Assertions.assertEquals((Object)BigInteger.valueOf(4L), (Object)((PositionRange)position.get()).end().getOffset());
    }

    @Test
    void testFindRangeMidSecondEntryReset() {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        DetailedJournalReceiver j1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(10L), Optional.of(new JournalReceiver("j2", "jlib")), 1L, 1L);
        DetailedJournalReceiver j2 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j2", "jlib"), new Date(2L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(11L), BigInteger.valueOf(20L), Optional.of(new JournalReceiver("j3", "jlib")), 1L, 1L);
        DetailedJournalReceiver j3 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j3", "jlib"), new Date(3L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(21L), BigInteger.valueOf(30L), Optional.empty(), 1L, 1L);
        List<DetailedJournalReceiver> list = Arrays.asList(j1, j2, j3);
        Optional position = jreceivers.findPosition(new JournalProcessedPosition(BigInteger.ONE, j1.info().receiver(), Instant.ofEpochSecond(0L), true), BigInteger.valueOf(15L), list, j3);
        Assertions.assertTrue((boolean)position.isPresent());
        Assertions.assertEquals((Object)"j2", (Object)((PositionRange)position.get()).end().getReceiver().name());
        Assertions.assertEquals((Object)BigInteger.valueOf(16L), (Object)((PositionRange)position.get()).end().getOffset());
    }

    @Test
    void testFindRangeMidSecondContiguous() {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        DetailedJournalReceiver j1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(2L), Optional.of(new JournalReceiver("j2", "jlib")), 1L, 1L);
        DetailedJournalReceiver j2 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j2", "jlib"), new Date(2L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(3L), BigInteger.valueOf(20L), Optional.of(new JournalReceiver("j3", "jlib")), 1L, 1L);
        DetailedJournalReceiver j3 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j3", "jlib"), new Date(3L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(21L), BigInteger.valueOf(22L), Optional.empty(), 1L, 1L);
        List<DetailedJournalReceiver> list = Arrays.asList(j1, j2, j3);
        Optional position = jreceivers.findPosition(new JournalProcessedPosition(BigInteger.ONE, j1.info().receiver(), Instant.ofEpochSecond(0L), true), BigInteger.valueOf(10L), list, j3);
        Assertions.assertTrue((boolean)position.isPresent());
        Assertions.assertEquals((Object)"j2", (Object)((PositionRange)position.get()).end().getReceiver().name());
        Assertions.assertEquals((Object)BigInteger.valueOf(11L), (Object)((PositionRange)position.get()).end().getOffset());
    }

    @Test
    void testFindRangeMidEndEntry() {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        DetailedJournalReceiver j1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(2L), Optional.of(new JournalReceiver("j2", "jlib")), 1L, 1L);
        DetailedJournalReceiver j2 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j2", "jlib"), new Date(2L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(3L), BigInteger.valueOf(20L), Optional.of(new JournalReceiver("j3", "jlib")), 1L, 1L);
        DetailedJournalReceiver j3 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j3", "jlib"), new Date(3L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(21L), BigInteger.valueOf(35L), Optional.empty(), 1L, 1L);
        List<DetailedJournalReceiver> list = Arrays.asList(j1, j2, j3);
        Optional position = jreceivers.findPosition(new JournalProcessedPosition(BigInteger.ONE, j1.info().receiver(), Instant.ofEpochSecond(0L), true), BigInteger.valueOf(30L), list, j3);
        Assertions.assertTrue((boolean)position.isPresent());
        Assertions.assertEquals((Object)"j3", (Object)((PositionRange)position.get()).end().getReceiver().name());
        Assertions.assertEquals((Object)BigInteger.valueOf(31L), (Object)((PositionRange)position.get()).end().getOffset());
    }

    @Test
    void testFindRangePastEnd() {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        DetailedJournalReceiver j1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(2L), Optional.of(new JournalReceiver("j2", "jlib")), 1L, 1L);
        DetailedJournalReceiver j2 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j2", "jlib"), new Date(2L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(3L), BigInteger.valueOf(20L), Optional.of(new JournalReceiver("j3", "jlib")), 1L, 1L);
        DetailedJournalReceiver j3 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j3", "jlib"), new Date(3L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(21L), BigInteger.valueOf(35L), Optional.empty(), 1L, 1L);
        List<DetailedJournalReceiver> list = List.of(j1, j2, j3);
        Optional position = jreceivers.findPosition(new JournalProcessedPosition(BigInteger.ONE, j1.info().receiver(), Instant.ofEpochSecond(0L), true), BigInteger.valueOf(100L), list, j3);
        Assertions.assertTrue((boolean)position.isPresent());
        Assertions.assertEquals((Object)"j3", (Object)((PositionRange)position.get()).end().getReceiver().name());
        Assertions.assertEquals((Object)BigInteger.valueOf(35L), (Object)((PositionRange)position.get()).end().getOffset());
    }

    @Test
    void testFindRangeEqualsEnd() {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 10, this.journalInfo);
        DetailedJournalReceiver j1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(10L), Optional.empty(), 1L, 1L);
        List<DetailedJournalReceiver> list = List.of(j1);
        Optional position = jreceivers.findPosition(new JournalProcessedPosition(BigInteger.ONE, j1.info().receiver(), Instant.ofEpochSecond(0L), true), BigInteger.valueOf(100L), list, j1);
        Assertions.assertTrue((boolean)position.isPresent());
        Assertions.assertEquals((Object)"j1", (Object)((PositionRange)position.get()).end().getReceiver().name());
        Assertions.assertEquals((Object)BigInteger.valueOf(10L), (Object)((PositionRange)position.get()).end().getOffset());
    }

    @Test
    void testFindMidStartingMid() {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        DetailedJournalReceiver j1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(10L), Optional.of(new JournalReceiver("j2", "jlib")), 1L, 1L);
        DetailedJournalReceiver j2 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j2", "jlib"), new Date(2L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(11L), BigInteger.valueOf(20L), Optional.of(new JournalReceiver("j3", "jlib")), 1L, 1L);
        DetailedJournalReceiver j3 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j3", "jlib"), new Date(3L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(21L), BigInteger.valueOf(30L), Optional.of(new JournalReceiver("j4", "jlib")), 1L, 1L);
        DetailedJournalReceiver j4 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j4", "jlib"), new Date(4L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(41L), BigInteger.valueOf(50L), Optional.empty(), 1L, 1L);
        List<DetailedJournalReceiver> list = List.of(j1, j2, j3, j4);
        JournalProcessedPosition start = new JournalProcessedPosition(BigInteger.valueOf(25L), j3.info().receiver(), Instant.ofEpochSecond(0L), true);
        Optional position = jreceivers.findPosition(start, BigInteger.valueOf(10L), list, j4);
        Assertions.assertTrue((boolean)position.isPresent());
        Assertions.assertEquals((Object)"j4", (Object)((PositionRange)position.get()).end().getReceiver().name());
        Assertions.assertEquals((Object)BigInteger.valueOf(45L), (Object)((PositionRange)position.get()).end().getOffset());
    }

    @Test
    void testFindStartingPastEnd() {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        DetailedJournalReceiver j1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(10L), Optional.of(new JournalReceiver("j2", "jlib")), 1L, 1L);
        DetailedJournalReceiver j2 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j2", "jlib"), new Date(2L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(11L), BigInteger.valueOf(20L), Optional.empty(), 1L, 1L);
        List<DetailedJournalReceiver> list = List.of(j1, j2);
        Optional position = jreceivers.findPosition(new JournalProcessedPosition(BigInteger.valueOf(30L), new JournalReceiver("j3", "jlib"), Instant.ofEpochSecond(0L), true), BigInteger.valueOf(15L), list, j2);
        Assertions.assertTrue((boolean)position.isEmpty());
    }

    @Test
    void testPaginateInSameReceiverEnd() throws Exception {
        int maxOffset = 1000;
        BigInteger maxServerSideEntriesBI = BigInteger.valueOf(1000L);
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 1000, this.journalInfo);
        JournalProcessedPosition startPosition = new JournalProcessedPosition(BigInteger.ONE, new JournalReceiver("j1", "jlib"), Instant.ofEpochSecond(0L), true);
        DetailedJournalReceiver endJournalPosition = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(100L), Optional.empty(), 1L, 1L);
        PositionRange range = jreceivers.paginateInSameReceiver(startPosition, endJournalPosition, maxServerSideEntriesBI);
        Assertions.assertEquals((Object)endJournalPosition.end(), (Object)range.end().getOffset());
    }

    @Test
    void testPaginateInSameReceiverLimited() throws Exception {
        int maxOffset = 10;
        BigInteger maxServerSideEntriesBI = BigInteger.valueOf(10L);
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 10, this.journalInfo);
        JournalProcessedPosition startPosition = new JournalProcessedPosition(BigInteger.ONE, new JournalReceiver("j1", "jlib"), Instant.ofEpochSecond(0L), true);
        DetailedJournalReceiver endJournalPosition = new DetailedJournalReceiver(new JournalReceiverInfo(startPosition.getReceiver(), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(100L), Optional.empty(), 1L, 1L);
        PositionRange range = jreceivers.paginateInSameReceiver(startPosition, endJournalPosition, maxServerSideEntriesBI);
        Assertions.assertEquals((Object)startPosition.getOffset().add(maxServerSideEntriesBI), (Object)range.end().getOffset());
    }

    @Test
    void testUpdateEndPosition() {
        DetailedJournalReceiver j1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(10L), Optional.of(new JournalReceiver("j2", "jlib")), 1L, 1L);
        DetailedJournalReceiver j2 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j2", "jlib"), new Date(2L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(11L), BigInteger.valueOf(20L), Optional.empty(), 1L, 1L);
        List<DetailedJournalReceiver> list = Arrays.asList(j1, j2);
        DetailedJournalReceiver endPosition = new DetailedJournalReceiver(new JournalReceiverInfo(j2.info().receiver(), new Date(2L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(11L), BigInteger.valueOf(200L), Optional.empty(), 1L, 1L);
        ReceiverPagination.updateEndPosition(list, (DetailedJournalReceiver)endPosition);
        Assertions.assertEquals((Object)endPosition, (Object)list.get(1));
    }

    @Test
    void testFindMissingCurrentReceiver() {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        DetailedJournalReceiver j1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(10L), Optional.of(new JournalReceiver("j2", "jlib")), 1L, 1L);
        DetailedJournalReceiver j2 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j2", "jlib"), new Date(2L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(11L), BigInteger.valueOf(20L), Optional.empty(), 1L, 1L);
        DetailedJournalReceiver j3 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j3", "jlib"), new Date(3L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(21L), BigInteger.valueOf(31L), Optional.of(new JournalReceiver("j4", "jlib")), 1L, 1L);
        List<DetailedJournalReceiver> list = List.of(j1, j2);
        Optional position = jreceivers.findPosition(new JournalProcessedPosition(BigInteger.valueOf(30L), j1.info().receiver(), Instant.ofEpochSecond(0L), true), BigInteger.valueOf(15L), list, j3);
        Assertions.assertTrue((boolean)position.isEmpty());
    }

    @Test
    void testContainsEndPosition() {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        List<DetailedJournalReceiver> list = List.of(this.dr2, this.dr3);
        Assertions.assertTrue((boolean)jreceivers.containsEndPosition(list, this.dr3), (String)"last entry found");
        Assertions.assertTrue((boolean)jreceivers.containsEndPosition(list, this.dr2), (String)"first entry found");
    }

    @Test
    void testNotContainsEndPosition() {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        List<DetailedJournalReceiver> list = List.of(this.dr2, this.dr3);
        boolean found = jreceivers.containsEndPosition(list, this.dr1);
        Assertions.assertFalse((boolean)found, (String)"receiver does not exist in list");
    }

    @Test
    void testStartEqualsEndNotProcessed() {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        DetailedJournalReceiver j1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(10L), Optional.empty(), 1L, 1L);
        List<DetailedJournalReceiver> list = List.of(j1);
        JournalProcessedPosition start = new JournalProcessedPosition(BigInteger.valueOf(10L), j1.info().receiver(), Instant.ofEpochSecond(0L), false);
        Optional found = jreceivers.findPosition(start, BigInteger.valueOf(15L), list, j1);
        Assertions.assertEquals((Object)start, (Object)((PositionRange)found.get()).start());
        Assertions.assertEquals((Object)start.asJournalPosition(), (Object)((PositionRange)found.get()).end());
        Assertions.assertFalse((boolean)((PositionRange)found.get()).startEqualsEnd());
    }

    @Test
    void testStartEqualsEndProcessed() {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        DetailedJournalReceiver j1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(10L), Optional.empty(), 1L, 1L);
        List<DetailedJournalReceiver> list = List.of(j1);
        JournalProcessedPosition start = new JournalProcessedPosition(BigInteger.valueOf(10L), j1.info().receiver(), Instant.ofEpochSecond(0L), true);
        Optional found = jreceivers.findPosition(start, BigInteger.valueOf(15L), list, j1);
        Assertions.assertEquals((Object)start, (Object)((PositionRange)found.get()).start());
        Assertions.assertEquals((Object)start.asJournalPosition(), (Object)((PositionRange)found.get()).end());
        Assertions.assertTrue((boolean)((PositionRange)found.get()).startEqualsEnd());
    }

    @Test
    void testStartEqualsEndProcessedResetReceiver() {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        DetailedJournalReceiver j1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(10L), Optional.of(new JournalReceiver("j2", "jlib")), 1L, 1L);
        DetailedJournalReceiver j2 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j2", "jlib"), new Date(2L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(1L), Optional.empty(), 1L, 1L);
        List<DetailedJournalReceiver> list = List.of(j1, j2);
        JournalProcessedPosition start = new JournalProcessedPosition(BigInteger.valueOf(10L), j1.info().receiver(), Instant.ofEpochSecond(10L), true);
        Optional found = jreceivers.findPosition(start, BigInteger.valueOf(20L), list, j2);
        Assertions.assertEquals((Object)new JournalProcessedPosition(JournalPosition.startPosition((DetailedJournalReceiver)j2), start.getTimeOfLastProcessed(), false), (Object)((PositionRange)found.get()).start());
        Assertions.assertEquals((Object)JournalPosition.endPosition((DetailedJournalReceiver)j2), (Object)((PositionRange)found.get()).end());
        Assertions.assertFalse((boolean)((PositionRange)found.get()).startEqualsEnd());
    }

    @Test
    void testStartEqualsEndNotProcessedResetReceivers() {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        DetailedJournalReceiver j1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(10L), Optional.of(new JournalReceiver("j2", "jlib")), 1L, 1L);
        DetailedJournalReceiver j2 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j2", "jlib"), new Date(2L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(1L), Optional.empty(), 1L, 1L);
        List<DetailedJournalReceiver> list = List.of(j1, j2);
        JournalProcessedPosition start = new JournalProcessedPosition(BigInteger.valueOf(10L), j1.info().receiver(), Instant.ofEpochSecond(10L), false);
        Optional found = jreceivers.findPosition(start, BigInteger.valueOf(20L), list, j2);
        Assertions.assertEquals((Object)start, (Object)((PositionRange)found.get()).start());
        Assertions.assertEquals((Object)JournalPosition.endPosition((DetailedJournalReceiver)j1), (Object)((PositionRange)found.get()).end());
        Assertions.assertFalse((boolean)((PositionRange)found.get()).startEqualsEnd());
    }

    @Test
    void testStartEqualsEndProcessedResetReceiversPaginate() {
        ReceiverPagination jreceivers = new ReceiverPagination(this.journalInfoRetrieval, 100, this.journalInfo);
        DetailedJournalReceiver j1 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j1", "jlib"), new Date(1L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(10L), Optional.of(new JournalReceiver("j2", "jlib")), 1L, 1L);
        DetailedJournalReceiver j2 = new DetailedJournalReceiver(new JournalReceiverInfo(new JournalReceiver("j2", "jlib"), new Date(2L), JournalStatus.OnlineSavedDetached, Optional.of(1)), BigInteger.valueOf(1L), BigInteger.valueOf(10L), Optional.empty(), 1L, 1L);
        List<DetailedJournalReceiver> list = List.of(j1, j2);
        JournalProcessedPosition start = new JournalProcessedPosition(BigInteger.valueOf(10L), j1.info().receiver(), Instant.ofEpochSecond(10L), true);
        Optional found = jreceivers.findPosition(start, BigInteger.valueOf(5L), list, j2);
        Assertions.assertEquals((Object)new JournalProcessedPosition(JournalPosition.startPosition((DetailedJournalReceiver)j2), start.getTimeOfLastProcessed(), false), (Object)((PositionRange)found.get()).start());
        Assertions.assertEquals((Object)new JournalPosition(BigInteger.valueOf(5L), j2.info().receiver()), (Object)((PositionRange)found.get()).end());
        Assertions.assertFalse((boolean)((PositionRange)found.get()).startEqualsEnd());
    }
}

