/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.configuration;

import io.deephaven.configuration.ConfigurationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class ConfigurationScope {
    private final String token;
    private final List<String> targetValues;
    private final List<ConfigurationScope> subScopes;

    private String getToken() {
        return this.token;
    }

    private List<String> getTargetValues() {
        return this.targetValues;
    }

    ConfigurationScope(String token, String targetValue) {
        this.token = token;
        this.subScopes = new ArrayList<ConfigurationScope>();
        this.targetValues = Arrays.stream(targetValue.split("\\|")).collect(Collectors.toList());
    }

    ConfigurationScope(List<ConfigurationScope> scopes) {
        if (scopes.size() == 1) {
            this.token = scopes.get(0).getToken();
            this.targetValues = scopes.get(0).getTargetValues();
            this.subScopes = new ArrayList<ConfigurationScope>();
        } else {
            this.token = null;
            this.targetValues = null;
            this.subScopes = scopes;
        }
    }

    boolean scopeMatches(ConfigurationContext context) {
        if (this.subScopes.isEmpty()) {
            return context.matches(this.token, this.targetValues);
        }
        for (ConfigurationScope aScope : this.subScopes) {
            if (aScope.scopeMatches(context)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.subScopes.isEmpty()) {
            return this.token + "=" + String.join((CharSequence)"|", this.targetValues);
        }
        return "[" + this.subScopes.stream().map(Objects::toString).collect(Collectors.joining(",")) + "]";
    }
}

