/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.configuration;

import io.deephaven.configuration.Configuration;
import io.deephaven.configuration.ConfigurationContext;
import io.deephaven.configuration.ConfigurationException;
import io.deephaven.configuration.ConfigurationScope;
import io.deephaven.configuration.PropertyHistory;
import io.deephaven.configuration.PropertyInputStreamLoader;
import io.deephaven.configuration.PropertyInputStreamLoaderFactory;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;

public class ParsedProperties
extends Properties {
    private static final String TOKEN_COMMENT_HASH = "#";
    private static final String TOKEN_COMMENT_BANG = "!";
    private static final String TOKEN_FINALIZE = "finalize ";
    private static final String TOKEN_FINAL = "final ";
    private static final String TOKEN_INCLUDE = "includefiles";
    private static final String TOKEN_SCOPE = Matcher.quoteReplacement("[");
    private static final String TOKEN_SCOPE_END = Matcher.quoteReplacement("]");
    private static final String TOKEN_SCOPE_OPEN = Matcher.quoteReplacement("{");
    private static final String TOKEN_SCOPE_CLOSE = Matcher.quoteReplacement("}");
    private static final Pattern propPattern = Pattern.compile("[:=]");
    private static final Pattern commaPattern = Pattern.compile(",");
    private static final Pattern equalPattern = Pattern.compile("[=]");
    private static final Logger log = LoggerFactory.getLogger(ParsedProperties.class);
    private String thisFile;
    private final LinkedList<ConfigurationScope> scope = new LinkedList();
    private final Map<String, Object> props;
    private int lineNum = 0;
    private final Set<String> finalProperties;
    private final Map<String, List<PropertyHistory>> lineNumbers;
    private final ConfigurationContext context;
    private final PropertyInputStreamLoader propertyInputStreamLoader;
    private boolean expectingScopeOpen = false;
    private boolean haveParsedFirstLine = false;
    private final boolean ignoreScopes;

    public Map<String, List<PropertyHistory>> getLineNumbers() {
        return Collections.unmodifiableMap(this.lineNumbers);
    }

    public ParsedProperties() {
        this(false);
    }

    public ParsedProperties(boolean ignoreScopes) {
        this.context = new ConfigurationContext();
        this.finalProperties = new HashSet<String>();
        this.lineNumbers = new HashMap<String, List<PropertyHistory>>();
        this.props = new LinkedHashMap<String, Object>();
        this.ignoreScopes = ignoreScopes;
        this.propertyInputStreamLoader = PropertyInputStreamLoaderFactory.newInstance();
    }

    @Override
    public synchronized void putAll(Map<?, ?> t) {
        t.forEach((? super K k, ? super V v) -> this.setProperty(k.toString(), v.toString()));
    }

    private ParsedProperties(ParsedProperties callingProperties) {
        this.context = callingProperties.getContext();
        this.finalProperties = callingProperties.getFinalProperties();
        this.lineNumbers = callingProperties.lineNumbers;
        this.props = callingProperties.props;
        this.ignoreScopes = callingProperties.ignoreScopes;
        this.propertyInputStreamLoader = callingProperties.propertyInputStreamLoader;
    }

    private void parseLine(String nextLine) throws IOException {
        boolean inScope = this.isContextValid();
        if (nextLine == null || nextLine.startsWith(TOKEN_COMMENT_HASH) || nextLine.startsWith(TOKEN_COMMENT_BANG) || nextLine.length() == 0) {
            return;
        }
        if (this.expectingScopeOpen && !nextLine.startsWith(TOKEN_SCOPE_OPEN)) {
            throw new ConfigurationException(TOKEN_SCOPE_OPEN + " must immediately follow a scope declaration, found : " + nextLine);
        }
        if (!this.expectingScopeOpen && nextLine.startsWith(TOKEN_SCOPE_OPEN)) {
            throw new ConfigurationException(TOKEN_SCOPE_OPEN + " may not be used as the first character of a property name: " + nextLine);
        }
        if (ParsedProperties.startsWithIgnoreCase(nextLine, TOKEN_FINALIZE) && inScope) {
            this.finalizeProperty(nextLine);
        } else if (ParsedProperties.startsWithIgnoreCase(nextLine, TOKEN_FINAL) && inScope) {
            String restOfLine = ParsedProperties.ltrim(nextLine.replaceFirst(TOKEN_FINAL, ""));
            this.storePropertyDeclaration(restOfLine, true);
        } else if (ParsedProperties.startsWithIgnoreCase(nextLine, TOKEN_SCOPE)) {
            this.defineScopeBlock(nextLine);
        } else if (ParsedProperties.startsWithIgnoreCase(nextLine, TOKEN_SCOPE_OPEN)) {
            this.openScopeBlock(nextLine);
        } else if (ParsedProperties.startsWithIgnoreCase(nextLine, TOKEN_SCOPE_CLOSE)) {
            this.closeScopeBlock(nextLine);
        } else if (inScope) {
            this.storePropertyDeclaration(nextLine, false);
        }
        this.haveParsedFirstLine = true;
    }

    private static boolean startsWithIgnoreCase(String baseString, String findString) {
        return baseString.regionMatches(true, 0, findString, 0, findString.length());
    }

    private void storePropertyDeclaration(String nextLine, boolean markFinal) throws IOException {
        String[] parts = propPattern.split(nextLine, 2);
        String token = parts[0].trim();
        String value = parts.length > 1 ? ParsedProperties.ltrim(parts[1]) : "";
        if (token.equals(TOKEN_INCLUDE)) {
            if (this.haveParsedFirstLine) {
                throw new ConfigurationException("includefiles found in location other than first non-comment line in file " + this.thisFile + ".");
            }
            for (String file : commaPattern.split(value)) {
                ParsedProperties includeProps = new ParsedProperties(this);
                includeProps.load(file.trim());
            }
        } else {
            if (token.equalsIgnoreCase(TOKEN_FINAL) || token.equalsIgnoreCase(TOKEN_FINALIZE)) {
                throw new ConfigurationException(token + " is a reserved keyword and may not be used as a property name.");
            }
            if (!this.isFinal(token)) {
                List tokenHistory = this.lineNumbers.computeIfAbsent(token, (? super K prop) -> new ArrayList());
                this.props.put(token, value);
                tokenHistory.add(0, new PropertyHistory(this.thisFile, this.lineNum, value, this.stringScope()));
                if (markFinal) {
                    this.finalizeProperty(token);
                }
            } else {
                this.handleFinalConflict(token);
            }
        }
    }

    private void closeScopeBlock(String nextLine) throws IOException {
        if (this.scope.size() <= 0) {
            throw new ConfigurationException(TOKEN_SCOPE_CLOSE + " found at line " + this.lineNum + " with no matching " + TOKEN_SCOPE_OPEN);
        }
        this.scope.removeLast();
        String restOfLine = ParsedProperties.ltrim(nextLine.replaceFirst(TOKEN_SCOPE_CLOSE, ""));
        this.parseLine(restOfLine);
    }

    private void openScopeBlock(String nextLine) throws IOException {
        if (!this.expectingScopeOpen) {
            throw new ConfigurationException("Found " + TOKEN_SCOPE_OPEN + " at line " + this.lineNum + " when none was expected.");
        }
        this.expectingScopeOpen = false;
        if (nextLine.length() > 1) {
            this.parseLine(ParsedProperties.ltrim(nextLine.substring(TOKEN_SCOPE_OPEN.length())));
        }
    }

    private void defineScopeBlock(String nextLine) throws IOException {
        int endBlock = nextLine.indexOf(TOKEN_SCOPE_END);
        if (endBlock < 0) {
            throw new ConfigurationException("Invalid scope declaration: unterminated scope block at line " + this.lineNum + ": " + nextLine);
        }
        String scopeSection = nextLine.substring(1, endBlock);
        String[] scopeItems = commaPattern.split(scopeSection);
        if (scopeItems.length == 0) {
            throw new ConfigurationException("Invalid scope declaration: scope with no scope items at line " + this.lineNum + ": " + nextLine);
        }
        ArrayList<ConfigurationScope> newScopes = new ArrayList<ConfigurationScope>();
        for (String aScope : scopeItems) {
            String[] parts = equalPattern.split(aScope, 2);
            if (parts.length < 2) {
                throw new ConfigurationException("Invalid scope declaration: no '=' found at line " + this.lineNum + ":" + nextLine);
            }
            String contextToken = parts[0].trim();
            String contextValue = ParsedProperties.ltrim(parts[1]);
            newScopes.add(new ConfigurationScope(contextToken, contextValue));
        }
        this.scope.add(new ConfigurationScope(newScopes));
        String restOfLine = ParsedProperties.ltrim(nextLine.substring(endBlock + 1));
        this.expectingScopeOpen = true;
        this.parseLine(restOfLine);
    }

    private void finalizeProperty(String nextLine) {
        String[] tokens;
        if (this.ignoreScopes) {
            return;
        }
        for (String aToken : tokens = commaPattern.split(nextLine.replaceFirst(TOKEN_FINALIZE, ""))) {
            String token = aToken.trim();
            if (!this.containsKey(token)) {
                List tokenHistory = this.lineNumbers.computeIfAbsent(token, (? super K prop) -> new ArrayList());
                tokenHistory.add(0, new PropertyHistory(this.thisFile, this.lineNum, "(Property finalized with no value defined)", this.stringScope()));
            }
            this.makePropertyFinal(token);
        }
    }

    private boolean isFinal(String token) {
        return this.finalProperties.stream().anyMatch(str -> {
            String pattern = this.createWildcardExpansionPattern((String)str);
            Pattern pat = Pattern.compile(pattern);
            return pat.matcher(token).matches();
        });
    }

    private void makePropertyFinal(String token) {
        if (this.ignoreScopes) {
            return;
        }
        this.finalProperties.add(token);
    }

    private boolean isContextValid() {
        if (this.ignoreScopes) {
            return true;
        }
        for (ConfigurationScope aScope : this.scope) {
            if (aScope.scopeMatches(this.context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.props.clear();
    }

    @Override
    public boolean contains(Object value) {
        return this.props.containsValue(value.toString());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.props.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.props.containsValue(value);
    }

    @Override
    public Enumeration<Object> elements() {
        throw new RuntimeException("'Elements' method is not available for Deephaven properties.");
    }

    @Override
    @NotNull
    public Set entrySet() {
        return this.props.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != this.props.getClass()) {
            return false;
        }
        return this.props.equals(o);
    }

    @Override
    public Object get(@NotNull Object key) {
        return this.props.get(key);
    }

    @Override
    public String getProperty(String key) {
        Object propVal = this.get(key);
        if (propVal == null) {
            return null;
        }
        return propVal instanceof String ? (String)propVal : null;
    }

    @Override
    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    @Override
    public Enumeration keys() {
        return Collections.enumeration(this.props.keySet());
    }

    @Override
    @NotNull
    public Set keySet() {
        return this.props.keySet();
    }

    @Override
    public void list(PrintStream out) {
        this.list(new PrintWriter(out, true));
    }

    @Override
    public void list(PrintWriter out) {
        out.println("-- listing properties --");
        for (Map.Entry e : this.entrySet()) {
            String key = (String)e.getKey();
            Object val = (String)e.getValue();
            if (((String)val).length() > 40) {
                val = ((String)val).substring(0, 37) + "...";
            }
            out.println(key + "=" + (String)val);
        }
    }

    @Override
    public int size() {
        return this.props.size();
    }

    @Override
    @NotNull
    public Collection values() {
        return this.props.values();
    }

    @Override
    public synchronized void load(InputStream stream) throws IOException {
        String rawLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        ParsedPropertiesLineReader lr = new ParsedPropertiesLineReader(reader);
        while (lr.isOpen() && (rawLine = lr.readLine()) != null) {
            String nextLine = ParsedProperties.convertUnicodeEncoding(rawLine);
            this.lineNum += lr.getNumLinesLastRead();
            if (nextLine == null) break;
            this.parseLine(nextLine);
        }
        if (this.scope.size() != 0) {
            throw new ConfigurationException("Failed to close scope in file " + this.thisFile);
        }
        this.thisFile = "(Modified outside of configuration file)";
        this.lineNum = -1;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return this.setProperty(key.toString(), value.toString());
    }

    @Override
    public synchronized Object remove(Object key) {
        if (this.isFinal(key.toString())) {
            this.handleFinalConflict(key.toString());
        }
        return this.props.remove(key);
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        if (!this.isFinal(key)) {
            List tokenHistory = this.lineNumbers.computeIfAbsent(key, (? super K prop) -> new ArrayList());
            StackTraceElement[] stack = new Throwable().getStackTrace();
            StringBuilder stackOutput = new StringBuilder("<not from configuration file>: ");
            if (stack != null && stack.length > 1) {
                int traceLen = Integer.min(4, stack.length);
                for (int fc = 1; fc < traceLen; ++fc) {
                    stackOutput.append(stack[fc].toString()).append(System.lineSeparator());
                }
            }
            tokenHistory.add(0, new PropertyHistory(stackOutput.toString(), 0, value, this.stringScope()));
            return this.props.put(key, value);
        }
        this.handleFinalConflict(key);
        return this.props.get(key);
    }

    private String stringScope() {
        return "[" + this.scope.stream().map(ConfigurationScope::toString).collect(Collectors.joining("]-[")) + "]";
    }

    public synchronized void load(String fileName) throws IOException, ConfigurationException {
        if (!Configuration.isQuiet()) {
            log.info((Object)("Loading " + fileName));
        }
        this.thisFile = fileName;
        try (InputStream resourceAsStream = this.propertyInputStreamLoader.openConfiguration(fileName);){
            this.load(resourceAsStream);
        }
    }

    private String createWildcardExpansionPattern(String token) {
        return ("\\Q" + token + "\\E").replaceAll("\\*", "\\\\E.*\\\\Q");
    }

    private void handleFinalConflict(String token) throws ConfigurationException {
        List<PropertyHistory> tokenHistory = this.lineNumbers.get(token);
        String finalPattern = null;
        if (tokenHistory == null && (tokenHistory = this.lineNumbers.get(finalPattern = this.finalProperties.stream().filter(str -> {
            String pattern = this.createWildcardExpansionPattern((String)str);
            Pattern pat = Pattern.compile(pattern);
            return pat.matcher(token).matches();
        }).findFirst().orElse(""))) == null) {
            throw new ConfigurationException("Property '" + token + "' previously marked as final was then modified in file '" + this.thisFile + "' at line " + this.lineNum);
        }
        StringBuilder msgBuilder = new StringBuilder("Property '" + token + "' marked as final in file '" + tokenHistory.get((int)0).fileName + "' with value at line " + tokenHistory.get((int)0).lineNumber);
        if (finalPattern != null) {
            msgBuilder.append(" with pattern '").append(finalPattern).append("' and");
        }
        if (this.lineNum >= 0) {
            msgBuilder.append(" was then modified in file '").append(this.thisFile).append("' at line ").append(this.lineNum);
        } else {
            msgBuilder.append(" was then modified outside of a configuration file");
        }
        throw new ConfigurationException(msgBuilder.toString());
    }

    private Set<String> getFinalProperties() {
        return this.finalProperties;
    }

    private ConfigurationContext getContext() {
        return this.context;
    }

    private static String convertUnicodeEncoding(String inString) {
        return StringEscapeUtils.unescapeJava((String)inString);
    }

    private static String ltrim(String trimMe) {
        int pos;
        if (trimMe == null) {
            return null;
        }
        for (pos = 0; pos < trimMe.length() && Character.isWhitespace(trimMe.charAt(pos)); ++pos) {
        }
        return trimMe.substring(pos);
    }

    Collection<String> getContextKeyValues() {
        return this.context.getContextKeyValues();
    }

    private class ParsedPropertiesLineReader {
        private final BufferedReader breader;
        private boolean open = true;
        private String nextLine;
        private int numLinesLastRead = 0;

        ParsedPropertiesLineReader(Reader reader) {
            this.breader = new BufferedReader(reader);
        }

        String readLine() throws IOException {
            StringBuilder retLine = new StringBuilder();
            this.numLinesLastRead = 0;
            if (this.nextLine == null) {
                this.nextLine = ParsedProperties.ltrim(this.breader.readLine());
            }
            do {
                if (retLine.toString().endsWith("\\") && !retLine.toString().endsWith("\\\\")) {
                    retLine.deleteCharAt(retLine.length() - 1);
                }
                if (this.nextLine != null) {
                    retLine.append(this.nextLine);
                }
                this.nextLine = ParsedProperties.ltrim(this.breader.readLine());
                ++this.numLinesLastRead;
            } while (retLine.toString().endsWith("\\") && !retLine.toString().endsWith("\\\\") && this.nextLine != null);
            if (this.nextLine == null) {
                this.open = false;
                this.breader.close();
            }
            return retLine.toString();
        }

        int getNumLinesLastRead() {
            return this.numLinesLastRead;
        }

        boolean isOpen() {
            return this.open;
        }
    }
}

