/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.configuration;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.configuration.PropertyException;
import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PropertyFile {
    protected final Logger log;
    protected Properties properties;
    private static final Parser booleanParser = new BooleanParser();
    private static final Parser integerParser = new IntegerParser();
    private static final Parser shortParser = new ShortParser();
    private static final Parser longParser = new LongParser();
    private static final Parser doubleParser = new DoubleParser();
    private static final Parser stringParser = new StringParser();

    public PropertyFile() {
        this.properties = new Properties();
        this.log = LoggerFactory.getLogger(PropertyFile.class);
    }

    public PropertyFile(String filename, Logger log, boolean fatal) {
        block3: {
            this.properties = new Properties();
            this.log = log;
            try {
                this.properties.load(new FileInputStream(filename));
            }
            catch (IOException e) {
                if (fatal) {
                    throw new PropertyException("Error reading engine params file", e);
                }
                if (log == null) break block3;
                log.warn((Object)("Error reading engine params file: " + e));
            }
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Properties getProperties(String prefix) {
        Properties result = new Properties();
        for (Object key : this.properties.keySet()) {
            String s;
            if (!(key instanceof String) || !(s = (String)key).startsWith(prefix)) continue;
            String value = this.properties.getProperty(s);
            result.setProperty(s.substring(prefix.length()), value);
        }
        return result;
    }

    public String setProperty(String key, String value) {
        if (null == value) {
            return (String)this.properties.remove(key);
        }
        return (String)this.properties.setProperty(key, value);
    }

    @NotNull
    public String getProperty(String propertyName) {
        String result = this.properties.getProperty(propertyName);
        if (null == result) {
            throw new PropertyException("Missing property in config file: " + propertyName);
        }
        return result;
    }

    public char getChar(String propertyName) {
        String propertyValue = this.getProperty(propertyName).trim();
        return propertyValue.length() > 0 ? propertyValue.charAt(0) : (char)'\u0000';
    }

    public int getInteger(String propertyName) {
        return Integer.parseInt(this.getProperty(propertyName).trim());
    }

    public int getPositiveInteger(String propertyName) {
        return Require.gtZero((int)this.getInteger(propertyName), (String)propertyName);
    }

    public short getShort(String propertyName) {
        return Short.parseShort(this.getProperty(propertyName).trim());
    }

    public long getLong(String propertyName) {
        return Long.parseLong(this.getProperty(propertyName).trim());
    }

    public double getDouble(String propertyName) {
        return Double.parseDouble(this.getProperty(propertyName).trim());
    }

    public boolean getBoolean(String propertyName) {
        return Boolean.valueOf(this.getProperty(propertyName).trim());
    }

    public boolean getBooleanWithDefault(String propertyName, boolean defaultValue) {
        if (!this.hasProperty(propertyName)) {
            return defaultValue;
        }
        return this.getBoolean(propertyName);
    }

    public long getLongWithDefault(String propertyName, long defaultValue) {
        if (!this.hasProperty(propertyName)) {
            return defaultValue;
        }
        return this.getLong(propertyName);
    }

    public short getShortWithDefault(String propertyName, short defaultValue) {
        if (!this.hasProperty(propertyName)) {
            return defaultValue;
        }
        return this.getShort(propertyName);
    }

    public int getIntegerWithDefault(String propertyName, int defaultValue) {
        if (!this.hasProperty(propertyName)) {
            return defaultValue;
        }
        return this.getInteger(propertyName);
    }

    public int getPossibleIntegerWithDefault(int defaultValue, String ... possiblePropertyNames) {
        for (String propertyName : possiblePropertyNames) {
            if (!this.hasProperty(propertyName)) continue;
            return this.getInteger(propertyName);
        }
        return defaultValue;
    }

    public String getStringWithDefault(String propertyName, String defaultValue) {
        if (!this.hasProperty(propertyName)) {
            return defaultValue;
        }
        return this.getProperty(propertyName);
    }

    public String getPossibleStringWithDefault(String defaultValue, String ... possiblePropertyNames) {
        for (String propertyName : possiblePropertyNames) {
            if (!this.hasProperty(propertyName)) continue;
            return this.getProperty(propertyName);
        }
        return defaultValue;
    }

    public double getDoubleWithDefault(String propertyName, double defaultValue) {
        if (!this.hasProperty(propertyName)) {
            return defaultValue;
        }
        return this.getDouble(propertyName);
    }

    private <T extends Parser> Object get(T parser, String propertyName, Logger logger, String logPrefix) {
        String propStringValue = this.properties.getProperty(propertyName);
        if (propStringValue == null) {
            String msg = "property " + propertyName + " is missing";
            logger.error((Object)(logPrefix + ": " + msg));
            throw new PropertyException(msg);
        }
        try {
            Object propValue = parser.parse(propStringValue);
            logger.info((Object)(logPrefix + ": property " + propertyName + " = " + propValue));
            return propValue;
        }
        catch (NumberFormatException e) {
            String msg = "property " + propertyName + " string value " + propStringValue + " couldn't be parsed as " + parser.typeName();
            logger.error((Object)(logPrefix + ": " + msg));
            throw new PropertyException(msg);
        }
    }

    public boolean getBoolean(String propertyName, Logger logger, String logPrefix) {
        Object result = this.get(booleanParser, propertyName, logger, logPrefix);
        return (Boolean)result;
    }

    public int getInteger(String propertyName, Logger logger, String logPrefix) {
        Object result = this.get(integerParser, propertyName, logger, logPrefix);
        return (Integer)result;
    }

    public short getShort(String propertyName, Logger logger, String logPrefix) {
        Object result = this.get(shortParser, propertyName, logger, logPrefix);
        return (Short)result;
    }

    public long getLong(String propertyName, Logger logger, String logPrefix) {
        Object result = this.get(longParser, propertyName, logger, logPrefix);
        return (Long)result;
    }

    public double getDouble(String propertyName, Logger logger, String logPrefix) {
        Object result = this.get(doubleParser, propertyName, logger, logPrefix);
        return (Double)result;
    }

    public String getString(String propertyName, Logger logger, String logPrefix) {
        Object result = this.get(stringParser, propertyName, logger, logPrefix);
        return (String)result;
    }

    public boolean getBooleanForClass(Class c, String propertyLast) {
        return this.getBoolean(c.getSimpleName() + "." + propertyLast, this.log, c.getName());
    }

    public boolean getBooleanForClassWithDefault(Class c, String propertyLast, boolean defaultValue) {
        String prop = c.getSimpleName() + "." + propertyLast;
        if (!this.hasProperty(prop)) {
            return defaultValue;
        }
        return this.getBoolean(prop, this.log, c.getName());
    }

    public int getIntegerForClass(Class c, String propertyLast) {
        return this.getInteger(c.getSimpleName() + "." + propertyLast, this.log, c.getName());
    }

    public int getIntegerForClassWithDefault(Class c, String propertyLast, int defaultValue) {
        String prop = c.getSimpleName() + "." + propertyLast;
        if (!this.hasProperty(prop)) {
            return defaultValue;
        }
        return this.getInteger(prop, this.log, c.getName());
    }

    public long getShortForClass(Class c, String propertyLast) {
        return this.getShort(c.getSimpleName() + "." + propertyLast, this.log, c.getName());
    }

    public long getLongForClass(Class c, String propertyLast) {
        return this.getLong(c.getSimpleName() + "." + propertyLast, this.log, c.getName());
    }

    public long getLongForClassWithDefault(Class c, String propertyLast, long defaultValue) {
        String prop = c.getSimpleName() + "." + propertyLast;
        if (!this.hasProperty(prop)) {
            return defaultValue;
        }
        return this.getLong(prop, this.log, c.getName());
    }

    public double getDoubleForClass(Class c, String propertyLast) {
        return this.getDouble(c.getSimpleName() + "." + propertyLast, this.log, c.getName());
    }

    public double getDoubleForClassWithDefault(Class c, String propertyLast, double defaultValue) {
        String prop = c.getSimpleName() + "." + propertyLast;
        if (!this.hasProperty(prop)) {
            return defaultValue;
        }
        return this.getDouble(prop, this.log, c.getName());
    }

    public String getStringForClass(Class c, String propertyLast) {
        return this.getString(c.getSimpleName() + "." + propertyLast, this.log, c.getName());
    }

    public boolean hasProperty(String propertyName) {
        return this.properties.getProperty(propertyName) != null;
    }

    public String getStringForClassWithDefault(Class c, String propertyLast, String defaultValue) {
        String prop = c.getSimpleName() + "." + propertyLast;
        if (!this.hasProperty(prop)) {
            return defaultValue;
        }
        return this.getString(prop, this.log, c.getName());
    }

    public TIntHashSet getIntHashSetForClass(Class c, String propertyLast) {
        return this.getIntHashSetFromProperty(c.getSimpleName() + "." + propertyLast);
    }

    public int[] getIntArrayForClass(Class c, String propertyLast) {
        return this.getIntegerArray(c.getSimpleName() + "." + propertyLast);
    }

    public void getClassParams(Logger log, Class c, String instanceStr, Object obj, int desiredMods) {
        Class<?> paramClass = obj.getClass();
        Field[] fields = paramClass.getDeclaredFields();
        String propBase = c.getSimpleName();
        String errMsg = "(getClassParams) class " + propBase + " property error.";
        for (Field f : fields) {
            if ((f.getModifiers() & desiredMods) == 0) {
                throw new PropertyException(errMsg, new PropertyException("Field with wrong modifiers " + f.toString()));
            }
            String fieldName = f.getName();
            String s = instanceStr == null || instanceStr.length() == 0 ? "" : instanceStr + ".";
            String propName = propBase + "." + s + fieldName;
            try {
                String value = this.getProperties().getProperty(propName);
                if (value == null) {
                    throw new PropertyException("null value for property " + propName);
                }
                String source = "file";
                f.setAccessible(true);
                String fieldTypeName = f.getType().getName();
                if (fieldTypeName.equals("java.lang.String")) {
                    f.set(obj, value.trim());
                } else if (fieldTypeName.equals("char")) {
                    f.setChar(obj, value.charAt(0));
                } else if (fieldTypeName.equals("byte")) {
                    f.setByte(obj, Byte.parseByte(value));
                } else if (fieldTypeName.equals("boolean")) {
                    f.setBoolean(obj, Boolean.parseBoolean(value));
                } else if (fieldTypeName.equals("short")) {
                    f.setShort(obj, Short.parseShort(value));
                } else if (fieldTypeName.equals("int")) {
                    f.setInt(obj, Integer.parseInt(value));
                } else if (fieldTypeName.equals("long")) {
                    f.setLong(obj, Long.parseLong(value));
                } else if (fieldTypeName.equals("float")) {
                    f.setFloat(obj, Float.parseFloat(value));
                } else if (fieldTypeName.equals("double")) {
                    f.setDouble(obj, Double.parseDouble(value));
                } else {
                    throw new PropertyException("Type not supported for property " + propName);
                }
                if (log == null) continue;
                log.info((Object)(">>>" + propName + " = " + f.get(obj).toString() + " (" + source + ")"));
            }
            catch (Exception e) {
                throw new PropertyException("Property " + propName + " is missing.", e);
            }
        }
    }

    public void getClassParams(Class c, Object obj) {
        this.getClassParams(null, c, null, obj, 1);
    }

    public void getClassParams(Logger log, Class c, Object obj) {
        this.getClassParams(log, c, null, obj, 1);
    }

    public void getClassParams(Logger log, Class c, String name, Object obj) {
        this.getClassParams(log, c, name, obj, 1);
    }

    public TIntHashSet getIntHashSetFromProperty(String propertyName) {
        TIntHashSet set = new TIntHashSet();
        for (String id : this.getProperty(propertyName).split("[, ]")) {
            if (id.length() <= 0) continue;
            set.add(Integer.parseInt(id));
        }
        return set;
    }

    public Set<String> getStringSetFromProperty(String propertyName) {
        Set set = CollectionUtil.setFromArray((Object[])this.getProperty(propertyName).split("[, ]"));
        set.remove("");
        return set;
    }

    public Set<String> getStringSetFromPropertyWithDefault(String propertyName, Set<String> defaultValue) {
        return this.hasProperty(propertyName) ? this.getStringSetFromProperty(propertyName) : defaultValue;
    }

    public String[] getStringArrayFromProperty(String propertyName) {
        return this.getProperty(propertyName).split("[, ]");
    }

    public String[] getStringArrayFromPropertyWithDefault(String propertyName, String[] defaultValue) {
        return this.hasProperty(propertyName) ? this.getStringArrayFromProperty(propertyName) : defaultValue;
    }

    public Set<String> getStringSetFromPropertyForClass(Class c, String propertyLast) {
        return this.getStringSetFromProperty(c.getSimpleName() + "." + propertyLast);
    }

    public Set<String> getNameStringSetFromProperty(String propertyName) {
        String propertyValue;
        switch (propertyValue = this.getProperty(propertyName).trim()) {
            case "*": {
                return CollectionUtil.universalSet();
            }
            case "": {
                return Collections.emptySet();
            }
        }
        Set result = CollectionUtil.setFromArray((Object[])propertyValue.split("[, ]+"));
        result.remove("");
        return result;
    }

    public Map<String, String> getNameStringMapFromProperty(String propertyName) {
        String propertyValue = this.getProperty(propertyName).trim();
        if (propertyValue.equals("")) {
            return Collections.emptyMap();
        }
        Matcher propertyMapMatcher = Pattern.compile("\\A\\(\\s*((?:[a-zA-Z0-9\\-\\. ]+=>[a-zA-Z0-9\\-\\. ]+,?)*)\\s*\\)\\Z").matcher(propertyValue);
        Require.requirement((boolean)propertyMapMatcher.matches(), (String)"propertyMapMatcher.matches())");
        HashMap<String, String> result = new HashMap<String, String>();
        for (String pair : propertyMapMatcher.group(1).split(",")) {
            if (pair.equals("")) continue;
            String[] values = pair.split("=>");
            Require.eq((int)values.length, (String)"values.length", (int)2);
            Require.eqNull((Object)result.put(values[0].trim(), values[1].trim()), (String)"result.put(values[0].trim(), values[1].trim())");
        }
        return result;
    }

    public int[] getIntegerArray(String propertyName) {
        String s = this.getProperty(propertyName);
        if (s.equals("")) {
            return new int[0];
        }
        String[] parts = s.split(",");
        int[] result = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            result[i] = Integer.parseInt(parts[i]);
        }
        return result;
    }

    public TIntSet getNonNegativeIntSetWithRangeSupport(String propertyName) {
        String s = this.getProperty(propertyName);
        TIntHashSet result = new TIntHashSet();
        String[] tokens = s.replaceAll(" +", "").split(",");
        Pattern rangePattern = Pattern.compile("(\\d+)\\-(\\d+)");
        for (int ti = 0; ti < tokens.length; ++ti) {
            String token = tokens[ti];
            if (token.length() == 0) continue;
            Matcher rangeMatcher = rangePattern.matcher(token);
            if (rangeMatcher.matches()) {
                int rangeBegin = Integer.parseInt(rangeMatcher.group(1));
                int rangeEnd = Integer.parseInt(rangeMatcher.group(2));
                Assert.assertion((0 <= rangeBegin && rangeBegin <= rangeEnd ? 1 : 0) != 0, (String)"0 <= rangeBegin && rangeBegin <= rangeEnd");
                for (int value = rangeBegin; value <= rangeEnd; ++value) {
                    result.add(value);
                }
                continue;
            }
            int value = Integer.parseInt(token);
            Assert.assertion((0 <= value ? 1 : 0) != 0, (String)"0 <= value");
            result.add(value);
        }
        return result;
    }

    public BitSet getBitSet(String propertyName, int length) {
        String s = this.getProperty(propertyName);
        if (s.equals("")) {
            return new BitSet(0);
        }
        String[] parts = s.split(",");
        BitSet result = new BitSet(length);
        for (int i = 0; i < parts.length; ++i) {
            result.set(Require.inRange((int)Integer.parseInt(parts[i]), (String)"bit", (int)length, (String)"length"));
        }
        return result;
    }

    public TObjectIntHashMap<String> getStringIntHashMap(String propertyName, String separator) {
        String s = this.getProperty(propertyName);
        if (s.equals("")) {
            return new TObjectIntHashMap();
        }
        String[] parts = s.split(",");
        TObjectIntHashMap map = new TObjectIntHashMap(parts.length);
        for (int i = 0; i < parts.length; ++i) {
            String[] keyValue = parts[i].split(separator);
            if (keyValue.length != 2) {
                throw new PropertyException("Can't parse property " + propertyName + "=" + s);
            }
            map.put((Object)keyValue[0], Integer.parseInt(keyValue[1]));
        }
        return map;
    }

    public long[] getLongArray(String propertyName) {
        String s = this.getProperty(propertyName);
        String[] parts = s.split(",");
        long[] result = new long[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            result[i] = Long.parseLong(parts[i]);
        }
        return result;
    }

    private static class StringParser
    implements Parser {
        private StringParser() {
        }

        @Override
        public String parse(String s) throws NumberFormatException {
            return s;
        }

        @Override
        public String typeName() {
            return "String";
        }
    }

    private static class DoubleParser
    implements Parser {
        private DoubleParser() {
        }

        @Override
        public Double parse(String s) throws NumberFormatException {
            return Double.valueOf(s);
        }

        @Override
        public String typeName() {
            return "double";
        }
    }

    private static class LongParser
    implements Parser {
        private LongParser() {
        }

        @Override
        public Long parse(String s) throws NumberFormatException {
            return Long.valueOf(s);
        }

        @Override
        public String typeName() {
            return "long";
        }
    }

    private static class ShortParser
    implements Parser {
        private ShortParser() {
        }

        @Override
        public Short parse(String s) throws NumberFormatException {
            return Short.valueOf(s);
        }

        @Override
        public String typeName() {
            return "short";
        }
    }

    private static class IntegerParser
    implements Parser {
        private IntegerParser() {
        }

        @Override
        public Integer parse(String s) throws NumberFormatException {
            return Integer.valueOf(s);
        }

        @Override
        public String typeName() {
            return "int";
        }
    }

    private static class BooleanParser
    implements Parser {
        private BooleanParser() {
        }

        @Override
        public Boolean parse(String s) throws NumberFormatException {
            return Boolean.valueOf(s);
        }

        @Override
        public String typeName() {
            return "boolean";
        }
    }

    private static interface Parser {
        public Object parse(String var1) throws NumberFormatException;

        public String typeName();
    }
}

