/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.configuration;

import com.google.auto.service.AutoService;
import io.deephaven.configuration.ConfigurationException;
import io.deephaven.configuration.PropertyInputStreamLoader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

@AutoService(value={PropertyInputStreamLoader.class})
public class PropertyInputStreamLoaderTraditional
implements PropertyInputStreamLoader {
    @Override
    public long getPriority() {
        return 100L;
    }

    @Override
    public InputStream openConfiguration(String name) {
        InputStream viaResources = this.getClass().getResourceAsStream("/" + name);
        if (viaResources != null) {
            return viaResources;
        }
        try {
            return new FileInputStream(name);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Could not load property file: " + name, e);
        }
    }
}

