/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp.container;

import io.deephaven.engine.rowset.impl.rsp.container.ArrayContainer;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerUtil;
import io.deephaven.engine.rowset.impl.rsp.container.SearchRangeIterator;

final class ArrayContainerRangeIterator
implements SearchRangeIterator {
    private final ArrayContainer parent;
    private int nextPos;
    private int start;
    private int end;

    public ArrayContainerRangeIterator(ArrayContainer p, int initialSkipCount) {
        this.parent = p;
        this.nextPos = initialSkipCount;
    }

    public ArrayContainerRangeIterator(ArrayContainerRangeIterator other) {
        this.nextPos = other.nextPos;
        this.start = other.start;
        this.end = other.end;
        this.parent = other.parent;
    }

    public ArrayContainerRangeIterator copy() {
        return new ArrayContainerRangeIterator(this);
    }

    @Override
    public boolean hasNext() {
        return this.nextPos < this.parent.cardinality;
    }

    @Override
    public int start() {
        return this.start;
    }

    @Override
    public int end() {
        return this.end;
    }

    @Override
    public void next() {
        int v;
        this.start = ContainerUtil.toIntUnsigned(this.parent.content[this.nextPos++]);
        this.end = this.start + 1;
        while (this.nextPos < this.parent.cardinality && (v = ContainerUtil.toIntUnsigned(this.parent.content[this.nextPos])) == this.end) {
            ++this.nextPos;
            this.end = v + 1;
        }
    }

    private void setRangeBoundariesFor(int v, int idx) {
        int vj;
        int vi = ContainerUtil.toIntUnsigned(this.parent.content[idx]);
        this.end = vi + 1;
        int iend = idx;
        int j = idx + 1;
        while (j < this.parent.cardinality && (vj = ContainerUtil.toIntUnsigned(this.parent.content[j])) - vi <= j - idx) {
            iend = j++;
            this.end = vj + 1;
        }
        this.start = Math.max(v, vi);
        this.nextPos = iend + 1;
    }

    @Override
    public boolean advance(int v) {
        if (this.nextPos > 0 && this.end > v) {
            return true;
        }
        int i = ContainerUtil.unsignedBinarySearch(this.parent.content, this.nextPos, this.parent.cardinality, ContainerUtil.lowbits(v));
        if (i < 0) {
            i = -i - 1;
        }
        if (i >= this.parent.cardinality) {
            this.nextPos = this.parent.cardinality;
            return false;
        }
        this.setRangeBoundariesFor(v, i);
        return true;
    }

    @Override
    public boolean search(ContainerUtil.TargetComparator comp) {
        int c;
        if (this.nextPos == 0) {
            if (!this.hasNext()) {
                return false;
            }
            this.next();
        }
        if ((c = comp.directionFrom(this.end - 1)) <= 0) {
            if (c == 0) {
                this.start = this.end - 1;
                return true;
            }
            if (this.start == this.end - 1) {
                return false;
            }
            c = comp.directionFrom(this.start);
            if (c < 0) {
                return false;
            }
            if (c == 0) {
                return true;
            }
            int j = ContainerUtil.rangeSearch(this.start + 1, this.end - 1, comp);
            if (j == -1) {
                return true;
            }
            this.start = j;
            return true;
        }
        int i = ContainerUtil.search(this.parent.content, this.nextPos, this.parent.cardinality, comp);
        if (i < 0) {
            this.setRangeBoundariesFor(this.start, this.nextPos - 1);
            return true;
        }
        this.setRangeBoundariesFor(this.parent.content[i], i);
        return true;
    }
}

