/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp.container;

import io.deephaven.engine.rowset.impl.rsp.container.ArrayContainer;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerShortBatchIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortConsumer;

public class ArrayShortBatchIterator
implements ContainerShortBatchIterator {
    private final ArrayContainer array;
    private int index;

    public ArrayShortBatchIterator(ArrayContainer array, int initialSkipCount) {
        this.array = array;
        this.index = initialSkipCount;
    }

    @Override
    public int next(short[] buffer, int offset, int maxCount) {
        int count = Math.min(maxCount, this.array.cardinality - this.index);
        System.arraycopy(this.array.content, this.index, buffer, offset, count);
        this.index += count;
        return count;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.array.getCardinality();
    }

    @Override
    public boolean forEach(ShortConsumer sc) {
        while (this.index < this.array.cardinality) {
            boolean wantMore;
            if (wantMore = sc.accept(this.array.content[this.index++])) continue;
            return false;
        }
        return true;
    }
}

