/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp.container;

import io.deephaven.engine.rowset.impl.rsp.container.BitmapContainer;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerUtil;
import io.deephaven.engine.rowset.impl.rsp.container.SearchRangeIterator;

final class BitmapContainerRangeIterator
implements SearchRangeIterator {
    private final long[] bitmap;
    private int x;
    private long w;
    private int start;
    private int end;
    private int offset;
    private boolean hasNext;

    public BitmapContainerRangeIterator(BitmapContainer p) {
        this(p, 0);
    }

    public BitmapContainerRangeIterator(BitmapContainer p, int initialSkipCount) {
        this.bitmap = p.bitmap;
        this.x = 0;
        this.offset = 0;
        this.w = this.bitmap[0];
        int remaining = initialSkipCount;
        while (true) {
            int bitCount;
            if (remaining < (bitCount = Long.bitCount(this.w))) {
                for (int i = 0; i < remaining; ++i) {
                    int shift = BitmapContainerRangeIterator.lowestBit(this.w) + 1;
                    this.offset += shift;
                    this.w >>>= shift;
                }
                break;
            }
            remaining -= bitCount;
            if (this.x >= 1023) {
                this.w = 0L;
                break;
            }
            ++this.x;
            this.w = this.bitmap[this.x];
        }
        this.end = -1;
        this.start = -1;
        this.hasNext = this.eatZeroes();
    }

    private boolean eatZeroes() {
        if (this.x >= this.bitmap.length) {
            return false;
        }
        if (this.w == 0L) {
            this.offset = 0;
            while (++this.x < this.bitmap.length) {
                this.w = this.bitmap[this.x];
                if (this.w == 0L) continue;
            }
            if (this.w == 0L) {
                return false;
            }
        }
        int zbits = BitmapContainerRangeIterator.lowestBit(this.w);
        this.offset += zbits;
        this.w >>>= zbits;
        return true;
    }

    BitmapContainerRangeIterator(BitmapContainerRangeIterator other) {
        this.bitmap = other.bitmap;
        this.x = other.x;
        this.w = other.w;
        this.start = other.start;
        this.end = other.end;
        this.offset = other.offset;
        this.hasNext = other.hasNext;
    }

    public BitmapContainerRangeIterator copy() {
        return new BitmapContainerRangeIterator(this);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public int start() {
        return this.start;
    }

    @Override
    public int end() {
        return this.end;
    }

    @Override
    public void next() {
        this.start = 64 * this.x + this.offset;
        int oneBits = BitmapContainerRangeIterator.lowestBit(this.w ^ 0xFFFFFFFFFFFFFFFFL);
        this.offset += oneBits;
        this.w >>>= oneBits;
        if (this.offset == 64) {
            this.offset = 0;
            do {
                ++this.x;
                if (this.x >= this.bitmap.length) {
                    this.end = 65536;
                    this.hasNext = false;
                    return;
                }
                this.w = this.bitmap[this.x];
            } while (this.w == -1L);
            oneBits = BitmapContainerRangeIterator.lowestBit(this.w ^ 0xFFFFFFFFFFFFFFFFL);
            this.offset += oneBits;
            this.w >>>= oneBits;
        }
        this.end = 64 * this.x + this.offset;
        this.hasNext = this.eatZeroes();
    }

    @Override
    public boolean advance(int v) {
        if (this.start == -1) {
            if (!this.hasNext()) {
                return false;
            }
            this.next();
        }
        if (v < this.end) {
            if (this.start < v) {
                this.start = v;
            }
            return true;
        }
        int p = v >> 6;
        int poffset = v & 0x3F;
        this.x = p;
        if (this.x >= this.bitmap.length) {
            return false;
        }
        this.offset = poffset;
        this.w = this.bitmap[this.x] >>> this.offset;
        this.hasNext = this.eatZeroes();
        if (!this.hasNext()) {
            return false;
        }
        this.next();
        if (this.start < v) {
            this.start = v;
        }
        return true;
    }

    private void setTo(int i, int ioffset) {
        this.x = i;
        this.w = this.bitmap[this.x];
        this.offset = ioffset;
        this.w >>>= this.offset;
        this.next();
    }

    private static int lowestBit(long v) {
        return Long.numberOfTrailingZeros(v);
    }

    private static int highestBit(long v) {
        return 63 - Long.numberOfLeadingZeros(v);
    }

    private static long maskForAllBitsSetFromOffsetToHigher(int offset) {
        return -1L << offset;
    }

    @Override
    public boolean search(ContainerUtil.TargetComparator comp) {
        int moffset;
        int m;
        int j;
        int c;
        if (this.start == -1) {
            if (!this.hasNext()) {
                return false;
            }
            this.next();
        }
        if ((c = comp.directionFrom(this.start)) <= 0) {
            return c == 0;
        }
        for (j = this.bitmap.length - 1; j > 0 && this.bitmap[j] == 0L; --j) {
        }
        int joffset = BitmapContainerRangeIterator.highestBit(this.bitmap[j]);
        int jv = 64 * j + joffset;
        if (comp.directionFrom(jv) >= 0) {
            this.x = this.bitmap.length;
            this.start = jv;
            this.end = this.start + 1;
            this.hasNext = false;
            return true;
        }
        int i = this.start >>> 6;
        int ioffset = this.start & 0x3F;
        int iv = this.start;
        while (true) {
            int mv = (iv + jv) / 2;
            m = mv >>> 6;
            moffset = mv & 0x3F;
            boolean tryLowerBits = false;
            long mask = BitmapContainerRangeIterator.maskForAllBitsSetFromOffsetToHigher(moffset);
            long masked = this.bitmap[m] & mask;
            if (masked == 0L) {
                int m2 = m;
                while (this.bitmap[++m2] == 0L) {
                }
                int m2offset = BitmapContainerRangeIterator.lowestBit(this.bitmap[m2]);
                if (m2 == j && m2offset == joffset) {
                    tryLowerBits = true;
                } else {
                    m = m2;
                    moffset = m2offset;
                    mv = 64 * m + moffset;
                }
            } else {
                moffset = BitmapContainerRangeIterator.lowestBit(masked);
                if (m == j && moffset == joffset) {
                    tryLowerBits = true;
                } else {
                    mv = 64 * m + moffset;
                }
            }
            if (tryLowerBits) {
                masked = this.bitmap[m] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                if (masked != 0L) {
                    moffset = BitmapContainerRangeIterator.highestBit(masked);
                    mv = 64 * m + moffset;
                } else {
                    while (this.bitmap[--m] == 0L) {
                    }
                    moffset = BitmapContainerRangeIterator.highestBit(this.bitmap[m]);
                    mv = 64 * m + moffset;
                }
            }
            if (mv <= iv || mv >= jv) {
                this.setTo(i, ioffset);
                return true;
            }
            c = comp.directionFrom(mv);
            if (c < 0) {
                jv = mv;
                j = m;
                joffset = moffset;
                continue;
            }
            if (c <= 0) break;
            iv = mv;
            i = m;
            ioffset = moffset;
        }
        this.setTo(m, moffset);
        return true;
    }
}

