/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp.container;

import io.deephaven.engine.rowset.impl.rsp.container.BitmapContainer;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerShortBatchIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortConsumer;

public class BitmapShortBatchIterator
implements ContainerShortBatchIterator {
    private final BitmapContainer bitmap;
    private int wordIndex;
    private long word;

    public BitmapShortBatchIterator(BitmapContainer bitmap, int initialSkipCount) {
        this.bitmap = bitmap;
        this.wordIndex = 0;
        this.word = bitmap.bitmap[0];
        int remaining = initialSkipCount;
        while (true) {
            int bitCount;
            if (remaining < (bitCount = Long.bitCount(this.word))) {
                for (int i = 0; i < remaining; ++i) {
                    this.word &= this.word - 1L;
                }
                break;
            }
            remaining -= bitCount;
            if (this.wordIndex >= 1023) {
                this.word = 0L;
                break;
            }
            ++this.wordIndex;
            this.word = bitmap.bitmap[this.wordIndex];
        }
    }

    @Override
    public int next(short[] buffer, int offset, int maxCount) {
        int count = 0;
        while (count < maxCount) {
            while (this.word == 0L) {
                ++this.wordIndex;
                if (this.wordIndex == 1024) {
                    return count;
                }
                this.word = this.bitmap.bitmap[this.wordIndex];
            }
            buffer[offset + count] = (short)(64 * this.wordIndex + Long.numberOfTrailingZeros(this.word));
            ++count;
            this.word &= this.word - 1L;
        }
        return count;
    }

    @Override
    public boolean hasNext() {
        if (this.word != 0L) {
            return true;
        }
        if (this.wordIndex >= 1023) {
            return false;
        }
        do {
            ++this.wordIndex;
            this.word = this.bitmap.bitmap[this.wordIndex];
            if (this.word == 0L) continue;
            return true;
        } while (this.wordIndex < 1023);
        return false;
    }

    @Override
    public boolean forEach(ShortConsumer sc) {
        while (true) {
            if (this.word == 0L) {
                ++this.wordIndex;
                if (this.wordIndex == 1024) {
                    return true;
                }
                this.word = this.bitmap.bitmap[this.wordIndex];
                continue;
            }
            short v = (short)(64 * this.wordIndex + Long.numberOfTrailingZeros(this.word));
            boolean wantMore = sc.accept(v);
            this.word &= this.word - 1L;
            if (!wantMore) break;
        }
        return false;
    }
}

