/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp.container;

import io.deephaven.engine.rowset.impl.rsp.container.ArrayContainer;
import io.deephaven.engine.rowset.impl.rsp.container.RunContainer;
import io.deephaven.engine.rowset.impl.rsp.container.ShortIterator;
import java.util.Arrays;

public final class ContainerUtil {
    public static final boolean USE_HYBRID_BINSEARCH = true;

    public static int advanceUntil(short[] array, int pos, int length, short min) {
        int upper;
        int lower = pos + 1;
        if (lower >= length || ContainerUtil.toIntUnsigned(array[lower]) >= ContainerUtil.toIntUnsigned(min)) {
            return lower;
        }
        int spansize = 1;
        while (lower + spansize < length && ContainerUtil.toIntUnsigned(array[lower + spansize]) < ContainerUtil.toIntUnsigned(min)) {
            spansize *= 2;
        }
        int n = upper = lower + spansize < length ? lower + spansize : length - 1;
        if (array[upper] == min) {
            return upper;
        }
        if (ContainerUtil.toIntUnsigned(array[upper]) < ContainerUtil.toIntUnsigned(min)) {
            return length;
        }
        lower += spansize >>> 1;
        while (lower + 1 != upper) {
            int mid = lower + upper >>> 1;
            short arraymid = array[mid];
            if (arraymid == min) {
                return mid;
            }
            if (ContainerUtil.toIntUnsigned(arraymid) < ContainerUtil.toIntUnsigned(min)) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        return upper;
    }

    public static int iterateUntil(short[] array, int pos, int length, int min) {
        while (pos < length && ContainerUtil.toIntUnsigned(array[pos]) < min) {
            ++pos;
        }
        return pos;
    }

    protected static int branchyUnsignedBinarySearch(short[] array, int begin, int end, short k) {
        int ikey = ContainerUtil.toIntUnsigned(k);
        if (end > 0 && ContainerUtil.toIntUnsigned(array[end - 1]) < ikey) {
            return -end - 1;
        }
        int low = begin;
        int high = end - 1;
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = ContainerUtil.toIntUnsigned(array[middleIndex]);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    public static int search(short[] array, int begin, int end, TargetComparator comp) {
        if (end < 1) {
            return -1;
        }
        int high = end - 1;
        int c = comp.directionFrom(ContainerUtil.toIntUnsigned(array[high]));
        if (c >= 0) {
            return high;
        }
        int low = begin;
        c = comp.directionFrom(ContainerUtil.toIntUnsigned(array[low]));
        if (c < 0) {
            return -1;
        }
        while (low + 32 < high) {
            int mid = (low + high) / 2;
            int midValue = ContainerUtil.toIntUnsigned(array[mid]);
            c = comp.directionFrom(midValue);
            if (c < 0) {
                high = mid - 1;
                continue;
            }
            if (c > 0) {
                low = mid;
                continue;
            }
            return mid;
        }
        while (low < high) {
            int lowNext = low + 1;
            int lowNextValue = ContainerUtil.toIntUnsigned(array[lowNext]);
            c = comp.directionFrom(lowNextValue);
            if (c < 0) {
                return low;
            }
            if (c == 0) {
                return lowNext;
            }
            low = lowNext;
        }
        return low;
    }

    public static int rangeSearch(int begin, int end, TargetComparator comp) {
        if (begin >= end) {
            return -1;
        }
        int low = begin;
        int c = comp.directionFrom(low);
        if (c <= 0) {
            if (c == 0) {
                return low;
            }
            return -1;
        }
        int high = end - 1;
        if (comp.directionFrom(high) >= 0) {
            return high;
        }
        while (low <= high) {
            int mid = (low + high) / 2;
            c = comp.directionFrom(mid);
            if (c < 0) {
                high = mid - 1;
                continue;
            }
            if (c > 0) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return low - 1;
    }

    public static int compareUnsigned(short a, short b) {
        return ContainerUtil.toIntUnsigned(a) - ContainerUtil.toIntUnsigned(b);
    }

    public static void fillArrayAND(short[] container, long[] bitmap1, long[] bitmap2) {
        int pos = 0;
        if (bitmap1.length != bitmap2.length) {
            throw new IllegalArgumentException("not supported");
        }
        for (int k = 0; k < bitmap1.length; ++k) {
            for (long bitset = bitmap1[k] & bitmap2[k]; bitset != 0L; bitset &= bitset - 1L) {
                container[pos++] = (short)(k * 64 + Long.numberOfTrailingZeros(bitset));
            }
        }
    }

    public static void fillArrayANDNOT(short[] container, long[] bitmap1, long[] bitmap2) {
        int pos = 0;
        if (bitmap1.length != bitmap2.length) {
            throw new IllegalArgumentException("not supported");
        }
        for (int k = 0; k < bitmap1.length; ++k) {
            for (long bitset = bitmap1[k] & (bitmap2[k] ^ 0xFFFFFFFFFFFFFFFFL); bitset != 0L; bitset &= bitset - 1L) {
                container[pos++] = (short)(k * 64 + Long.numberOfTrailingZeros(bitset));
            }
        }
    }

    public static void fillArrayXOR(short[] container, long[] bitmap1, long[] bitmap2) {
        int pos = 0;
        if (bitmap1.length != bitmap2.length) {
            throw new IllegalArgumentException("not supported");
        }
        for (int k = 0; k < bitmap1.length; ++k) {
            for (long bitset = bitmap1[k] ^ bitmap2[k]; bitset != 0L; bitset &= bitset - 1L) {
                container[pos++] = (short)(k * 64 + Long.numberOfTrailingZeros(bitset));
            }
        }
    }

    public static void flipBitmapRange(long[] bitmap, int start, int end) {
        if (start == end) {
            return;
        }
        int firstword = start / 64;
        int endword = (end - 1) / 64;
        int n = firstword;
        bitmap[n] = bitmap[n] ^ (-1L << start ^ 0xFFFFFFFFFFFFFFFFL);
        for (int i = firstword; i < endword; ++i) {
            bitmap[i] = bitmap[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n2 = endword;
        bitmap[n2] = bitmap[n2] ^ -1L >>> -end;
    }

    @Deprecated
    public static int cardinalityInBitmapWordRange(long[] bitmap, int start, int end) {
        if (start >= end) {
            return 0;
        }
        int firstword = start / 64;
        int endword = (end - 1) / 64;
        int answer = 0;
        for (int i = firstword; i <= endword; ++i) {
            answer += Long.bitCount(bitmap[i]);
        }
        return answer;
    }

    public static int cardinalityInBitmapRange(long[] bitmap, int start, int end) {
        if (start >= end) {
            return 0;
        }
        int firstword = start / 64;
        int endword = (end - 1) / 64;
        if (firstword == endword) {
            return Long.bitCount(bitmap[firstword] & (-1L << start & -1L >>> -end));
        }
        int answer = Long.bitCount(bitmap[firstword] & -1L << start);
        for (int i = firstword + 1; i < endword; ++i) {
            answer += Long.bitCount(bitmap[i]);
        }
        return answer += Long.bitCount(bitmap[endword] & -1L >>> -end);
    }

    protected static int hybridUnsignedBinarySearch(short[] array, int begin, int end, short k) {
        int x;
        int ikey = ContainerUtil.toIntUnsigned(k);
        if (end > 0 && ContainerUtil.toIntUnsigned(array[end - 1]) < ikey) {
            return -end - 1;
        }
        int low = begin;
        int high = end - 1;
        while (low + 32 < high) {
            int middleIndex = low + high >>> 1;
            int middleValue = ContainerUtil.toIntUnsigned(array[middleIndex]);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        for (x = low; x <= high; ++x) {
            int val = ContainerUtil.toIntUnsigned(array[x]);
            if (val < ikey) continue;
            if (val != ikey) break;
            return x;
        }
        return -(x + 1);
    }

    protected static short lowbits(int x) {
        return (short)x;
    }

    protected static short lowbits(long x) {
        return (short)x;
    }

    public static void resetBitmapRange(long[] bitmap, int start, int end) {
        if (start == end) {
            return;
        }
        int firstword = start / 64;
        int endword = (end - 1) / 64;
        if (firstword == endword) {
            int n = firstword;
            bitmap[n] = bitmap[n] & (-1L << start & -1L >>> -end ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
        int n = firstword;
        bitmap[n] = bitmap[n] & (-1L << start ^ 0xFFFFFFFFFFFFFFFFL);
        for (int i = firstword + 1; i < endword; ++i) {
            bitmap[i] = 0L;
        }
        int n2 = endword;
        bitmap[n2] = bitmap[n2] & (-1L >>> -end ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int select(long w, int j) {
        int counter;
        int ww;
        int seen = 0;
        int part = (int)(w & 0xFFFFFFFFFFFFFFFFL);
        int n = Integer.bitCount(part);
        if (n <= j) {
            part = (int)(w >>> 32);
            seen += 32;
            j -= n;
        }
        if ((n = Integer.bitCount(part = (ww = part) & 0xFFFF)) <= j) {
            part = ww >>> 16;
            seen += 16;
            j -= n;
        }
        if ((n = Integer.bitCount(part = (ww = part) & 0xFF)) <= j) {
            part = ww >>> 8;
            seen += 8;
            j -= n;
        }
        ww = part;
        for (counter = 0; counter < 8 && (j -= ww >>> counter & 1) >= 0; ++counter) {
        }
        return seen + counter;
    }

    public static void setBitmapRange(long[] bitmap, int start, int end) {
        if (start == end) {
            return;
        }
        int firstword = start / 64;
        int endword = (end - 1) / 64;
        if (firstword == endword) {
            int n = firstword;
            bitmap[n] = bitmap[n] | -1L << start & -1L >>> -end;
            return;
        }
        int n = firstword;
        bitmap[n] = bitmap[n] | -1L << start;
        for (int i = firstword + 1; i < endword; ++i) {
            bitmap[i] = -1L;
        }
        int n2 = endword;
        bitmap[n2] = bitmap[n2] | -1L >>> -end;
    }

    @Deprecated
    public static int setBitmapRangeAndCardinalityChange(long[] bitmap, int start, int end) {
        int cardbefore = ContainerUtil.cardinalityInBitmapWordRange(bitmap, start, end);
        ContainerUtil.setBitmapRange(bitmap, start, end);
        int cardafter = ContainerUtil.cardinalityInBitmapWordRange(bitmap, start, end);
        return cardafter - cardbefore;
    }

    @Deprecated
    public static int flipBitmapRangeAndCardinalityChange(long[] bitmap, int start, int end) {
        int cardbefore = ContainerUtil.cardinalityInBitmapWordRange(bitmap, start, end);
        ContainerUtil.flipBitmapRange(bitmap, start, end);
        int cardafter = ContainerUtil.cardinalityInBitmapWordRange(bitmap, start, end);
        return cardafter - cardbefore;
    }

    @Deprecated
    public static int resetBitmapRangeAndCardinalityChange(long[] bitmap, int start, int end) {
        int cardbefore = ContainerUtil.cardinalityInBitmapWordRange(bitmap, start, end);
        ContainerUtil.resetBitmapRange(bitmap, start, end);
        int cardafter = ContainerUtil.cardinalityInBitmapWordRange(bitmap, start, end);
        return cardafter - cardbefore;
    }

    protected static int toIntUnsigned(short x) {
        return x & 0xFFFF;
    }

    public static int unsignedBinarySearch(short[] array, int begin, int end, short k) {
        return ContainerUtil.hybridUnsignedBinarySearch(array, begin, end, k);
    }

    public static int unsignedDifference(short[] set1, int length1, short[] set2, int length2, short[] buffer) {
        int pos = 0;
        int k1 = 0;
        int k2 = 0;
        if (0 == length2) {
            System.arraycopy(set1, 0, buffer, 0, length1);
            return length1;
        }
        if (0 == length1) {
            return 0;
        }
        short s1 = set1[k1];
        short s2 = set2[k2];
        while (true) {
            if (ContainerUtil.toIntUnsigned(s1) < ContainerUtil.toIntUnsigned(s2)) {
                buffer[pos++] = s1;
                if (++k1 >= length1) break;
                s1 = set1[k1];
                continue;
            }
            if (ContainerUtil.toIntUnsigned(s1) == ContainerUtil.toIntUnsigned(s2)) {
                ++k2;
                if (++k1 >= length1) break;
                if (k2 >= length2) {
                    System.arraycopy(set1, k1, buffer, pos, length1 - k1);
                    return pos + length1 - k1;
                }
                s1 = set1[k1];
                s2 = set2[k2];
                continue;
            }
            if (++k2 >= length2) {
                System.arraycopy(set1, k1, buffer, pos, length1 - k1);
                return pos + length1 - k1;
            }
            s2 = set2[k2];
        }
        return pos;
    }

    public static int unsignedDifference(ShortIterator set1, ShortIterator set2, short[] buffer) {
        int pos = 0;
        if (!set2.hasNext()) {
            while (set1.hasNext()) {
                buffer[pos++] = set1.next();
            }
            return pos;
        }
        if (!set1.hasNext()) {
            return 0;
        }
        short v1 = set1.next();
        short v2 = set2.next();
        while (true) {
            if (ContainerUtil.toIntUnsigned(v1) < ContainerUtil.toIntUnsigned(v2)) {
                buffer[pos++] = v1;
                if (!set1.hasNext()) {
                    return pos;
                }
                v1 = set1.next();
                continue;
            }
            if (v1 == v2) {
                if (!set1.hasNext()) break;
                if (!set2.hasNext()) {
                    while (set1.hasNext()) {
                        buffer[pos++] = set1.next();
                    }
                    return pos;
                }
                v1 = set1.next();
                v2 = set2.next();
                continue;
            }
            if (!set2.hasNext()) {
                buffer[pos++] = v1;
                while (set1.hasNext()) {
                    buffer[pos++] = set1.next();
                }
                return pos;
            }
            v2 = set2.next();
        }
        return pos;
    }

    public static int unsignedExclusiveUnion2by2(short[] set1, int length1, short[] set2, int length2, short[] buffer) {
        int pos = 0;
        int k1 = 0;
        int k2 = 0;
        if (0 == length2) {
            System.arraycopy(set1, 0, buffer, 0, length1);
            return length1;
        }
        if (0 == length1) {
            System.arraycopy(set2, 0, buffer, 0, length2);
            return length2;
        }
        short s1 = set1[k1];
        short s2 = set2[k2];
        while (true) {
            if (ContainerUtil.toIntUnsigned(s1) < ContainerUtil.toIntUnsigned(s2)) {
                buffer[pos++] = s1;
                if (++k1 >= length1) {
                    System.arraycopy(set2, k2, buffer, pos, length2 - k2);
                    return pos + length2 - k2;
                }
                s1 = set1[k1];
                continue;
            }
            if (ContainerUtil.toIntUnsigned(s1) == ContainerUtil.toIntUnsigned(s2)) {
                ++k2;
                if (++k1 >= length1) {
                    System.arraycopy(set2, k2, buffer, pos, length2 - k2);
                    return pos + length2 - k2;
                }
                if (k2 >= length2) {
                    System.arraycopy(set1, k1, buffer, pos, length1 - k1);
                    return pos + length1 - k1;
                }
                s1 = set1[k1];
                s2 = set2[k2];
                continue;
            }
            buffer[pos++] = s2;
            if (++k2 >= length2) {
                System.arraycopy(set1, k1, buffer, pos, length1 - k1);
                return pos + length1 - k1;
            }
            s2 = set2[k2];
        }
    }

    public static int unsignedIntersect2by2(short[] set1, int length1, short[] set2, int length2, short[] buffer) {
        int THRESHOLD = 25;
        if (set1.length * 25 < set2.length) {
            return ContainerUtil.unsignedOneSidedGallopingIntersect2by2(set1, length1, set2, length2, buffer);
        }
        if (set2.length * 25 < set1.length) {
            return ContainerUtil.unsignedOneSidedGallopingIntersect2by2(set2, length2, set1, length1, buffer);
        }
        return ContainerUtil.unsignedLocalIntersect2by2(set1, length1, set2, length2, buffer);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean unsignedIntersects(short[] set1, int length1, short[] set2, int length2) {
        if (0 == length1) return false;
        if (0 == length2) {
            return false;
        }
        int k1 = 0;
        int k2 = 0;
        short s1 = set1[k1];
        short s2 = set2[k2];
        while (true) {
            if (ContainerUtil.toIntUnsigned(s2) < ContainerUtil.toIntUnsigned(s1)) {
                do {
                    if (++k2 != length2) continue;
                    return false;
                } while (ContainerUtil.toIntUnsigned(s2 = set2[k2]) < ContainerUtil.toIntUnsigned(s1));
            }
            if (ContainerUtil.toIntUnsigned(s1) >= ContainerUtil.toIntUnsigned(s2)) return true;
            do {
                if (++k1 != length1) continue;
                return false;
            } while (ContainerUtil.toIntUnsigned(s1 = set1[k1]) < ContainerUtil.toIntUnsigned(s2));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static int unsignedLocalIntersect2by2(short[] set1, int length1, short[] set2, int length2, short[] buffer) {
        if (0 == length1) return 0;
        if (0 == length2) {
            return 0;
        }
        int k1 = 0;
        int k2 = 0;
        int pos = 0;
        short s1 = set1[k1];
        short s2 = set2[k2];
        while (true) {
            int v1 = ContainerUtil.toIntUnsigned(s1);
            int v2 = ContainerUtil.toIntUnsigned(s2);
            if (v2 < v1) {
                do {
                    if (++k2 != length2) continue;
                    return pos;
                } while ((v2 = ContainerUtil.toIntUnsigned(s2 = set2[k2])) < v1);
            }
            if (v1 >= v2) {
                buffer[pos++] = s1;
                if (++k1 == length1) {
                    return pos;
                }
                if (++k2 == length2) {
                    return pos;
                }
                s1 = set1[k1];
                s2 = set2[k2];
                continue;
            }
            do {
                if (++k1 != length1) continue;
                return pos;
            } while ((v1 = ContainerUtil.toIntUnsigned(s1 = set1[k1])) < v2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int unsignedLocalIntersect2by2Cardinality(short[] set1, int length1, short[] set2, int length2) {
        if (0 == length1) return 0;
        if (0 == length2) {
            return 0;
        }
        int k1 = 0;
        int k2 = 0;
        int pos = 0;
        short s1 = set1[k1];
        short s2 = set2[k2];
        while (true) {
            int v1 = ContainerUtil.toIntUnsigned(s1);
            int v2 = ContainerUtil.toIntUnsigned(s2);
            if (v2 < v1) {
                do {
                    if (++k2 != length2) continue;
                    return pos;
                } while ((v2 = ContainerUtil.toIntUnsigned(s2 = set2[k2])) < v1);
            }
            if (v1 >= v2) {
                ++pos;
                if (++k1 == length1) {
                    return pos;
                }
                if (++k2 == length2) {
                    return pos;
                }
                s1 = set1[k1];
                s2 = set2[k2];
                continue;
            }
            do {
                if (++k1 != length1) continue;
                return pos;
            } while ((v1 = ContainerUtil.toIntUnsigned(s1 = set1[k1])) < v2);
        }
    }

    protected static int unsignedOneSidedGallopingIntersect2by2(short[] smallSet, int smallLength, short[] largeSet, int largeLength, short[] buffer) {
        if (0 == smallLength) {
            return 0;
        }
        int k1 = 0;
        int k2 = 0;
        int pos = 0;
        short s1 = largeSet[k1];
        short s2 = smallSet[k2];
        while (true) {
            if (ContainerUtil.toIntUnsigned(s1) < ContainerUtil.toIntUnsigned(s2)) {
                if ((k1 = ContainerUtil.advanceUntil(largeSet, k1, largeLength, s2)) == largeLength) break;
                s1 = largeSet[k1];
            }
            if (ContainerUtil.toIntUnsigned(s2) < ContainerUtil.toIntUnsigned(s1)) {
                if (++k2 == smallLength) break;
                s2 = smallSet[k2];
                continue;
            }
            buffer[pos++] = s2;
            if (++k2 == smallLength || (k1 = ContainerUtil.advanceUntil(largeSet, k1, largeLength, s2 = smallSet[k2])) == largeLength) break;
            s1 = largeSet[k1];
        }
        return pos;
    }

    public static int unsignedUnion2by2(short[] set1, int offset1, int length1, short[] set2, int offset2, int length2, short[] buffer) {
        if (0 == length2) {
            System.arraycopy(set1, offset1, buffer, 0, length1);
            return length1;
        }
        if (0 == length1) {
            System.arraycopy(set2, offset2, buffer, 0, length2);
            return length2;
        }
        int pos = 0;
        int k1 = offset1;
        int k2 = offset2;
        short s1 = set1[k1];
        short s2 = set2[k2];
        while (true) {
            int v2;
            int v1;
            if ((v1 = ContainerUtil.toIntUnsigned(s1)) < (v2 = ContainerUtil.toIntUnsigned(s2))) {
                buffer[pos++] = s1;
                if (++k1 >= length1 + offset1) {
                    System.arraycopy(set2, k2, buffer, pos, length2 - k2 + offset2);
                    return pos + length2 - k2 + offset2;
                }
                s1 = set1[k1];
                continue;
            }
            if (v1 == v2) {
                buffer[pos++] = s1;
                ++k2;
                if (++k1 >= length1 + offset1) {
                    System.arraycopy(set2, k2, buffer, pos, length2 - k2 + offset2);
                    return pos + length2 - k2 + offset2;
                }
                if (k2 >= length2 + offset2) {
                    System.arraycopy(set1, k1, buffer, pos, length1 - k1 + offset1);
                    return pos + length1 - k1 + offset1;
                }
                s1 = set1[k1];
                s2 = set2[k2];
                continue;
            }
            buffer[pos++] = s2;
            if (++k2 >= length2 + offset2) {
                System.arraycopy(set1, k1, buffer, pos, length1 - k1 + offset1);
                return pos + length1 - k1 + offset1;
            }
            s2 = set2[k2];
        }
    }

    public static void partialRadixSort(int[] data) {
        int radix = 8;
        int shift = 16;
        int mask = 0xFF0000;
        int[] copy = new int[data.length];
        int[] histogram = new int[257];
        while (shift < 32) {
            int i;
            for (i = 0; i < data.length; ++i) {
                int n = ((data[i] & mask) >>> shift) + 1;
                histogram[n] = histogram[n] + 1;
            }
            for (i = 0; i < 256; ++i) {
                int n = i + 1;
                histogram[n] = histogram[n] + histogram[i];
            }
            for (i = 0; i < data.length; ++i) {
                int n = (data[i] & mask) >>> shift;
                int n2 = histogram[n];
                histogram[n] = n2 + 1;
                copy[n2] = data[i];
            }
            System.arraycopy(copy, 0, data, 0, data.length);
            shift += 8;
            mask <<= 8;
            Arrays.fill(histogram, 0);
        }
    }

    static boolean overlaps(ArrayContainer c1, RunContainer c2) {
        int c2i = 0;
        for (int c1i = 0; c1i < c1.cardinality; ++c1i) {
            if (c2i >= c2.nbrruns) {
                return false;
            }
            short k = c1.content[c1i];
            int s = c2.searchFrom(k, c2i);
            if (s >= 0) {
                return true;
            }
            c2i = -(s + 1);
        }
        return false;
    }

    static boolean overlaps(RunContainer c1, ArrayContainer c2) {
        int c2i = 0;
        for (int c1i = 0; c1i < c1.nbrruns; ++c1i) {
            if (c2i >= c2.cardinality) {
                return false;
            }
            int value = ContainerUtil.toIntUnsigned(c1.getValue(c1i));
            int len = ContainerUtil.toIntUnsigned(c1.getLength(c1i));
            for (int j = value; j <= value + len; ++j) {
                int s = ContainerUtil.unsignedBinarySearch(c2.content, c2i, c2.cardinality, ContainerUtil.lowbits(j));
                if (s >= 0) {
                    return true;
                }
                c2i = -(s + 1);
            }
        }
        return false;
    }

    private ContainerUtil() {
    }

    @FunctionalInterface
    public static interface TargetComparator {
        public int directionFrom(int var1);
    }
}

