/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp.container;

import io.deephaven.engine.rowset.impl.rsp.container.ArrayContainer;
import io.deephaven.engine.rowset.impl.rsp.container.BitmapContainer;
import io.deephaven.engine.rowset.impl.rsp.container.Container;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerShortBatchIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerUtil;
import io.deephaven.engine.rowset.impl.rsp.container.MutableInteger;
import io.deephaven.engine.rowset.impl.rsp.container.PositionHint;
import io.deephaven.engine.rowset.impl.rsp.container.RangeConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.RangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.RunContainerRangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.RunShortBatchIterator;
import io.deephaven.engine.rowset.impl.rsp.container.SearchRangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortAdvanceIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.ShortIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortRangeConsumer;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public final class RunContainer
extends Container {
    private static final int DEFAULT_INIT_SIZE_IN_RUNS = 3;
    private static final boolean ENABLE_GALLOPING_AND = false;
    private short[] valueslength;
    int nbrruns = 0;
    private boolean shared = false;
    int cardinality;

    private static int branchyUnsignedInterleavedBinarySearch(short[] array, int begin, int end, short k) {
        int ikey = ContainerUtil.toIntUnsigned(k);
        int low = begin;
        int high = end - 1;
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = ContainerUtil.toIntUnsigned(array[2 * middleIndex]);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    private static int hybridUnsignedInterleavedBinarySearch(short[] array, int begin, int end, short k) {
        int x;
        int ikey = ContainerUtil.toIntUnsigned(k);
        if (end > 0 && ContainerUtil.toIntUnsigned(array[2 * (end - 1)]) < ikey) {
            return -end - 1;
        }
        int low = begin;
        int high = end - 1;
        while (low + 16 <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = ContainerUtil.toIntUnsigned(array[2 * middleIndex]);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        for (x = low; x <= high; ++x) {
            int val = ContainerUtil.toIntUnsigned(array[2 * x]);
            if (val < ikey) continue;
            if (val != ikey) break;
            return x;
        }
        return -(x + 1);
    }

    protected static int sizeInBytes(int numberOfRuns) {
        return 4 * numberOfRuns;
    }

    private static int unsignedInterleavedBinarySearch(short[] array, int begin, int end, short k) {
        return RunContainer.hybridUnsignedInterleavedBinarySearch(array, begin, end, k);
    }

    public RunContainer() {
        this(3);
    }

    private RunContainer(short[] valueslength, int nbrruns, int cardinality) {
        this.valueslength = valueslength;
        this.nbrruns = nbrruns;
        this.cardinality = cardinality;
    }

    public RunContainer(RunContainer rc) {
        this(Arrays.copyOf(rc.valueslength, rc.valueslength.length), rc.nbrruns, rc.cardinality);
    }

    protected RunContainer(ArrayContainer arr, int nbrRunsCapacity) {
        this.valueslength = new short[RunContainer.runsShortArraySizeRounding(nbrRunsCapacity)];
        int arrCard = arr.getCardinality();
        if (arrCard == 0) {
            this.nbrruns = 0;
            return;
        }
        int prevVal = ContainerUtil.toIntUnsigned(arr.content[0]);
        int runLen = 0;
        int runIdx = 0;
        this.setValue(0, (short)prevVal);
        for (int i = 1; i < arrCard; ++i) {
            int curVal = ContainerUtil.toIntUnsigned(arr.content[i]);
            if (curVal == prevVal + 1) {
                ++runLen;
            } else {
                this.setLength(runIdx, (short)runLen);
                this.setValue(++runIdx, (short)curVal);
                runLen = 0;
            }
            prevVal = curVal;
        }
        this.setLength(runIdx, (short)runLen);
        this.nbrruns = runIdx + 1;
        this.cardinality = arrCard;
    }

    public RunContainer(int start, int end) {
        this.nbrruns = 1;
        this.valueslength = new short[6];
        this.valueslength[0] = (short)start;
        int d = end - start;
        this.valueslength[1] = (short)(d - 1);
        this.cardinality = d;
    }

    public RunContainer(int start1, int end1, int start2, int end2) {
        this.nbrruns = 2;
        int d1 = end1 - start1;
        int d2 = end2 - start2;
        this.valueslength = new short[6];
        this.valueslength[0] = ContainerUtil.lowbits(start1);
        this.valueslength[1] = ContainerUtil.lowbits(d1 - 1);
        this.valueslength[2] = ContainerUtil.lowbits(start2);
        this.valueslength[3] = ContainerUtil.lowbits(d2 - 1);
        this.cardinality = d1 + d2;
    }

    public static RunContainer select(RunContainer src, int startRank, int endRank) {
        int kLen;
        RunContainer ans = new RunContainer(src.valueslength.length);
        int k = 0;
        int kStart = ContainerUtil.toIntUnsigned(src.getValue(0));
        int kEndPos = kLen = ContainerUtil.toIntUnsigned(src.getLength(0));
        int ostart = -1;
        int oend = -1;
        int run = 0;
        for (int pos = startRank; pos < endRank; ++pos) {
            while (kEndPos < pos) {
                kStart = ContainerUtil.toIntUnsigned(src.getValue(++k));
                kLen = ContainerUtil.toIntUnsigned(src.getLength(k));
                kEndPos += 1 + kLen;
            }
            int key = kStart + kLen - (kEndPos - pos);
            if (ostart == -1) {
                ostart = oend = key;
                continue;
            }
            if (key == oend + 1) {
                oend = key;
                continue;
            }
            ans.setValue(run, (short)ostart);
            int len = oend - ostart;
            ans.setLength(run, (short)len);
            ans.cardinality += len + 1;
            ++run;
            ostart = oend = key;
        }
        ans.setValue(run, (short)ostart);
        int len = oend - ostart;
        ans.setLength(run, (short)len);
        ans.cardinality += len + 1;
        ans.nbrruns = ++run;
        int lenFromRuns = 2 * run;
        if (ans.valueslength.length - lenFromRuns > 64) {
            short[] vs = new short[RunContainer.runsShortArraySizeRounding(ans.nbrruns)];
            System.arraycopy(ans.valueslength, 0, vs, 0, lenFromRuns);
            ans.valueslength = vs;
        }
        return ans;
    }

    protected RunContainer(BitmapContainer bc) {
        this.nbrruns = bc.numberOfRuns();
        this.cardinality = bc.getCardinality();
        this.valueslength = new short[RunContainer.runsShortArraySizeRounding(this.nbrruns)];
        if (this.nbrruns == 0) {
            return;
        }
        int longCtr = 0;
        long curWord = bc.bitmap[0];
        int runCount = 0;
        while (true) {
            int runEnd;
            if (curWord == 0L && longCtr < bc.bitmap.length - 1) {
                curWord = bc.bitmap[++longCtr];
                continue;
            }
            if (curWord == 0L) {
                return;
            }
            int localRunStart = Long.numberOfTrailingZeros(curWord);
            int runStart = localRunStart + 64 * longCtr;
            long curWordWith1s = curWord | curWord - 1L;
            while (curWordWith1s == -1L && longCtr < bc.bitmap.length - 1) {
                curWordWith1s = bc.bitmap[++longCtr];
            }
            if (curWordWith1s == -1L) {
                runEnd = 64 + longCtr * 64;
                this.setValue(runCount, (short)runStart);
                this.setLength(runCount, (short)(runEnd - runStart - 1));
                return;
            }
            int localRunEnd = Long.numberOfTrailingZeros(curWordWith1s ^ 0xFFFFFFFFFFFFFFFFL);
            runEnd = localRunEnd + longCtr * 64;
            this.setValue(runCount, (short)runStart);
            this.setLength(runCount, (short)(runEnd - runStart - 1));
            ++runCount;
            curWord = curWordWith1s & curWordWith1s + 1L;
        }
    }

    public RunContainer(int runsCapacity) {
        this.valueslength = new short[RunContainer.runsShortArraySizeRounding(runsCapacity)];
    }

    RunContainer(short[] array, int numRuns) {
        if (array.length < 2 * numRuns) {
            throw new RuntimeException("Mismatch between buffer and numRuns");
        }
        this.nbrruns = numRuns;
        this.valueslength = array;
        for (int i = 0; i < numRuns; ++i) {
            this.cardinality += this.getLengthAsInt(i) + 1;
        }
    }

    public static RunContainer makeByWrapping(short[] valueslength, int nbrruns, int cardinality) {
        return new RunContainer(valueslength, nbrruns, cardinality);
    }

    @Override
    public Container iadd(int begin, int end) {
        return this.iaddImpl(begin, end, () -> this, this::deepcopyIfShared);
    }

    @Override
    public Container add(int begin, int end) {
        return this.iaddImpl(begin, end, this::cowRef, this::deepCopy);
    }

    private Container iaddImpl(int begin, int end, Supplier<RunContainer> self, Supplier<RunContainer> copy) {
        if (end == begin) {
            return self.get();
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        short k = (short)begin;
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, k);
        if (begin == end - 1) {
            if (index >= 0) {
                return self.get();
            }
            return this.isetImpl(k, index, null, self, copy);
        }
        RunContainer ans = copy.get();
        return ans.iaddUnsafe(begin, end, index < 0 ? ~index : index);
    }

    @Override
    public Container iset(short k) {
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, k);
        return this.iset(k, index);
    }

    private Container iset(short k, int index) {
        if (index >= 0) {
            return this;
        }
        return this.isetImpl(k, index, null, () -> this, this::deepcopyIfShared);
    }

    @Override
    public Container set(short k) {
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, k);
        return this.setImpl(k, index);
    }

    private Container setImpl(short k, int index) {
        if (index >= 0) {
            return this.cowRef();
        }
        return this.isetImpl(k, index, null, this::cowRef, this::deepCopy);
    }

    @Override
    Container iset(short k, PositionHint positionHint) {
        int begin = Math.max(positionHint.value, 0);
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, begin, this.nbrruns, k);
        if (index >= 0) {
            positionHint.value = index;
            return this;
        }
        return this.isetImpl(k, index, positionHint, () -> this, this::deepcopyIfShared);
    }

    @Override
    Container set(short k, PositionHint positionHint) {
        int begin = Math.max(positionHint.value, 0);
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, begin, this.nbrruns, k);
        if (index >= 0) {
            positionHint.value = index;
            return this.cowRef();
        }
        return this.isetImpl(k, index, positionHint, this::cowRef, this::deepCopy);
    }

    private Container isetImpl(short k, int index, PositionHint positionHint, Supplier<RunContainer> self, Supplier<RunContainer> copy) {
        index = -index - 2;
        int kAsInt = ContainerUtil.toIntUnsigned(k);
        if (index >= 0) {
            int le;
            int valueAtIndex = this.getValueAsInt(index);
            int offset = kAsInt - valueAtIndex;
            if (offset <= (le = this.getLengthAsInt(index))) {
                MutableInteger.setIfNotNull(positionHint, index);
                return self.get();
            }
            if (offset == le + 1) {
                int valueAtIndexPlusOne;
                if (index + 1 < this.nbrruns && (valueAtIndexPlusOne = this.getValueAsInt(index + 1)) == kAsInt + 1) {
                    int newEndInclusive = valueAtIndexPlusOne + this.getLengthAsInt(index + 1);
                    if (this.nbrruns == 2) {
                        PositionHint.resetIfNotNull(positionHint);
                        return RunContainer.makeSingleRangeContainer(valueAtIndex, newEndInclusive + 1);
                    }
                    RunContainer ans = copy.get();
                    int newLen = newEndInclusive - valueAtIndex;
                    ans.setLength(index, (short)newLen);
                    ans.cardinality += newLen - le;
                    ans.recoverRoomAtIndex(index + 1);
                    MutableInteger.setIfNotNull(positionHint, index);
                    return ans;
                }
                RunContainer ans = copy.get();
                ans.incrementLength(index);
                MutableInteger.setIfNotNull(positionHint, index);
                return ans;
            }
            if (index + 1 < this.nbrruns && this.getValueAsInt(index + 1) == kAsInt + 1) {
                RunContainer ans = copy.get();
                ans.setValue(index + 1, k);
                ans.incrementLength(index + 1);
                MutableInteger.setIfNotNull(positionHint, index + 1);
                return ans;
            }
        }
        if (index == -1 && this.nbrruns > 0 && this.getValueAsInt(0) == kAsInt + 1) {
            RunContainer ans = copy.get();
            ans.incrementLength(0);
            ans.decrementValue(0);
            MutableInteger.setIfNotNull(positionHint, 0);
            return ans;
        }
        if (this.nbrruns >= 2045) {
            if (positionHint != null) {
                positionHint.reset();
                return this.toBitmapContainer().iset(k, positionHint);
            }
            return this.toBitmapContainer().iset(k);
        }
        RunContainer ans = copy.get();
        ans.makeRoomAtIndex(index + 1);
        ans.setValue(index + 1, k);
        ans.setLength(index + 1, (short)0);
        ++ans.cardinality;
        MutableInteger.setIfNotNull(positionHint, index + 1);
        return ans;
    }

    @Override
    public Container and(ArrayContainer x) {
        if (x.isEmpty() || this.isEmpty()) {
            return Container.empty();
        }
        ArrayContainer ac = new ArrayContainer(x.getCardinality());
        int rlepos = 0;
        int arraypos = 0;
        int rleval = this.getValueAsInt(rlepos);
        int rlelength = this.getLengthAsInt(rlepos);
        while (arraypos < x.getCardinality()) {
            int arrayval = ContainerUtil.toIntUnsigned(x.content[arraypos]);
            while (rleval + rlelength < arrayval) {
                if (++rlepos == this.nbrruns) {
                    return ac;
                }
                rleval = this.getValueAsInt(rlepos);
                rlelength = this.getLengthAsInt(rlepos);
            }
            if (rleval > arrayval) {
                arraypos = ContainerUtil.advanceUntil(x.content, arraypos, x.getCardinality(), (short)rleval);
                continue;
            }
            ac.content[ac.cardinality] = (short)arrayval;
            ++ac.cardinality;
            ++arraypos;
        }
        return ac;
    }

    @Override
    public Container and(BitmapContainer x) {
        if (x.isEmpty() || this.isEmpty()) {
            return Container.empty();
        }
        int card = this.getCardinality();
        int resultCardUpperBound = Math.min(card, x.getCardinality());
        if (resultCardUpperBound <= 3835) {
            ArrayContainer answer = new ArrayContainer(resultCardUpperBound);
            SearchRangeIterator xit = x.getShortRangeIterator(0);
            block0: for (int run = 0; run < this.nbrruns; ++run) {
                int runStart = this.getValueAsInt(run);
                int runLast = runStart + this.getLengthAsInt(run);
                boolean valid = xit.advance(runStart);
                if (!valid) break;
                while (xit.start() <= runLast) {
                    int rEnd;
                    boolean inRun;
                    int rBegin = Math.max(xit.start(), runStart);
                    if (xit.end() < runLast + 1) {
                        inRun = true;
                        rEnd = xit.end();
                    } else {
                        inRun = false;
                        rEnd = runLast + 1;
                    }
                    for (int runValue = rBegin; runValue < rEnd; ++runValue) {
                        answer.content[answer.cardinality++] = (short)runValue;
                    }
                    if (!inRun) continue block0;
                    if (!xit.hasNext()) break block0;
                    xit.next();
                }
            }
            return answer.maybeSwitchContainer();
        }
        BitmapContainer answer = x.deepCopy();
        int start = 0;
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int end = this.getValueAsInt(rlepos);
            int prevOnes = answer.cardinalityInRange(start, end);
            ContainerUtil.resetBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnes, 0);
            start = end + this.getLengthAsInt(rlepos) + 1;
        }
        int ones = answer.cardinalityInRange(start, 65536);
        ContainerUtil.resetBitmapRange(answer.bitmap, start, 65536);
        answer.updateCardinality(ones, 0);
        return answer.runOptimize();
    }

    @Override
    public Container and(RunContainer x) {
        if (x.isEmpty() || this.isEmpty()) {
            return Container.empty();
        }
        RunContainer answer = new RunContainer(this.nbrruns + x.nbrruns);
        int rlepos = 0;
        int xrlepos = 0;
        int start = this.getValueAsInt(rlepos);
        int end = start + this.getLengthAsInt(rlepos) + 1;
        int xstart = ContainerUtil.toIntUnsigned(x.getValue(xrlepos));
        int xend = xstart + ContainerUtil.toIntUnsigned(x.getLength(xrlepos)) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            int earliestend;
            if (end <= xstart) {
                if (++rlepos >= this.nbrruns) continue;
                start = this.getValueAsInt(rlepos);
                end = start + this.getLengthAsInt(rlepos) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = ContainerUtil.toIntUnsigned(x.getValue(xrlepos));
                xend = xstart + ContainerUtil.toIntUnsigned(x.getLength(xrlepos)) + 1;
                continue;
            }
            int lateststart = Math.max(start, xstart);
            if (end == xend) {
                earliestend = end;
                ++xrlepos;
                if (++rlepos < this.nbrruns) {
                    start = this.getValueAsInt(rlepos);
                    end = start + this.getLengthAsInt(rlepos) + 1;
                }
                if (xrlepos < x.nbrruns) {
                    xstart = ContainerUtil.toIntUnsigned(x.getValue(xrlepos));
                    xend = xstart + ContainerUtil.toIntUnsigned(x.getLength(xrlepos)) + 1;
                }
            } else if (end < xend) {
                earliestend = end;
                if (++rlepos < this.nbrruns) {
                    start = this.getValueAsInt(rlepos);
                    end = start + this.getLengthAsInt(rlepos) + 1;
                }
            } else {
                earliestend = xend;
                if (++xrlepos < x.nbrruns) {
                    xstart = ContainerUtil.toIntUnsigned(x.getValue(xrlepos));
                    xend = xstart + ContainerUtil.toIntUnsigned(x.getLength(xrlepos)) + 1;
                }
            }
            answer.valueslength[2 * answer.nbrruns] = (short)lateststart;
            int d = earliestend - lateststart;
            answer.valueslength[2 * answer.nbrruns + 1] = (short)(d - 1);
            answer.cardinality += d;
            ++answer.nbrruns;
        }
        return answer.toEfficientContainer();
    }

    private Container andRangeImpl(boolean inPlace, int start, int end) {
        RunContainer ans;
        if (end <= start || this.isEmpty()) {
            return Container.empty();
        }
        int srun = this.searchFrom(ContainerUtil.lowbits(start), 0);
        if (srun < 0 && (srun ^= 0xFFFFFFFF) >= this.nbrruns) {
            return Container.empty();
        }
        int rsval = this.getValueAsInt(srun);
        if (end <= rsval) {
            return Container.empty();
        }
        int erun = this.searchFrom(ContainerUtil.lowbits(end - 1), srun);
        if (erun < 0) {
            if ((erun ^= 0xFFFFFFFF) >= this.nbrruns) {
                erun = this.nbrruns - 1;
            } else if (end <= this.getValueAsInt(erun)) {
                --erun;
            }
        }
        if (srun == erun) {
            int rend = Math.min(rsval + this.getLengthAsInt(srun) + 1, end);
            int rstart = Math.max(start, rsval);
            return Container.singleRange(rstart, rend);
        }
        if (srun + 1 == erun) {
            int r2start = this.getValueAsInt(erun);
            int r2end = Math.min(r2start + this.getLengthAsInt(erun) + 1, end);
            int r1start = Math.max(start, rsval);
            int r1end = rsval + this.getLengthAsInt(srun) + 1;
            return Container.twoRanges(r1start, r1end, r2start, r2end);
        }
        int lastVal = this.getValueAsInt(erun);
        int erunLen = this.getLengthAsInt(erun);
        int erunEnd = lastVal + erunLen + 1;
        if (srun == 0 && start <= rsval && erun == this.nbrruns - 1 && erunEnd <= end) {
            return inPlace ? this : this.cowRef();
        }
        if (inPlace) {
            ans = this;
            ans.cardinality = 0;
        } else {
            ans = new RunContainer(erun - srun + 1);
        }
        int n = 0;
        int firstVal = Math.max(start, rsval);
        int firstEnd = rsval + this.getLengthAsInt(srun) + 1;
        ans.valueslength[n++] = (short)firstVal;
        int d = firstEnd - firstVal;
        ans.valueslength[n++] = (short)(d - 1);
        ans.cardinality += d;
        for (int run = srun + 1; run < erun; ++run) {
            ans.valueslength[n++] = this.getValue(run);
            short len = this.getLength(run);
            ans.valueslength[n++] = len;
            ans.cardinality += ContainerUtil.toIntUnsigned(len) + 1;
        }
        ans.valueslength[n++] = (short)lastVal;
        int lastEnd = Math.min(erunEnd, end);
        d = lastEnd - lastVal;
        ans.valueslength[n++] = (short)(d - 1);
        ans.nbrruns = n / 2;
        ans.cardinality += d;
        return ans;
    }

    @Override
    public Container andRange(int start, int end) {
        return this.andRangeImpl(false, start, end);
    }

    @Override
    public Container iandRange(int start, int end) {
        return this.andRangeImpl(!this.shared, start, end);
    }

    @Override
    public Container andNot(ArrayContainer x) {
        if (x.isEmpty()) {
            return this.cowRef();
        }
        int arbitrary_threshold = 32;
        if (x.getCardinality() < 32) {
            return this.andNotAsRun(x).toEfficientContainer();
        }
        int card = this.getCardinality();
        if (card <= 4090) {
            ArrayContainer ac = new ArrayContainer(card);
            ac.cardinality = ContainerUtil.unsignedDifference(this.getShortIterator(), x.getShortIterator(), ac.content);
            return ac;
        }
        return this.toBitmapOrArrayContainer(card).iandNot(x);
    }

    @Override
    public Container andNot(BitmapContainer x) {
        if (x.isEmpty()) {
            return this.cowRef();
        }
        int card = this.getCardinality();
        if (card <= 3835) {
            ArrayContainer answer = new ArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int runStart = this.getValueAsInt(rlepos);
                int runEnd = runStart + this.getLengthAsInt(rlepos);
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    if (x.contains((short)runValue)) continue;
                    answer.content[answer.cardinality++] = (short)runValue;
                }
            }
            return answer;
        }
        BitmapContainer answer = x.deepCopy();
        int lastPos = 0;
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int start = this.getValueAsInt(rlepos);
            int end = start + this.getLengthAsInt(rlepos) + 1;
            int prevOnes = answer.cardinalityInRange(lastPos, start);
            int flippedOnes = answer.cardinalityInRange(start, end);
            ContainerUtil.resetBitmapRange(answer.bitmap, lastPos, start);
            ContainerUtil.flipBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnes + flippedOnes, end - start - flippedOnes);
            lastPos = end;
        }
        int ones = answer.cardinalityInRange(lastPos, 65536);
        ContainerUtil.resetBitmapRange(answer.bitmap, lastPos, 65536);
        answer.updateCardinality(ones, 0);
        return answer.maybeSwitchContainer();
    }

    @Override
    public Container andNot(RunContainer x) {
        int d;
        if (x.isEmpty()) {
            return this.cowRef();
        }
        RunContainer ans = new RunContainer(this.nbrruns + x.nbrruns);
        int rlepos = 0;
        int xrlepos = 0;
        int start = this.getValueAsInt(rlepos);
        int end = start + this.getLengthAsInt(rlepos) + 1;
        int xstart = ContainerUtil.toIntUnsigned(x.getValue(xrlepos));
        int xend = xstart + ContainerUtil.toIntUnsigned(x.getLength(xrlepos)) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            if (end <= xstart) {
                ans.valueslength[2 * ans.nbrruns] = (short)start;
                d = end - start;
                ans.valueslength[2 * ans.nbrruns + 1] = (short)(d - 1);
                ++ans.nbrruns;
                ans.cardinality += d;
                if (++rlepos >= this.nbrruns) continue;
                start = this.getValueAsInt(rlepos);
                end = start + this.getLengthAsInt(rlepos) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = ContainerUtil.toIntUnsigned(x.getValue(xrlepos));
                xend = xstart + ContainerUtil.toIntUnsigned(x.getLength(xrlepos)) + 1;
                continue;
            }
            if (start < xstart) {
                ans.valueslength[2 * ans.nbrruns] = (short)start;
                d = xstart - start;
                ans.valueslength[2 * ans.nbrruns + 1] = (short)(d - 1);
                ++ans.nbrruns;
                ans.cardinality += d;
            }
            if (xend < end) {
                start = xend;
                continue;
            }
            if (++rlepos >= this.nbrruns) continue;
            start = this.getValueAsInt(rlepos);
            end = start + this.getLengthAsInt(rlepos) + 1;
        }
        if (rlepos < this.nbrruns) {
            ans.valueslength[2 * ans.nbrruns] = (short)start;
            d = end - start;
            ans.valueslength[2 * ans.nbrruns + 1] = (short)(d - 1);
            ++ans.nbrruns;
            ans.cardinality += d;
            if (++rlepos < this.nbrruns) {
                System.arraycopy(this.valueslength, 2 * rlepos, ans.valueslength, 2 * ans.nbrruns, 2 * (this.nbrruns - rlepos));
                for (int run = rlepos; run < this.nbrruns; ++run) {
                    ans.cardinality += this.getLengthAsInt(run) + 1;
                }
                ans.nbrruns = ans.nbrruns + this.nbrruns - rlepos;
            }
        }
        return ans.toEfficientContainer();
    }

    private void appendValueLength(int value, int index) {
        int length;
        int previousValue = this.getValueAsInt(index);
        int offset = value - previousValue;
        if (offset > (length = this.getLengthAsInt(index))) {
            this.setLength(index, (short)offset);
            this.cardinality += offset - length;
        }
    }

    private boolean canPrependValueLength(int value, int index) {
        if (index < this.nbrruns) {
            int nextValue = this.getValueAsInt(index);
            return nextValue == value + 1;
        }
        return false;
    }

    public void clear() {
        if (this.nbrruns != 0 && this.shared) {
            throw new IllegalStateException("Cannot clear a shared container.");
        }
        this.nbrruns = 0;
        this.cardinality = 0;
    }

    @Override
    public RunContainer deepCopy() {
        return new RunContainer(this);
    }

    @Override
    public RunContainer cowRef() {
        this.setCopyOnWrite();
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.nbrruns == 0;
    }

    @Override
    public boolean isAllOnes() {
        return this.nbrruns == 1 && this.valueslength[1] == -1;
    }

    @Override
    public boolean isSingleElement() {
        return this.nbrruns == 1 && this.valueslength[1] == 0;
    }

    private void closeValueLength(int value, int index) {
        int initialValue = this.getValueAsInt(index);
        int initialLen = this.getLengthAsInt(index);
        int newLen = value - initialValue;
        this.setLength(index, (short)newLen);
        this.cardinality -= initialLen - newLen;
    }

    @Override
    public boolean contains(short x) {
        return this.searchFrom(x, 0) >= 0;
    }

    int searchFrom(short x, int i) {
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, i, this.nbrruns, x);
        if (index >= 0) {
            return index;
        }
        return this.searchSecondHalf(x, index);
    }

    int searchSecondHalf(short x, int index) {
        int le;
        int offset;
        int index2 = -index - 2;
        if (index2 != -1 && (offset = ContainerUtil.toIntUnsigned(x) - this.getValueAsInt(index2)) <= (le = this.getLengthAsInt(index2))) {
            return index2;
        }
        return index;
    }

    @Override
    public boolean contains(int rangeStart, int rangeEnd) {
        int ri = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (short)rangeStart);
        if (ri >= 0) {
            int len = this.getLengthAsInt(ri);
            return rangeEnd - rangeStart <= len + 1;
        }
        int ri2 = -ri - 2;
        if (ri2 == -1) {
            return false;
        }
        int v = this.getValueAsInt(ri2);
        int lastOfThatRange = v + this.getLengthAsInt(ri2);
        return rangeEnd <= lastOfThatRange + 1;
    }

    @Override
    protected boolean contains(RunContainer runContainer) {
        int i1 = 0;
        int i2 = 0;
        while (i1 < this.numberOfRuns() && i2 < runContainer.numberOfRuns()) {
            int start1 = this.getValueAsInt(i1);
            int stop1 = start1 + this.getLengthAsInt(i1);
            int start2 = runContainer.getValueAsInt(i2);
            int stop2 = start2 + runContainer.getLengthAsInt(i2);
            if (start1 > start2) {
                return false;
            }
            if (stop1 > stop2) {
                ++i2;
                continue;
            }
            if (stop1 == stop2) {
                ++i1;
                ++i2;
                continue;
            }
            ++i1;
        }
        return i2 == runContainer.numberOfRuns();
    }

    @Override
    protected boolean contains(ArrayContainer arrayContainer) {
        int cardinality = this.getCardinality();
        int runCount = this.numberOfRuns();
        if (arrayContainer.getCardinality() > cardinality) {
            return false;
        }
        int ia = 0;
        int ir = 0;
        while (ia < arrayContainer.getCardinality() && ir < runCount) {
            int start = this.getValueAsInt(ir);
            int stop = start + this.getLengthAsInt(ir);
            int ac = ContainerUtil.toIntUnsigned(arrayContainer.content[ia]);
            if (ac < start) {
                return false;
            }
            if (ac > stop) {
                ++ir;
                continue;
            }
            ++ia;
        }
        return ia == arrayContainer.getCardinality();
    }

    @Override
    protected boolean contains(BitmapContainer bitmapContainer) {
        int ib;
        int cardinality = this.getCardinality();
        if (bitmapContainer.getCardinality() != -1 && bitmapContainer.getCardinality() > cardinality) {
            return false;
        }
        int runCount = this.numberOfRuns();
        int ir = 0;
        for (ib = 0; ib < bitmapContainer.bitmap.length && ir < runCount; ib = (int)((short)(ib + 1))) {
            long w = bitmapContainer.bitmap[ib];
            while (w != 0L && ir < runCount) {
                int start = this.getValueAsInt(ir);
                int stop = start + this.getLengthAsInt(ir);
                long t = w & -w;
                long r = ib * 64 + Long.numberOfTrailingZeros(w);
                if (r < (long)start) {
                    return false;
                }
                if (r > (long)stop) {
                    ir = (short)(ir + 1);
                    continue;
                }
                w ^= t;
            }
            if (w == 0L) {
                continue;
            }
            return false;
        }
        if (ib < bitmapContainer.bitmap.length) {
            while (ib < bitmapContainer.bitmap.length) {
                if (bitmapContainer.bitmap[ib] != 0L) {
                    return false;
                }
                ib = (short)(ib + 1);
            }
        }
        return true;
    }

    private void copyToOffset(int offset) {
        int newRuns = offset + this.nbrruns;
        int minCapacity = 2 * newRuns;
        if (this.valueslength.length < minCapacity) {
            int newCapacity = RunContainer.runsShortArraySizeRounding(newRuns);
            short[] newvalueslength = new short[newCapacity];
            this.copyValuesLength(this.valueslength, 0, newvalueslength, offset, this.nbrruns);
            this.valueslength = newvalueslength;
        } else {
            this.copyValuesLength(this.valueslength, 0, this.valueslength, offset, this.nbrruns);
        }
    }

    private void copyValuesLength(short[] src, int srcIndex, short[] dst, int dstIndex, int length) {
        System.arraycopy(src, 2 * srcIndex, dst, 2 * dstIndex, 2 * length);
    }

    private void decrementLength(int index) {
        int n = 2 * index + 1;
        this.valueslength[n] = (short)(this.valueslength[n] - 1);
        --this.cardinality;
    }

    private void decrementValue(int index) {
        int n = 2 * index;
        this.valueslength[n] = (short)(this.valueslength[n] - 1);
    }

    private static int nextRunsCapacity(int oldRuns) {
        return oldRuns == 0 ? 3 : (oldRuns < 32 ? RunContainer.runsSizeRounding(oldRuns * 2) : (oldRuns < 512 ? RunContainer.runsSizeRounding(oldRuns * 3 / 2) : RunContainer.runsSizeRounding(oldRuns * 5 / 4)));
    }

    protected void ensureCapacity(int minNbRuns) {
        int minCapacity = 2 * minNbRuns;
        if (this.valueslength.length >= minCapacity) {
            return;
        }
        int newRunsCapacity = this.nbrruns;
        while ((newRunsCapacity = RunContainer.nextRunsCapacity(newRunsCapacity)) < minNbRuns) {
        }
        short[] nv = new short[2 * newRunsCapacity];
        this.copyValuesLength(this.valueslength, 0, nv, 0, this.nbrruns);
        this.valueslength = nv;
    }

    @Override
    public Container iflip(short x) {
        boolean contains;
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, x);
        if (index >= 0) {
            contains = true;
        } else {
            boolean bl = contains = this.searchSecondHalf(x, index) >= 0;
        }
        if (contains) {
            return this.iunset(x, index);
        }
        return this.iset(x, index);
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    public short getLength(int index) {
        return this.valueslength[2 * index + 1];
    }

    public int getLengthAsInt(int index) {
        return ContainerUtil.toIntUnsigned(this.getLength(index));
    }

    @Override
    public ShortAdvanceIterator getReverseShortIterator() {
        return new ReverseShortIterator(this);
    }

    @Override
    public ShortIterator getShortIterator() {
        return new ForwardShortIterator(this);
    }

    @Override
    public ContainerShortBatchIterator getShortBatchIterator(int skipCount) {
        return new RunShortBatchIterator(this, skipCount);
    }

    @Override
    public SearchRangeIterator getShortRangeIterator(int initialSeek) {
        return new RunContainerRangeIterator(this, initialSeek);
    }

    public short getValue(int index) {
        return this.valueslength[2 * index];
    }

    public int getValueAsInt(int index) {
        return ContainerUtil.toIntUnsigned(this.getValue(index));
    }

    public RunContainer iaddUnsafe(int begin, int end, int searchBeginRunIndex) {
        int d;
        int effectiveBeginIndex;
        int bIndex = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, searchBeginRunIndex, this.nbrruns, (short)begin);
        int eIndex = bIndex >= 0 ? RunContainer.unsignedInterleavedBinarySearch(this.valueslength, bIndex, this.nbrruns, (short)(end - 1)) : ((effectiveBeginIndex = ~bIndex) >= this.nbrruns ? bIndex : RunContainer.unsignedInterleavedBinarySearch(this.valueslength, effectiveBeginIndex, this.nbrruns, (short)(end - 1)));
        if (bIndex >= 0) {
            if (eIndex >= 0) {
                this.mergeValuesLength(bIndex, eIndex);
                return this;
            }
            if (this.canPrependValueLength(end - 1, (eIndex = -eIndex - 2) + 1)) {
                this.mergeValuesLength(bIndex, eIndex + 1);
                return this;
            }
            this.appendValueLength(end - 1, eIndex);
            this.mergeValuesLength(bIndex, eIndex);
            return this;
        }
        if (eIndex >= 0) {
            if ((bIndex = -bIndex - 2) >= 0 && this.valueLengthContains(begin - 1, bIndex)) {
                this.mergeValuesLength(bIndex, eIndex);
                return this;
            }
            this.prependValueLength(begin, bIndex + 1);
            this.mergeValuesLength(bIndex + 1, eIndex);
            return this;
        }
        bIndex = -bIndex - 2;
        if ((eIndex = -eIndex - 2) >= 0) {
            if (bIndex >= 0) {
                if (!this.valueLengthContains(begin - 1, bIndex)) {
                    if (bIndex == eIndex) {
                        if (this.canPrependValueLength(end - 1, eIndex + 1)) {
                            this.prependValueLength(begin, eIndex + 1);
                            return this;
                        }
                        this.makeRoomAtIndex(eIndex + 1);
                        this.setValue(eIndex + 1, (short)begin);
                        d = end - begin;
                        this.setLength(eIndex + 1, (short)(d - 1));
                        this.cardinality += d;
                        return this;
                    }
                    this.prependValueLength(begin, ++bIndex);
                }
            } else {
                bIndex = 0;
                this.prependValueLength(begin, bIndex);
            }
            if (this.canPrependValueLength(end - 1, eIndex + 1)) {
                this.mergeValuesLength(bIndex, eIndex + 1);
                return this;
            }
            this.appendValueLength(end - 1, eIndex);
            this.mergeValuesLength(bIndex, eIndex);
            return this;
        }
        if (this.canPrependValueLength(end - 1, 0)) {
            this.prependValueLength(begin, 0);
        } else {
            this.makeRoomAtIndex(0);
            this.setValue(0, (short)begin);
            d = end - begin;
            this.setLength(0, (short)(d - 1));
            this.cardinality += d;
        }
        return this;
    }

    @Override
    public Container iappend(int begin, int end) {
        RunContainer ans;
        int capacityForAns;
        int lastLen;
        if (end <= begin) {
            return this;
        }
        if (this.nbrruns == 0) {
            RunContainer ans2 = this.shared ? new RunContainer() : this;
            ans2.valueslength[0] = (short)begin;
            int d = end - begin;
            ans2.valueslength[1] = (short)(d - 1);
            ans2.nbrruns = 1;
            ans2.cardinality = d;
            return ans2;
        }
        int lastValue = this.getValueAsInt(this.nbrruns - 1);
        if (lastValue + (lastLen = this.getLengthAsInt(this.nbrruns - 1)) + 1 == begin) {
            RunContainer ans3 = this.deepcopyIfShared();
            int d = end - begin;
            ans3.valueslength[2 * this.nbrruns - 1] = (short)(lastLen + d);
            ans3.cardinality += d;
            return ans3;
        }
        int capacityNeeded = 2 * (this.nbrruns + 1);
        if (capacityNeeded > this.valueslength.length) {
            capacityForAns = this.nextCapacity();
            if (capacityForAns > 4090) {
                BitmapContainer bitmapContainer = this.toBitmapContainer();
                return ((Container)bitmapContainer).iappend(begin, end);
            }
        } else {
            capacityForAns = this.valueslength.length;
        }
        if (this.shared) {
            short[] newValuesLength = this.getValuesLengthInBiggerArray(RunContainer.runsShortArraySizeRounding(capacityForAns / 2));
            ans = RunContainer.makeByWrapping(newValuesLength, this.nbrruns, this.cardinality);
        } else {
            ans = this;
            if (capacityForAns != this.valueslength.length) {
                this.increaseCapacityTo(RunContainer.runsShortArraySizeRounding(capacityForAns / 2));
            }
        }
        ans.valueslength[2 * this.nbrruns] = (short)begin;
        int d = end - begin;
        ans.valueslength[2 * this.nbrruns + 1] = (short)(d - 1);
        ans.cardinality += d;
        ++ans.nbrruns;
        return ans;
    }

    @Override
    public Container iand(ArrayContainer x) {
        return this.and(x);
    }

    @Override
    public Container iand(BitmapContainer x) {
        return this.and(x);
    }

    @Override
    public Container iand(RunContainer x) {
        return this.and(x);
    }

    @Override
    public Container iandNot(ArrayContainer x) {
        if (x.isEmpty()) {
            return this;
        }
        return this.andNot(x);
    }

    @Override
    public Container iandNot(BitmapContainer x) {
        if (x.isEmpty()) {
            return this;
        }
        return this.andNot(x);
    }

    @Override
    public Container iandNot(RunContainer x) {
        if (x.isEmpty()) {
            return this;
        }
        return this.andNot(x);
    }

    private int nextCapacity() {
        int newCapacity = this.valueslength.length == 0 ? 3 : (this.valueslength.length < 64 ? this.valueslength.length * 2 : (this.valueslength.length < 1024 ? this.valueslength.length * 3 / 2 : this.valueslength.length * 5 / 4));
        return newCapacity;
    }

    private short[] getValuesLengthInBiggerArray(int newCapacity) {
        short[] nv = new short[newCapacity];
        System.arraycopy(this.valueslength, 0, nv, 0, 2 * this.nbrruns);
        return nv;
    }

    private void increaseCapacityTo(int newCapacity) {
        this.valueslength = this.getValuesLengthInBiggerArray(newCapacity);
    }

    private void increaseCapacity() {
        this.increaseCapacityTo(this.nextCapacity());
    }

    private void incrementLength(int index) {
        int n = 2 * index + 1;
        this.valueslength[n] = (short)(this.valueslength[n] + 1);
        ++this.cardinality;
    }

    private void incrementValue(int index) {
        int n = 2 * index;
        this.valueslength[n] = (short)(this.valueslength[n] + 1);
    }

    private void chopValueLength(int value, int index) {
        int initialValue = this.getValueAsInt(index);
        int length = this.getLengthAsInt(index);
        this.setValue(index, (short)value);
        int d = value - initialValue;
        this.setLength(index, (short)(length - d));
        this.cardinality -= d;
    }

    @Override
    public Container inot(int rangeStart, int rangeEnd) {
        int k;
        RunContainer ans;
        if (rangeEnd <= rangeStart) {
            return this;
        }
        if (this.valueslength.length <= 2 * this.nbrruns + 1) {
            boolean firstValueInRange;
            boolean lastValueBeforeRange = false;
            boolean firstValuePastRange = false;
            if (rangeStart > 0) {
                lastValueBeforeRange = this.contains((short)(rangeStart - 1));
            }
            if (lastValueBeforeRange == (firstValueInRange = this.contains((short)rangeStart))) {
                boolean lastValueInRange = this.contains((short)(rangeEnd - 1));
                if (rangeEnd != 65536) {
                    firstValuePastRange = this.contains((short)rangeEnd);
                }
                if (lastValueInRange == firstValuePastRange) {
                    return this.not(rangeStart, rangeEnd);
                }
            }
        }
        int myNbrRuns = this.nbrruns;
        if (this.shared) {
            ans = new RunContainer(Arrays.copyOf(this.valueslength, this.valueslength.length), 0, 0);
        } else {
            this.nbrruns = 0;
            this.cardinality = 0;
            ans = this;
        }
        for (k = 0; k < myNbrRuns && this.getValueAsInt(k) < rangeStart; ++k) {
            ans.cardinality += this.getLengthAsInt(k) + 1;
            ++ans.nbrruns;
        }
        short bufferedValue = 0;
        short bufferedLength = 0;
        short nextValue = 0;
        short nextLength = 0;
        if (k < myNbrRuns) {
            bufferedValue = this.getValue(k);
            bufferedLength = this.getLength(k);
        }
        ans.smartAppendForXor((short)rangeStart, (short)(rangeEnd - rangeStart - 1));
        while (k < myNbrRuns) {
            if (ans.nbrruns > k + 1) {
                throw new RuntimeException("internal error in inot, writer has overtaken reader!! " + k + " " + ans.nbrruns);
            }
            if (k + 1 < myNbrRuns) {
                nextValue = this.getValue(k + 1);
                nextLength = this.getLength(k + 1);
            }
            ans.smartAppendForXor(bufferedValue, bufferedLength);
            bufferedValue = nextValue;
            bufferedLength = nextLength;
            ++k;
        }
        return ans.toEfficientContainer();
    }

    @Override
    public Container ior(ArrayContainer x) {
        if (this.shared) {
            return this.or(x);
        }
        if (this.isAllOnes() || x.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return x.cowRef();
        }
        int offset = x.getCardinality();
        this.copyToOffset(offset);
        int myRuns = this.nbrruns;
        this.nbrruns = 0;
        this.cardinality = 0;
        RunContainer.orImpl(this, this, myRuns, offset, x);
        return this.toEfficientContainer();
    }

    @Override
    public Container ior(BitmapContainer x) {
        if (this.isAllOnes() || x.isEmpty()) {
            return this;
        }
        if (x.isAllOnes()) {
            return Container.full();
        }
        if (this.isEmpty()) {
            return x.cowRef();
        }
        return this.or(x);
    }

    @Override
    public Container ior(RunContainer x) {
        if (this.shared) {
            return this.or(x);
        }
        if (this.isAllOnes() || x.isEmpty()) {
            return this;
        }
        if (this.isEmpty() || x.isAllOnes()) {
            return x.cowRef();
        }
        int srcOffset = x.nbrruns;
        this.copyToOffset(srcOffset);
        int srcRuns = this.nbrruns;
        this.nbrruns = 0;
        this.cardinality = 0;
        RunContainer.orImpl(this, this, srcRuns, srcOffset, x);
        return this.toEfficientContainer();
    }

    private static void orImpl(RunContainer dst, RunContainer src, int srcRuns, int srcOffset, RunContainer other) {
        int otherRuns = other.nbrruns;
        int srcPosWithOffset = srcOffset;
        int srcRunsWithOffset = srcRuns + srcOffset;
        int otherPos = 0;
        while (srcPosWithOffset < srcRunsWithOffset && otherPos < otherRuns) {
            short value = src.getValue(srcPosWithOffset);
            short xvalue = other.getValue(otherPos);
            short length = src.getLength(srcPosWithOffset);
            short xlength = other.getLength(otherPos);
            if (ContainerUtil.compareUnsigned(value, xvalue) <= 0) {
                dst.smartAppend(value, length);
                ++srcPosWithOffset;
                continue;
            }
            dst.smartAppend(xvalue, xlength);
            ++otherPos;
        }
        if (srcPosWithOffset < srcRunsWithOffset) {
            int srcNextRunVal;
            int lastNext;
            if (src == dst && dst.nbrruns == srcPosWithOffset && (lastNext = dst.last() + 1) < (srcNextRunVal = src.getValueAsInt(srcPosWithOffset))) {
                dst.nbrruns += srcRunsWithOffset - srcPosWithOffset;
                for (int run = srcPosWithOffset; run < srcRunsWithOffset; ++run) {
                    dst.cardinality += dst.getLengthAsInt(run) + 1;
                }
                return;
            }
            do {
                dst.smartAppend(src.getValue(srcPosWithOffset), src.getLength(srcPosWithOffset));
            } while (++srcPosWithOffset < srcRunsWithOffset);
            return;
        }
        while (otherPos < otherRuns) {
            dst.smartAppend(other.getValue(otherPos), other.getLength(otherPos));
            ++otherPos;
        }
    }

    @Override
    public Container iremove(int begin, int end) {
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        if (begin == end - 1) {
            return this.iunset((short)begin);
        }
        RunContainer ans = this.deepcopyIfShared();
        return ans.iremoveImpl(begin, end);
    }

    private Container iremoveImpl(int begin, int end) {
        int bIndex = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (short)begin);
        int eIndex = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (short)(end - 1));
        if (bIndex >= 0) {
            if (eIndex < 0) {
                eIndex = -eIndex - 2;
            }
            if (this.valueLengthContains(end, eIndex)) {
                this.chopValueLength(end, eIndex);
                this.recoverRoomsInRange(bIndex - 1, eIndex - 1);
            } else {
                this.recoverRoomsInRange(bIndex - 1, eIndex);
            }
        } else if (eIndex >= 0) {
            if ((bIndex = -bIndex - 2) >= 0 && this.valueLengthContains(begin, bIndex)) {
                this.closeValueLength(begin - 1, bIndex);
            }
            if (this.getLength(eIndex) == 0) {
                this.recoverRoomsInRange(eIndex - 1, eIndex);
            } else {
                this.incrementValue(eIndex);
                this.decrementLength(eIndex);
            }
            this.recoverRoomsInRange(bIndex, eIndex - 1);
        } else {
            bIndex = -bIndex - 2;
            if ((eIndex = -eIndex - 2) >= 0) {
                if (bIndex >= 0) {
                    if (bIndex == eIndex) {
                        if (this.valueLengthContains(begin, bIndex)) {
                            if (this.valueLengthContains(end, eIndex)) {
                                this.makeRoomAtIndex(bIndex);
                                this.cardinality += this.getLengthAsInt(bIndex) + 1;
                                this.closeValueLength(begin - 1, bIndex);
                                this.chopValueLength(end, bIndex + 1);
                                return this;
                            }
                            this.closeValueLength(begin - 1, bIndex);
                        }
                    } else {
                        if (this.valueLengthContains(begin, bIndex)) {
                            this.closeValueLength(begin - 1, bIndex);
                        }
                        if (this.valueLengthContains(end, eIndex)) {
                            this.chopValueLength(end, eIndex);
                            --eIndex;
                        }
                        this.recoverRoomsInRange(bIndex, eIndex);
                    }
                } else if (this.valueLengthContains(end, eIndex)) {
                    this.chopValueLength(end, eIndex);
                    this.recoverRoomsInRange(bIndex, eIndex - 1);
                } else {
                    this.recoverRoomsInRange(bIndex, eIndex);
                }
            }
        }
        return this;
    }

    @Override
    public Container ixor(ArrayContainer x) {
        if (this.shared) {
            return this.xor(x);
        }
        if (x.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return x.cowRef();
        }
        int offset = x.getCardinality();
        this.copyToOffset(offset);
        int myRuns = this.nbrruns;
        this.nbrruns = 0;
        this.cardinality = 0;
        RunContainer.xOrImpl(this, this, myRuns, offset, x);
        return this.toEfficientContainer();
    }

    @Override
    public Container ixor(BitmapContainer x) {
        return this.xor(x);
    }

    @Override
    public Container ixor(RunContainer x) {
        if (this.shared) {
            return this.xor(x);
        }
        if (x.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return x.cowRef();
        }
        int offset = x.nbrruns;
        this.copyToOffset(offset);
        int myRuns = this.nbrruns;
        this.nbrruns = 0;
        this.cardinality = 0;
        RunContainer.xOrImpl(this, this, myRuns, offset, x);
        return this.toEfficientContainer();
    }

    private RunContainer andNotAsRun(ArrayContainer x) {
        int d;
        RunContainer ans = new RunContainer(this.nbrruns + x.cardinality);
        int rlepos = 0;
        int xrlepos = 0;
        int start = this.getValueAsInt(rlepos);
        int end = start + this.getLengthAsInt(rlepos) + 1;
        int xstart = ContainerUtil.toIntUnsigned(x.content[xrlepos]);
        while (rlepos < this.nbrruns && xrlepos < x.cardinality) {
            if (end <= xstart) {
                ans.valueslength[2 * ans.nbrruns] = (short)start;
                d = end - start;
                ans.valueslength[2 * ans.nbrruns + 1] = (short)(d - 1);
                ans.cardinality += d;
                ++ans.nbrruns;
                if (++rlepos >= this.nbrruns) continue;
                start = this.getValueAsInt(rlepos);
                end = start + this.getLengthAsInt(rlepos) + 1;
                continue;
            }
            if (xstart + 1 <= start) {
                if (++xrlepos >= x.cardinality) continue;
                xstart = ContainerUtil.toIntUnsigned(x.content[xrlepos]);
                continue;
            }
            if (start < xstart) {
                ans.valueslength[2 * ans.nbrruns] = (short)start;
                d = xstart - start;
                ans.valueslength[2 * ans.nbrruns + 1] = (short)(d - 1);
                ans.cardinality += d;
                ++ans.nbrruns;
            }
            if (xstart + 1 < end) {
                start = xstart + 1;
                continue;
            }
            if (++rlepos >= this.nbrruns) continue;
            start = this.getValueAsInt(rlepos);
            end = start + this.getLengthAsInt(rlepos) + 1;
        }
        if (rlepos < this.nbrruns) {
            ans.valueslength[2 * ans.nbrruns] = (short)start;
            d = end - start;
            ans.valueslength[2 * ans.nbrruns + 1] = (short)(d - 1);
            ans.cardinality += d;
            ++ans.nbrruns;
            if (++rlepos < this.nbrruns) {
                int nruns = this.nbrruns - rlepos;
                System.arraycopy(this.valueslength, 2 * rlepos, ans.valueslength, 2 * ans.nbrruns, 2 * nruns);
                for (int i = 0; i < nruns; ++i) {
                    ans.cardinality += ans.getLengthAsInt(ans.nbrruns + i) + 1;
                }
                ans.nbrruns += nruns;
            }
        }
        return ans;
    }

    private static void orImpl(RunContainer dst, RunContainer src, int srcRuns, int srcOffset, ArrayContainer other) {
        int otherCardinality = other.getCardinality();
        int srcPosWithOffset = srcOffset;
        int srcRunsWithOffset = srcRuns + srcOffset;
        int otherIdx = 0;
        if (otherIdx < otherCardinality && srcPosWithOffset < srcRunsWithOffset) {
            short otherValue = other.content[otherIdx];
            do {
                short srcValue;
                if (ContainerUtil.compareUnsigned(srcValue = src.getValue(srcPosWithOffset), otherValue) <= 0) {
                    short srcLen = src.getLength(srcPosWithOffset);
                    dst.smartAppend(srcValue, srcLen);
                    ++srcPosWithOffset;
                    continue;
                }
                dst.smartAppend(otherValue);
                if (++otherIdx >= otherCardinality) break;
                otherValue = other.content[otherIdx];
            } while (srcPosWithOffset < srcRunsWithOffset);
        }
        if (otherIdx < otherCardinality) {
            do {
                dst.smartAppend(other.content[otherIdx]);
            } while (++otherIdx < otherCardinality);
            return;
        }
        if (src == dst && dst.nbrruns == srcPosWithOffset) {
            int nextRunValue = src.getValueAsInt(srcPosWithOffset);
            int dstCurrentLastNext = dst.last() + 1;
            if (dstCurrentLastNext < nextRunValue) {
                dst.nbrruns += srcRunsWithOffset - srcPosWithOffset;
                for (int run = srcPosWithOffset; run < srcRunsWithOffset; ++run) {
                    dst.cardinality += dst.getLengthAsInt(run) + 1;
                }
                return;
            }
        }
        do {
            short srcValue = src.getValue(srcPosWithOffset);
            short srcLen = src.getLength(srcPosWithOffset);
            dst.smartAppend(srcValue, srcLen);
        } while (++srcPosWithOffset < srcRunsWithOffset);
    }

    private void makeRoomAtIndex(int index) {
        if (2 * (this.nbrruns + 1) > this.valueslength.length) {
            this.increaseCapacity();
        }
        this.copyValuesLength(this.valueslength, index, this.valueslength, index + 1, this.nbrruns - index);
        ++this.nbrruns;
    }

    private void mergeValuesLength(int begin, int end) {
        if (begin >= end) {
            return;
        }
        int bValue = this.getValueAsInt(begin);
        int bLength = this.getLengthAsInt(begin);
        int eValue = this.getValueAsInt(end);
        int eLength = this.getLengthAsInt(end);
        int newLength = eValue - bValue + eLength;
        this.setLength(begin, (short)newLength);
        this.recoverRoomsInRange(begin, end);
        this.cardinality += newLength - bLength;
    }

    @Override
    public Container not(int rangeStart, int rangeEnd) {
        int k;
        if (rangeEnd <= rangeStart) {
            return this.cowRef();
        }
        RunContainer ans = new RunContainer(this.nbrruns + 1);
        for (k = 0; k < this.nbrruns && this.getValueAsInt(k) < rangeStart; ++k) {
            short len;
            ans.valueslength[2 * k] = this.valueslength[2 * k];
            ans.valueslength[2 * k + 1] = len = this.valueslength[2 * k + 1];
            ++ans.nbrruns;
            ans.cardinality += len + 1;
        }
        ans.smartAppendForXor((short)rangeStart, (short)(rangeEnd - rangeStart - 1));
        while (k < this.nbrruns) {
            ans.smartAppendForXor(this.getValue(k), this.getLength(k));
            ++k;
        }
        return ans.toEfficientContainer();
    }

    @Override
    public int numberOfRuns() {
        return this.nbrruns;
    }

    @Override
    public Container or(ArrayContainer x) {
        if (this.isAllOnes() || x.isEmpty()) {
            return this.cowRef();
        }
        if (this.isEmpty()) {
            return x.cowRef();
        }
        RunContainer answer = new RunContainer(this.nbrruns + x.getCardinality());
        RunContainer.orImpl(answer, this, this.nbrruns, 0, x);
        return answer.toEfficientContainer();
    }

    @Override
    public Container or(BitmapContainer x) {
        if (this.isAllOnes() || x.isEmpty()) {
            return this.cowRef();
        }
        if (x.isAllOnes()) {
            return Container.full();
        }
        if (this.isEmpty()) {
            return x.cowRef();
        }
        BitmapContainer answer = x.deepCopy();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int start = this.getValueAsInt(rlepos);
            int end = start + this.getLengthAsInt(rlepos) + 1;
            int prevOnesInRange = answer.cardinalityInRange(start, end);
            ContainerUtil.setBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnesInRange, end - start);
        }
        if (answer.isAllOnes()) {
            return Container.full();
        }
        return answer;
    }

    @Override
    public Container or(RunContainer x) {
        if (this.isAllOnes() || x.isEmpty()) {
            return this.cowRef();
        }
        if (this.isEmpty() || x.isAllOnes()) {
            return x.cowRef();
        }
        RunContainer answer = new RunContainer(this.nbrruns + x.nbrruns);
        RunContainer.orImpl(answer, this, this.nbrruns, 0, x);
        return answer.toEfficientContainer();
    }

    private void prependValueLength(int value, int index) {
        int initialValue = this.getValueAsInt(index);
        int length = this.getLengthAsInt(index);
        this.setValue(index, (short)value);
        int d = initialValue - value;
        this.setLength(index, (short)(d + length));
        this.cardinality += d;
    }

    @Override
    public int rank(short lowbits) {
        int x = ContainerUtil.toIntUnsigned(lowbits);
        int answer = 0;
        for (int k = 0; k < this.nbrruns; ++k) {
            int value = this.getValueAsInt(k);
            int length = this.getLengthAsInt(k);
            if (x < value) {
                return answer;
            }
            if (value + length + 1 > x) {
                return answer + x - value + 1;
            }
            answer += length + 1;
        }
        return answer;
    }

    private void recoverRoomAtIndex(int index) {
        this.cardinality -= this.getLengthAsInt(index) + 1;
        this.copyValuesLength(this.valueslength, index + 1, this.valueslength, index, this.nbrruns - index - 1);
        --this.nbrruns;
    }

    private void recoverRoomsInRange(int begin, int end) {
        for (int run = begin + 1; run <= end; ++run) {
            this.cardinality -= this.getLengthAsInt(run) + 1;
        }
        if (end + 1 < this.nbrruns) {
            this.copyValuesLength(this.valueslength, end + 1, this.valueslength, begin + 1, this.nbrruns - 1 - end);
        }
        this.nbrruns -= end - begin;
    }

    @Override
    public Container remove(int begin, int end) {
        RunContainer rc = this.deepCopyIfNotShared();
        return rc.iremove(begin, end);
    }

    @Override
    public Container unset(short x) {
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, x);
        return this.unsetImpl(x, index, false, null);
    }

    @Override
    public Container iunset(short x) {
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, x);
        return this.iunset(x, index);
    }

    private Container iunset(short x, int index) {
        return this.unsetImpl(x, index, true, null);
    }

    @Override
    Container iunset(short x, PositionHint positionHint) {
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, Math.max(positionHint.value, 0), this.nbrruns, x);
        return this.unsetImpl(x, index, true, positionHint);
    }

    @Override
    Container unset(short x, PositionHint positionHint) {
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, Math.max(positionHint.value, 0), this.nbrruns, x);
        return this.unsetImpl(x, index, false, positionHint);
    }

    private Container unsetImpl(short x, int index, boolean inPlace, PositionHint positionHintOut) {
        int le;
        if (index >= 0) {
            RunContainer ans;
            RunContainer runContainer = ans = inPlace ? this.deepcopyIfShared() : this.deepCopy();
            if (ans.getLength(index) == 0) {
                ans.recoverRoomAtIndex(index);
            } else {
                ans.incrementValue(index);
                ans.decrementLength(index);
            }
            MutableInteger.setIfNotNull(positionHintOut, index);
            return ans;
        }
        if ((index = -index - 2) < 0) {
            MutableInteger.setIfNotNull(positionHintOut, 0);
            return inPlace ? this : this.cowRef();
        }
        int offset = ContainerUtil.toIntUnsigned(x) - this.getValueAsInt(index);
        if (offset < (le = this.getLengthAsInt(index))) {
            RunContainer ans = inPlace ? this.deepcopyIfShared() : this.deepCopy();
            ans.setLength(index, (short)(offset - 1));
            ans.cardinality += offset - 1 - le;
            int newValue = ContainerUtil.toIntUnsigned(x) + 1;
            int newLength = le - offset - 1;
            ans.makeRoomAtIndex(index + 1);
            ans.setValue(index + 1, (short)newValue);
            ans.setLength(index + 1, (short)newLength);
            ans.cardinality += newLength + 1;
            MutableInteger.setIfNotNull(positionHintOut, index + 1);
            return ans;
        }
        if (offset != le) {
            MutableInteger.setIfNotNull(positionHintOut, index);
            return inPlace ? this : this.cowRef();
        }
        RunContainer ans = inPlace ? this.deepcopyIfShared() : this.deepCopy();
        ans.decrementLength(index);
        MutableInteger.setIfNotNull(positionHintOut, index);
        return ans;
    }

    @Override
    public Container runOptimize() {
        return this.toEfficientContainer();
    }

    @Override
    public short select(int j) {
        int offset = 0;
        for (int k = 0; k < this.nbrruns; ++k) {
            int nextOffset = offset + this.getLengthAsInt(k) + 1;
            if (nextOffset > j) {
                return (short)(this.getValue(k) + (j - offset));
            }
            offset = nextOffset;
        }
        throw new IllegalArgumentException("Cannot select " + j + " since cardinality is " + this.getCardinality());
    }

    @Override
    public RunContainer select(int startRank, int endRank) {
        return RunContainer.select(this, startRank, endRank);
    }

    @Override
    public int find(short x) {
        int value;
        int pos = 0;
        int target = ContainerUtil.toIntUnsigned(x);
        for (int k = 0; k < this.nbrruns && target >= (value = this.getValueAsInt(k)); ++k) {
            int length = this.getLengthAsInt(k);
            int end = value + length;
            if (target <= end) {
                return pos + target - value;
            }
            pos += length + 1;
        }
        return -pos - 1;
    }

    @Override
    public void selectRanges(RangeConsumer outValues, RangeIterator inPositions) {
        int kLen;
        if (this.nbrruns == 0) {
            return;
        }
        int k = 0;
        int kStart = this.getValueAsInt(0);
        int kEndPos = kLen = this.getLengthAsInt(0);
        int ostart = -1;
        int oend = -1;
        while (inPositions.hasNext()) {
            inPositions.next();
            int istart = inPositions.start();
            int iend = inPositions.end();
            for (int pos = istart; pos < iend; ++pos) {
                while (kEndPos < pos) {
                    if (++k >= this.nbrruns) {
                        throw new IllegalArgumentException("selectRanges for invalid pos=" + pos);
                    }
                    kStart = this.getValueAsInt(k);
                    kLen = this.getLengthAsInt(k);
                    kEndPos += 1 + kLen;
                }
                int key = kStart + kLen - (kEndPos - pos);
                if (ostart == -1) {
                    ostart = oend = key;
                    continue;
                }
                if (key == oend + 1) {
                    oend = key;
                    continue;
                }
                outValues.accept(ostart, oend + 1);
                ostart = oend = key;
            }
        }
        outValues.accept(ostart, oend + 1);
    }

    @Override
    public boolean findRanges(RangeConsumer outPositions, RangeIterator inValues, int maxPos) {
        if (!inValues.hasNext()) {
            return false;
        }
        int k = 0;
        int offset = 0;
        int kStart = this.getValueAsInt(0);
        int kLen = this.getLengthAsInt(0);
        int kEnd = kStart + kLen;
        int ostart = -1;
        int oend = -1;
        do {
            inValues.next();
            int istart = inValues.start();
            int iend = inValues.end();
            for (int key = istart; key < iend; ++key) {
                while (kEnd < key) {
                    if (++k >= this.nbrruns) {
                        throw new IllegalArgumentException("findRanges for invalid key=" + key);
                    }
                    offset += kLen + 1;
                    kStart = this.getValueAsInt(k);
                    kLen = this.getLengthAsInt(k);
                    kEnd = kStart + kLen;
                }
                if (key < kStart) {
                    throw new IllegalArgumentException("findRanges for invalid key=" + key);
                }
                int pos = offset + (key - kStart);
                if (ostart == -1) {
                    if (pos > maxPos) {
                        return true;
                    }
                    ostart = oend = pos;
                    continue;
                }
                if (pos > maxPos) {
                    outPositions.accept(ostart, oend + 1);
                    return true;
                }
                if (pos == oend + 1) {
                    oend = pos;
                    continue;
                }
                outPositions.accept(ostart, oend + 1);
                ostart = oend = pos;
            }
        } while (inValues.hasNext());
        outPositions.accept(ostart, oend + 1);
        return false;
    }

    private void setLength(int index, short v) {
        this.setLength(this.valueslength, index, v);
    }

    private void setLength(short[] valueslength, int index, short v) {
        valueslength[2 * index + 1] = v;
    }

    private void setValue(int index, short v) {
        this.setValue(this.valueslength, index, v);
    }

    private void setValue(short[] valueslength, int index, short v) {
        valueslength[2 * index] = v;
    }

    private int skipAhead(RunContainer skippingOn, int pos, int targetToExceed) {
        int probePos;
        int end;
        int left = pos;
        int span = 1;
        do {
            if ((probePos = left + span) >= skippingOn.nbrruns - 1 && (end = ContainerUtil.toIntUnsigned(skippingOn.getValue(probePos = skippingOn.nbrruns - 1)) + ContainerUtil.toIntUnsigned(skippingOn.getLength(probePos)) + 1) <= targetToExceed) {
                return skippingOn.nbrruns;
            }
            end = ContainerUtil.toIntUnsigned(skippingOn.getValue(probePos)) + ContainerUtil.toIntUnsigned(skippingOn.getLength(probePos)) + 1;
            span *= 2;
        } while (end <= targetToExceed);
        int right = probePos;
        while (right - left > 1) {
            int mid = (right + left) / 2;
            int midVal = ContainerUtil.toIntUnsigned(skippingOn.getValue(mid)) + ContainerUtil.toIntUnsigned(skippingOn.getLength(mid)) + 1;
            if (midVal > targetToExceed) {
                right = mid;
                continue;
            }
            left = mid;
        }
        return right;
    }

    private void simpleAppend(short start, short length) {
        this.valueslength[2 * this.nbrruns] = start;
        this.valueslength[2 * this.nbrruns + 1] = length;
        this.cardinality += ContainerUtil.toIntUnsigned(length) + 1;
        ++this.nbrruns;
    }

    private void smartAppend(short val) {
        this.smartAppend(val, (short)0);
    }

    void smartAppend(short start, short length) {
        if (this.nbrruns == 0) {
            this.simpleAppend(start, length);
            return;
        }
        int oldStart = this.getValueAsInt(this.nbrruns - 1);
        int oldLen = this.getLengthAsInt(this.nbrruns - 1);
        int oldEnd = oldStart + oldLen + 1;
        if (ContainerUtil.toIntUnsigned(start) > oldEnd) {
            this.simpleAppend(start, length);
            return;
        }
        int newEnd = ContainerUtil.toIntUnsigned(start) + ContainerUtil.toIntUnsigned(length) + 1;
        if (newEnd > oldEnd) {
            this.setLength(this.nbrruns - 1, (short)(newEnd - 1 - oldStart));
            this.cardinality += newEnd - oldEnd;
        }
    }

    private void smartAppendForXor(short val) {
        this.smartAppendForXor(val, (short)0);
    }

    private void smartAppendForXor(short start, short length) {
        if (this.nbrruns == 0) {
            this.simpleAppend(start, length);
            return;
        }
        int oldStart = this.getValueAsInt(this.nbrruns - 1);
        int oldLen = this.getLengthAsInt(this.nbrruns - 1);
        int oldEnd = oldStart + oldLen + 1;
        int newStart = ContainerUtil.toIntUnsigned(start);
        if (newStart > oldEnd) {
            this.simpleAppend(start, length);
            return;
        }
        if (newStart == oldEnd) {
            int n = 2 * (this.nbrruns - 1) + 1;
            this.valueslength[n] = (short)(this.valueslength[n] + (length + 1));
            this.cardinality += ContainerUtil.toIntUnsigned((short)(length + 1));
            return;
        }
        int newEnd = newStart + ContainerUtil.toIntUnsigned(length) + 1;
        if (newStart == oldStart) {
            if (newEnd < oldEnd) {
                this.setValue(this.nbrruns - 1, (short)newEnd);
                this.setLength(this.nbrruns - 1, (short)(oldEnd - newEnd - 1));
                this.cardinality -= newEnd - oldStart;
                return;
            }
            if (newEnd > oldEnd) {
                this.setValue(this.nbrruns - 1, (short)oldEnd);
                this.setLength(this.nbrruns - 1, (short)(newEnd - oldEnd - 1));
                this.cardinality -= oldEnd - oldStart;
                this.cardinality += newEnd - oldEnd;
                return;
            }
            --this.nbrruns;
            this.cardinality -= oldEnd - oldStart;
            return;
        }
        short newLen = (short)(start - oldStart - 1);
        this.setLength(this.nbrruns - 1, newLen);
        this.cardinality += ContainerUtil.toIntUnsigned(newLen) - oldLen;
        if (newEnd < oldEnd) {
            this.setValue(this.nbrruns, (short)newEnd);
            int d = oldEnd - newEnd;
            this.setLength(this.nbrruns, (short)(d - 1));
            this.cardinality += d;
            ++this.nbrruns;
            return;
        }
        if (newEnd > oldEnd) {
            this.setValue(this.nbrruns, (short)oldEnd);
            int d = newEnd - oldEnd;
            this.setLength(this.nbrruns, (short)(d - 1));
            this.cardinality += d;
            ++this.nbrruns;
        }
    }

    private Container toBitmapIfNeeded() {
        int sizeAsBitmapContainer = 8192;
        int sizeAsRunContainer = RunContainer.sizeInBytes(this.nbrruns);
        if (sizeAsBitmapContainer > sizeAsRunContainer) {
            return this;
        }
        return this.toBitmapContainer();
    }

    Container toBitmapOrArrayContainer(int card) {
        if (card <= 3835) {
            ArrayContainer answer = new ArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int runStart = this.getValueAsInt(rlepos);
                int runEnd = runStart + this.getLengthAsInt(rlepos);
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    answer.content[answer.cardinality++] = (short)runValue;
                }
            }
            return answer;
        }
        BitmapContainer answer = new BitmapContainer();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int start = this.getValueAsInt(rlepos);
            int end = start + this.getLengthAsInt(rlepos) + 1;
            ContainerUtil.setBitmapRange(answer.bitmap, start, end);
        }
        answer.cardinality = card;
        return answer;
    }

    Container toEfficientContainer() {
        if (this.nbrruns == 0) {
            return Container.empty();
        }
        if (this.nbrruns == 1) {
            int start = ContainerUtil.toIntUnsigned(this.valueslength[0]);
            int len = ContainerUtil.toIntUnsigned(this.valueslength[1]);
            if (len == 0) {
                return RunContainer.makeSingletonContainer(ContainerUtil.lowbits(start));
            }
            int end = start + len + 1;
            return RunContainer.makeSingleRangeContainer(start, end);
        }
        if (this.nbrruns == 2 && 0 == this.valueslength[1] && 0 == this.valueslength[3]) {
            return RunContainer.makeTwoValuesContainer(this.valueslength[0], this.valueslength[2]);
        }
        int sizeAsRunContainer = RunContainer.sizeInBytes(this.nbrruns);
        int sizeAsBitmapContainer = 8192;
        int card = this.getCardinality();
        int sizeAsArrayContainer = ArrayContainer.sizeInBytes(card);
        if (sizeAsRunContainer <= Math.min(8192, sizeAsArrayContainer)) {
            this.compact();
            return this;
        }
        return this.toBitmapOrArrayContainer(card);
    }

    private void compact() {
        int used = RunContainer.runsShortArraySizeRounding(this.nbrruns);
        if (this.shared || 2 * this.valueslength.length <= used) {
            return;
        }
        short[] newValueslength = new short[used];
        System.arraycopy(this.valueslength, 0, newValueslength, 0, 2 * this.nbrruns);
        this.valueslength = newValueslength;
    }

    @Override
    public void trim() {
        this.compact();
    }

    private boolean valueLengthContains(int value, int index) {
        int length;
        int initialValue = this.getValueAsInt(index);
        return value <= initialValue + (length = this.getLengthAsInt(index));
    }

    private static void xOrImpl(RunContainer dst, RunContainer src, int srcRuns, int srcOffset, ArrayContainer other) {
        int srcPosWithOffset = srcOffset;
        int srcRunsWithOffset = srcRuns + srcOffset;
        int otherIdx = 0;
        short otherValue = other.content[otherIdx];
        short srcValue = src.getValue(srcPosWithOffset);
        while (true) {
            if (ContainerUtil.compareUnsigned(srcValue, otherValue) < 0) {
                dst.smartAppendForXor(srcValue, src.getLength(srcPosWithOffset));
                if (++srcPosWithOffset == srcRunsWithOffset) {
                    dst.smartAppendForXor(otherValue);
                    while (++otherIdx < other.cardinality) {
                        dst.smartAppendForXor(other.content[otherIdx]);
                    }
                    return;
                }
                srcValue = src.getValue(srcPosWithOffset);
                continue;
            }
            dst.smartAppendForXor(otherValue);
            if (++otherIdx >= other.cardinality) {
                if (srcPosWithOffset < srcRunsWithOffset) {
                    int srcNextRunVal;
                    int lastNext;
                    if (src == dst && dst.nbrruns == srcPosWithOffset && (lastNext = dst.last() + 1) < (srcNextRunVal = src.getValueAsInt(srcPosWithOffset))) {
                        dst.nbrruns += srcRunsWithOffset - srcPosWithOffset;
                        for (int run = srcPosWithOffset; run < srcRunsWithOffset; ++run) {
                            dst.cardinality += dst.getLengthAsInt(run) + 1;
                        }
                        return;
                    }
                    do {
                        dst.smartAppendForXor(src.getValue(srcPosWithOffset), src.getLength(srcPosWithOffset));
                    } while (++srcPosWithOffset < srcRunsWithOffset);
                }
                return;
            }
            otherValue = other.content[otherIdx];
        }
    }

    @Override
    public Container xor(ArrayContainer x) {
        if (x.isEmpty()) {
            return this.cowRef();
        }
        if (this.isEmpty()) {
            return x.cowRef();
        }
        int arbitrary_threshold = 32;
        int xCard = x.getCardinality();
        if (xCard < 32) {
            if (xCard == 0) {
                return this.cowRef();
            }
            RunContainer dst = new RunContainer(this.nbrruns + x.getCardinality());
            RunContainer.xOrImpl(dst, this, this.nbrruns, 0, x);
            return dst.toEfficientContainer();
        }
        int card = this.getCardinality();
        if (card <= 3835) {
            return x.xor(this.getShortIterator());
        }
        return this.toBitmapOrArrayContainer(card).ixor(x);
    }

    @Override
    public Container xor(BitmapContainer x) {
        if (x.isEmpty()) {
            return this.cowRef();
        }
        if (this.isEmpty()) {
            return x.cowRef();
        }
        BitmapContainer answer = x.deepCopy();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int start = this.getValueAsInt(rlepos);
            int end = start + this.getLengthAsInt(rlepos) + 1;
            int prevOnes = answer.cardinalityInRange(start, end);
            ContainerUtil.flipBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnes, end - start - prevOnes);
        }
        return answer.maybeSwitchContainer();
    }

    private static void xOrImpl(RunContainer dst, RunContainer src, int srcRuns, int srcOffset, RunContainer other) {
        int srcPosWithOffset = srcOffset;
        int srcRunsWithOffset = srcRuns + srcOffset;
        int otherPos = 0;
        short srcValue = src.getValue(srcPosWithOffset);
        short otherValue = other.getValue(otherPos);
        while (true) {
            if (ContainerUtil.compareUnsigned(srcValue, otherValue) < 0) {
                dst.smartAppendForXor(srcValue, src.getLength(srcPosWithOffset));
                if (++srcPosWithOffset == srcRunsWithOffset) {
                    while (otherPos < other.nbrruns) {
                        dst.smartAppendForXor(other.getValue(otherPos), other.getLength(otherPos));
                        ++otherPos;
                    }
                    return;
                }
                srcValue = src.getValue(srcPosWithOffset);
                continue;
            }
            dst.smartAppendForXor(other.getValue(otherPos), other.getLength(otherPos));
            if (++otherPos == other.nbrruns) {
                if (srcPosWithOffset < srcRunsWithOffset) {
                    int srcNextRunVal;
                    int lastNext;
                    if (src == dst && dst.nbrruns == srcPosWithOffset && (lastNext = dst.last() + 1) < (srcNextRunVal = src.getValueAsInt(srcPosWithOffset))) {
                        dst.nbrruns += srcRunsWithOffset - srcPosWithOffset;
                        for (int run = srcPosWithOffset; run < srcRunsWithOffset; ++run) {
                            dst.cardinality += dst.getLengthAsInt(run) + 1;
                        }
                        return;
                    }
                    do {
                        dst.smartAppendForXor(src.getValue(srcPosWithOffset), src.getLength(srcPosWithOffset));
                    } while (++srcPosWithOffset < srcRunsWithOffset);
                }
                return;
            }
            otherValue = other.getValue(otherPos);
        }
    }

    @Override
    public Container xor(RunContainer x) {
        if (x.isEmpty()) {
            return this.cowRef();
        }
        if (this.isEmpty()) {
            return x.cowRef();
        }
        RunContainer answer = new RunContainer(this.nbrruns + x.nbrruns);
        RunContainer.xOrImpl(answer, this, this.nbrruns, 0, x);
        return answer.toEfficientContainer();
    }

    @Override
    public boolean forEach(ShortConsumer sc) {
        for (int k = 0; k < this.nbrruns; ++k) {
            int val = this.getValueAsInt(k);
            int len = this.getLengthAsInt(k);
            for (int v = val; v <= val + len; ++v) {
                boolean wantMore = sc.accept((short)v);
                if (wantMore) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean forEach(int rankOffset, ShortConsumer sc) {
        int len;
        int val;
        int rank = 0;
        int k = 0;
        while (rank < rankOffset) {
            val = this.getValueAsInt(k);
            len = this.getLengthAsInt(k);
            ++k;
            int nextRank = rank + len + 1;
            if (nextRank > rankOffset) {
                int n = nextRank - rankOffset;
                int last = val + len;
                for (int v = last - n + 1; v <= last; ++v) {
                    boolean wantMore = sc.accept((short)v);
                    if (wantMore) continue;
                    return false;
                }
                break;
            }
            rank = nextRank;
        }
        while (k < this.nbrruns) {
            val = this.getValueAsInt(k);
            len = this.getLengthAsInt(k);
            for (int v = val; v <= val + len; ++v) {
                boolean wantMore = sc.accept((short)v);
                if (wantMore) continue;
                return false;
            }
            ++k;
        }
        return true;
    }

    @Override
    public boolean forEachRange(int rankOffset, ShortRangeConsumer sc) {
        int len;
        int val;
        int rank = 0;
        int k = 0;
        while (rank < rankOffset) {
            val = this.getValueAsInt(k);
            len = this.getLengthAsInt(k);
            ++k;
            int nextRank = rank + len + 1;
            if (nextRank > rankOffset) {
                int last = val + len;
                int n = nextRank - rankOffset;
                int start = last - n + 1;
                boolean wantMore = sc.accept((short)start, (short)last);
                if (wantMore) break;
                return false;
            }
            rank = nextRank;
        }
        while (k < this.nbrruns) {
            val = this.getValueAsInt(k);
            boolean wantMore = sc.accept((short)val, (short)(val + (len = this.getLengthAsInt(k))));
            if (!wantMore) {
                return false;
            }
            ++k;
        }
        return true;
    }

    @Override
    public BitmapContainer toBitmapContainer() {
        int card = 0;
        BitmapContainer answer = new BitmapContainer();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int start = this.getValueAsInt(rlepos);
            int len = this.getLengthAsInt(rlepos) + 1;
            int end = start + len;
            ContainerUtil.setBitmapRange(answer.bitmap, start, end);
            card += len;
        }
        answer.cardinality = card;
        return answer;
    }

    @Override
    public int nextValue(short fromValue) {
        int le;
        int effectiveIndex;
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, fromValue);
        int n = effectiveIndex = index >= 0 ? index : -index - 2;
        if (effectiveIndex == -1) {
            return this.first();
        }
        int startValue = this.getValueAsInt(effectiveIndex);
        int value = ContainerUtil.toIntUnsigned(fromValue);
        int offset = value - startValue;
        if (offset <= (le = this.getLengthAsInt(effectiveIndex))) {
            return value;
        }
        if (effectiveIndex + 1 < this.numberOfRuns()) {
            return this.getValueAsInt(effectiveIndex + 1);
        }
        return -1;
    }

    private void assertNonEmpty() {
        if (this.nbrruns == 0) {
            throw new NoSuchElementException("Empty " + this.getContainerName());
        }
    }

    @Override
    public int first() {
        this.assertNonEmpty();
        return ContainerUtil.toIntUnsigned(this.valueslength[0]);
    }

    @Override
    public int last() {
        this.assertNonEmpty();
        int index = this.numberOfRuns() - 1;
        int start = this.getValueAsInt(index);
        int length = this.getLengthAsInt(index);
        return start + length;
    }

    @Override
    public boolean subsetOf(ArrayContainer c) {
        if (this.isEmpty()) {
            return true;
        }
        if (c.isEmpty()) {
            return false;
        }
        if (this.first() < c.first() || this.last() > c.last()) {
            return false;
        }
        int ci = 0;
        for (int i = 0; i < this.nbrruns; ++i) {
            int ival = this.getValueAsInt(i);
            int ilen = this.getLengthAsInt(i);
            for (int j = ival; j <= ival + ilen; ++j) {
                if (ci >= c.getCardinality()) {
                    return false;
                }
                int s = ContainerUtil.unsignedBinarySearch(c.content, ci, c.cardinality, ContainerUtil.lowbits(j));
                if (s < 0) {
                    return false;
                }
                ci = s + 1;
            }
        }
        return true;
    }

    @Override
    public boolean subsetOf(BitmapContainer c) {
        if (this.isEmpty()) {
            return true;
        }
        if (c.isEmpty()) {
            return false;
        }
        if (this.first() < c.first() || this.last() > c.last()) {
            return false;
        }
        for (int i = 0; i < this.nbrruns; ++i) {
            int ival = this.getValueAsInt(i);
            int ilen = this.getLengthAsInt(i);
            for (int j = ival; j <= ival + ilen; ++j) {
                if (c.contains(ContainerUtil.lowbits(j))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean subsetOf(RunContainer c) {
        if (this.isEmpty()) {
            return true;
        }
        if (c.isEmpty()) {
            return false;
        }
        if (this.first() < c.first() || this.last() > c.last()) {
            return false;
        }
        int ci = 0;
        for (int i = 0; i < this.nbrruns; ++i) {
            int ival = this.getValueAsInt(i);
            int ilen = this.getLengthAsInt(i);
            for (int j = ival; j <= ival + ilen; ++j) {
                if (ci >= c.nbrruns) {
                    return false;
                }
                int s = c.searchFrom(ContainerUtil.lowbits(j), ci);
                if (s < 0) {
                    return false;
                }
                ci = s;
            }
        }
        return true;
    }

    @Override
    public boolean overlapsRange(int rangeStart, int rangeEnd) {
        if (this.isEmpty() || rangeEnd <= this.first() || rangeStart > this.last()) {
            return false;
        }
        int i = this.searchFrom(ContainerUtil.lowbits(rangeStart), 0);
        if (i >= 0) {
            return true;
        }
        int last = rangeEnd - 1;
        int j = this.searchFrom(ContainerUtil.lowbits(last), i ^= 0xFFFFFFFF);
        if (j >= 0) {
            return true;
        }
        return i != (j ^= 0xFFFFFFFF);
    }

    @Override
    public boolean overlaps(ArrayContainer c) {
        return this.getCardinality() < c.getCardinality() ? ContainerUtil.overlaps(this, c) : ContainerUtil.overlaps(c, this);
    }

    @Override
    public boolean overlaps(BitmapContainer c) {
        for (int i = 0; i < this.nbrruns; ++i) {
            int ival = this.getValueAsInt(i);
            int ilen = this.getLengthAsInt(i);
            for (int j = ival; j <= ival + ilen; ++j) {
                if (!c.contains(ContainerUtil.lowbits(j))) continue;
                return true;
            }
        }
        return false;
    }

    static boolean overlaps(RunContainer c1, RunContainer c2) {
        int c2i = 0;
        for (int c1i = 0; c1i < c1.nbrruns; ++c1i) {
            if (c2i >= c2.nbrruns) {
                return false;
            }
            int value = ContainerUtil.toIntUnsigned(c1.getValue(c1i));
            int len = ContainerUtil.toIntUnsigned(c1.getLength(c1i));
            for (int j = value; j <= value + len; ++j) {
                int s = c2.searchFrom(ContainerUtil.lowbits(j), c2i);
                if (s >= 0) {
                    return true;
                }
                c2i = -(s + 1);
            }
        }
        return false;
    }

    @Override
    public boolean overlaps(RunContainer c) {
        return this.getCardinality() < c.getCardinality() ? RunContainer.overlaps(this, c) : RunContainer.overlaps(c, this);
    }

    @Override
    public void setCopyOnWrite() {
        this.shared = true;
    }

    private RunContainer deepcopyIfShared() {
        return this.shared ? this.deepCopy() : this;
    }

    private RunContainer deepCopyIfNotShared() {
        return this.shared ? this : this.deepCopy();
    }

    @Override
    public int bytesAllocated() {
        return 2 * this.valueslength.length;
    }

    @Override
    public int bytesUsed() {
        return 4 * this.nbrruns;
    }

    @Override
    public Container toLargeContainer() {
        return this;
    }

    @Override
    public void validate() {
        int prev = -2;
        int computedCard = 0;
        for (int i = 0; i < this.nbrruns; ++i) {
            int val = this.getValueAsInt(i);
            int len = this.getLengthAsInt(i);
            computedCard += len + 1;
            if (val - 1 <= prev || val + len > 65535) {
                throw new IllegalStateException("i=" + i + ", prev=" + prev + ", val=" + val + ", len=" + len);
            }
            prev = val + len;
        }
        int readCard = this.getCardinality();
        if (computedCard != readCard) {
            throw new IllegalStateException("computedCard=" + computedCard + ", readCard=" + readCard);
        }
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    static class ForwardShortIterator
    implements ShortIterator {
        protected int pos;
        protected int le = 0;
        protected int maxlength;
        protected int base;
        protected RunContainer parent;

        ForwardShortIterator(RunContainer p) {
            this.wrap(p);
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.parent.nbrruns;
        }

        @Override
        public short next() {
            return ContainerUtil.lowbits(this.nextAsInt());
        }

        @Override
        public int nextAsInt() {
            int ans = this.base + this.le;
            ++this.le;
            if (this.le > this.maxlength) {
                ++this.pos;
                this.le = 0;
                if (this.pos < this.parent.nbrruns) {
                    this.maxlength = this.parent.getLengthAsInt(this.pos);
                    this.base = this.parent.getValueAsInt(this.pos);
                }
            }
            return ans;
        }

        void wrap(RunContainer p) {
            this.parent = p;
            this.pos = 0;
            this.le = 0;
            if (this.pos < this.parent.nbrruns) {
                this.maxlength = this.parent.getLengthAsInt(this.pos);
                this.base = this.parent.getValueAsInt(this.pos);
            }
        }
    }

    static final class ReverseShortIterator
    implements ShortAdvanceIterator {
        private int nextRange;
        private int curr = -1;
        private int rangeStart = -1;
        private RunContainer parent;

        private int runStart(int i) {
            return this.parent.getValueAsInt(i);
        }

        private int runLast(int i) {
            return this.runLast(this.runStart(i), i);
        }

        private int runLast(int runStart, int i) {
            return runStart + this.parent.getLengthAsInt(i);
        }

        ReverseShortIterator(RunContainer p) {
            this.wrap(p);
        }

        @Override
        public boolean hasNext() {
            return this.curr > this.rangeStart || this.nextRange >= 0;
        }

        @Override
        public short next() {
            return (short)this.nextAsInt();
        }

        @Override
        public int nextAsInt() {
            if (--this.curr < this.rangeStart && this.nextRange >= 0) {
                this.updateFromNextRange();
                --this.nextRange;
            }
            return this.curr;
        }

        @Override
        public short curr() {
            return (short)this.currAsInt();
        }

        @Override
        public int currAsInt() {
            return this.curr;
        }

        @Override
        public boolean advance(int v) {
            if (this.curr < 0) {
                if (this.nextRange == -1) {
                    return false;
                }
                this.next();
            }
            if (this.curr <= v) {
                return true;
            }
            if (this.rangeStart <= v) {
                this.curr = Math.max(this.rangeStart, v);
                return true;
            }
            if (this.nextRange < 0) {
                return false;
            }
            int left = 0;
            int runStartLeft = this.runStart(0);
            int runLastLeft = this.runLast(runStartLeft, 0);
            if (v <= runLastLeft) {
                this.nextRange = -1;
                if (v <= runStartLeft) {
                    this.curr = this.rangeStart = runStartLeft;
                    return v == runStartLeft;
                }
                this.curr = Math.min(v, runLastLeft);
                this.rangeStart = runStartLeft;
                return true;
            }
            int right = this.nextRange;
            int runStartRight = this.runStart(right);
            if (runStartRight <= v) {
                this.rangeStart = runStartRight;
                this.curr = Math.min(v, this.runLast(runStartRight, this.nextRange));
                --this.nextRange;
                return true;
            }
            while (true) {
                this.nextRange = (left + right) / 2;
                int runStartPos = this.runStart(this.nextRange);
                if (v < runStartPos) {
                    right = this.nextRange;
                    continue;
                }
                runStartLeft = runStartPos;
                runLastLeft = this.runLast(runStartPos, this.nextRange);
                if (left == this.nextRange) {
                    this.curr = runLastLeft;
                    this.rangeStart = runStartLeft;
                    --this.nextRange;
                    return true;
                }
                if (v <= runLastLeft) {
                    this.curr = Math.min(v, runLastLeft);
                    this.rangeStart = runStartPos;
                    --this.nextRange;
                    return true;
                }
                left = this.nextRange;
            }
        }

        private void updateFromNextRange() {
            this.rangeStart = this.runStart(this.nextRange);
            this.curr = this.runLast(this.rangeStart, this.nextRange);
        }

        void wrap(RunContainer p) {
            this.parent = p;
            this.nextRange = this.parent.nbrruns - 1;
        }
    }
}

