/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp.container;

import io.deephaven.engine.rowset.impl.rsp.container.ArrayContainer;
import io.deephaven.engine.rowset.impl.rsp.container.BitmapContainer;
import io.deephaven.engine.rowset.impl.rsp.container.Container;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerShortBatchIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerUtil;
import io.deephaven.engine.rowset.impl.rsp.container.ImmutableContainer;
import io.deephaven.engine.rowset.impl.rsp.container.MutableInteger;
import io.deephaven.engine.rowset.impl.rsp.container.PositionHint;
import io.deephaven.engine.rowset.impl.rsp.container.RangeConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.RangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.RunContainer;
import io.deephaven.engine.rowset.impl.rsp.container.SearchRangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortAdvanceIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.ShortIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortRangeConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.SingletonContainer;
import io.deephaven.engine.rowset.impl.rsp.container.TwoValuesContainer;

public final class SingleRangeContainer
extends ImmutableContainer {
    private final short rangeFirstValue;
    private final short rangeLastValue;

    public SingleRangeContainer(int begin, int end) {
        if (DEBUG && (end <= begin || begin < 0 || end > 65536)) {
            throw new IllegalArgumentException("begin=" + begin + ", end=" + end);
        }
        this.rangeFirstValue = ContainerUtil.lowbits(begin);
        this.rangeLastValue = ContainerUtil.lowbits(end - 1);
    }

    private int begin() {
        return this.first();
    }

    private int end() {
        return this.last() + 1;
    }

    @Override
    public Container add(int rangeBegin, int rangeEnd) {
        boolean maxEndIsUs;
        if (rangeEnd <= rangeBegin) {
            return this;
        }
        int begin = this.begin();
        int end = this.end();
        boolean minBeginIsUs = begin <= rangeBegin;
        boolean bl = maxEndIsUs = rangeEnd <= end;
        if (minBeginIsUs && maxEndIsUs) {
            return this;
        }
        if (rangeEnd < begin) {
            return Container.twoRanges(rangeBegin, rangeEnd, begin, end);
        }
        if (end < rangeBegin) {
            return Container.twoRanges(begin, end, rangeBegin, rangeEnd);
        }
        return new SingleRangeContainer(minBeginIsUs ? begin : rangeBegin, maxEndIsUs ? end : rangeEnd);
    }

    @Override
    Container set(short x, PositionHint positionHint) {
        return this.setImpl(x, positionHint);
    }

    @Override
    public Container set(short x) {
        return this.setImpl(x, null);
    }

    private Container setImpl(short x, PositionHint positionHint) {
        int v = ContainerUtil.toIntUnsigned(x);
        int begin = this.begin();
        int end = this.end();
        if (v < begin) {
            if (v + 1 == begin) {
                PositionHint.resetIfNotNull(positionHint);
                return new SingleRangeContainer(v, end);
            }
            MutableInteger.setIfNotNull(positionHint, 0);
            return new RunContainer(v, v + 1, begin, end);
        }
        if (v < end) {
            return this;
        }
        if (end == v) {
            PositionHint.resetIfNotNull(positionHint);
            return new SingleRangeContainer(begin, v + 1);
        }
        MutableInteger.setIfNotNull(positionHint, 1);
        return new RunContainer(begin, end, v, v + 1);
    }

    private Container andImpl(Container x) {
        return x.andRange(this.begin(), this.end());
    }

    @Override
    public Container and(ArrayContainer x) {
        return this.andImpl(x);
    }

    @Override
    public Container and(BitmapContainer x) {
        return this.andImpl(x);
    }

    @Override
    public Container and(RunContainer x) {
        return this.andImpl(x);
    }

    @Override
    public Container andRange(int rangeBegin, int rangeEnd) {
        boolean maxEndIsThem;
        int begin = this.begin();
        int end = this.end();
        if (rangeEnd <= begin || end <= rangeBegin) {
            return Container.empty();
        }
        boolean minBeginIsThem = rangeBegin <= begin;
        boolean bl = maxEndIsThem = end <= rangeEnd;
        if (minBeginIsThem && maxEndIsThem) {
            return this;
        }
        return new SingleRangeContainer(minBeginIsThem ? begin : rangeBegin, maxEndIsThem ? end : rangeEnd);
    }

    private Container andNotImpl(Container x) {
        int begin = this.begin();
        int end = this.end();
        return x.andRange(begin, end).inot(begin, end);
    }

    @Override
    public Container andNot(ArrayContainer x) {
        return this.andNotImpl(x);
    }

    @Override
    public Container andNot(BitmapContainer x) {
        return this.andNotImpl(x);
    }

    @Override
    public Container andNot(RunContainer x) {
        return this.andNotImpl(x);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isAllOnes() {
        return this.rangeFirstValue == 0 && this.rangeLastValue == -1;
    }

    @Override
    public boolean contains(short x) {
        int v = ContainerUtil.toIntUnsigned(x);
        return this.begin() <= v && v < this.end();
    }

    @Override
    public boolean contains(int rangeStart, int rangeEnd) {
        return this.begin() <= rangeStart && rangeEnd <= this.end();
    }

    private boolean containsImpl(Container c) {
        return c.isEmpty() || this.begin() <= c.first() && c.last() < this.end();
    }

    @Override
    protected boolean contains(RunContainer runContainer) {
        return this.containsImpl(runContainer);
    }

    @Override
    protected boolean contains(ArrayContainer arrayContainer) {
        return this.containsImpl(arrayContainer);
    }

    @Override
    protected boolean contains(BitmapContainer bitmapContainer) {
        return this.containsImpl(bitmapContainer);
    }

    @Override
    public Container iflip(short x) {
        int v = ContainerUtil.toIntUnsigned(x);
        int begin = this.begin();
        int end = this.end();
        if (v <= begin) {
            if (v == begin) {
                int card = end - begin;
                if (card == 2) {
                    return new SingletonContainer(ContainerUtil.lowbits(begin + 1));
                }
                if (card == 1) {
                    return Container.empty();
                }
                return new SingleRangeContainer(begin + 1, end);
            }
            if (v == begin - 1) {
                return new SingleRangeContainer(begin - 1, end);
            }
            return new RunContainer(v, v + 1, begin, end);
        }
        if (v >= end - 1) {
            if (v == end - 1) {
                int card = end - begin;
                if (card == 2) {
                    return new SingletonContainer(ContainerUtil.lowbits(begin));
                }
                if (card == 1) {
                    return Container.empty();
                }
                return new SingleRangeContainer(begin, end - 1);
            }
            if (v == end) {
                return new SingleRangeContainer(begin, end + 1);
            }
            return new RunContainer(begin, this.end(), v, v + 1);
        }
        return Container.twoRanges(begin, v, v + 1, end);
    }

    @Override
    public int getCardinality() {
        return this.end() - this.begin();
    }

    @Override
    public boolean forEach(ShortConsumer sc) {
        return this.forEach(0, sc);
    }

    @Override
    public boolean forEach(int rankOffset, ShortConsumer sc) {
        int end = this.end();
        for (int i = this.begin() + rankOffset; i < end; ++i) {
            if (sc.accept(ContainerUtil.lowbits(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachRange(int rankOffset, ShortRangeConsumer sc) {
        int rangeStart = this.begin() + rankOffset;
        if (rangeStart >= this.end()) {
            throw new IllegalStateException("rankOffset=" + rankOffset + ", cardinality=" + this.getCardinality());
        }
        return sc.accept(ContainerUtil.lowbits(rangeStart), this.rangeLastValue);
    }

    @Override
    public ShortAdvanceIterator getReverseShortIterator() {
        return new ReverseIter(this);
    }

    @Override
    public ShortIterator getShortIterator() {
        return new ForwardIter(this);
    }

    @Override
    public ContainerShortBatchIterator getShortBatchIterator(int skipFromStartCount) {
        if (DEBUG && skipFromStartCount >= this.getCardinality()) {
            throw new IllegalArgumentException("skipFromStartCount=" + skipFromStartCount + ", cardinality=" + this.getCardinality());
        }
        return new ContainerShortBatchIter(this, skipFromStartCount);
    }

    @Override
    public SearchRangeIterator getShortRangeIterator(int skipFromStartCount) {
        if (DEBUG && skipFromStartCount >= this.getCardinality()) {
            throw new IllegalArgumentException("skipFromStartCount=" + skipFromStartCount + ", cardinality=" + this.getCardinality());
        }
        return new SearchRangeIter(this, skipFromStartCount);
    }

    private Container orImpl(Container c) {
        int begin = this.begin();
        int end = this.end();
        if (c.isEmpty() || begin <= c.first() && c.last() < end) {
            return this;
        }
        return c.add(begin, end);
    }

    private Container xorImpl(Container x) {
        return x.not(this.begin(), this.end());
    }

    @Override
    public Container not(int negBegin, int negEnd) {
        int maxEnd;
        int minEnd;
        int maxBegin;
        int minBegin;
        int begin = this.begin();
        int end = this.end();
        if (end <= negBegin) {
            if (end == negBegin) {
                return new SingleRangeContainer(begin, negEnd);
            }
            return new RunContainer(begin, end, negBegin, negEnd);
        }
        if (negEnd <= begin) {
            if (negEnd == begin) {
                return new SingleRangeContainer(negBegin, end);
            }
            return new RunContainer(negBegin, negEnd, begin, end);
        }
        if (begin < negBegin) {
            minBegin = begin;
            maxBegin = negBegin;
        } else {
            minBegin = negBegin;
            maxBegin = begin;
        }
        if (end < negEnd) {
            minEnd = end;
            maxEnd = negEnd;
        } else {
            minEnd = negEnd;
            maxEnd = end;
        }
        if (minBegin == maxBegin) {
            if (minEnd == maxEnd) {
                return Container.empty();
            }
            return Container.singleRange(minEnd, maxEnd);
        }
        if (minEnd == maxEnd) {
            return Container.singleRange(minBegin, maxBegin);
        }
        return Container.twoRanges(minBegin, maxBegin, minEnd, maxEnd);
    }

    @Override
    int numberOfRuns() {
        return 1;
    }

    @Override
    public Container or(ArrayContainer x) {
        return this.orImpl(x);
    }

    @Override
    public Container or(BitmapContainer x) {
        return this.orImpl(x);
    }

    @Override
    public Container or(RunContainer x) {
        return this.orImpl(x);
    }

    @Override
    public int rank(short lowbits) {
        int v = ContainerUtil.toIntUnsigned(lowbits);
        int first = this.first();
        int last = this.last();
        if (v > last) {
            return last - first + 1;
        }
        if (v < first) {
            return 0;
        }
        return 1 + v - first;
    }

    @Override
    public Container remove(int rangeFirst, int rangeEnd) {
        int rangeLast = rangeEnd - 1;
        int first = this.first();
        int last = this.last();
        if (rangeLast < first || last < rangeFirst) {
            return this;
        }
        if (rangeFirst <= first) {
            if (last <= rangeLast) {
                return Container.empty();
            }
            if (last - 1 == rangeLast) {
                return Container.singleton(ContainerUtil.lowbits(last));
            }
            return new SingleRangeContainer(rangeLast + 1, last + 1);
        }
        if (last <= rangeLast) {
            if (first + 1 == rangeFirst) {
                return Container.singleton(ContainerUtil.lowbits(first));
            }
            return new SingleRangeContainer(first, rangeFirst);
        }
        if (first + 1 == rangeFirst && rangeLast + 1 == last) {
            return new TwoValuesContainer(ContainerUtil.lowbits(first), ContainerUtil.lowbits(last));
        }
        return new RunContainer(first, rangeFirst, rangeLast + 1, last + 1);
    }

    @Override
    public Container unset(short x) {
        int v = ContainerUtil.toIntUnsigned(x);
        int begin = this.begin();
        int end = this.end();
        if (v < begin || v >= end) {
            return this;
        }
        if (v == begin) {
            if (end - begin == 1) {
                return Container.empty();
            }
            if (end - begin == 2) {
                return new SingletonContainer(ContainerUtil.lowbits(begin + 1));
            }
            return new SingleRangeContainer(begin + 1, end);
        }
        if (v + 1 == end) {
            if (end - begin == 2) {
                return new SingletonContainer(ContainerUtil.lowbits(begin));
            }
            return new SingleRangeContainer(begin, end - 1);
        }
        return Container.twoRanges(begin, v, v + 1, end);
    }

    @Override
    Container unset(short x, PositionHint positionHint) {
        positionHint.reset();
        return this.unset(x);
    }

    @Override
    public Container runOptimize() {
        return this;
    }

    @Override
    public short select(int j) {
        if (j < 0 || j >= this.getCardinality()) {
            throw new IllegalArgumentException("j=" + j);
        }
        return ContainerUtil.lowbits(this.begin() + j);
    }

    @Override
    public Container select(int startRank, int endRank) {
        if (startRank == 0 && endRank >= this.getCardinality()) {
            return this;
        }
        int begin = this.begin();
        return Container.singleRange(begin + startRank, begin + endRank);
    }

    @Override
    public int find(short x) {
        int begin;
        int v = ContainerUtil.toIntUnsigned(x);
        if (v < (begin = this.begin())) {
            return -1;
        }
        int end = this.end();
        if (v >= end) {
            return ~this.getCardinality();
        }
        return v - begin;
    }

    @Override
    public void selectRanges(RangeConsumer outValues, RangeIterator inPositions) {
        int begin = this.begin();
        while (inPositions.hasNext()) {
            inPositions.next();
            int pBegin = inPositions.start();
            int pEnd = inPositions.end();
            outValues.accept(begin + pBegin, begin + pEnd);
        }
    }

    @Override
    public boolean findRanges(RangeConsumer outPositions, RangeIterator inValues, int maxPos) {
        int begin = this.begin();
        int end = this.end();
        while (inValues.hasNext()) {
            inValues.next();
            int vBegin = inValues.start();
            if (vBegin < begin) {
                throw new IllegalStateException("begin=" + begin + ", vBegin=" + vBegin);
            }
            int vEnd = inValues.end();
            if (vEnd > end) {
                throw new IllegalStateException("end=" + end + ", vEnd=" + vEnd);
            }
            int rBegin = vBegin - begin;
            if (rBegin > maxPos) {
                return true;
            }
            int rEnd = vEnd - begin;
            int rLast = rEnd - 1;
            if (rLast >= maxPos) {
                outPositions.accept(rBegin, maxPos + 1);
                return true;
            }
            outPositions.accept(rBegin, rEnd);
        }
        return false;
    }

    @Override
    public void trim() {
    }

    @Override
    public Container xor(ArrayContainer x) {
        return this.xorImpl(x);
    }

    @Override
    public Container xor(BitmapContainer x) {
        return this.xorImpl(x);
    }

    @Override
    public Container xor(RunContainer x) {
        return this.xorImpl(x);
    }

    @Override
    public BitmapContainer toBitmapContainer() {
        return BitmapContainer.singleRange(this.begin(), this.end());
    }

    @Override
    public int nextValue(short fromValue) {
        int begin;
        int v = ContainerUtil.toIntUnsigned(fromValue);
        if (v < (begin = this.begin())) {
            return begin;
        }
        int end = this.end();
        if (v >= end) {
            return -1;
        }
        return v;
    }

    @Override
    public int first() {
        return ContainerUtil.toIntUnsigned(this.rangeFirstValue);
    }

    @Override
    public int last() {
        return ContainerUtil.toIntUnsigned(this.rangeLastValue);
    }

    private boolean subsetOfImpl(Container c) {
        return c.contains(this.begin(), this.end());
    }

    @Override
    public boolean subsetOf(ArrayContainer x) {
        return this.subsetOfImpl(x);
    }

    @Override
    public boolean subsetOf(BitmapContainer x) {
        return this.subsetOfImpl(x);
    }

    @Override
    public boolean subsetOf(RunContainer x) {
        return this.subsetOfImpl(x);
    }

    private boolean overlapsImpl(Container c) {
        return c.overlapsRange(this.begin(), this.end());
    }

    @Override
    public boolean overlaps(ArrayContainer x) {
        return this.overlapsImpl(x);
    }

    @Override
    public boolean overlaps(BitmapContainer x) {
        return this.overlapsImpl(x);
    }

    @Override
    public boolean overlaps(RunContainer x) {
        return this.overlapsImpl(x);
    }

    @Override
    public boolean overlapsRange(int rangeStart, int rangeEnd) {
        return this.end() > rangeStart && rangeEnd > this.begin();
    }

    @Override
    public void setCopyOnWrite() {
    }

    @Override
    public int bytesAllocated() {
        return 4;
    }

    @Override
    public int bytesUsed() {
        return 4;
    }

    @Override
    public String toString() {
        return "{ " + this.first() + "-" + this.last() + " }";
    }

    @Override
    public Container toLargeContainer() {
        return new RunContainer(this.begin(), this.end());
    }

    @Override
    public void validate() {
        int first = this.first();
        int last = this.last();
        if (last < first || first < 0 || last > 65535) {
            throw new IllegalStateException("first=" + first + ", last=" + last);
        }
    }

    private static class SearchRangeIter
    implements SearchRangeIterator {
        private int start;
        private final int end;
        private boolean hasNext;

        public SearchRangeIter(SingleRangeContainer sr, int skip) {
            this.start = sr.first() + skip;
            this.end = sr.last() + 1;
            this.hasNext = true;
        }

        @Override
        public boolean advance(int v) {
            this.hasNext = false;
            if (this.end <= v) {
                return false;
            }
            this.start = Math.max(v, this.start);
            return true;
        }

        @Override
        public boolean search(ContainerUtil.TargetComparator comp) {
            this.hasNext = false;
            int c = comp.directionFrom(this.end - 1);
            if (c >= 0) {
                this.start = this.end - 1;
                return true;
            }
            if (this.end - this.start == 1) {
                return false;
            }
            c = comp.directionFrom(this.start);
            if (c <= 0) {
                return c == 0;
            }
            if (this.end - this.start == 2) {
                return true;
            }
            int v = ContainerUtil.rangeSearch(this.start + 1, this.end - 1, comp);
            if (v >= 0) {
                this.start = v;
            }
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        @Override
        public void next() {
            this.hasNext = false;
        }
    }

    private static class ContainerShortBatchIter
    implements ContainerShortBatchIterator {
        private int curr;
        private final int last;

        public ContainerShortBatchIter(SingleRangeContainer sr, int skip) {
            this.curr = sr.first() + skip - 1;
            this.last = sr.last();
        }

        @Override
        public int next(short[] buffer, int offset, int maxCount) {
            int p = 0;
            while (p < maxCount && this.curr < this.last) {
                buffer[offset + p++] = ContainerUtil.lowbits(++this.curr);
            }
            return p;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.last;
        }

        @Override
        public boolean forEach(ShortConsumer sc) {
            while (this.curr < this.last) {
                if (sc.accept(ContainerUtil.lowbits(++this.curr))) continue;
                return false;
            }
            return true;
        }
    }

    private static final class ReverseIter
    extends IterBase
    implements ShortAdvanceIterator {
        public ReverseIter(SingleRangeContainer s) {
            super(s.end(), s.begin());
        }

        @Override
        protected void nextPos() {
            --this.curr;
        }

        @Override
        public boolean advance(int v) {
            if (v >= this.curr) {
                return true;
            }
            if (v < this.last) {
                this.curr = this.last;
                return false;
            }
            this.curr = v;
            return true;
        }
    }

    private static final class ForwardIter
    extends IterBase
    implements ShortAdvanceIterator {
        public ForwardIter(SingleRangeContainer s) {
            super(s.begin() - 1, s.end() - 1);
        }

        @Override
        protected void nextPos() {
            ++this.curr;
        }

        @Override
        public boolean advance(int v) {
            if (v <= this.curr) {
                return true;
            }
            if (v > this.last) {
                this.curr = this.last;
                return false;
            }
            this.curr = v;
            return true;
        }
    }

    private static abstract class IterBase {
        protected int curr;
        protected final int last;

        public IterBase(int curr, int last) {
            this.curr = curr;
            this.last = last;
        }

        public boolean hasNext() {
            return this.curr != this.last;
        }

        protected abstract void nextPos();

        public short curr() {
            return ContainerUtil.lowbits(this.curr);
        }

        public int currAsInt() {
            return this.curr;
        }

        public short next() {
            this.nextPos();
            return this.curr();
        }

        public int nextAsInt() {
            this.nextPos();
            return this.currAsInt();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

