/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp.container;

import io.deephaven.engine.rowset.impl.rsp.container.ArrayContainer;
import io.deephaven.engine.rowset.impl.rsp.container.BitmapContainer;
import io.deephaven.engine.rowset.impl.rsp.container.Container;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerShortBatchIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerUtil;
import io.deephaven.engine.rowset.impl.rsp.container.ImmutableContainer;
import io.deephaven.engine.rowset.impl.rsp.container.PositionHint;
import io.deephaven.engine.rowset.impl.rsp.container.RangeConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.RangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.RunContainer;
import io.deephaven.engine.rowset.impl.rsp.container.SearchRangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortAdvanceIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.ShortIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortRangeConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.SingleRangeContainer;
import io.deephaven.engine.rowset.impl.rsp.container.TwoValuesContainer;

public final class SingletonContainer
extends ImmutableContainer {
    final short value;

    public int intValue() {
        return ContainerUtil.toIntUnsigned(this.value);
    }

    public SingletonContainer(short value) {
        this.value = value;
    }

    @Override
    public Container add(int begin, int end) {
        int card = end - begin;
        if (card <= 0) {
            return this;
        }
        if (card == 1) {
            return this.set(ContainerUtil.lowbits(begin));
        }
        int intValue = this.intValue();
        if (intValue < begin) {
            if (intValue + 1 == begin) {
                return new SingleRangeContainer(intValue, end);
            }
            return new RunContainer(intValue, intValue + 1, begin, end);
        }
        if (begin == intValue) {
            return new SingleRangeContainer(begin, end);
        }
        if (intValue < end) {
            return new SingleRangeContainer(begin, end);
        }
        if (end == intValue) {
            return new SingleRangeContainer(begin, end + 1);
        }
        return new RunContainer(begin, end, intValue, intValue + 1);
    }

    @Override
    Container set(short x, PositionHint positionHint) {
        positionHint.reset();
        return this.set(x);
    }

    @Override
    public Container set(short x) {
        int v;
        int intValue = this.intValue();
        if (intValue < (v = ContainerUtil.toIntUnsigned(x))) {
            if (intValue + 1 == v) {
                return new SingleRangeContainer(intValue, v + 1);
            }
            return new TwoValuesContainer(this.value, x);
        }
        if (v == intValue) {
            return this;
        }
        if (v + 1 == intValue) {
            return new SingleRangeContainer(v, intValue + 1);
        }
        return new TwoValuesContainer(x, this.value);
    }

    private Container andImpl(Container c) {
        return c.contains(this.value) ? this : Container.empty();
    }

    @Override
    public Container and(ArrayContainer x) {
        return this.andImpl(x);
    }

    @Override
    public Container and(BitmapContainer x) {
        return this.andImpl(x);
    }

    @Override
    public Container and(RunContainer x) {
        return this.andImpl(x);
    }

    @Override
    public Container andRange(int start, int end) {
        int v = this.intValue();
        if (v < start || end <= v) {
            return Container.empty();
        }
        return this;
    }

    private Container andNotImpl(Container c) {
        return c.contains(this.value) ? Container.empty() : this;
    }

    @Override
    public Container andNot(ArrayContainer x) {
        return this.andNotImpl(x);
    }

    @Override
    public Container andNot(BitmapContainer x) {
        return this.andNotImpl(x);
    }

    @Override
    public Container andNot(RunContainer x) {
        return this.andNotImpl(x);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isAllOnes() {
        return false;
    }

    @Override
    public boolean contains(short x) {
        return this.value == x;
    }

    @Override
    public boolean contains(int rangeStart, int rangeEnd) {
        return rangeEnd <= rangeStart || rangeStart == this.intValue() && rangeEnd - rangeStart == 1;
    }

    @Override
    protected boolean contains(RunContainer runContainer) {
        return runContainer.nbrruns == 0 || runContainer.nbrruns == 1 && runContainer.getValue(0) == this.value && runContainer.getLength(0) == 0;
    }

    @Override
    protected boolean contains(ArrayContainer arrayContainer) {
        return arrayContainer.cardinality == 0 || arrayContainer.cardinality == 1 && arrayContainer.content[0] == this.value;
    }

    @Override
    protected boolean contains(BitmapContainer bitmapContainer) {
        return bitmapContainer.cardinality == 0 || bitmapContainer.cardinality == 1 && bitmapContainer.contains(this.value);
    }

    @Override
    public Container iflip(short x) {
        int intValue;
        if (x == this.value) {
            return Container.empty();
        }
        int v = ContainerUtil.toIntUnsigned(x);
        if (v < (intValue = this.intValue())) {
            if (v + 1 == intValue) {
                return new SingleRangeContainer(v, intValue + 1);
            }
            return new TwoValuesContainer(x, this.value);
        }
        if (intValue + 1 == v) {
            return new SingleRangeContainer(intValue, v + 1);
        }
        return new TwoValuesContainer(this.value, x);
    }

    @Override
    public int getCardinality() {
        return 1;
    }

    @Override
    public boolean forEach(ShortConsumer sc) {
        return this.forEach(0, sc);
    }

    @Override
    public boolean forEach(int rankOffset, ShortConsumer sc) {
        if (rankOffset > 0) {
            return true;
        }
        return sc.accept(this.value);
    }

    @Override
    public boolean forEachRange(int rankOffset, ShortRangeConsumer sc) {
        if (rankOffset > 0) {
            return true;
        }
        return sc.accept(this.value, this.value);
    }

    @Override
    public ShortAdvanceIterator getReverseShortIterator() {
        return new ReverseIter(this.value);
    }

    @Override
    public ShortIterator getShortIterator() {
        return new ForwardIter(this.value);
    }

    @Override
    public ContainerShortBatchIterator getShortBatchIterator(int skipFromStartCount) {
        if (skipFromStartCount > 0) {
            throw new IllegalArgumentException("skipFromStartCount=" + skipFromStartCount);
        }
        return new ContainerShortBatchIter(this);
    }

    @Override
    public SearchRangeIterator getShortRangeIterator(int skipFromStartCount) {
        if (skipFromStartCount > 0) {
            throw new IllegalArgumentException("skipFromStartCount=" + skipFromStartCount);
        }
        return new SearchRangeIter(this.value);
    }

    private Container orImpl(Container x) {
        return x.cowRef().iset(this.value);
    }

    private Container xorImpl(Container x) {
        return x.cowRef().iflip(this.value);
    }

    @Override
    public Container not(int rangeStart, int rangeEnd) {
        if (rangeEnd <= rangeStart) {
            return this;
        }
        int intValue = this.intValue();
        if (rangeEnd <= intValue) {
            if (intValue == rangeEnd) {
                return Container.singleRange(rangeStart, intValue + 1);
            }
            return Container.twoRanges(rangeStart, rangeEnd, intValue, intValue + 1);
        }
        if (intValue < rangeStart) {
            if (intValue == rangeStart - 1) {
                return new SingleRangeContainer(intValue, rangeEnd);
            }
            return Container.twoRanges(intValue, intValue + 1, rangeStart, rangeEnd);
        }
        if (rangeStart == intValue) {
            if (intValue + 1 == rangeEnd) {
                return Container.empty();
            }
            return Container.singleRange(intValue + 1, rangeEnd);
        }
        if (rangeEnd - 1 == intValue) {
            return Container.singleRange(rangeStart, rangeEnd - 1);
        }
        return Container.twoRanges(rangeStart, intValue, intValue + 1, rangeEnd);
    }

    @Override
    int numberOfRuns() {
        return 1;
    }

    @Override
    public Container or(ArrayContainer x) {
        return this.orImpl(x);
    }

    @Override
    public Container or(BitmapContainer x) {
        return this.orImpl(x);
    }

    @Override
    public Container or(RunContainer x) {
        return this.orImpl(x);
    }

    @Override
    public int rank(short lowbits) {
        int intValue;
        int intLowbits = ContainerUtil.toIntUnsigned(lowbits);
        if (intLowbits < (intValue = this.intValue())) {
            return 0;
        }
        return 1;
    }

    @Override
    public Container remove(int begin, int end) {
        int intValue = this.intValue();
        return begin <= intValue && intValue < end ? Container.empty() : this;
    }

    @Override
    public Container unset(short x) {
        return x == this.value ? Container.empty() : this;
    }

    @Override
    public Container unset(short x, PositionHint positionHint) {
        positionHint.reset();
        return this.unset(x);
    }

    @Override
    public Container runOptimize() {
        return this;
    }

    @Override
    public short select(int j) {
        if (j != 0) {
            throw new IllegalArgumentException("j=" + j);
        }
        return this.value;
    }

    @Override
    public Container select(int startRank, int endRank) {
        if (startRank != 0 || endRank != 1) {
            throw new IllegalStateException("startRank=" + startRank + ", endRank=" + endRank);
        }
        return this;
    }

    @Override
    public int find(short x) {
        int intValue = this.intValue();
        int v = ContainerUtil.toIntUnsigned(x);
        if (v < intValue) {
            return -1;
        }
        if (v == intValue) {
            return 0;
        }
        return -2;
    }

    @Override
    public void selectRanges(RangeConsumer outValues, RangeIterator inPositions) {
        if (!inPositions.hasNext()) {
            return;
        }
        inPositions.next();
        int start = inPositions.start();
        int end = inPositions.end();
        if (start != 0 || end != 1) {
            throw new IllegalArgumentException("start=" + start + ", end=" + end);
        }
        int intValue = this.intValue();
        outValues.accept(intValue, intValue + 1);
        if (inPositions.hasNext()) {
            throw new IllegalArgumentException("hasNext=true");
        }
    }

    @Override
    public boolean findRanges(RangeConsumer outPositions, RangeIterator inValues, int maxPos) {
        if (maxPos < 0 || !inValues.hasNext()) {
            return false;
        }
        inValues.next();
        int start = inValues.start();
        int end = inValues.end();
        int intValue = this.intValue();
        if (start == intValue && end == intValue + 1) {
            outPositions.accept(0, 1);
            return maxPos == 0;
        }
        throw new IllegalArgumentException("start=" + start + ", end=" + end);
    }

    @Override
    public void trim() {
    }

    @Override
    public Container xor(ArrayContainer x) {
        return this.xorImpl(x);
    }

    @Override
    public Container xor(BitmapContainer x) {
        return this.xorImpl(x);
    }

    @Override
    public Container xor(RunContainer x) {
        return this.xorImpl(x);
    }

    @Override
    public BitmapContainer toBitmapContainer() {
        BitmapContainer bc = new BitmapContainer();
        bc.bitmapSet(this.value);
        bc.cardinality = 1;
        return bc;
    }

    @Override
    public int nextValue(short fromValue) {
        int intValue = this.intValue();
        int intFromValue = ContainerUtil.toIntUnsigned(fromValue);
        if (intFromValue <= intValue) {
            return intValue;
        }
        return -1;
    }

    @Override
    public int first() {
        return this.intValue();
    }

    @Override
    public int last() {
        return this.intValue();
    }

    @Override
    public boolean subsetOf(ArrayContainer x) {
        return x.contains(this.value);
    }

    @Override
    public boolean subsetOf(BitmapContainer x) {
        return x.contains(this.value);
    }

    @Override
    public boolean subsetOf(RunContainer x) {
        return x.contains(this.value);
    }

    @Override
    public boolean overlaps(ArrayContainer x) {
        return x.contains(this.value);
    }

    @Override
    public boolean overlaps(BitmapContainer x) {
        return x.contains(this.value);
    }

    @Override
    public boolean overlaps(RunContainer x) {
        return x.contains(this.value);
    }

    @Override
    public boolean overlapsRange(int start, int end) {
        int intValue = this.intValue();
        return start <= intValue && intValue < end;
    }

    @Override
    public void setCopyOnWrite() {
    }

    @Override
    public int bytesAllocated() {
        return 2;
    }

    @Override
    public int bytesUsed() {
        return 2;
    }

    @Override
    public String toString() {
        return "{ " + this.intValue() + " }";
    }

    @Override
    public Container toLargeContainer() {
        return new ArrayContainer(new short[]{this.value});
    }

    @Override
    public void validate() {
    }

    public static class SearchRangeIter
    implements SearchRangeIterator {
        private final int intValue;
        private boolean hasNext;

        public SearchRangeIter(short v) {
            this.intValue = ContainerUtil.toIntUnsigned(v);
            this.hasNext = true;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public int start() {
            return this.intValue;
        }

        @Override
        public int end() {
            return this.intValue + 1;
        }

        @Override
        public void next() {
            this.hasNext = false;
        }

        @Override
        public boolean advance(int v) {
            this.hasNext = false;
            return v <= this.intValue;
        }

        @Override
        public boolean search(ContainerUtil.TargetComparator comp) {
            this.hasNext = false;
            return comp.directionFrom(this.intValue) >= 0;
        }
    }

    private static class ContainerShortBatchIter
    implements ContainerShortBatchIterator {
        private final short value;
        private boolean hasNext;

        public ContainerShortBatchIter(SingletonContainer sc) {
            this.value = sc.value;
            this.hasNext = true;
        }

        @Override
        public int next(short[] buffer, int offset, int maxCount) {
            if (!this.hasNext || maxCount < 1) {
                return 0;
            }
            buffer[offset] = this.value;
            this.hasNext = false;
            return 1;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public boolean forEach(ShortConsumer sc) {
            if (!this.hasNext) {
                return true;
            }
            this.hasNext = false;
            return sc.accept(this.value);
        }
    }

    public static final class ReverseIter
    extends Iter
    implements ShortAdvanceIterator {
        public ReverseIter(short value) {
            super(value);
        }

        @Override
        public boolean advance(int v) {
            this.hasNext = false;
            return this.intValue() <= v;
        }
    }

    private static final class ForwardIter
    extends Iter
    implements ShortAdvanceIterator {
        public ForwardIter(short value) {
            super(value);
        }

        @Override
        public boolean advance(int v) {
            this.hasNext = false;
            return v <= this.intValue();
        }
    }

    private static class Iter {
        private final short value;
        protected boolean hasNext;

        public Iter(short value) {
            this.value = value;
            this.hasNext = true;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public short next() {
            this.hasNext = false;
            return this.curr();
        }

        public int nextAsInt() {
            this.hasNext = false;
            return this.currAsInt();
        }

        public short curr() {
            return this.value;
        }

        public int currAsInt() {
            return this.intValue();
        }

        protected int intValue() {
            return ContainerUtil.toIntUnsigned(this.value);
        }
    }
}

