/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp.container;

import io.deephaven.engine.rowset.impl.rsp.container.ArrayContainer;
import io.deephaven.engine.rowset.impl.rsp.container.BitmapContainer;
import io.deephaven.engine.rowset.impl.rsp.container.Container;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerShortBatchIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerUtil;
import io.deephaven.engine.rowset.impl.rsp.container.ImmutableContainer;
import io.deephaven.engine.rowset.impl.rsp.container.MutableInteger;
import io.deephaven.engine.rowset.impl.rsp.container.PositionHint;
import io.deephaven.engine.rowset.impl.rsp.container.RangeConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.RangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.RunContainer;
import io.deephaven.engine.rowset.impl.rsp.container.SearchRangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortAdvanceIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.ShortIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortRangeConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.SingleRangeContainer;
import io.deephaven.engine.rowset.impl.rsp.container.SingletonContainer;

public final class TwoValuesContainer
extends ImmutableContainer {
    final short v1;
    final short v2;
    private static final ThreadLocal<int[]> intBuf = ThreadLocal.withInitial(() -> new int[6]);

    int v1AsInt() {
        return ContainerUtil.toIntUnsigned(this.v1);
    }

    int v2AsInt() {
        return ContainerUtil.toIntUnsigned(this.v2);
    }

    public TwoValuesContainer(short v1, short v2) {
        int iv1 = ContainerUtil.toIntUnsigned(v1);
        int iv2 = ContainerUtil.toIntUnsigned(v2);
        if (iv2 - iv1 < 2) {
            throw new IllegalStateException("iv1=" + iv1 + ", iv2=" + iv2);
        }
        this.v1 = v1;
        this.v2 = v2;
    }

    @Override
    public Container add(int rangeStart, int rangeEnd) {
        boolean v2Contained;
        if (rangeEnd <= rangeStart) {
            return this;
        }
        if (rangeEnd - rangeStart == 1) {
            return this.set(ContainerUtil.lowbits(rangeStart));
        }
        int iv1 = this.v1AsInt();
        int iv2 = this.v2AsInt();
        if (iv2 < rangeStart) {
            if (iv2 + 1 == rangeStart) {
                return new RunContainer(iv1, iv1 + 1, iv2, rangeEnd);
            }
            RunContainer c = new RunContainer(iv1, iv1 + 1, iv2, iv2 + 1);
            return c.iaddUnsafe(rangeStart, rangeEnd, 2);
        }
        if (rangeEnd <= iv1) {
            if (rangeEnd == iv1) {
                return new RunContainer(rangeStart, iv1 + 1, iv2, iv2 + 1);
            }
            RunContainer c = new RunContainer(rangeStart, rangeEnd, iv1, iv1 + 1);
            return c.iaddUnsafe(iv2, iv2 + 1, 2);
        }
        boolean v1Contained = rangeStart <= iv1;
        boolean bl = v2Contained = iv2 < rangeEnd;
        if (v1Contained && v2Contained) {
            return new SingleRangeContainer(rangeStart, rangeEnd);
        }
        if (v1Contained) {
            if (iv2 == rangeEnd) {
                return new SingleRangeContainer(rangeStart, iv2 + 1);
            }
            return new RunContainer(rangeStart, rangeEnd, iv2, iv2 + 1);
        }
        if (v2Contained) {
            if (iv1 + 1 == rangeStart) {
                return new SingleRangeContainer(iv1, rangeEnd);
            }
            return new RunContainer(iv1, iv1 + 1, rangeStart, rangeEnd);
        }
        if (iv1 + 1 == rangeStart) {
            if (iv2 == rangeEnd) {
                return new SingleRangeContainer(iv1, iv2 + 1);
            }
            return new RunContainer(iv1, rangeEnd, iv2, iv2 + 1);
        }
        RunContainer c = new RunContainer(iv1, iv1 + 1, rangeStart, rangeEnd);
        return c.iaddUnsafe(iv2, iv2 + 1, 2);
    }

    @Override
    Container set(short x, PositionHint positionHint) {
        return this.setImpl(x, positionHint);
    }

    @Override
    public Container set(short x) {
        return this.setImpl(x, null);
    }

    private Container setImpl(short x, PositionHint positionHint) {
        int iv1 = this.v1AsInt();
        int iv2 = this.v2AsInt();
        int v = ContainerUtil.toIntUnsigned(x);
        if (v < iv1) {
            if (v + 1 == iv1) {
                MutableInteger.setIfNotNull(positionHint, 0);
                return new RunContainer(v, iv1 + 1, iv2, iv2 + 1);
            }
            MutableInteger.setIfNotNull(positionHint, 1);
            return new ArrayContainer(x, this.v1, this.v2);
        }
        if (iv1 == v) {
            return this;
        }
        if (iv1 + 1 == v) {
            if (v + 1 == iv2) {
                PositionHint.resetIfNotNull(positionHint);
                return new SingleRangeContainer(iv1, iv2 + 1);
            }
            MutableInteger.setIfNotNull(positionHint, 0);
            return new RunContainer(iv1, iv1 + 2, iv2, iv2 + 1);
        }
        if (v < iv2) {
            if (v + 1 == iv2) {
                MutableInteger.setIfNotNull(positionHint, 1);
                return new RunContainer(iv1, iv1 + 1, v, iv2 + 1);
            }
            MutableInteger.setIfNotNull(positionHint, 2);
            return new ArrayContainer(this.v1, x, this.v2);
        }
        if (iv2 == v) {
            return this;
        }
        if (iv2 + 1 == v) {
            MutableInteger.setIfNotNull(positionHint, 1);
            return new RunContainer(iv1, iv1 + 1, iv2, v + 1);
        }
        MutableInteger.setIfNotNull(positionHint, 3);
        return new ArrayContainer(this.v1, this.v2, x);
    }

    private Container andImpl(Container c) {
        boolean containsv1 = c.contains(this.v1);
        boolean containsv2 = c.contains(this.v2);
        if (containsv1 && containsv2) {
            return this;
        }
        if (containsv1) {
            return new SingletonContainer(this.v1);
        }
        if (containsv2) {
            return new SingletonContainer(this.v2);
        }
        return Container.empty();
    }

    @Override
    public Container and(ArrayContainer x) {
        return this.andImpl(x);
    }

    @Override
    public Container and(BitmapContainer x) {
        return this.andImpl(x);
    }

    @Override
    public Container and(RunContainer x) {
        return this.andImpl(x);
    }

    private int andCardImpl(Container c) {
        int ac = 0;
        if (c.contains(this.v1)) {
            ++ac;
        }
        if (c.contains(this.v2)) {
            ++ac;
        }
        return ac;
    }

    @Override
    public Container andRange(int start, int end) {
        int iv1 = this.v1AsInt();
        int iv2 = this.v2AsInt();
        if (iv1 < start) {
            if (iv2 < start || end <= iv2) {
                return Container.empty();
            }
            return new SingletonContainer(this.v2);
        }
        if (end <= iv2) {
            if (iv1 < end) {
                return new SingletonContainer(this.v1);
            }
            return Container.empty();
        }
        return this;
    }

    private Container andNotImpl(Container c) {
        boolean containsv1 = c.contains(this.v1);
        boolean containsv2 = c.contains(this.v2);
        if (containsv1 && containsv2) {
            return Container.empty();
        }
        if (containsv1) {
            return new SingletonContainer(this.v2);
        }
        if (containsv2) {
            return new SingletonContainer(this.v1);
        }
        return this;
    }

    @Override
    public Container andNot(ArrayContainer x) {
        return this.andNotImpl(x);
    }

    @Override
    public Container andNot(BitmapContainer x) {
        return this.andNotImpl(x);
    }

    @Override
    public Container andNot(RunContainer x) {
        return this.andNotImpl(x);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isAllOnes() {
        return false;
    }

    @Override
    public boolean contains(short x) {
        return x == this.v1 || x == this.v2;
    }

    @Override
    public boolean contains(int rangeStart, int rangeEnd) {
        if (rangeEnd <= rangeStart) {
            return true;
        }
        if (rangeEnd - rangeStart == 1) {
            return this.contains(ContainerUtil.lowbits(rangeStart));
        }
        return false;
    }

    private boolean containsImpl(Container c) {
        if (c.isEmpty()) {
            return true;
        }
        int card = c.getCardinality();
        if (card > 2) {
            return false;
        }
        if (card == 2) {
            return c.first() == this.v1AsInt() && c.last() == this.v2AsInt();
        }
        return this.contains(ContainerUtil.lowbits(c.first()));
    }

    @Override
    protected boolean contains(RunContainer x) {
        return this.containsImpl(x);
    }

    @Override
    protected boolean contains(ArrayContainer x) {
        return this.containsImpl(x);
    }

    @Override
    protected boolean contains(BitmapContainer c) {
        if (c.isEmpty()) {
            return true;
        }
        int card = c.getCardinality();
        if (card > 2) {
            return false;
        }
        if (card == 2) {
            return c.contains(this.v1) && c.contains(this.v2);
        }
        return c.contains(this.v1) || c.contains(this.v2);
    }

    @Override
    public Container iflip(short x) {
        if (x == this.v1) {
            return new SingletonContainer(this.v2);
        }
        if (x == this.v2) {
            return new SingletonContainer(this.v1);
        }
        return this.set(x);
    }

    @Override
    public int getCardinality() {
        return 2;
    }

    @Override
    public boolean forEach(ShortConsumer sc) {
        return sc.accept(this.v1) && sc.accept(this.v2);
    }

    @Override
    public boolean forEach(int rankOffset, ShortConsumer sc) {
        if (rankOffset > 1) {
            return true;
        }
        if (rankOffset <= 0) {
            return sc.accept(this.v1) && sc.accept(this.v2);
        }
        return sc.accept(this.v2);
    }

    @Override
    public boolean forEachRange(int rankOffset, ShortRangeConsumer sc) {
        if (rankOffset > 1) {
            return true;
        }
        if (rankOffset <= 0) {
            return sc.accept(this.v1, this.v1) && sc.accept(this.v2, this.v2);
        }
        return sc.accept(this.v2, this.v2);
    }

    @Override
    public ShortAdvanceIterator getReverseShortIterator() {
        return new ReverseIter(this);
    }

    @Override
    public ShortIterator getShortIterator() {
        return new ForwardIter(this);
    }

    @Override
    public ContainerShortBatchIterator getShortBatchIterator(int skipFromStartCount) {
        if (DEBUG && skipFromStartCount > 1) {
            throw new IllegalArgumentException("skipFromStartCount=" + skipFromStartCount);
        }
        return new ContainerShortBatchIter(this, skipFromStartCount);
    }

    @Override
    public SearchRangeIterator getShortRangeIterator(int skipFromStartCount) {
        if (DEBUG && skipFromStartCount > 1) {
            throw new IllegalArgumentException("skipFromStartCount=" + skipFromStartCount);
        }
        return new SearchRangeIter(this, skipFromStartCount);
    }

    @Override
    public Container not(int rangeStart, int rangeEnd) {
        if (rangeEnd <= rangeStart) {
            return this;
        }
        if (rangeEnd - rangeStart == 1) {
            return this.iflip(ContainerUtil.lowbits(rangeStart));
        }
        int iv1 = this.v1AsInt();
        int iv2 = this.v2AsInt();
        if (iv2 < rangeStart) {
            if (iv2 + 1 == rangeStart) {
                return new RunContainer(iv1, iv1 + 1, iv2, rangeEnd);
            }
            RunContainer ans = new RunContainer(iv1, iv1 + 1, iv2, iv2 + 1);
            return ans.iaddUnsafe(rangeStart, rangeEnd, 2);
        }
        if (rangeEnd <= iv1) {
            if (rangeEnd == iv1) {
                return new RunContainer(rangeStart, iv1 + 1, iv2, iv2 + 1);
            }
            RunContainer c = new RunContainer(rangeStart, rangeEnd, iv1, iv1 + 1);
            return c.iaddUnsafe(iv2, iv2 + 1, 2);
        }
        boolean v1Contained = rangeStart <= iv1;
        boolean v2Contained = iv2 < rangeEnd;
        int[] buf = intBuf.get();
        int n = 0;
        if (v1Contained) {
            if (iv1 == rangeStart) {
                buf[n++] = iv1 + 1;
            } else {
                if (iv1 + 1 == rangeEnd) {
                    return Container.twoRanges(rangeStart, iv1, iv2, iv2 + 1);
                }
                buf[n++] = rangeStart;
                buf[n++] = iv1;
                buf[n++] = iv1 + 1;
            }
        } else if (iv1 + 1 == rangeStart) {
            buf[n++] = iv1;
        } else {
            if (iv2 == rangeStart) {
                return Container.twoRanges(iv1, iv1 + 1, iv2 + 1, rangeEnd);
            }
            buf[n++] = iv1;
            buf[n++] = iv1 + 1;
            buf[n++] = rangeStart;
        }
        if (v2Contained) {
            buf[n++] = iv2;
            if (iv2 != rangeEnd - 1) {
                buf[n++] = iv2 + 1;
                buf[n++] = rangeEnd;
            }
        } else if (iv2 == rangeEnd) {
            buf[n++] = iv2 + 1;
        } else {
            buf[n++] = rangeEnd;
            buf[n++] = iv2;
            buf[n++] = iv2 + 1;
        }
        if (n == 2) {
            return Container.singleRange(buf[0], buf[1]);
        }
        Container c = Container.twoRanges(buf[0], buf[1], buf[2], buf[3]);
        if (n == 6) {
            c = c.iadd(buf[4], buf[5]);
        }
        return c;
    }

    @Override
    int numberOfRuns() {
        return 2;
    }

    private Container orImpl(Container c) {
        PositionHint hint = new PositionHint();
        Container ans = c.set(this.v1, hint);
        return ans.iset(this.v2, hint);
    }

    @Override
    public Container or(ArrayContainer x) {
        return this.orImpl(x);
    }

    @Override
    public Container or(BitmapContainer x) {
        return this.orImpl(x);
    }

    @Override
    public Container or(RunContainer x) {
        return this.orImpl(x);
    }

    @Override
    public int rank(short lowbits) {
        int iv1;
        int v = ContainerUtil.toIntUnsigned(lowbits);
        if (v < (iv1 = this.v1AsInt())) {
            return 0;
        }
        if (v == iv1) {
            return 1;
        }
        int iv2 = this.v2AsInt();
        if (v < iv2) {
            return 1;
        }
        return 2;
    }

    @Override
    public Container remove(int begin, int end) {
        boolean hasv2;
        if (end <= begin) {
            return this;
        }
        int iv1 = this.v1AsInt();
        int iv2 = this.v2AsInt();
        boolean hasv1 = begin <= iv1 && iv1 < end;
        boolean bl = hasv2 = begin <= iv2 && iv2 < end;
        if (hasv1) {
            if (hasv2) {
                return Container.empty();
            }
            return new SingletonContainer(this.v2);
        }
        if (hasv2) {
            return new SingletonContainer(this.v1);
        }
        return this;
    }

    @Override
    public Container unset(short x) {
        if (x == this.v1) {
            return new SingletonContainer(this.v2);
        }
        if (x == this.v2) {
            return new SingletonContainer(this.v1);
        }
        return this;
    }

    @Override
    Container unset(short x, PositionHint positionHint) {
        positionHint.reset();
        return this.unset(x);
    }

    @Override
    public Container runOptimize() {
        return this;
    }

    @Override
    public short select(int j) {
        if (j == 0) {
            return this.v1;
        }
        if (j == 1) {
            return this.v2;
        }
        throw new IllegalArgumentException("j=" + j);
    }

    @Override
    public Container select(int startRank, int endRank) {
        if (endRank <= startRank) {
            return Container.empty();
        }
        if (startRank < 0 || endRank > 2) {
            throw new IllegalArgumentException();
        }
        int n = endRank - startRank;
        if (startRank == 0) {
            if (n == 1) {
                return new SingletonContainer(this.v1);
            }
            return this;
        }
        return new SingletonContainer(this.v2);
    }

    @Override
    public int find(short x) {
        int iv1;
        int v = ContainerUtil.toIntUnsigned(x);
        if (v < (iv1 = this.v1AsInt())) {
            return -1;
        }
        if (v == iv1) {
            return 0;
        }
        int iv2 = this.v2AsInt();
        if (v < iv2) {
            return -2;
        }
        if (v == iv2) {
            return 1;
        }
        return -3;
    }

    @Override
    public void selectRanges(RangeConsumer outValues, RangeIterator inPositions) {
        if (!inPositions.hasNext()) {
            return;
        }
        int iv1 = this.v1AsInt();
        int iv2 = this.v2AsInt();
        inPositions.next();
        int pStart = inPositions.start();
        int pEnd = inPositions.end();
        if (pStart == 0) {
            if (pEnd == 1) {
                outValues.accept(iv1, iv1 + 1);
                return;
            }
            if (pEnd == 2) {
                outValues.accept(iv1, iv1 + 1);
                outValues.accept(iv2, iv2 + 1);
                return;
            }
        } else if (pStart == 1 && pEnd == 2) {
            outValues.accept(iv2, iv2 + 1);
            return;
        }
        throw new IllegalArgumentException("pStart=" + pStart + ", pEnd=" + pEnd + ", iv1=" + iv1 + ", iv2=" + iv2);
    }

    @Override
    public boolean findRanges(RangeConsumer outPositions, RangeIterator inValues, int maxPos) {
        if (maxPos < 0) {
            throw new IllegalArgumentException("maxPos=" + maxPos);
        }
        int iv1 = this.v1AsInt();
        int iv2 = this.v2AsInt();
        int start = -1;
        int end = -1;
        boolean doThrow = false;
        boolean accept1 = false;
        boolean accept2 = false;
        while (inValues.hasNext()) {
            inValues.next();
            start = inValues.start();
            end = inValues.end();
            if (start <= iv1 && iv1 < end) {
                if (start < iv1 || end != iv1 + 1) {
                    doThrow = true;
                    break;
                }
                accept1 = true;
                if (maxPos != 0) continue;
                break;
            }
            if (start <= iv2 && iv2 < end) {
                if (start < iv2 || end != iv2 + 1) {
                    doThrow = true;
                    break;
                }
                if (maxPos == 0) break;
                accept2 = true;
                if (!inValues.hasNext()) break;
                inValues.next();
                start = inValues.start();
                end = inValues.end();
                doThrow = true;
                break;
            }
            doThrow = true;
            break;
        }
        if (doThrow) {
            throw new IllegalArgumentException("start=" + start + ", end=" + end + ", iv1=" + iv1 + ", iv2=" + iv2);
        }
        if (accept1) {
            if (accept2) {
                outPositions.accept(0, 2);
                return maxPos == 1;
            }
            outPositions.accept(0, 1);
            return maxPos == 0;
        }
        if (accept2) {
            outPositions.accept(1, 2);
            return maxPos == 1;
        }
        return false;
    }

    @Override
    public void trim() {
    }

    private Container xorImpl(Container c) {
        return c.deepCopy().iflip(this.v1).iflip(this.v2);
    }

    @Override
    public Container xor(ArrayContainer x) {
        return this.xorImpl(x);
    }

    @Override
    public Container xor(BitmapContainer x) {
        return this.xorImpl(x);
    }

    @Override
    public Container xor(RunContainer x) {
        return this.xorImpl(x);
    }

    @Override
    public BitmapContainer toBitmapContainer() {
        BitmapContainer b = new BitmapContainer();
        b.bitmapSet(this.v1);
        b.bitmapSet(this.v2);
        b.cardinality = 2;
        return b;
    }

    @Override
    public int nextValue(short fromValue) {
        int iv1;
        int v = ContainerUtil.toIntUnsigned(fromValue);
        if (v <= (iv1 = this.v1AsInt())) {
            return iv1;
        }
        int iv2 = this.v2AsInt();
        if (v <= iv2) {
            return iv2;
        }
        return -1;
    }

    @Override
    public int first() {
        return this.v1AsInt();
    }

    @Override
    public int last() {
        return this.v2AsInt();
    }

    private boolean subsetOfImpl(Container c) {
        return c.contains(this.v1) && c.contains(this.v2);
    }

    @Override
    public boolean subsetOf(ArrayContainer x) {
        return this.subsetOfImpl(x);
    }

    @Override
    public boolean subsetOf(BitmapContainer x) {
        return this.subsetOfImpl(x);
    }

    @Override
    public boolean subsetOf(RunContainer x) {
        return this.subsetOfImpl(x);
    }

    private boolean overlapsImpl(Container c) {
        return c.contains(this.v1) || c.contains(this.v2);
    }

    @Override
    public boolean overlaps(ArrayContainer x) {
        return this.overlapsImpl(x);
    }

    @Override
    public boolean overlaps(BitmapContainer x) {
        return this.overlapsImpl(x);
    }

    @Override
    public boolean overlaps(RunContainer x) {
        return this.overlapsImpl(x);
    }

    @Override
    public boolean overlapsRange(int start, int end) {
        int iv1 = this.v1AsInt();
        int iv2 = this.v2AsInt();
        return start <= iv1 && iv1 < end || start <= iv2 && iv2 < end;
    }

    @Override
    public void setCopyOnWrite() {
    }

    @Override
    public int bytesAllocated() {
        return 4;
    }

    @Override
    public int bytesUsed() {
        return 4;
    }

    @Override
    public String toString() {
        return "{ " + this.v1AsInt() + "," + this.v2AsInt() + " }";
    }

    @Override
    public Container toLargeContainer() {
        return new ArrayContainer(new short[]{this.v1, this.v2});
    }

    @Override
    public void validate() {
        int iv1 = this.v1AsInt();
        int iv2 = this.v2AsInt();
        if (iv2 - iv1 < 2) {
            throw new IllegalStateException("iv1=" + iv1 + ", iv2=" + iv2);
        }
    }

    private static final class SearchRangeIter
    extends ForwardIterBase
    implements SearchRangeIterator {
        public SearchRangeIter(TwoValuesContainer c, int skip) {
            super(c, -1 + skip);
        }

        @Override
        public void next() {
            this.nextPos();
        }

        @Override
        public boolean search(ContainerUtil.TargetComparator comp) {
            int c;
            if (this.pos >= 1) {
                int c2 = comp.directionFrom(this.v2AsInt());
                return c2 >= 0;
            }
            if (this.pos == -1) {
                this.pos = 0;
            }
            if ((c = comp.directionFrom(this.v2AsInt())) >= 0) {
                this.pos = 1;
                return true;
            }
            c = comp.directionFrom(this.v1AsInt());
            return c >= 0;
        }

        @Override
        public int start() {
            return this.pos == 0 ? this.v1AsInt() : this.v2AsInt();
        }

        @Override
        public int end() {
            return this.start() + 1;
        }
    }

    public static final class ContainerShortBatchIter
    extends ForwardIterBase
    implements ContainerShortBatchIterator {
        public ContainerShortBatchIter(TwoValuesContainer c, int skip) {
            super(c, -1 + skip);
        }

        @Override
        public int next(short[] buffer, int offset, int maxCount) {
            int n = 0;
            while (n < maxCount && this.pos < 1) {
                ++this.pos;
                buffer[offset + n++] = this.curr();
            }
            return n;
        }

        @Override
        public boolean forEach(ShortConsumer sc) {
            while (this.pos < 1) {
                ++this.pos;
                if (sc.accept(this.curr())) continue;
                return false;
            }
            return true;
        }
    }

    private static final class ReverseIter
    extends IterBase
    implements ShortAdvanceIterator {
        public ReverseIter(TwoValuesContainer c) {
            super(c, 2);
        }

        @Override
        public short next() {
            return this.nextAsShort();
        }

        @Override
        protected void nextPos() {
            --this.pos;
        }

        @Override
        public boolean hasNext() {
            return this.pos > 0;
        }

        @Override
        public boolean advance(int v) {
            if (this.pos <= 0) {
                return this.v1AsInt() <= v;
            }
            if (this.v2AsInt() <= v) {
                this.pos = 1;
                return true;
            }
            this.pos = 0;
            return this.v1AsInt() <= v;
        }
    }

    private static final class ForwardIter
    extends ForwardIterBase
    implements ShortAdvanceIterator {
        public ForwardIter(TwoValuesContainer c) {
            super(c, -1);
        }

        @Override
        public short next() {
            return this.nextAsShort();
        }
    }

    private static class ForwardIterBase
    extends IterBase {
        public ForwardIterBase(TwoValuesContainer c, int initialPos) {
            super(c, initialPos);
        }

        public boolean hasNext() {
            return this.pos < 1;
        }

        @Override
        protected final void nextPos() {
            ++this.pos;
        }

        public boolean advance(int v) {
            if (this.pos >= 1) {
                return v <= this.v2AsInt();
            }
            if (v <= this.v1AsInt()) {
                this.pos = 0;
                return true;
            }
            this.pos = 1;
            return v <= this.v2AsInt();
        }
    }

    private static abstract class IterBase {
        protected final short v1;
        protected final short v2;
        protected int pos;

        public IterBase(TwoValuesContainer c, int initialPos) {
            this.v1 = c.v1;
            this.v2 = c.v2;
            this.pos = initialPos;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public short curr() {
            return this.pos == 0 ? this.v1 : this.v2;
        }

        public int currAsInt() {
            return ContainerUtil.toIntUnsigned(this.curr());
        }

        protected short nextAsShort() {
            this.nextPos();
            return this.curr();
        }

        public int nextAsInt() {
            this.nextPos();
            return this.currAsInt();
        }

        protected abstract void nextPos();

        protected int v1AsInt() {
            return ContainerUtil.toIntUnsigned(this.v1);
        }

        protected int v2AsInt() {
            return ContainerUtil.toIntUnsigned(this.v2);
        }
    }
}

