/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.modelfarm;

import io.deephaven.base.verify.Require;
import io.deephaven.configuration.Configuration;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.modelfarm.Model;
import io.deephaven.modelfarm.ModelMultiExec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;

public class ConditionalModels<DATA_TYPE, STATE_TYPE, KEY_TYPE>
implements ModelMultiExec.Models<DATA_TYPE> {
    private static final Logger log = LoggerFactory.getLogger(ConditionalModels.class);
    private static final boolean LOG_PERF = Configuration.getInstance().getBooleanWithDefault("ModelFarm.logConditionalModelsPerformance", false);
    private final Map<KEY_TYPE, STATE_TYPE> stateMap;
    private final Model<DATA_TYPE>[] models;
    private final BiPredicate<DATA_TYPE, STATE_TYPE>[] predicates;
    private final Function<DATA_TYPE, KEY_TYPE> dataToKey;
    private final Map<KEY_TYPE, Object> lockMap = new ConcurrentHashMap<KEY_TYPE, Object>();

    public ConditionalModels(Model<DATA_TYPE>[] models, BiPredicate<DATA_TYPE, STATE_TYPE>[] predicates, Map<KEY_TYPE, STATE_TYPE> stateMap, Function<DATA_TYPE, KEY_TYPE> dataToKey) {
        Require.neqNull(stateMap, (String)"stateMap");
        Require.neqNull(models, (String)"models");
        Require.elementsNeqNull((Object[])models, (String)"models");
        Require.neqNull(predicates, (String)"predicates");
        Require.elementsNeqNull((Object[])predicates, (String)"predicates");
        Require.neqNull(dataToKey, (String)"dataToKey");
        this.stateMap = stateMap;
        this.models = models;
        this.predicates = predicates;
        this.dataToKey = dataToKey;
    }

    @Override
    public Object getLock(DATA_TYPE data) {
        return this.lockMap.computeIfAbsent(this.dataToKey.apply(data), key -> new Object());
    }

    @Override
    public Iterator<Model<DATA_TYPE>> iterator(DATA_TYPE data) {
        long t0 = System.nanoTime();
        KEY_TYPE key = this.dataToKey.apply(data);
        STATE_TYPE validFit = this.stateMap.get(key);
        long t1 = System.nanoTime();
        ArrayList<Model<DATA_TYPE>> toRun = new ArrayList<Model<DATA_TYPE>>(this.models.length);
        boolean[] pvals = new boolean[this.models.length];
        long[] ptimes = new long[this.models.length];
        for (int i = 0; i < this.models.length; ++i) {
            boolean pval;
            long t0p = System.nanoTime();
            try {
                pval = this.predicates[i].test(data, validFit);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception evaluating predicate. model=" + i, e);
            }
            long t1p = System.nanoTime();
            pvals[i] = pval;
            ptimes[i] = (t1p - t0p) / 1000L;
            if (!pval) continue;
            toRun.add(this.models[i]);
        }
        long t2 = System.nanoTime();
        if (LOG_PERF) {
            log.warn().append((CharSequence)"ConditionalModels.iterator PERFORMANCE: key=").append((CharSequence)key.toString()).append((CharSequence)"tall=").append((t2 - t1) / 1000L).append((CharSequence)" tstate=").append((t1 - t0) / 1000L).append((CharSequence)" predicatevals=").append((CharSequence)Arrays.toString(pvals)).append((CharSequence)" predicatetimes=").append((CharSequence)Arrays.toString(ptimes)).endl();
        }
        return toRun.iterator();
    }
}

