/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.modelfarm;

import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.engine.exceptions.CancellationException;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.NotificationStepSource;
import io.deephaven.engine.table.impl.remote.ConstructSnapshot;
import io.deephaven.engine.updategraph.UpdateGraphProcessor;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.modelfarm.Model;
import io.deephaven.modelfarm.ModelFarm;
import io.deephaven.util.FunctionalInterfaces;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ModelFarmBase<DATATYPE>
implements ModelFarm {
    private static final Logger log = LoggerFactory.getLogger(ModelFarmBase.class);
    private static int modelFarmNThreads = 0;
    private static final AtomicInteger nModelFarms = new AtomicInteger(0);
    private final int modelFarmN = nModelFarms.getAndIncrement();
    protected final Model<DATATYPE> model;
    private final ThreadGroup threadGroup;
    private final Set<Thread> threads = new LinkedHashSet<Thread>();
    private State state = State.WAITING;

    protected ModelFarmBase(int nThreads, Model<DATATYPE> model) {
        this.model = (Model)Require.neqNull(model, (String)"model");
        this.threadGroup = this.initializeThreadGroup(Require.gtZero((int)nThreads, (String)"nThreads"), this.threads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadGroup initializeThreadGroup(int nThreads, Set<Thread> threads) {
        Class<ModelFarmBase> clazz = ModelFarmBase.class;
        synchronized (ModelFarmBase.class) {
            ThreadGroup threadGroup = new ThreadGroup("ModelFarm");
            for (int i = 0; i < nThreads; ++i) {
                String threadName = "ModelFarm_" + this.modelFarmN + "_Thread_" + modelFarmNThreads++;
                threads.add(new Thread(threadGroup, new Worker(), threadName));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return threadGroup;
        }
    }

    protected abstract void execute() throws InterruptedException;

    protected static FunctionalInterfaces.ThrowingBiConsumer<QueryDataRetrievalOperation, Table, RuntimeException> getDoLockedConsumer(GetDataLockType lockType) {
        switch (lockType) {
            case UGP_LOCK_ALREADY_HELD: {
                return (queryDataRetrievalOperation, source) -> queryDataRetrievalOperation.retrieveData(false);
            }
            case UGP_LOCK: {
                return (queryDataRetrievalOperation, source) -> UpdateGraphProcessor.DEFAULT.exclusiveLock().doLocked(() -> queryDataRetrievalOperation.retrieveData(false));
            }
            case UGP_READ_LOCK: {
                return (queryDataRetrievalOperation, source) -> UpdateGraphProcessor.DEFAULT.sharedLock().doLocked(() -> queryDataRetrievalOperation.retrieveData(false));
            }
            case SNAPSHOT: {
                return (queryDataRetrievalOperation, source) -> {
                    try {
                        ConstructSnapshot.callDataSnapshotFunction((String)"ModelFarmBase.getData(SNAPSHOT)", (ConstructSnapshot.SnapshotControl)ConstructSnapshot.makeSnapshotControl((boolean)false, (boolean)source.isRefreshing(), (NotificationStepSource)((NotificationStepSource)source)), (usePrev, beforeClockValue) -> {
                            queryDataRetrievalOperation.retrieveData(usePrev);
                            return true;
                        });
                    }
                    catch (CancellationException e) {
                        log.warn((Throwable)e).append((CharSequence)"ModelFarmBase.getData(SNAPSHOT): CancellationException.  The ModelFarm is probably shutting down.").endl();
                    }
                };
            }
        }
        throw new UnsupportedOperationException("Unsupported lockType: " + lockType);
    }

    protected final synchronized State getState() {
        return this.state;
    }

    private synchronized void setState(State state) {
        boolean changed = this.state != state;
        this.state = (State)((Object)Require.neqNull((Object)((Object)state), (String)"state"));
        if (changed) {
            this.notifyAll();
        }
    }

    @Override
    public final synchronized void start() {
        if (this.state != State.WAITING) {
            throw new IllegalStateException("Start may only be called on an unstarted ModelFarm. state=" + this.state);
        }
        this.setState(State.RUNNING);
        for (Thread thread : this.threads) {
            thread.start();
        }
        this.modelFarmStarted();
    }

    protected abstract void modelFarmStarted();

    @Override
    public final synchronized void shutdown() {
        switch (this.state) {
            case SHUTDOWN: 
            case TERMINATING: 
            case TERMINATED: {
                return;
            }
            case WAITING: 
            case RUNNING: {
                log.info().append((CharSequence)"ModelFarm shutting down...").endl();
                this.setState(State.SHUTDOWN);
                break;
            }
            default: {
                throw new IllegalStateException("State is not being handled by the switch! state=" + this.state);
            }
        }
    }

    @Override
    public final synchronized void terminate() {
        if (this.state != State.TERMINATING && this.state != State.TERMINATED) {
            this.setState(State.TERMINATING);
            this.threadGroup.interrupt();
        }
    }

    @Override
    public final boolean awaitTermination() {
        return this.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit) {
        ModelFarmBase modelFarmBase = this;
        // MONITORENTER : modelFarmBase
        switch (this.state) {
            case WAITING: {
                this.setState(State.TERMINATED);
                // MONITOREXIT : modelFarmBase
                return true;
            }
            case RUNNING: {
                this.shutdown();
                break;
            }
            case SHUTDOWN: 
            case TERMINATING: {
                break;
            }
            case TERMINATED: {
                // MONITOREXIT : modelFarmBase
                return true;
            }
            default: {
                throw new IllegalStateException("State is not being handled by the switch! state=" + this.state);
            }
        }
        Require.eqTrue((boolean)this.isShutdown(), (String)"isShutdown()");
        // MONITOREXIT : modelFarmBase
        long timeoutMillis = timeout == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + unit.toMillis(timeout);
        boolean allThreadsTerminated = false;
        ModelFarmBase modelFarmBase2 = this;
        // MONITORENTER : modelFarmBase2
        long currentTime = System.currentTimeMillis();
        while (!allThreadsTerminated && currentTime < timeoutMillis) {
            if (!this.threads.isEmpty()) {
                try {
                    this.wait(timeoutMillis - currentTime);
                    if (this.threads.isEmpty()) {
                        allThreadsTerminated = true;
                    }
                }
                catch (InterruptedException e) {
                    if (!this.threads.isEmpty()) throw new RuntimeException("Interrupted while awaiting ModelFarm termination.", e);
                    allThreadsTerminated = true;
                }
            } else {
                allThreadsTerminated = true;
            }
            currentTime = System.currentTimeMillis();
        }
        // MONITOREXIT : modelFarmBase2
        if (allThreadsTerminated) {
            Assert.eq((Object)((Object)this.getState()), (String)"getState()", (Object)((Object)State.TERMINATED));
            log.warn().append((CharSequence)"ModelFarm all threads terminated.").endl();
            return allThreadsTerminated;
        }
        log.warn().append((CharSequence)"ModelFarm timed out waiting for threads to terminate.").endl();
        return allThreadsTerminated;
    }

    private boolean isShutdown() {
        State state = this.getState();
        switch (state) {
            case SHUTDOWN: 
            case TERMINATING: 
            case TERMINATED: {
                return true;
            }
            case WAITING: 
            case RUNNING: {
                return false;
            }
        }
        throw new IllegalStateException("State is not being handled by the switch! state=" + state);
    }

    @Override
    public final void shutdownAndAwaitTermination() {
        this.shutdownAndAwaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public final boolean shutdownAndAwaitTermination(long timeout, TimeUnit unit) {
        this.shutdown();
        return this.awaitTermination(timeout, unit);
    }

    protected abstract boolean isQueueEmpty();

    public String toString() {
        return "ModelFarm" + this.modelFarmN + "_" + this.getClass().getSimpleName();
    }

    @FunctionalInterface
    static interface MostRecentDataGetter<KEYTYPE, DATATYPE> {
        public DATATYPE get(KEYTYPE var1);
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ModelFarmBase modelFarmBase = ModelFarmBase.this;
            synchronized (modelFarmBase) {
                Assert.assertion((boolean)ModelFarmBase.this.threads.contains(Thread.currentThread()), (String)"threads.contains(Thread.currentThread())");
            }
            try {
                while (true) {
                    try {
                        ModelFarmBase.this.execute();
                    }
                    catch (InterruptedException e) {
                        log.warn().append((CharSequence)"ModelFarm worker thread interrupted.").endl();
                    }
                    catch (Exception e) {
                        log.error((Throwable)e).append((CharSequence)"Exception in ModelFarm worker thread.").endl();
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        pw.close();
                        log.error().append((CharSequence)"Exception in ModelFarm worker thread stack trace. \n").append((CharSequence)sw.toString()).endl();
                        throw new RuntimeException(e);
                    }
                    State state = ModelFarmBase.this.getState();
                    if ((state != State.SHUTDOWN || !ModelFarmBase.this.isQueueEmpty()) && state != State.TERMINATING && state != State.TERMINATED) continue;
                    log.warn().append((CharSequence)"ModelFarm worker thread exiting. state=").append((CharSequence)state.toString()).append((CharSequence)" isQueueEmpty=").append(ModelFarmBase.this.isQueueEmpty()).endl();
                    return;
                }
            }
            finally {
                ModelFarmBase modelFarmBase2 = ModelFarmBase.this;
                synchronized (modelFarmBase2) {
                    ModelFarmBase.this.threads.remove(Thread.currentThread());
                    boolean threadsEmpty = ModelFarmBase.this.threads.isEmpty();
                    if (threadsEmpty && (ModelFarmBase.this.state == State.SHUTDOWN || ModelFarmBase.this.state == State.TERMINATING)) {
                        ModelFarmBase.this.setState(State.TERMINATED);
                    }
                }
            }
        }
    }

    public static enum GetDataLockType {
        UGP_LOCK_ALREADY_HELD,
        UGP_LOCK,
        UGP_READ_LOCK,
        SNAPSHOT;

    }

    @FunctionalInterface
    static interface QueryDataRetrievalOperation {
        public void retrieveData(boolean var1);
    }

    public static enum State {
        WAITING,
        RUNNING,
        SHUTDOWN,
        TERMINATING,
        TERMINATED;

    }
}

