/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.modelfarm;

import io.deephaven.base.verify.Assert;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.TrackingRowSet;
import io.deephaven.engine.table.Table;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.modelfarm.Model;
import io.deephaven.modelfarm.ModelFarmBase;
import io.deephaven.modelfarm.RowDataManager;
import io.deephaven.util.FunctionalInterfaces;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Set;

public class ModelFarmOnDemand<KEYTYPE, DATATYPE, ROWDATAMANAGERTYPE extends RowDataManager<KEYTYPE, DATATYPE>>
extends ModelFarmBase<DATATYPE> {
    private static final boolean LOG_PERF = Configuration.getInstance().getBooleanWithDefault("ModelFarm.logModelFarmOnDemandPerformance", false);
    private static final Logger log = LoggerFactory.getLogger(ModelFarmOnDemand.class);
    private static final FunctionalInterfaces.ThrowingBiConsumer<ModelFarmBase.QueryDataRetrievalOperation, Table, RuntimeException> DO_LOCKED_FUNCTION = ModelFarmOnDemand.getDoLockedConsumer(ModelFarmBase.GetDataLockType.UGP_READ_LOCK);
    private final Queue<QueueAndCallback<DATATYPE>> execQueue = new ArrayDeque<QueueAndCallback<DATATYPE>>(1024);

    public ModelFarmOnDemand(int nThreads, Model<DATATYPE> model) {
        super(nThreads, model);
    }

    public void requestUpdate(ROWDATAMANAGERTYPE dataManager, Runnable callback) {
        this.requestUpdate(dataManager, callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestUpdate(ROWDATAMANAGERTYPE dataManager, Runnable callback, Set<KEYTYPE> keys) {
        if (keys != null && keys.isEmpty()) {
            return;
        }
        Table dataManagerTable = dataManager.table();
        ArrayDeque dataToEval = new ArrayDeque(keys != null ? keys.size() : dataManagerTable.intSize());
        DO_LOCKED_FUNCTION.accept(usePrev -> {
            TrackingRowSet rowSet = dataManagerTable.getRowSet();
            if (rowSet.isEmpty()) {
                log.warn().append((CharSequence)(ModelFarmOnDemand.class.getSimpleName() + ": ")).append((CharSequence)"Table is empty. Nothing to price.").endl();
                callback.run();
                return;
            }
            RowSet.Iterator iter = rowSet.iterator();
            while (iter.hasNext()) {
                boolean includeThisKey;
                long idx = iter.nextLong();
                if (keys != null) {
                    Object key = usePrev ? dataManager.uniqueIdPrev(idx) : dataManager.uniqueIdCurrent(idx);
                    includeThisKey = keys.contains(key);
                } else {
                    includeThisKey = true;
                }
                if (!includeThisKey) continue;
                Object data = dataManager.newData();
                dataManager.loadData(data, idx, usePrev);
                dataToEval.add(data);
            }
        }, (Object)dataManagerTable);
        if (dataToEval.isEmpty()) {
            log.warn().append((CharSequence)"ModelFarmOnDemand: dataToEval is empty!").endl();
            callback.run();
            return;
        }
        Queue<QueueAndCallback<DATATYPE>> queue = this.execQueue;
        synchronized (queue) {
            this.execQueue.add(new QueueAndCallback(dataToEval, callback));
            this.execQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() throws InterruptedException {
        boolean queueEmpty;
        Object data;
        QueueAndCallback<DATATYPE> queueAndCallbackOneRequest;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long t0 = System.nanoTime();
        Queue<QueueAndCallback<DATATYPE>> queue = this.execQueue;
        synchronized (queue) {
            while ((queueAndCallbackOneRequest = this.execQueue.peek()) == null) {
                this.execQueue.wait();
            }
            data = queueAndCallbackOneRequest.queue.poll();
            Assert.neqNull(data, (String)"data");
            queueEmpty = queueAndCallbackOneRequest.queue.isEmpty();
            if (queueEmpty) {
                this.execQueue.remove();
            }
        }
        long t1 = System.nanoTime();
        if (data == null) {
            throw new IllegalStateException("Data is null!");
        }
        this.model.exec(data);
        long t2 = System.nanoTime();
        if (LOG_PERF) {
            log.warn((Object)("ModelFarmOnDemand.execute PERFORMANCE: all=" + (t2 - t0) / 1000L + " take=" + (t1 - t0) / 100L + " exec=" + (t2 - t1) / 1000L));
        }
        if (queueEmpty && queueAndCallbackOneRequest.callback != null) {
            queueAndCallbackOneRequest.callback.run();
        }
    }

    @Override
    protected void modelFarmStarted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isQueueEmpty() {
        Queue<QueueAndCallback<DATATYPE>> queue = this.execQueue;
        synchronized (queue) {
            return this.execQueue.isEmpty();
        }
    }

    private static class QueueAndCallback<DATATYPE> {
        private final Queue<DATATYPE> queue;
        private final Runnable callback;

        private QueueAndCallback(Queue<DATATYPE> queue, Runnable callback) {
            this.queue = queue;
            this.callback = callback;
        }
    }
}

