/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.modelfarm;

import io.deephaven.configuration.Configuration;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.modelfarm.ExecPrioritizer;
import io.deephaven.modelfarm.Model;
import io.deephaven.modelfarm.ModelFarmBase;
import io.deephaven.modelfarm.RDMModelFarm;
import io.deephaven.modelfarm.RowDataManager;
import io.deephaven.modelfarm.util.KeyedPriorityBlockingQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class ModelFarmRealTime<KEYTYPE, DATATYPE, ROWDATAMANAGERTYPE extends RowDataManager<KEYTYPE, DATATYPE>>
extends RDMModelFarm<KEYTYPE, DATATYPE, ROWDATAMANAGERTYPE> {
    private static final Logger log = LoggerFactory.getLogger(ModelFarmRealTime.class);
    private static final boolean LOG_PERF = Configuration.getInstance().getBooleanWithDefault("ModelFarm.logModelFarmRealTimePerformance", false);
    private final ModelFarmBase.GetDataLockType GETDATA_LOCK_TYPE = ModelFarmBase.GetDataLockType.valueOf(Configuration.getInstance().getStringWithDefault("ModelFarm.ModelFarmRealTime.getDataLockType", "UGP_READ_LOCK"));
    private final KeyedPriorityBlockingQueue<KEYTYPE> execQueue = new KeyedPriorityBlockingQueue();
    private final ExecPrioritizer<KEYTYPE, DATATYPE, ROWDATAMANAGERTYPE> prioritizer;
    private final ModelFarmBase.MostRecentDataGetter<KEYTYPE, DATATYPE> mostRecentDataGetter;
    private final Map<KEYTYPE, Integer> lastPriorityMap = new ConcurrentHashMap<KEYTYPE, Integer>();
    private final Map<KEYTYPE, AtomicBoolean> isEvalingMap = new ConcurrentHashMap<KEYTYPE, AtomicBoolean>();

    public ModelFarmRealTime(int nThreads, Model<DATATYPE> model, ROWDATAMANAGERTYPE dataManager, ExecPrioritizer<KEYTYPE, DATATYPE, ROWDATAMANAGERTYPE> prioritizer) {
        super(nThreads, model, dataManager);
        this.prioritizer = prioritizer;
        log.warn().append((CharSequence)"ModelFarmRealTime lock type: ").append((CharSequence)this.GETDATA_LOCK_TYPE.toString()).endl();
        this.mostRecentDataGetter = this.getMostRecentDataFactory(this.GETDATA_LOCK_TYPE);
    }

    @Override
    protected void onDataUpdate(RowSet added, RowSet removed, RowSet modified) {
        this.updateQueue(added);
        this.updateQueue(modified);
    }

    private void updateQueue(RowSet rowSet) {
        RowSet.Iterator it = rowSet.iterator();
        while (it.hasNext()) {
            long i = it.nextLong();
            Object key = this.dataManager.uniqueIdCurrent(i);
            int priority = this.prioritizer == null ? 0 : this.prioritizer.priority(this.dataManager, i);
            ModelFarmBase.State state = this.getState();
            if (state != ModelFarmBase.State.WAITING && state != ModelFarmBase.State.RUNNING) continue;
            this.execQueue.enqueue(key, priority);
            this.lastPriorityMap.put(key, priority);
        }
    }

    @Override
    protected boolean isQueueEmpty() {
        return this.execQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() throws InterruptedException {
        long t0 = System.nanoTime();
        KEYTYPE key = this.execQueue.take();
        long t1 = System.nanoTime();
        AtomicBoolean isEvaling = this.isEvalingMap.computeIfAbsent(key, k -> new AtomicBoolean(false));
        if (!isEvaling.compareAndSet(false, true)) {
            Integer priority = this.lastPriorityMap.get(key);
            this.execQueue.enqueue(key, priority == null ? Integer.MIN_VALUE : priority);
            long t2 = System.nanoTime();
            if (LOG_PERF) {
                log.warn().append((CharSequence)"ModelFarmRealTime.execute PERFORMANCE: isExec=false all=").append((t2 - t0) / 1000L).append((CharSequence)" take=").append((t1 - t0) / 1000L).append((CharSequence)" enqueue=").append((t2 - t1) / 1000L).endl();
            }
            return;
        }
        try {
            long t4;
            long t3;
            DATATYPE data = this.mostRecentDataGetter.get(key);
            long t2 = System.nanoTime();
            if (data != null) {
                this.prioritizer.execHappened(data);
                t3 = System.nanoTime();
                this.model.exec(data);
                t4 = System.nanoTime();
            } else {
                t3 = t2;
                t4 = t2;
            }
            if (LOG_PERF) {
                log.warn().append((CharSequence)"ModelFarmRealTime.execute PERFORMANCE: isExec=true all=").append((t4 - t0) / 1000L).append((CharSequence)" take=").append((t1 - t0) / 1000L).append((CharSequence)" get=").append((t2 - t1) / 1000L).append((CharSequence)" prio=").append((t3 - t2) / 1000L).append((CharSequence)(" exec=" + (t4 - t3) / 1000L)).endl();
            }
        }
        finally {
            if (!isEvaling.compareAndSet(true, false)) {
                throw new IllegalStateException("isEvaling is false but should be true for key " + key);
            }
        }
    }

    public boolean requestUpdateMaxPriority(KEYTYPE key) {
        return this.requestUpdate(key, Integer.MAX_VALUE);
    }

    public boolean requestUpdate(KEYTYPE key, int priority) {
        return this.execQueue.enqueue(key, priority);
    }
}

