/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.modelfarm;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

public class ModelInputDeserializer<T>
implements AutoCloseable {
    private final Class<T> c;
    private final FileInputStream fis;
    private final ObjectInputStream ois;
    private boolean isClosed = false;

    public ModelInputDeserializer(Class<T> c, String filename) throws IOException {
        this.c = c;
        this.fis = new FileInputStream(filename);
        this.ois = new ObjectInputStream(this.fis);
    }

    public synchronized T next() throws IOException, ClassNotFoundException {
        if (this.isClosed) {
            throw new RuntimeException("Attempting to access the next value after the stream is closed.");
        }
        return this.c.cast(this.ois.readObject());
    }

    @Override
    public synchronized void close() throws IOException {
        this.ois.close();
        this.fis.close();
        this.isClosed = true;
    }
}

