/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.modelfarm;

import io.deephaven.modelfarm.Model;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;

public class ModelInputSerializer<T>
implements Model<T>,
AutoCloseable {
    private final FileOutputStream fos;
    private final ObjectOutputStream oos;
    private boolean isClosed = false;

    public ModelInputSerializer(String filename) {
        try {
            this.fos = new FileOutputStream(filename);
            this.oos = new ObjectOutputStream(this.fos);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public synchronized void exec(T data) {
        if (!this.isClosed) {
            try {
                this.oos.writeObject(data);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.oos.close();
        this.fos.close();
        this.isClosed = true;
    }
}

