/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.modelfarm;

import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ShiftObliviousListener;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.ShiftObliviousInstrumentedListenerAdapter;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.modelfarm.Model;
import io.deephaven.modelfarm.ModelFarmBase;
import io.deephaven.modelfarm.RowDataManager;
import io.deephaven.util.FunctionalInterfaces;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class RDMModelFarm<KEYTYPE, DATATYPE, ROWDATAMANAGERTYPE extends RowDataManager<KEYTYPE, DATATYPE>>
extends ModelFarmBase<DATATYPE> {
    private static final Logger log = LoggerFactory.getLogger(RDMModelFarm.class);
    private static final long NO_ENTRY_VALUE = -1L;
    private static final long REMOVED_ENTRY_VALUE = -2L;
    protected final ROWDATAMANAGERTYPE dataManager;
    private final ReadWriteLock keyIndexCurrentLock = new ReentrantReadWriteLock();
    private final ReadWriteLock keyIndexPrevLock = new ReentrantReadWriteLock();
    private final TObjectLongMap<KEYTYPE> keyIndexPrev = new TObjectLongHashMap(10, 0.5f, -1L);
    private final TObjectLongMap<KEYTYPE> keyIndexDelta = new TObjectLongHashMap(10, 0.5f, -1L);
    private ShiftObliviousInstrumentedListenerAdapter listener = null;

    public RDMModelFarm(int nThreads, Model<DATATYPE> model, ROWDATAMANAGERTYPE dataManager) {
        super(nThreads, model);
        this.dataManager = (RowDataManager)Require.neqNull(dataManager, (String)"dataManager");
    }

    @Override
    protected void modelFarmStarted() {
        Assert.eqNull((Object)this.listener, (String)"listener");
        this.listener = new ShiftObliviousInstrumentedListenerAdapter(this.dataManager.table(), false){
            private static final long serialVersionUID = -2137065147841887955L;

            public void onUpdate(RowSet added, RowSet removed, RowSet modified) {
                RDMModelFarm.this.keyIndexCurrentLock.writeLock().lock();
                RDMModelFarm.this.keyIndexPrevLock.writeLock().lock();
                RDMModelFarm.this.keyIndexDelta.forEachEntry((key, idx) -> {
                    if (idx == -2L) {
                        RDMModelFarm.this.keyIndexPrev.remove(key);
                    } else {
                        RDMModelFarm.this.keyIndexPrev.put(key, idx);
                    }
                    return true;
                });
                RDMModelFarm.this.keyIndexPrevLock.writeLock().unlock();
                RDMModelFarm.this.keyIndexDelta.clear();
                RDMModelFarm.this.removeKeyIndex(removed);
                RDMModelFarm.this.removeKeyIndex(modified);
                RDMModelFarm.this.addKeyIndex(added);
                RDMModelFarm.this.addKeyIndex(modified);
                RDMModelFarm.this.keyIndexCurrentLock.writeLock().unlock();
                RDMModelFarm.this.onDataUpdate(added, removed, modified);
            }
        };
        this.dataManager.table().addUpdateListener((ShiftObliviousListener)this.listener, true);
    }

    private void removeKeyIndex(RowSet rowSet) {
        rowSet.forAllRowKeys(i -> {
            Object key = this.dataManager.uniqueIdPrev(i);
            this.keyIndexDelta.put(key, -2L);
        });
    }

    private void addKeyIndex(RowSet rowSet) {
        rowSet.forAllRowKeys(i -> {
            Object key = this.dataManager.uniqueIdCurrent(i);
            this.keyIndexDelta.put(key, i);
        });
    }

    protected abstract void onDataUpdate(RowSet var1, RowSet var2, RowSet var3);

    private boolean loadData(DATATYPE data, KEYTYPE key, boolean usePrev) {
        long i;
        if (usePrev) {
            this.keyIndexPrevLock.readLock().lock();
            i = this.keyIndexPrev.get(key);
            this.keyIndexPrevLock.readLock().unlock();
        } else {
            this.keyIndexCurrentLock.readLock().lock();
            i = this.keyIndexDelta.get(key);
            if (i == -2L) {
                i = -1L;
            } else if (i == -1L) {
                this.keyIndexPrevLock.readLock().lock();
                i = this.keyIndexPrev.get(key);
                this.keyIndexPrevLock.readLock().unlock();
            }
            this.keyIndexCurrentLock.readLock().unlock();
        }
        if (i == -1L) {
            log.warn().append((CharSequence)"Attempting to get row data for a key with no index.  key=").append((CharSequence)key.toString()).endl();
            return false;
        }
        this.dataManager.loadData(data, i, usePrev);
        return true;
    }

    protected ModelFarmBase.MostRecentDataGetter<KEYTYPE, DATATYPE> getMostRecentDataFactory(ModelFarmBase.GetDataLockType lockType) {
        FunctionalInterfaces.ThrowingBiConsumer<ModelFarmBase.QueryDataRetrievalOperation, Table, RuntimeException> doLockedConsumer = RDMModelFarm.getDoLockedConsumer(lockType);
        return key -> {
            Object data = this.dataManager.newData();
            boolean[] isOk = new boolean[1];
            doLockedConsumer.accept(usePrev -> {
                isOk[0] = this.loadData(data, key, usePrev);
            }, (Object)this.dataManager.table());
            if (isOk[0]) {
                return data;
            }
            return null;
        };
    }
}

