/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.modelfarm.util;

import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;

public class KeyedPriorityBlockingQueue<E> {
    private long nextId = 0L;
    private final PriorityQueue<Enqueued<E>> fitterQueue = new PriorityQueue();
    private final Map<E, Enqueued> map = new HashMap<E, Enqueued>();

    public synchronized boolean enqueue(E element, int priority) {
        Enqueued e = this.map.get(element);
        if (e == null) {
            Enqueued<E> ee = new Enqueued<E>(this.nextId++, priority, element);
            this.fitterQueue.add(ee);
            this.map.put(element, ee);
            this.notify();
            return true;
        }
        if (e.priority < priority) {
            Enqueued<E> ee = new Enqueued<E>(this.nextId++, priority, element);
            e.isActive = false;
            this.fitterQueue.add(ee);
            this.map.put(element, ee);
            this.notify();
            return true;
        }
        return false;
    }

    public synchronized E take() throws InterruptedException {
        Enqueued<E> e = this.takeHead();
        while (!e.isActive) {
            e = this.takeHead();
        }
        this.map.remove(e.element);
        return e.element;
    }

    private void checkInterrupt() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    private synchronized Enqueued<E> takeHead() throws InterruptedException {
        while (this.fitterQueue.isEmpty()) {
            this.wait();
            this.checkInterrupt();
        }
        this.checkInterrupt();
        return this.fitterQueue.poll();
    }

    public synchronized boolean isEmpty() {
        return this.fitterQueue.isEmpty();
    }

    private static class Enqueued<E>
    implements Comparable<Enqueued> {
        private final long id;
        private final int priority;
        private final E element;
        private boolean isActive = true;

        private Enqueued(long id, int priority, E element) {
            this.id = id;
            this.priority = priority;
            this.element = element;
        }

        @Override
        public int compareTo(@NotNull Enqueued o) {
            if (this == o) {
                return 0;
            }
            int p = this.priority - o.priority;
            if (p != 0) {
                return -p;
            }
            return Long.signum(this.id - o.id);
        }
    }
}

