/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.modelfarm.util;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.table.Table;
import io.deephaven.time.DateTime;
import io.deephaven.vector.DoubleVector;
import io.deephaven.vector.FloatVector;
import io.deephaven.vector.IntVector;
import io.deephaven.vector.LongVector;
import io.deephaven.vector.ObjectVector;

public class ModelFarmUtils {
    private ModelFarmUtils() {
    }

    public static void requireTable(String tableName, Table t, String[] colNames, Class[] colTypes) {
        Require.eq((int)colNames.length, (String)"colNames.length", (int)colTypes.length, (String)"colTypes.length");
        for (int i = 0; i < colNames.length; ++i) {
            String cn = colNames[i];
            Class ct = colTypes[i];
            Require.eqTrue((boolean)t.hasColumns(new String[]{cn}), (String)("Table is missing column.  tableName=" + tableName + " columnName=" + cn));
            Class cta = t.getDefinition().getColumn(cn).getDataType();
            Require.eqTrue((boolean)cta.equals(ct), (String)("Table column is of the wrong type.  tableName=" + tableName + " columnName=" + cn + " typeRequired=" + ct + " typeActual=" + cta));
        }
    }

    public static String[] arrayString(Object o) {
        return o == null ? null : (String[])((ObjectVector)o).toArray();
    }

    public static DateTime[] arrayDateTime(Object o) {
        return o == null ? null : (DateTime[])((ObjectVector)o).toArray();
    }

    public static float[] arrayFloat(Object o) {
        return o == null ? null : ((FloatVector)o).toArray();
    }

    public static double[] arrayDouble(Object o) {
        return o == null ? null : ((DoubleVector)o).toArray();
    }

    public static int[] arrayInt(Object o) {
        return o == null ? null : ((IntVector)o).toArray();
    }

    public static long[] arrayLong(Object o) {
        return o == null ? null : ((LongVector)o).toArray();
    }

    public static double[][] array2Double(Object o) {
        if (o == null) {
            return null;
        }
        ObjectVector a = (ObjectVector)o;
        double[][] result = new double[a.intSize()][];
        for (int i = 0; i < a.intSize(); ++i) {
            result[i] = ((DoubleVector)a.get((long)i)).toArray();
        }
        return result;
    }
}

