/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.gui.shape;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import io.deephaven.gui.shape.NamedShape;
import io.deephaven.gui.shape.Shape;
import java.awt.Polygon;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class JShapes
implements Shape {
    private static final long serialVersionUID = 4371847295627181055L;
    private final java.awt.Shape shape;
    private static final double SIZE = 6.0;
    private static JShapes SQUARE = new JShapes(new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0));
    private static JShapes CIRCLE = new JShapes(new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
    private static JShapes UP_TRIANGLE = new JShapes(new Polygon(new int[]{0, 3, -3}, new int[]{-3, 3, 3}, 3));
    private static JShapes DIAMOND = new JShapes(new Polygon(new int[]{0, 3, 0, -3}, new int[]{-3, 0, 3, 0}, 4));
    private static JShapes HORIZONTAL_RECTANGLE = new JShapes(new Rectangle2D.Double(-3.0, -1.5, 6.0, 3.0));
    private static JShapes ELLIPSE = new JShapes(new Ellipse2D.Double(-3.0, -1.5, 6.0, 3.0));
    private static JShapes DOWN_TRIANGLE = new JShapes(new Polygon(new int[]{-3, 3, 0}, new int[]{-3, -3, 3}, 3));
    private static JShapes RIGHT_TRIANGLE = new JShapes(new Polygon(new int[]{-3, 3, -3}, new int[]{-3, 0, 3}, 3));
    private static JShapes VERTICAL_RECTANGLE = new JShapes(new Rectangle2D.Double(-1.5, -3.0, 3.0, 6.0));
    private static JShapes LEFT_TRIANGLE = new JShapes(new Polygon(new int[]{-3, 3, 3}, new int[]{0, -3, 3}, 3));
    private static final BiMap<NamedShape, JShapes> shapeStringToInstanceMap = ImmutableBiMap.builder().put((Object)NamedShape.SQUARE, (Object)SQUARE).put((Object)NamedShape.CIRCLE, (Object)CIRCLE).put((Object)NamedShape.UP_TRIANGLE, (Object)UP_TRIANGLE).put((Object)NamedShape.DIAMOND, (Object)DIAMOND).put((Object)NamedShape.HORIZONTAL_RECTANGLE, (Object)HORIZONTAL_RECTANGLE).put((Object)NamedShape.ELLIPSE, (Object)ELLIPSE).put((Object)NamedShape.DOWN_TRIANGLE, (Object)DOWN_TRIANGLE).put((Object)NamedShape.RIGHT_TRIANGLE, (Object)RIGHT_TRIANGLE).put((Object)NamedShape.VERTICAL_RECTANGLE, (Object)VERTICAL_RECTANGLE).put((Object)NamedShape.LEFT_TRIANGLE, (Object)LEFT_TRIANGLE).build();

    public JShapes(java.awt.Shape shape) {
        this.shape = shape;
    }

    public static JShapes shape(NamedShape shape) {
        return (JShapes)shapeStringToInstanceMap.get((Object)shape);
    }

    public static NamedShape shape(JShapes shape) {
        return (NamedShape)shapeStringToInstanceMap.inverse().get((Object)shape);
    }

    public java.awt.Shape getShape() {
        return this.shape;
    }
}

