/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.Series;
import io.deephaven.plot.SeriesInternal;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.PartitionedTableHandle;
import io.deephaven.plot.util.tables.SwappableTable;
import io.deephaven.plot.util.tables.TableHandle;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class AbstractSeriesInternal
implements Series,
SeriesInternal {
    private static final long serialVersionUID = 156282740742368526L;
    private final AxesImpl axes;
    private final int id;
    private final Comparable name;
    private final Set<TableHandle> tableHandles = new CopyOnWriteArraySet<TableHandle>();
    private final Set<SwappableTable> swappableTables = new CopyOnWriteArraySet<SwappableTable>();
    private final Set<PartitionedTableHandle> partitionedTableHandles = new CopyOnWriteArraySet<PartitionedTableHandle>();

    protected AbstractSeriesInternal(AxesImpl axes, int id, Comparable name) {
        ArgumentValidations.assertNotNull(axes, "Axes must not be null", null);
        ArgumentValidations.assertNotNull(name, "Series name must not be null", axes.getPlotInfo());
        this.axes = axes;
        this.id = id;
        this.name = name;
    }

    protected AbstractSeriesInternal(AbstractSeriesInternal series, AxesImpl axes) {
        this.axes = axes;
        this.id = series.id;
        this.name = series.name;
        this.tableHandles.addAll(series.tableHandles);
        this.partitionedTableHandles.addAll(series.partitionedTableHandles);
        this.swappableTables.addAll(series.swappableTables);
    }

    @Override
    public AxesImpl axes() {
        return this.axes;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public Comparable name() {
        return this.name;
    }

    @Override
    public void addTableHandle(TableHandle h) {
        this.tableHandles.add(h);
    }

    @Override
    public void removeTableHandle(TableHandle h) {
        this.tableHandles.remove(h);
    }

    @Override
    public Set<TableHandle> getTableHandles() {
        return this.tableHandles;
    }

    @Override
    public void addPartitionedTableHandle(PartitionedTableHandle map) {
        this.partitionedTableHandles.add(map);
    }

    @Override
    public Set<PartitionedTableHandle> getPartitionedTableHandles() {
        return this.partitionedTableHandles;
    }

    @Override
    public void addSwappableTable(SwappableTable st) {
        this.swappableTables.add(st);
        this.addPartitionedTableHandle(st.getPartitionedTableHandle());
    }

    @Override
    public Set<SwappableTable> getSwappableTables() {
        return this.swappableTables;
    }
}

