/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import groovy.lang.Closure;
import io.deephaven.api.ColumnName;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.table.impl.MemoizedOperationKey;
import io.deephaven.gui.color.Color;
import io.deephaven.gui.color.Paint;
import io.deephaven.plot.Axes;
import io.deephaven.plot.AxisImpl;
import io.deephaven.plot.ChartImpl;
import io.deephaven.plot.ChartType;
import io.deephaven.plot.Font;
import io.deephaven.plot.PlotStyle;
import io.deephaven.plot.SeriesCollection;
import io.deephaven.plot.SeriesInternal;
import io.deephaven.plot.axisformatters.AxisFormat;
import io.deephaven.plot.axisformatters.NanosAxisFormat;
import io.deephaven.plot.axistransformations.AxisTransform;
import io.deephaven.plot.datasets.category.CategoryDataSeries;
import io.deephaven.plot.datasets.category.CategoryDataSeriesInternal;
import io.deephaven.plot.datasets.category.CategoryDataSeriesMap;
import io.deephaven.plot.datasets.category.CategoryDataSeriesPartitionedTable;
import io.deephaven.plot.datasets.category.CategoryDataSeriesSwappablePartitionedTable;
import io.deephaven.plot.datasets.category.CategoryTreemapDataSeriesTableMap;
import io.deephaven.plot.datasets.categoryerrorbar.CategoryErrorBarDataSeriesMap;
import io.deephaven.plot.datasets.categoryerrorbar.CategoryErrorBarDataSeriesPartitionedTable;
import io.deephaven.plot.datasets.categoryerrorbar.CategoryErrorBarDataSeriesSwappablePartitionedTable;
import io.deephaven.plot.datasets.data.IndexableData;
import io.deephaven.plot.datasets.data.IndexableDataArray;
import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayDate;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayDateTime;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayDouble;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayFloat;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayInt;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayLong;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayNumber;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayShort;
import io.deephaven.plot.datasets.data.IndexableNumericDataListNumber;
import io.deephaven.plot.datasets.data.IndexableNumericDataSwappableTable;
import io.deephaven.plot.datasets.data.IndexableNumericDataTable;
import io.deephaven.plot.datasets.histogram.HistogramCalculator;
import io.deephaven.plot.datasets.interval.IntervalXYDataSeriesArray;
import io.deephaven.plot.datasets.multiseries.MultiCatErrorBarSeries;
import io.deephaven.plot.datasets.multiseries.MultiCatErrorBarSeriesSwappable;
import io.deephaven.plot.datasets.multiseries.MultiCatSeries;
import io.deephaven.plot.datasets.multiseries.MultiCatSeriesSwappable;
import io.deephaven.plot.datasets.multiseries.MultiOHLCSeries;
import io.deephaven.plot.datasets.multiseries.MultiOHLCSeriesSwappable;
import io.deephaven.plot.datasets.multiseries.MultiSeries;
import io.deephaven.plot.datasets.multiseries.MultiXYErrorBarSeries;
import io.deephaven.plot.datasets.multiseries.MultiXYErrorBarSeriesSwappable;
import io.deephaven.plot.datasets.multiseries.MultiXYSeries;
import io.deephaven.plot.datasets.multiseries.MultiXYSeriesSwappable;
import io.deephaven.plot.datasets.ohlc.OHLCDataSeriesArray;
import io.deephaven.plot.datasets.ohlc.OHLCDataSeriesSwappableTableArray;
import io.deephaven.plot.datasets.ohlc.OHLCDataSeriesTableArray;
import io.deephaven.plot.datasets.xy.XYDataSeriesArray;
import io.deephaven.plot.datasets.xy.XYDataSeriesFunctionImpl;
import io.deephaven.plot.datasets.xy.XYDataSeriesSwappableTableArray;
import io.deephaven.plot.datasets.xy.XYDataSeriesTableArray;
import io.deephaven.plot.datasets.xyerrorbar.XYErrorBarDataSeries;
import io.deephaven.plot.datasets.xyerrorbar.XYErrorBarDataSeriesArray;
import io.deephaven.plot.datasets.xyerrorbar.XYErrorBarDataSeriesSwappableTableArray;
import io.deephaven.plot.datasets.xyerrorbar.XYErrorBarDataSeriesTableArray;
import io.deephaven.plot.errors.PlotExceptionCause;
import io.deephaven.plot.errors.PlotIllegalArgumentException;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.filters.SelectableDataSet;
import io.deephaven.plot.filters.SelectableDataSetOneClick;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.PlotUtils;
import io.deephaven.plot.util.functions.ClosureDoubleUnaryOperator;
import io.deephaven.plot.util.tables.PartitionedTableHandle;
import io.deephaven.plot.util.tables.SwappableTable;
import io.deephaven.plot.util.tables.TableBackedPartitionedTableHandle;
import io.deephaven.plot.util.tables.TableHandle;
import io.deephaven.time.DateTime;
import io.deephaven.time.calendar.BusinessCalendar;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class AxesImpl
implements Axes,
PlotExceptionCause {
    private static final long serialVersionUID = 6085888203519593898L;
    private final int id;
    private final String name;
    private final ChartImpl chart;
    private final AxisImpl[] axes;
    private final PlotInfo plotInfo;
    private PlotStyle plotStyle;
    private int dimension;
    private final SeriesCollection dataSeries;

    AxesImpl(int id, String name, ChartImpl chart, AxisImpl[] axes) {
        this.id = id;
        this.name = name;
        this.chart = chart;
        this.axes = axes;
        this.plotInfo = new PlotInfo(chart.figure(), chart, (SeriesInternal)null);
        this.dataSeries = new SeriesCollection(this.getPlotInfo());
        this.dimension = -1;
    }

    private AxesImpl(AxesImpl axes, ChartImpl chart) {
        this.id = axes.id;
        this.name = axes.name;
        this.chart = chart;
        this.plotInfo = new PlotInfo(chart.figure(), chart, (SeriesInternal)null);
        this.axes = AxesImpl.copyAxes(axes, chart);
        this.plotStyle = axes.plotStyle;
        this.dataSeries = axes.dataSeries.copy(this);
        this.dimension = axes.dimension;
    }

    AxesImpl copy(ChartImpl chart) {
        return new AxesImpl(this, chart);
    }

    private static AxisImpl[] copyAxes(AxesImpl axes, ChartImpl chart) {
        AxisImpl[] rst = new AxisImpl[axes.axes.length];
        for (int dim = 0; dim < rst.length; ++dim) {
            int id = axes.axes[dim].id();
            rst[dim] = chart.getAxis()[dim].get(id);
        }
        return rst;
    }

    @Override
    public PlotInfo getPlotInfo() {
        return this.plotInfo;
    }

    public ChartImpl chart() {
        return this.chart;
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    int dimension() {
        if (this.axes == null) {
            return -1;
        }
        return this.dimension;
    }

    void setDimension(int dim) {
        if (this.dimension != -1 && this.dimension != dim) {
            throw new PlotUnsupportedOperationException("Plots with different dimensions are not supported in a single chart.", this);
        }
        this.dimension = dim;
    }

    public SeriesCollection dataSeries() {
        return this.dataSeries;
    }

    public PlotStyle getPlotStyle() {
        if (this.plotStyle != null) {
            return this.plotStyle;
        }
        switch (this.chart.getChartType()) {
            case CATEGORY: {
                return PlotStyle.BAR;
            }
            case XY: {
                return PlotStyle.LINE;
            }
            case OHLC: {
                return PlotStyle.OHLC;
            }
            case PIE: {
                return PlotStyle.PIE;
            }
            case TREEMAP: {
                return PlotStyle.TREEMAP;
            }
        }
        throw new PlotUnsupportedOperationException("No default plot style for chart type: " + this.chart.getChartType(), this);
    }

    private void configureXYPlot() {
        this.setDimension(2);
        this.chart.setChartType(ChartType.XY);
        this.xAxis().setType(AxisImpl.Type.NUMBER);
        this.yAxis().setType(AxisImpl.Type.NUMBER);
        this.initialize();
    }

    private void configureCategoryPlot() {
        this.setDimension(2);
        this.chart.setChartType(ChartType.CATEGORY);
        this.xAxis().setType(AxisImpl.Type.CATEGORY);
        this.yAxis().setType(AxisImpl.Type.NUMBER);
        this.initialize();
    }

    private void configurePiePlot() {
        this.setDimension(2);
        this.chart.setChartType(ChartType.PIE);
        this.xAxis().setType(AxisImpl.Type.CATEGORY);
        this.yAxis().setType(AxisImpl.Type.NUMBER);
        this.initialize();
    }

    private void configureOHLCPlot() {
        this.setDimension(2);
        this.chart.setChartType(ChartType.OHLC);
        this.xAxis().setType(AxisImpl.Type.NUMBER);
        this.yAxis().setType(AxisImpl.Type.NUMBER);
        this.initialize();
    }

    private void configureTreemapPlot() {
        this.setDimension(2);
        this.chart.setChartType(ChartType.TREEMAP);
        this.xAxis().setType(AxisImpl.Type.CATEGORY);
        this.yAxis().setType(AxisImpl.Type.NUMBER);
        this.initialize();
    }

    private void initialize() {
        this.chart.setInitialized(true);
    }

    private void registerDataSeries(SeriesCollection.SeriesType type, boolean isMultiSeries, SeriesInternal series) {
        this.dataSeries.add(type, isMultiSeries, series);
    }

    private static SelectableDataSet getAggregatedSelectableDataSet(SelectableDataSet sds, Supplier<Collection<? extends Aggregation>> aggSupplier, List<String> byColumns) {
        ArrayList<String> cols = new ArrayList<String>(byColumns);
        if (sds instanceof SelectableDataSetOneClick) {
            Collections.addAll(cols, ((SelectableDataSetOneClick)sds).getByColumns());
        }
        Collection<? extends Aggregation> aggs = aggSupplier.get();
        List columnNames = ColumnName.from(cols);
        Function<Table, Table> applyAggs = t -> (Table)t.aggBy(aggs, columnNames);
        return sds.transform(MemoizedOperationKey.aggBy(aggs, (boolean)false, null, (Collection)columnNames), applyAggs);
    }

    private static SelectableDataSet getLastBySelectableDataSet(SelectableDataSet sds, String ... columns) {
        ArrayList<String> cols = new ArrayList<String>();
        Collections.addAll(cols, columns);
        return AxesImpl.getLastBySelectableDataSet(sds, cols);
    }

    private static SelectableDataSet getLastBySelectableDataSet(SelectableDataSet sds, Collection<String> columns) {
        if (sds instanceof SelectableDataSetOneClick) {
            Collections.addAll(columns, ((SelectableDataSetOneClick)sds).getByColumns());
        }
        return sds.transform(columns, t -> ((Table)t).lastBy(columns));
    }

    public Set<SwappableTable> getSwappableTables() {
        HashSet<SwappableTable> result = new HashSet<SwappableTable>();
        for (AxisImpl axis : this.axes) {
            result.addAll(axis.getSwappableTables());
        }
        for (SeriesCollection.SeriesDescription seriesDescription : this.dataSeries().getSeriesDescriptions().values()) {
            result.addAll(seriesDescription.getSeries().getSwappableTables());
        }
        return result;
    }

    public Set<PartitionedTableHandle> getPartitionedTableHandles() {
        HashSet<PartitionedTableHandle> result = new HashSet<PartitionedTableHandle>();
        for (AxisImpl axis : this.axes) {
            result.addAll(axis.getPartitionedTableHandles());
        }
        for (SeriesCollection.SeriesDescription seriesDescription : this.dataSeries().getSeriesDescriptions().values()) {
            result.addAll(seriesDescription.getSeries().getPartitionedTableHandles());
        }
        return result;
    }

    public AxisImpl[] getAxes() {
        return this.axes;
    }

    @Override
    public AxesImpl axesRemoveSeries(String ... removeSeriesNames) {
        this.dataSeries.remove((Comparable[])removeSeriesNames);
        return this;
    }

    @Override
    public SeriesInternal series(int id) {
        return this.dataSeries.series(id);
    }

    @Override
    public SeriesInternal series(Comparable name) {
        return this.dataSeries.series(name);
    }

    @Override
    public AxesImpl plotStyle(PlotStyle plotStyle) {
        ArgumentValidations.assertNotNull((Object)plotStyle, "style", this.getPlotInfo());
        this.plotStyle = plotStyle;
        return this;
    }

    @Override
    public AxesImpl plotStyle(String plotStyle) {
        ArgumentValidations.assertNotNull(plotStyle, "style", this.getPlotInfo());
        this.plotStyle = PlotStyle.plotStyle(plotStyle);
        return this;
    }

    @Override
    public AxesImpl twin() {
        return this.twin(null);
    }

    @Override
    public AxesImpl twin(String name) {
        AxisImpl[] ax = (AxisImpl[])this.axes.clone();
        return this.chart.newAxes(ax, name);
    }

    @Override
    public AxesImpl twin(int dim) {
        return this.twin(null, dim);
    }

    @Override
    public AxesImpl twin(String name, int dim) {
        AxisImpl[] ax = (AxisImpl[])this.axes.clone();
        for (int i = 0; i < ax.length; ++i) {
            if (i == dim) continue;
            ax[i] = this.chart.newAxis(i);
        }
        return this.chart.newAxes(ax, name);
    }

    @Override
    public AxesImpl twinX() {
        return this.twin(0);
    }

    @Override
    public AxesImpl twinX(String name) {
        return this.twin(name, 0);
    }

    @Override
    public AxesImpl twinY() {
        return this.twin(1);
    }

    @Override
    public AxesImpl twinY(String name) {
        return this.twin(name, 1);
    }

    @Override
    public AxisImpl axis(int dim) {
        if (this.axes == null) {
            return null;
        }
        if (dim < 0 | dim >= this.axes.length) {
            throw new PlotIllegalArgumentException("Axis not found: index=" + dim + ", required in range = [0," + (this.axes.length - 1) + "]", this);
        }
        return this.axes[dim];
    }

    @Override
    public AxisImpl xAxis() {
        return this.axis(0);
    }

    @Override
    public AxisImpl yAxis() {
        return this.axis(1);
    }

    @Override
    public AxesImpl xFormat(AxisFormat axisFormat) {
        this.xAxis().axisFormat(axisFormat);
        return this;
    }

    @Override
    public AxesImpl yFormat(AxisFormat axisFormat) {
        this.yAxis().axisFormat(axisFormat);
        return this;
    }

    @Override
    public AxesImpl xFormatPattern(String axisFormatPattern) {
        this.xAxis().axisFormatPattern(axisFormatPattern);
        return this;
    }

    @Override
    public AxesImpl yFormatPattern(String axisFormatPattern) {
        this.yAxis().axisFormatPattern(axisFormatPattern);
        return this;
    }

    @Override
    public AxesImpl xColor(Paint color) {
        this.xAxis().axisColor(color);
        return this;
    }

    @Override
    public AxesImpl xColor(String color) {
        return this.xColor((Paint)Color.color((String)color));
    }

    @Override
    public AxesImpl yColor(Paint color) {
        this.yAxis().axisColor(color);
        return this;
    }

    @Override
    public AxesImpl yColor(String color) {
        return this.yColor((Paint)Color.color((String)color));
    }

    @Override
    public AxesImpl xLabel(String label) {
        this.xAxis().axisLabel(label);
        return this;
    }

    @Override
    public AxesImpl yLabel(String label) {
        this.yAxis().axisLabel(label);
        return this;
    }

    @Override
    public AxesImpl xLabelFont(Font font) {
        this.xAxis().axisLabelFont(font);
        return this;
    }

    @Override
    public AxesImpl yLabelFont(Font font) {
        this.yAxis().axisLabelFont(font);
        return this;
    }

    @Override
    public AxesImpl xLabelFont(String family, String style, int size) {
        this.xAxis().axisLabelFont(family, style, size);
        return this;
    }

    @Override
    public AxesImpl yLabelFont(String family, String style, int size) {
        this.yAxis().axisLabelFont(family, style, size);
        return this;
    }

    @Override
    public AxesImpl xTicksFont(Font font) {
        this.xAxis().ticksFont(font);
        return this;
    }

    @Override
    public AxesImpl yTicksFont(Font font) {
        this.yAxis().ticksFont(font);
        return this;
    }

    @Override
    public AxesImpl xTicksFont(String family, String style, int size) {
        this.xAxis().ticksFont(family, style, size);
        return this;
    }

    @Override
    public AxesImpl yTicksFont(String family, String style, int size) {
        this.yAxis().ticksFont(family, style, size);
        return this;
    }

    @Override
    public AxesImpl xTransform(AxisTransform transform) {
        this.xAxis().transform(transform);
        return this;
    }

    @Override
    public AxesImpl yTransform(AxisTransform transform) {
        this.yAxis().transform(transform);
        return this;
    }

    @Override
    public AxesImpl xLog() {
        this.xAxis().log();
        return this;
    }

    @Override
    public AxesImpl yLog() {
        this.yAxis().log();
        return this;
    }

    @Override
    public AxesImpl xLog(boolean useLog) {
        this.xAxis().log(useLog);
        return this;
    }

    @Override
    public AxesImpl yLog(boolean useLog) {
        this.yAxis().log(useLog);
        return this;
    }

    @Override
    public AxesImpl xBusinessTime(BusinessCalendar calendar) {
        this.xAxis().businessTime(calendar);
        return this;
    }

    @Override
    public AxesImpl yBusinessTime(BusinessCalendar calendar) {
        this.yAxis().businessTime(calendar);
        return this;
    }

    @Override
    public AxesImpl xBusinessTime(SelectableDataSet sds, String calendar) {
        this.xAxis().businessTime(sds, calendar);
        return this;
    }

    @Override
    public AxesImpl yBusinessTime(SelectableDataSet sds, String calendar) {
        this.yAxis().businessTime(sds, calendar);
        return this;
    }

    @Override
    public AxesImpl xBusinessTime() {
        this.xAxis().businessTime();
        return this;
    }

    @Override
    public AxesImpl yBusinessTime() {
        this.yAxis().businessTime();
        return this;
    }

    @Override
    public AxesImpl xBusinessTime(boolean useBusinessTime) {
        this.xAxis().businessTime(useBusinessTime);
        return this;
    }

    @Override
    public AxesImpl yBusinessTime(boolean useBusinessTime) {
        this.yAxis().businessTime(useBusinessTime);
        return this;
    }

    @Override
    public AxesImpl xInvert() {
        this.xAxis().invert();
        return this;
    }

    @Override
    public AxesImpl xInvert(boolean invert) {
        this.xAxis().invert(invert);
        return this;
    }

    @Override
    public AxesImpl yInvert() {
        this.yAxis().invert();
        return this;
    }

    @Override
    public AxesImpl yInvert(boolean invert) {
        this.yAxis().invert(invert);
        return this;
    }

    @Override
    public AxesImpl xRange(double min, double max) {
        this.xAxis().range(min, max);
        return this;
    }

    @Override
    public AxesImpl yRange(double min, double max) {
        this.yAxis().range(min, max);
        return this;
    }

    @Override
    public AxesImpl xMin(double min) {
        this.xAxis().min(min);
        return this;
    }

    @Override
    public AxesImpl yMin(double min) {
        this.yAxis().min(min);
        return this;
    }

    @Override
    public AxesImpl xMin(SelectableDataSet sds, String min) {
        this.xAxis().min(sds, min);
        return this;
    }

    @Override
    public AxesImpl yMin(SelectableDataSet sds, String min) {
        this.yAxis().min(sds, min);
        return this;
    }

    @Override
    public AxesImpl xMax(double max) {
        this.xAxis().max(max);
        return this;
    }

    @Override
    public AxesImpl yMax(double max) {
        this.yAxis().max(max);
        return this;
    }

    @Override
    public AxesImpl xMax(SelectableDataSet sds, String max) {
        this.xAxis().max(sds, max);
        return this;
    }

    @Override
    public AxesImpl yMax(SelectableDataSet sds, String max) {
        this.yAxis().max(sds, max);
        return this;
    }

    @Override
    public AxesImpl xTicksVisible(boolean visible) {
        this.xAxis().ticksVisible(visible);
        return this;
    }

    @Override
    public AxesImpl yTicksVisible(boolean visible) {
        this.yAxis().ticksVisible(visible);
        return this;
    }

    @Override
    public AxesImpl xTicks(double gapBetweenTicks) {
        this.xAxis().ticks(gapBetweenTicks);
        return this;
    }

    @Override
    public AxesImpl yTicks(double gapBetweenTicks) {
        this.yAxis().ticks(gapBetweenTicks);
        return this;
    }

    @Override
    public AxesImpl xTicks(double[] tickLocations) {
        this.xAxis().ticks(tickLocations);
        return this;
    }

    @Override
    public AxesImpl yTicks(double[] tickLocations) {
        this.yAxis().ticks(tickLocations);
        return this;
    }

    @Override
    public AxesImpl xMinorTicksVisible(boolean visible) {
        this.xAxis().minorTicksVisible(visible);
        return this;
    }

    @Override
    public AxesImpl yMinorTicksVisible(boolean visible) {
        this.yAxis().minorTicksVisible(visible);
        return this;
    }

    @Override
    public AxesImpl xMinorTicks(int nminor) {
        this.xAxis().minorTicks(nminor);
        return this;
    }

    @Override
    public AxesImpl yMinorTicks(int nminor) {
        this.yAxis().minorTicks(nminor);
        return this;
    }

    @Override
    public AxesImpl xTickLabelAngle(double angle) {
        this.xAxis().tickLabelAngle(angle);
        return this;
    }

    @Override
    public AxesImpl yTickLabelAngle(double angle) {
        this.yAxis().tickLabelAngle(angle);
        return this;
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, Table t, String x, String xLow, String xHigh, String y, String yLow, String yHigh) {
        TableHandle h = new TableHandle(t, x, xLow, xHigh, y, yLow, yHigh);
        boolean hasXTimeAxis = ArgumentValidations.isTime(t, x, new PlotInfo(this, seriesName));
        boolean hasYTimeAxis = ArgumentValidations.isTime(t, y, new PlotInfo(this, seriesName));
        XYErrorBarDataSeriesTableArray ds = new XYErrorBarDataSeriesTableArray(this, this.dataSeries.nextId(), seriesName, h, x, xLow, xHigh, y, yLow, yHigh, true, true);
        return this.errorBarXY(ds, hasXTimeAxis, hasYTimeAxis, new TableHandle[]{h}, null);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, SelectableDataSet sds, String x, String xLow, String xHigh, String y, String yLow, String yHigh) {
        SwappableTable t = sds.getSwappableTable(seriesName, this.chart, x, xLow, xHigh, y, yLow, yHigh);
        boolean hasXTimeAxis = ArgumentValidations.isTime(sds, x, new PlotInfo(this, seriesName));
        boolean hasYTimeAxis = ArgumentValidations.isTime(sds, y, new PlotInfo(this, seriesName));
        XYErrorBarDataSeriesSwappableTableArray ds = new XYErrorBarDataSeriesSwappableTableArray(this, this.dataSeries.nextId(), seriesName, t, x, xLow, xHigh, y, yLow, yHigh, true, true);
        return this.errorBarXY(ds, hasXTimeAxis, hasYTimeAxis, null, new SwappableTable[]{t});
    }

    @Override
    public MultiXYErrorBarSeries errorBarXYBy(Comparable seriesName, Table t, String x, String xLow, String xHigh, String y, String yLow, String yHigh, String ... byColumns) {
        ArgumentValidations.assertNotNull(t, "t", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(x, "x", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(xLow, "xLow", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(xHigh, "xHigh", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(y, "y", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(yLow, "yLow", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(yHigh, "yHigh", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNullAndNotEmpty(byColumns, "byColumns", new PlotInfo(this, seriesName));
        this.configureXYPlot();
        TableBackedPartitionedTableHandle h = new TableBackedPartitionedTableHandle(t, Arrays.asList(x, xLow, xHigh, y, yLow, yHigh), byColumns, new PlotInfo(this, seriesName));
        MultiXYErrorBarSeries series = new MultiXYErrorBarSeries(this, this.dataSeries.nextId(), seriesName, h, x, xLow, xHigh, y, yLow, yHigh, byColumns, true, true);
        if (ArgumentValidations.isTime(t, x, new PlotInfo(this, seriesName))) {
            this.axes[0].axisFormat(new NanosAxisFormat());
        }
        if (ArgumentValidations.isTime(t, y, new PlotInfo(this, seriesName))) {
            this.axes[1].axisFormat(new NanosAxisFormat());
        }
        this.registerDataSeries(SeriesCollection.SeriesType.XY, true, series);
        return series;
    }

    @Override
    public MultiXYErrorBarSeriesSwappable errorBarXYBy(Comparable seriesName, SelectableDataSet sds, String x, String xLow, String xHigh, String y, String yLow, String yHigh, String ... byColumns) {
        ArgumentValidations.assertNotNull(sds, "sds", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(x, "x", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(xLow, "xLow", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(xHigh, "xHigh", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(y, "y", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(yLow, "yLow", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(yHigh, "yHigh", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNullAndNotEmpty(byColumns, "byColumns", new PlotInfo(this, seriesName));
        String[] columns = new String[byColumns.length + 6];
        columns[0] = x;
        columns[1] = xLow;
        columns[2] = xHigh;
        columns[3] = y;
        columns[4] = yLow;
        columns[5] = yHigh;
        System.arraycopy(byColumns, 0, columns, 6, byColumns.length);
        SwappableTable t = sds.getSwappableTable(seriesName, this.chart, columns);
        this.configureXYPlot();
        MultiXYErrorBarSeriesSwappable series = new MultiXYErrorBarSeriesSwappable(this, this.dataSeries.nextId(), seriesName, t, x, xLow, xHigh, y, yLow, yHigh, byColumns, true, true);
        this.setUpPlotBySeries(t.getTableDefinition(), x, y, (SeriesInternal)series);
        return series;
    }

    @Override
    public XYErrorBarDataSeries errorBarY(Comparable seriesName, Table t, String x, String y, String yLow, String yHigh) {
        TableHandle h = new TableHandle(t, x, y, yLow, yHigh);
        boolean hasXTimeAxis = ArgumentValidations.isTime(t, x, new PlotInfo(this, seriesName));
        boolean hasYTimeAxis = ArgumentValidations.isTime(t, y, new PlotInfo(this, seriesName));
        XYErrorBarDataSeriesTableArray ds = new XYErrorBarDataSeriesTableArray(this, this.dataSeries.nextId(), seriesName, h, x, null, null, y, yLow, yHigh, false, true);
        return this.errorBarXY(ds, hasXTimeAxis, hasYTimeAxis, new TableHandle[]{h}, null);
    }

    @Override
    public XYErrorBarDataSeries errorBarY(Comparable seriesName, SelectableDataSet sds, String x, String y, String yLow, String yHigh) {
        SwappableTable t = sds.getSwappableTable(seriesName, this.chart, x, y, yLow, yHigh);
        boolean hasXTimeAxis = ArgumentValidations.isTime(sds, x, new PlotInfo(this, seriesName));
        boolean hasYTimeAxis = ArgumentValidations.isTime(sds, y, new PlotInfo(this, seriesName));
        XYErrorBarDataSeriesSwappableTableArray ds = new XYErrorBarDataSeriesSwappableTableArray(this, this.dataSeries.nextId(), seriesName, t, x, null, null, y, yLow, yHigh, false, true);
        return this.errorBarXY(ds, hasXTimeAxis, hasYTimeAxis, null, new SwappableTable[]{t});
    }

    @Override
    public MultiXYErrorBarSeries errorBarYBy(Comparable seriesName, Table t, String x, String y, String yLow, String yHigh, String ... byColumns) {
        ArgumentValidations.assertNotNull(t, "t", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(x, "x", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(y, "y", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(yLow, "yLow", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(yHigh, "yHigh", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNullAndNotEmpty(byColumns, "byColumns", new PlotInfo(this, seriesName));
        this.configureXYPlot();
        TableBackedPartitionedTableHandle h = new TableBackedPartitionedTableHandle(t, Arrays.asList(x, y, yLow, yHigh), byColumns, new PlotInfo(this, seriesName));
        MultiXYErrorBarSeries series = new MultiXYErrorBarSeries(this, this.dataSeries.nextId(), seriesName, h, x, null, null, y, yLow, yHigh, byColumns, false, true);
        if (ArgumentValidations.isTime(t, x, new PlotInfo(this, seriesName))) {
            this.axes[0].axisFormat(new NanosAxisFormat());
        }
        if (ArgumentValidations.isTime(t, y, new PlotInfo(this, seriesName))) {
            this.axes[1].axisFormat(new NanosAxisFormat());
        }
        this.registerDataSeries(SeriesCollection.SeriesType.XY, true, series);
        return series;
    }

    @Override
    public MultiXYErrorBarSeriesSwappable errorBarYBy(Comparable seriesName, SelectableDataSet sds, String x, String y, String yLow, String yHigh, String ... byColumns) {
        ArgumentValidations.assertNotNull(sds, "sds", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(x, "x", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(y, "y", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(yLow, "yLow", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(yHigh, "yHigh", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNullAndNotEmpty(byColumns, "byColumns", new PlotInfo(this, seriesName));
        String[] columns = new String[byColumns.length + 4];
        columns[0] = x;
        columns[1] = y;
        columns[2] = yLow;
        columns[3] = yHigh;
        System.arraycopy(byColumns, 0, columns, 4, byColumns.length);
        SwappableTable t = sds.getSwappableTable(seriesName, this.chart, columns);
        this.configureXYPlot();
        MultiXYErrorBarSeriesSwappable series = new MultiXYErrorBarSeriesSwappable(this, this.dataSeries.nextId(), seriesName, t, x, null, null, y, yLow, yHigh, byColumns, false, true);
        this.setUpPlotBySeries(t.getTableDefinition(), x, y, (SeriesInternal)series);
        return series;
    }

    @Override
    public XYErrorBarDataSeries errorBarX(Comparable seriesName, Table t, String x, String xLow, String xHigh, String y) {
        TableHandle h = new TableHandle(t, x, xLow, xHigh, y);
        boolean hasXTimeAxis = ArgumentValidations.isTime(t, x, new PlotInfo(this, seriesName));
        boolean hasYTimeAxis = ArgumentValidations.isTime(t, y, new PlotInfo(this, seriesName));
        XYErrorBarDataSeriesTableArray ds = new XYErrorBarDataSeriesTableArray(this, this.dataSeries.nextId(), seriesName, h, x, xLow, xHigh, y, null, null, true, false);
        return this.errorBarXY(ds, hasXTimeAxis, hasYTimeAxis, new TableHandle[]{h}, null);
    }

    @Override
    public XYErrorBarDataSeries errorBarX(Comparable seriesName, SelectableDataSet sds, String x, String xLow, String xHigh, String y) {
        SwappableTable t = sds.getSwappableTable(seriesName, this.chart, x, xLow, xHigh, y);
        boolean hasXTimeAxis = ArgumentValidations.isTime(sds, x, new PlotInfo(this, seriesName));
        boolean hasYTimeAxis = ArgumentValidations.isTime(sds, y, new PlotInfo(this, seriesName));
        XYErrorBarDataSeriesSwappableTableArray ds = new XYErrorBarDataSeriesSwappableTableArray(this, this.dataSeries.nextId(), seriesName, t, x, xLow, xHigh, y, null, null, true, false);
        return this.errorBarXY(ds, hasXTimeAxis, hasYTimeAxis, null, new SwappableTable[]{t});
    }

    @Override
    public MultiXYErrorBarSeries errorBarXBy(Comparable seriesName, Table t, String x, String xLow, String xHigh, String y, String ... byColumns) {
        ArgumentValidations.assertNotNull(t, "t", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(x, "x", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(xLow, "xLow", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(xHigh, "xHigh", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(y, "y", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNullAndNotEmpty(byColumns, "byColumns", new PlotInfo(this, seriesName));
        this.configureXYPlot();
        TableBackedPartitionedTableHandle h = new TableBackedPartitionedTableHandle(t, Arrays.asList(x, xLow, xHigh, y), byColumns, new PlotInfo(this, seriesName));
        MultiXYErrorBarSeries series = new MultiXYErrorBarSeries(this, this.dataSeries.nextId(), seriesName, h, x, xLow, xHigh, y, null, null, byColumns, true, false);
        if (ArgumentValidations.isTime(t, x, new PlotInfo(this, seriesName))) {
            this.axes[0].axisFormat(new NanosAxisFormat());
        }
        if (ArgumentValidations.isTime(t, y, new PlotInfo(this, seriesName))) {
            this.axes[1].axisFormat(new NanosAxisFormat());
        }
        this.registerDataSeries(SeriesCollection.SeriesType.XY, true, series);
        return series;
    }

    @Override
    public MultiXYErrorBarSeriesSwappable errorBarXBy(Comparable seriesName, SelectableDataSet sds, String x, String xLow, String xHigh, String y, String ... byColumns) {
        ArgumentValidations.assertNotNull(sds, "sds", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(x, "x", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(xLow, "xLow", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(xHigh, "xHigh", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(y, "y", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNullAndNotEmpty(byColumns, "byColumns", new PlotInfo(this, seriesName));
        String[] columns = new String[byColumns.length + 4];
        columns[0] = x;
        columns[1] = xLow;
        columns[2] = xHigh;
        columns[3] = y;
        System.arraycopy(byColumns, 0, columns, 4, byColumns.length);
        SwappableTable t = sds.getSwappableTable(seriesName, this.chart, columns);
        this.configureXYPlot();
        MultiXYErrorBarSeriesSwappable series = new MultiXYErrorBarSeriesSwappable(this, this.dataSeries.nextId(), seriesName, t, x, xLow, xHigh, y, null, null, byColumns, true, false);
        this.setUpPlotBySeries(t.getTableDefinition(), x, y, (SeriesInternal)series);
        return series;
    }

    private XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, IndexableNumericData x, IndexableNumericData xLow, IndexableNumericData xHigh, IndexableNumericData y, IndexableNumericData yLow, IndexableNumericData yHigh, boolean hasXTimeAxis, boolean hasYTimeAxis) {
        return this.errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh, true, true, hasXTimeAxis, hasYTimeAxis);
    }

    private XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, IndexableNumericData x, IndexableNumericData xLow, IndexableNumericData xHigh, IndexableNumericData y, boolean drawXError, boolean drawYError, boolean hasXTimeAxis, boolean hasYTimeAxis) {
        return this.errorBarXY(seriesName, x, xLow, xHigh, y, null, null, drawXError, drawYError, hasXTimeAxis, hasYTimeAxis);
    }

    private XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, IndexableNumericData x, IndexableNumericData y, IndexableNumericData yLow, IndexableNumericData yHigh, boolean drawXError, boolean drawYError, boolean hasXTimeAxis, boolean hasYTimeAxis) {
        return this.errorBarXY(seriesName, x, null, null, y, yLow, yHigh, drawXError, drawYError, hasXTimeAxis, hasYTimeAxis);
    }

    private XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, IndexableNumericData x, IndexableNumericData xLow, IndexableNumericData xHigh, IndexableNumericData y, IndexableNumericData yLow, IndexableNumericData yHigh, boolean drawXError, boolean drawYError, boolean hasXTimeAxis, boolean hasYTimeAxis) {
        XYErrorBarDataSeriesArray ds = new XYErrorBarDataSeriesArray(this, this.dataSeries.nextId(), seriesName, x, xLow, xHigh, y, yLow, yHigh, drawXError, drawYError);
        return this.errorBarXY(ds, hasXTimeAxis, hasYTimeAxis, null, null);
    }

    private XYErrorBarDataSeriesArray errorBarXY(XYErrorBarDataSeriesArray series, boolean hasXTimeAxis, boolean hasYTimeAxis, TableHandle[] tableHandles, SwappableTable[] swappableTables) {
        this.configureXYPlot();
        if (tableHandles != null) {
            for (Serializable serializable : tableHandles) {
                series.addTableHandle((TableHandle)serializable);
            }
        }
        if (swappableTables != null) {
            for (Serializable serializable : swappableTables) {
                series.addSwappableTable((SwappableTable)serializable);
            }
        }
        if (hasXTimeAxis) {
            this.axes[0].axisFormat(new NanosAxisFormat());
        }
        if (hasYTimeAxis) {
            this.axes[1].axisFormat(new NanosAxisFormat());
        }
        this.registerDataSeries(SeriesCollection.SeriesType.XY, false, series);
        return series;
    }

    @Override
    public CategoryDataSeries catErrorBar(Comparable seriesName, Table t, String categories, String y, String yLow, String yHigh) {
        TableHandle h = PlotUtils.createCategoryTableHandle(t, categories, y, yLow, yHigh);
        if (ArgumentValidations.isTime(t, y, new PlotInfo(this, seriesName))) {
            this.axes[1].axisFormat(new NanosAxisFormat());
        }
        return this.catPlot(new CategoryErrorBarDataSeriesPartitionedTable(this, this.dataSeries.nextId(), seriesName, h, categories, y, yLow, yHigh), new TableHandle[]{h}, null);
    }

    @Override
    public CategoryDataSeries catErrorBar(Comparable seriesName, SelectableDataSet sds, String categories, String y, String yLow, String yHigh) {
        SelectableDataSet lastBySelectableDataSet = AxesImpl.getAggregatedSelectableDataSet(sds, () -> PlotUtils.createCategoryAggs(Aggregation.AggLast((String[])new String[]{y, yLow, yHigh})), Collections.singletonList(categories));
        SwappableTable t = lastBySelectableDataSet.getSwappableTable(seriesName, this.chart, categories, y, yLow, yHigh, "__CAT_ORDER");
        if (ArgumentValidations.isTime(lastBySelectableDataSet, y, new PlotInfo(this, seriesName))) {
            this.axes[1].axisFormat(new NanosAxisFormat());
        }
        return this.catPlot(new CategoryErrorBarDataSeriesSwappablePartitionedTable(this, this.dataSeries.nextId(), seriesName, t, categories, y, yLow, yHigh), null, new SwappableTable[]{t});
    }

    @Override
    public MultiSeries catErrorBarBy(Comparable seriesName, Table t, String categories, String y, String yLow, String yHigh, String ... byColumns) {
        ArgumentValidations.assertNotNull(t, "t", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(categories, "categories", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(y, "values", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(yLow, "yLow", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(yHigh, "yHigh", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNullAndNotEmpty(byColumns, "byColumns", new PlotInfo(this, seriesName));
        this.configureCategoryPlot();
        TableBackedPartitionedTableHandle h = PlotUtils.createCategoryPartitionedTableHandle(t, categories, new String[]{y, yLow, yHigh}, byColumns, new PlotInfo(this, seriesName));
        MultiCatErrorBarSeries series = new MultiCatErrorBarSeries(this, this.dataSeries.nextId(), seriesName, h, categories, y, yLow, yHigh, byColumns);
        if (ArgumentValidations.isTime(t, y, new PlotInfo(this, seriesName))) {
            this.axes[1].axisFormat(new NanosAxisFormat());
        }
        this.registerDataSeries(SeriesCollection.SeriesType.CATEGORY, true, series);
        return series;
    }

    @Override
    public MultiSeries catErrorBarBy(Comparable seriesName, SelectableDataSet sds, String categories, String y, String yLow, String yHigh, String ... byColumns) {
        ArgumentValidations.assertNotNull(sds, "sds", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(categories, "categories", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(y, "values", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(yLow, "yLow", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(yHigh, "yHigh", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNullAndNotEmpty(byColumns, "byColumns", new PlotInfo(this, seriesName));
        ArrayList<String> allOfTheByColumns = new ArrayList<String>();
        allOfTheByColumns.add(categories);
        allOfTheByColumns.addAll(Arrays.asList(byColumns));
        SelectableDataSet lastBySelectableDataSet = AxesImpl.getAggregatedSelectableDataSet(sds, () -> PlotUtils.createCategoryAggs(Aggregation.AggLast((String[])new String[]{y, yLow, yHigh})), allOfTheByColumns);
        String[] columns = new String[byColumns.length + 5];
        columns[0] = categories;
        columns[1] = y;
        columns[2] = yLow;
        columns[3] = yHigh;
        columns[4] = "__CAT_ORDER";
        System.arraycopy(byColumns, 0, columns, 5, byColumns.length);
        SwappableTable t = lastBySelectableDataSet.getSwappableTable(seriesName, this.chart, columns);
        this.configureCategoryPlot();
        MultiCatErrorBarSeriesSwappable series = new MultiCatErrorBarSeriesSwappable(this, this.dataSeries.nextId(), seriesName, t, categories, y, yLow, yHigh, byColumns);
        if (ArgumentValidations.isTime(t.getTableDefinition(), y, new PlotInfo(this, seriesName))) {
            this.axes[1].axisFormat(new NanosAxisFormat());
        }
        this.registerDataSeries(SeriesCollection.SeriesType.CATEGORY, true, series);
        return series;
    }

    @Override
    public XYDataSeriesFunctionImpl plot(Comparable seriesName, DoubleUnaryOperator function) {
        this.configureXYPlot();
        XYDataSeriesFunctionImpl ds = new XYDataSeriesFunctionImpl(this, this.dataSeries.nextId(), seriesName, function);
        this.registerDataSeries(SeriesCollection.SeriesType.UNARY_FUNCTION, false, ds);
        ds.pointsVisible(false);
        ds.linesVisible(true);
        return ds;
    }

    @Override
    public <T extends Number> XYDataSeriesFunctionImpl plot(Comparable seriesName, Closure<T> function) {
        return this.plot(seriesName, new ClosureDoubleUnaryOperator<T>(function));
    }

    private XYDataSeriesArray plot(XYDataSeriesArray series, boolean hasXTimeAxis, boolean hasYTimeAxis, TableHandle[] tableHandles, SwappableTable[] swappableTables) {
        this.configureXYPlot();
        if (tableHandles != null) {
            for (Serializable serializable : tableHandles) {
                series.addTableHandle((TableHandle)serializable);
            }
        }
        if (swappableTables != null) {
            for (Serializable serializable : swappableTables) {
                series.addSwappableTable((SwappableTable)serializable);
            }
        }
        this.registerDataSeries(SeriesCollection.SeriesType.XY, false, series);
        if (hasXTimeAxis) {
            this.axes[0].axisFormat(new NanosAxisFormat());
        }
        if (hasYTimeAxis) {
            this.axes[1].axisFormat(new NanosAxisFormat());
        }
        return series;
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, IndexableNumericData x, IndexableNumericData y, boolean hasXTimeAxis, boolean hasYTimeAxis) {
        XYDataSeriesArray ds = new XYDataSeriesArray(this, this.dataSeries.nextId(), seriesName, x, y);
        return this.plot(ds, hasXTimeAxis, hasYTimeAxis, null, null);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, Table t, String x, String y) {
        TableHandle h = new TableHandle(t, x, y);
        boolean hasXTimeAxis = ArgumentValidations.isTime(t, x, new PlotInfo(this, seriesName));
        boolean hasYTimeAxis = ArgumentValidations.isTime(t, y, new PlotInfo(this, seriesName));
        XYDataSeriesTableArray ds = new XYDataSeriesTableArray(this, this.dataSeries.nextId(), seriesName, h, x, y);
        return this.plot(ds, hasXTimeAxis, hasYTimeAxis, new TableHandle[]{h}, null);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, SelectableDataSet sds, String x, String y) {
        SwappableTable t = sds.getSwappableTable(seriesName, this.chart, x, y);
        boolean hasXTimeAxis = ArgumentValidations.isTime(sds, x, new PlotInfo(this, seriesName));
        boolean hasYTimeAxis = ArgumentValidations.isTime(sds, y, new PlotInfo(this, seriesName));
        XYDataSeriesSwappableTableArray ds = new XYDataSeriesSwappableTableArray(this, this.dataSeries.nextId(), seriesName, t, x, y);
        return this.plot(ds, hasXTimeAxis, hasYTimeAxis, null, new SwappableTable[]{t});
    }

    @Override
    public MultiXYSeries plotBy(Comparable seriesName, Table t, String x, String y, String ... byColumns) {
        ArgumentValidations.assertNotNull(t, "t", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(x, "x", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(y, "y", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNullAndNotEmpty(byColumns, "byColumns", new PlotInfo(this, seriesName));
        this.configureXYPlot();
        TableBackedPartitionedTableHandle h = new TableBackedPartitionedTableHandle(t, Arrays.asList(x, y), byColumns, new PlotInfo(this, seriesName));
        MultiXYSeries series = new MultiXYSeries(this, this.dataSeries.nextId(), seriesName, h, x, y, byColumns);
        this.setUpPlotBySeries(t, x, y, (SeriesInternal)series);
        return series;
    }

    @Override
    public MultiXYSeriesSwappable plotBy(Comparable seriesName, SelectableDataSet sds, String x, String y, String ... byColumns) {
        ArgumentValidations.assertNotNull(sds, "sds", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(x, "x", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(y, "y", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNullAndNotEmpty(byColumns, "byColumns", new PlotInfo(this, seriesName));
        this.configureXYPlot();
        SwappableTable t = sds.getSwappableTable(seriesName, this.chart, this.combineColumns(x, y, byColumns));
        MultiXYSeriesSwappable series = new MultiXYSeriesSwappable(this, this.dataSeries.nextId(), seriesName, t, x, y, byColumns);
        this.setUpPlotBySeries(t.getTableDefinition(), x, y, (SeriesInternal)series);
        return series;
    }

    private String[] combineColumns(String x, String y, String ... byColumns) {
        String[] columns = new String[byColumns.length + 2];
        columns[0] = x;
        columns[1] = y;
        System.arraycopy(byColumns, 0, columns, 2, byColumns.length);
        return columns;
    }

    private void setUpPlotBySeries(Table t, String x, String y, SeriesInternal series) {
        this.setUpPlotBySeries(t.getDefinition(), x, y, series);
    }

    private void setUpPlotBySeries(TableDefinition t, String x, String y, SeriesInternal series) {
        if (ArgumentValidations.isTime(t, x, new PlotInfo(this, series.name()))) {
            this.axes[0].axisFormat(new NanosAxisFormat());
        }
        if (ArgumentValidations.isTime(t, y, new PlotInfo(this, series.name()))) {
            this.axes[1].axisFormat(new NanosAxisFormat());
        }
        this.registerDataSeries(SeriesCollection.SeriesType.XY, true, series);
    }

    @Override
    public OHLCDataSeriesArray ohlcPlot(Comparable seriesName, IndexableNumericData time, IndexableNumericData open, IndexableNumericData high, IndexableNumericData low, IndexableNumericData close) {
        this.configureOHLCPlot();
        OHLCDataSeriesArray ds = new OHLCDataSeriesArray(this, this.dataSeries.nextId(), seriesName, time, open, high, low, close);
        this.registerDataSeries(SeriesCollection.SeriesType.OHLC, false, ds);
        this.axes[0].axisFormat(new NanosAxisFormat());
        return ds;
    }

    @Override
    public OHLCDataSeriesTableArray ohlcPlot(Comparable seriesName, Table t, String time, String open, String high, String low, String close) {
        this.configureOHLCPlot();
        TableHandle h = new TableHandle(t, time, open, high, low, close);
        OHLCDataSeriesTableArray ds = new OHLCDataSeriesTableArray(this, this.dataSeries.nextId(), seriesName, h, time, open, high, low, close);
        this.registerDataSeries(SeriesCollection.SeriesType.OHLC, false, ds);
        ds.addTableHandle(h);
        this.axes[0].axisFormat(new NanosAxisFormat());
        return ds;
    }

    @Override
    public OHLCDataSeriesArray ohlcPlot(Comparable seriesName, SelectableDataSet sds, String time, String open, String high, String low, String close) {
        this.configureOHLCPlot();
        SwappableTable t = sds.getSwappableTable(seriesName, this.chart, time, open, high, low, close);
        OHLCDataSeriesSwappableTableArray ds = new OHLCDataSeriesSwappableTableArray(this, this.dataSeries.nextId(), seriesName, t, time, open, high, low, close);
        this.registerDataSeries(SeriesCollection.SeriesType.OHLC, false, ds);
        ds.addSwappableTable(t);
        this.axes[0].axisFormat(new NanosAxisFormat());
        return ds;
    }

    @Override
    public MultiOHLCSeries ohlcPlotBy(Comparable seriesName, Table t, String time, String open, String high, String low, String close, String ... byColumns) {
        ArgumentValidations.assertNotNull(t, "t", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(time, "timeCol", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(open, "openCol", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(high, "highCol", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(low, "lowCol", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(close, "closeCol", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNullAndNotEmpty(byColumns, "byColumns", new PlotInfo(this, seriesName));
        this.configureOHLCPlot();
        TableBackedPartitionedTableHandle h = new TableBackedPartitionedTableHandle(t, Arrays.asList(time, open, high, low, close), byColumns, new PlotInfo(this, seriesName));
        MultiOHLCSeries series = new MultiOHLCSeries(this, this.dataSeries.nextId(), seriesName, h, time, open, high, low, close, byColumns);
        this.axes[0].axisFormat(new NanosAxisFormat());
        this.registerDataSeries(SeriesCollection.SeriesType.OHLC, true, series);
        return series;
    }

    @Override
    public MultiOHLCSeriesSwappable ohlcPlotBy(Comparable seriesName, SelectableDataSet sds, String time, String open, String high, String low, String close, String ... byColumns) {
        ArgumentValidations.assertNotNull(sds, "sds", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(time, "timeCol", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(open, "openCol", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(high, "highCol", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(low, "lowCol", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(close, "closeCol", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNullAndNotEmpty(byColumns, "byColumns", new PlotInfo(this, seriesName));
        String[] columns = new String[byColumns.length + 5];
        columns[0] = time;
        columns[1] = open;
        columns[2] = high;
        columns[3] = low;
        columns[4] = close;
        System.arraycopy(byColumns, 0, columns, 5, byColumns.length);
        SwappableTable t = sds.getSwappableTable(seriesName, this.chart, columns);
        this.configureOHLCPlot();
        MultiOHLCSeriesSwappable series = new MultiOHLCSeriesSwappable(this, this.dataSeries.nextId(), seriesName, t, time, open, high, low, close, byColumns);
        this.axes[0].axisFormat(new NanosAxisFormat());
        this.registerDataSeries(SeriesCollection.SeriesType.OHLC, true, series);
        return series;
    }

    @Override
    public IntervalXYDataSeriesArray histPlot(Comparable seriesName, Table t) {
        ArgumentValidations.assertColumnsInTable(t, new PlotInfo(this, seriesName), "BinMin", "BinMid", "BinMax", "Count");
        this.configureXYPlot();
        this.plotStyle(PlotStyle.HISTOGRAM);
        TableHandle h = new TableHandle(t, "BinMin", "BinMid", "BinMax", "Count");
        IndexableNumericDataTable startX = new IndexableNumericDataTable(h, "BinMin", new PlotInfo(this, seriesName));
        IndexableNumericDataTable midX = new IndexableNumericDataTable(h, "BinMid", new PlotInfo(this, seriesName));
        IndexableNumericDataTable endX = new IndexableNumericDataTable(h, "BinMax", new PlotInfo(this, seriesName));
        IndexableNumericDataTable y = new IndexableNumericDataTable(h, "Count", new PlotInfo(this, seriesName));
        IntervalXYDataSeriesArray ds = new IntervalXYDataSeriesArray(this, this.dataSeries.nextId(), seriesName, h, (IndexableNumericData)startX, (IndexableNumericData)midX, (IndexableNumericData)endX, (IndexableNumericData)y, (IndexableNumericData)y, (IndexableNumericData)y);
        ds.addTableHandle(h);
        this.registerDataSeries(SeriesCollection.SeriesType.INTERVAL, false, ds);
        return ds;
    }

    @Override
    public IntervalXYDataSeriesArray histPlot(Comparable seriesName, Table t, String x, int nbins) {
        ArgumentValidations.assertIsNumeric(t, x, "Histogram can not be computed on non-numeric column: " + x, new PlotInfo(this, seriesName));
        return this.histPlot(seriesName, HistogramCalculator.calc(t, x, nbins, new PlotInfo(this, seriesName), new String[0]));
    }

    @Override
    public IntervalXYDataSeriesArray histPlot(Comparable seriesName, Table t, String x, double xmin, double xmax, int nbins) {
        ArgumentValidations.assertIsNumeric(t, x, "Histogram can not be computed on non-numeric column: " + x, new PlotInfo(this, seriesName));
        return this.histPlot(seriesName, HistogramCalculator.calc(t, x, xmin, xmax, nbins, new PlotInfo(this, seriesName), new String[0]));
    }

    private IntervalXYDataSeriesArray histPlot(Comparable seriesName, SwappableTable sds) {
        this.configureXYPlot();
        this.plotStyle(PlotStyle.HISTOGRAM);
        ArgumentValidations.assertColumnsInTable(sds.getTableDefinition(), new PlotInfo(this, seriesName), "BinMin", "BinMid", "BinMax", "Count");
        IndexableNumericDataSwappableTable startX = new IndexableNumericDataSwappableTable(sds, "BinMin", new PlotInfo(this, seriesName));
        IndexableNumericDataSwappableTable midX = new IndexableNumericDataSwappableTable(sds, "BinMid", new PlotInfo(this, seriesName));
        IndexableNumericDataSwappableTable endX = new IndexableNumericDataSwappableTable(sds, "BinMax", new PlotInfo(this, seriesName));
        IndexableNumericDataSwappableTable y = new IndexableNumericDataSwappableTable(sds, "Count", new PlotInfo(this, seriesName));
        IntervalXYDataSeriesArray ds = new IntervalXYDataSeriesArray(this, this.dataSeries.nextId(), seriesName, sds, (IndexableNumericData)startX, (IndexableNumericData)midX, (IndexableNumericData)endX, (IndexableNumericData)y, (IndexableNumericData)y, (IndexableNumericData)y);
        ds.addSwappableTable(sds);
        this.registerDataSeries(SeriesCollection.SeriesType.INTERVAL, false, ds);
        return ds;
    }

    @Override
    public IntervalXYDataSeriesArray histPlot(Comparable seriesName, SelectableDataSet sds, String x, int nbins) {
        PlotInfo plotInfo = new PlotInfo(this, seriesName);
        ArgumentValidations.assertIsNumeric(sds, x, "Histogram can not be computed on non-numeric column: " + x, plotInfo);
        List<Object> byCols = sds instanceof SelectableDataSetOneClick ? Arrays.asList(((SelectableDataSetOneClick)sds).getByColumns()) : Collections.emptyList();
        Function tableTransform = (Function<Table, Table> & Serializable)t -> HistogramCalculator.calc(t, x, nbins, plotInfo, byCols);
        ArrayList<String> allCols = new ArrayList<String>(byCols);
        allCols.add(x);
        SwappableTable ht = sds.getSwappableTable(seriesName, this.chart, tableTransform, allCols.toArray(CollectionUtil.ZERO_LENGTH_STRING_ARRAY));
        return this.histPlot(seriesName, ht);
    }

    @Override
    public IntervalXYDataSeriesArray histPlot(Comparable seriesName, SelectableDataSet sds, String x, double xmin, double xmax, int nbins) {
        PlotInfo plotInfo = new PlotInfo(this, seriesName);
        ArgumentValidations.assertIsNumeric(sds, x, "Histogram can not be computed on non-numeric column: " + x, plotInfo);
        List<Object> byCols = sds instanceof SelectableDataSetOneClick ? Arrays.asList(((SelectableDataSetOneClick)sds).getByColumns()) : Collections.emptyList();
        Function tableTransform = (Function<Table, Table> & Serializable)t -> HistogramCalculator.calc(t, x, xmin, xmax, nbins, plotInfo, byCols);
        ArrayList<String> allCols = new ArrayList<String>(byCols);
        allCols.add(x);
        SwappableTable ht = sds.getSwappableTable(seriesName, this.chart, tableTransform, allCols.toArray(CollectionUtil.ZERO_LENGTH_STRING_ARRAY));
        return this.histPlot(seriesName, ht);
    }

    @Override
    public CategoryDataSeriesPartitionedTable catHistPlot(Comparable seriesName, Table t, String categories) {
        this.configureCategoryPlot();
        this.plotStyle(PlotStyle.HISTOGRAM);
        if (ArgumentValidations.isTime(t, categories, new PlotInfo(this, seriesName))) {
            this.axes[1].axisFormat(new NanosAxisFormat());
        }
        Table counts = PlotUtils.createCategoryHistogramTable(t, categories);
        TableHandle h = new TableHandle(counts, categories, "Count", "__CAT_ORDER");
        CategoryDataSeriesPartitionedTable ds = new CategoryDataSeriesPartitionedTable(this, this.dataSeries.nextId(), seriesName, h, categories, "Count");
        ds.addTableHandle(h);
        this.registerDataSeries(SeriesCollection.SeriesType.CATEGORY, false, ds);
        return ds;
    }

    @Override
    public CategoryDataSeriesSwappablePartitionedTable catHistPlot(Comparable seriesName, SelectableDataSet sds, String categories) {
        this.configureCategoryPlot();
        this.plotStyle(PlotStyle.HISTOGRAM);
        if (ArgumentValidations.isTime(sds, categories, new PlotInfo(this, seriesName))) {
            this.axes[1].axisFormat(new NanosAxisFormat());
        }
        ArrayList<String> cols = new ArrayList<String>();
        cols.add(categories);
        if (sds instanceof SelectableDataSetOneClick) {
            cols.addAll(Arrays.asList(((SelectableDataSetOneClick)sds).getByColumns()));
        }
        Function tableTransform = (Function<Table, Table> & Serializable)t -> PlotUtils.createCategoryHistogramTable(t, cols.toArray(CollectionUtil.ZERO_LENGTH_STRING_ARRAY));
        SwappableTable counts = sds.getSwappableTable(seriesName, this.chart, tableTransform, categories, "__CAT_ORDER");
        CategoryDataSeriesSwappablePartitionedTable ds = new CategoryDataSeriesSwappablePartitionedTable(this, this.dataSeries.nextId(), seriesName, counts, categories, "Count");
        ds.addSwappableTable(counts);
        this.registerDataSeries(SeriesCollection.SeriesType.CATEGORY, false, ds);
        return ds;
    }

    @Override
    public <T extends Comparable> CategoryDataSeriesPartitionedTable catHistPlot(Comparable seriesName, T[] categories) {
        return this.catHistPlot(seriesName, PlotUtils.table(categories, "Category"), "Category");
    }

    @Override
    public CategoryDataSeriesPartitionedTable catHistPlot(Comparable seriesName, int[] categories) {
        return this.catHistPlot(seriesName, PlotUtils.table(categories, "Category"), "Category");
    }

    @Override
    public CategoryDataSeriesPartitionedTable catHistPlot(Comparable seriesName, long[] categories) {
        return this.catHistPlot(seriesName, PlotUtils.table(categories, "Category"), "Category");
    }

    @Override
    public CategoryDataSeriesPartitionedTable catHistPlot(Comparable seriesName, float[] categories) {
        return this.catHistPlot(seriesName, PlotUtils.table(categories, "Category"), "Category");
    }

    @Override
    public CategoryDataSeriesPartitionedTable catHistPlot(Comparable seriesName, double[] categories) {
        return this.catHistPlot(seriesName, PlotUtils.table(categories, "Category"), "Category");
    }

    @Override
    public <T extends Comparable> CategoryDataSeriesPartitionedTable catHistPlot(Comparable seriesName, List<T> categories) {
        return this.catHistPlot(seriesName, PlotUtils.table(categories, "Category"), "Category");
    }

    private CategoryDataSeriesInternal catPlot(CategoryDataSeriesInternal ds, TableHandle[] tableHandles, SwappableTable[] swappableTables) {
        return this.catPlot(ds, tableHandles, swappableTables, false);
    }

    private CategoryDataSeriesInternal catPlot(CategoryDataSeriesInternal ds, TableHandle[] tableHandles, SwappableTable[] swappableTables, boolean hasYTimeAxis) {
        this.configureCategoryPlot();
        if (hasYTimeAxis) {
            this.axes[1].axisFormat(new NanosAxisFormat());
        }
        if (tableHandles != null) {
            for (Serializable serializable : tableHandles) {
                ds.addTableHandle((TableHandle)serializable);
            }
        }
        if (swappableTables != null) {
            for (Serializable serializable : swappableTables) {
                ds.addSwappableTable((SwappableTable)serializable);
            }
        }
        this.registerDataSeries(SeriesCollection.SeriesType.CATEGORY, false, ds);
        return ds;
    }

    @Override
    public <T1 extends Comparable> CategoryDataSeriesInternal catPlot(Comparable seriesName, IndexableData<T1> categories, IndexableNumericData y) {
        return this.catPlot(seriesName, categories, y, false);
    }

    private <T1 extends Comparable> CategoryDataSeriesInternal catPlot(Comparable seriesName, IndexableData<T1> categories, IndexableNumericData values, boolean hasYTimeAxis) {
        if (hasYTimeAxis) {
            this.axes[1].axisFormat(new NanosAxisFormat());
        }
        return this.catPlot(new CategoryDataSeriesMap(this, this.dataSeries.nextId(), seriesName, categories, values), null, null);
    }

    @Override
    public CategoryDataSeriesInternal catPlot(Comparable seriesName, Table t, String categories, String y) {
        TableHandle h = PlotUtils.createCategoryTableHandle(t, categories, y);
        return this.catPlot(new CategoryDataSeriesPartitionedTable(this, this.dataSeries.nextId(), seriesName, h, categories, y), new TableHandle[]{h}, null, ArgumentValidations.isTime(t, y, new PlotInfo(this, seriesName)));
    }

    @Override
    public CategoryDataSeriesInternal catPlot(Comparable seriesName, SelectableDataSet sds, String categories, String y) {
        SelectableDataSet lastBySelectableDataSet = AxesImpl.getAggregatedSelectableDataSet(sds, () -> PlotUtils.createCategoryAggs(Aggregation.AggLast((String[])new String[]{y})), Collections.singletonList(categories));
        SwappableTable t = lastBySelectableDataSet.getSwappableTable(seriesName, this.chart, categories, y, "__CAT_ORDER");
        return this.catPlot(new CategoryDataSeriesSwappablePartitionedTable(this, this.dataSeries.nextId(), seriesName, t, categories, y), null, new SwappableTable[]{t}, ArgumentValidations.isTime(sds, y, new PlotInfo(this, seriesName)));
    }

    @Override
    public MultiCatSeries catPlotBy(Comparable seriesName, Table t, String categories, String y, String ... byColumns) {
        ArgumentValidations.assertNotNull(t, "t", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(categories, "categories", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(y, "values", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNullAndNotEmpty(byColumns, "byColumns", new PlotInfo(this, seriesName));
        this.configureCategoryPlot();
        TableBackedPartitionedTableHandle h = PlotUtils.createCategoryPartitionedTableHandle(t, categories, new String[]{y}, byColumns, new PlotInfo(this, seriesName));
        MultiCatSeries series = new MultiCatSeries(this, this.dataSeries.nextId(), seriesName, h, categories, y, byColumns);
        if (ArgumentValidations.isTime(t, y, new PlotInfo(this, seriesName))) {
            this.axes[1].axisFormat(new NanosAxisFormat());
        }
        this.registerDataSeries(SeriesCollection.SeriesType.CATEGORY, true, series);
        return series;
    }

    @Override
    public MultiCatSeriesSwappable catPlotBy(Comparable seriesName, SelectableDataSet sds, String categories, String y, String ... byColumns) {
        ArgumentValidations.assertNotNull(sds, "sds", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(categories, "categories", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNull(y, "timeCol", new PlotInfo(this, seriesName));
        ArgumentValidations.assertNotNullAndNotEmpty(byColumns, "byColumns", new PlotInfo(this, seriesName));
        String[] columns = new String[byColumns.length + 3];
        columns[0] = categories;
        columns[1] = y;
        columns[2] = "__CAT_ORDER";
        System.arraycopy(byColumns, 0, columns, 3, byColumns.length);
        ArrayList<String> allOfTheByColumns = new ArrayList<String>();
        allOfTheByColumns.add(categories);
        allOfTheByColumns.addAll(Arrays.asList(byColumns));
        SelectableDataSet lastBySelectableDataSet = AxesImpl.getAggregatedSelectableDataSet(sds, () -> PlotUtils.createCategoryAggs(Aggregation.AggLast((String[])new String[]{y})), allOfTheByColumns);
        SwappableTable t = lastBySelectableDataSet.getSwappableTable(seriesName, this.chart, columns);
        this.configureCategoryPlot();
        MultiCatSeriesSwappable series = new MultiCatSeriesSwappable(this, this.dataSeries.nextId(), seriesName, t, categories, y, byColumns);
        if (ArgumentValidations.isTime(t.getTableDefinition(), y, new PlotInfo(this, seriesName))) {
            this.axes[1].axisFormat(new NanosAxisFormat());
        }
        this.registerDataSeries(SeriesCollection.SeriesType.CATEGORY, true, series);
        return series;
    }

    private CategoryDataSeriesInternal piePlot(CategoryDataSeriesInternal ds, TableHandle[] tableHandles, SwappableTable[] swappableTables) {
        this.configurePiePlot();
        if (tableHandles != null) {
            for (Serializable serializable : tableHandles) {
                ds.addTableHandle((TableHandle)serializable);
            }
        }
        if (swappableTables != null) {
            for (Serializable serializable : swappableTables) {
                ds.addSwappableTable((SwappableTable)serializable);
            }
        }
        this.registerDataSeries(SeriesCollection.SeriesType.CATEGORY, false, ds);
        return ds;
    }

    @Override
    public <T1 extends Comparable> CategoryDataSeriesInternal piePlot(Comparable seriesName, IndexableData<T1> categories, IndexableNumericData y) {
        return this.piePlot(new CategoryDataSeriesMap(this, this.dataSeries.nextId(), seriesName, categories, y), null, null);
    }

    @Override
    public CategoryDataSeriesInternal piePlot(Comparable seriesName, Table t, String categories, String y) {
        TableHandle h = PlotUtils.createCategoryTableHandle(t, categories, y);
        return this.piePlot(new CategoryDataSeriesPartitionedTable(this, this.dataSeries.nextId(), seriesName, h, categories, y), new TableHandle[]{h}, null);
    }

    @Override
    public CategoryDataSeriesInternal piePlot(Comparable seriesName, SelectableDataSet sds, String categories, String y) {
        SelectableDataSet lastBySelectableDataSet = AxesImpl.getAggregatedSelectableDataSet(sds, () -> PlotUtils.createCategoryAggs(Aggregation.AggLast((String[])new String[]{y})), Collections.singletonList(categories));
        SwappableTable t = lastBySelectableDataSet.getSwappableTable(seriesName, this.chart, categories, y, "__CAT_ORDER");
        return this.piePlot(new CategoryDataSeriesSwappablePartitionedTable(this, this.dataSeries.nextId(), seriesName, t, categories, y), null, new SwappableTable[]{t});
    }

    private CategoryDataSeriesInternal treemapPlot(CategoryDataSeriesInternal ds, TableHandle[] tableHandles, SwappableTable[] swappableTables) {
        this.configureTreemapPlot();
        if (tableHandles != null) {
            for (Serializable serializable : tableHandles) {
                ds.addTableHandle((TableHandle)serializable);
            }
        }
        if (swappableTables != null) {
            for (Serializable serializable : swappableTables) {
                ds.addSwappableTable((SwappableTable)serializable);
            }
        }
        this.registerDataSeries(SeriesCollection.SeriesType.CATEGORY, false, ds);
        return ds;
    }

    @Override
    public CategoryDataSeries treemapPlot(Comparable seriesName, Table t, String ids, String parents, @Nullable String values, @Nullable String labels, @Nullable String hoverText, @Nullable String color) {
        TableHandle h = PlotUtils.createCategoryTableHandle(t, new String[]{ids}, parents, values, labels, hoverText, color);
        return this.treemapPlot(new CategoryTreemapDataSeriesTableMap(this, this.dataSeries.nextId(), seriesName, h, ids, parents, values, labels, hoverText, color), new TableHandle[]{h}, null);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, Date[] x, Date[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), true, true);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, Date[] x, DateTime[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), true, true);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, Date[] x, short[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), true, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, Date[] x, int[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), true, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, Date[] x, long[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), true, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, Date[] x, float[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), true, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, Date[] x, double[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), true, false);
    }

    @Override
    public <T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, Date[] x, T1[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), true, false);
    }

    @Override
    public <T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, Date[] x, List<T1> y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)), true, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, DateTime[] x, Date[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), true, true);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, DateTime[] x, DateTime[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), true, true);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, DateTime[] x, short[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), true, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, DateTime[] x, int[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), true, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, DateTime[] x, long[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), true, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, DateTime[] x, float[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), true, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, DateTime[] x, double[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), true, false);
    }

    @Override
    public <T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, DateTime[] x, T1[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), true, false);
    }

    @Override
    public <T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, DateTime[] x, List<T1> y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)), true, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, short[] x, Date[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), false, true);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, short[] x, DateTime[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), false, true);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, short[] x, short[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, short[] x, int[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, short[] x, long[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, short[] x, float[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, short[] x, double[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, short[] x, T1[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, short[] x, List<T1> y) {
        return this.plot(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, int[] x, Date[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), false, true);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, int[] x, DateTime[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), false, true);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, int[] x, short[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, int[] x, int[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, int[] x, long[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, int[] x, float[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, int[] x, double[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, int[] x, T1[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, int[] x, List<T1> y) {
        return this.plot(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, long[] x, Date[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), false, true);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, long[] x, DateTime[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), false, true);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, long[] x, short[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, long[] x, int[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, long[] x, long[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, long[] x, float[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, long[] x, double[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, long[] x, T1[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, long[] x, List<T1> y) {
        return this.plot(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, float[] x, Date[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), false, true);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, float[] x, DateTime[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), false, true);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, float[] x, short[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, float[] x, int[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, float[] x, long[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, float[] x, float[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, float[] x, double[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, float[] x, T1[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, float[] x, List<T1> y) {
        return this.plot(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, double[] x, Date[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), false, true);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, double[] x, DateTime[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), false, true);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, double[] x, short[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, double[] x, int[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, double[] x, long[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, double[] x, float[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public XYDataSeriesArray plot(Comparable seriesName, double[] x, double[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, double[] x, T1[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, double[] x, List<T1> y) {
        return this.plot(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T0 extends Number> XYDataSeriesArray plot(Comparable seriesName, T0[] x, Date[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), false, true);
    }

    @Override
    public <T0 extends Number> XYDataSeriesArray plot(Comparable seriesName, T0[] x, DateTime[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), false, true);
    }

    @Override
    public <T0 extends Number> XYDataSeriesArray plot(Comparable seriesName, T0[] x, short[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T0 extends Number> XYDataSeriesArray plot(Comparable seriesName, T0[] x, int[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T0 extends Number> XYDataSeriesArray plot(Comparable seriesName, T0[] x, long[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T0 extends Number> XYDataSeriesArray plot(Comparable seriesName, T0[] x, float[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T0 extends Number> XYDataSeriesArray plot(Comparable seriesName, T0[] x, double[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, T0[] x, T1[] y) {
        return this.plot(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, T0[] x, List<T1> y) {
        return this.plot(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T0 extends Number> XYDataSeriesArray plot(Comparable seriesName, List<T0> x, Date[] y) {
        return this.plot(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), false, true);
    }

    @Override
    public <T0 extends Number> XYDataSeriesArray plot(Comparable seriesName, List<T0> x, DateTime[] y) {
        return this.plot(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), false, true);
    }

    @Override
    public <T0 extends Number> XYDataSeriesArray plot(Comparable seriesName, List<T0> x, short[] y) {
        return this.plot(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T0 extends Number> XYDataSeriesArray plot(Comparable seriesName, List<T0> x, int[] y) {
        return this.plot(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T0 extends Number> XYDataSeriesArray plot(Comparable seriesName, List<T0> x, long[] y) {
        return this.plot(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T0 extends Number> XYDataSeriesArray plot(Comparable seriesName, List<T0> x, float[] y) {
        return this.plot(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T0 extends Number> XYDataSeriesArray plot(Comparable seriesName, List<T0> x, double[] y) {
        return this.plot(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, List<T0> x, T1[] y) {
        return this.plot(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number> XYDataSeriesArray plot(Comparable seriesName, List<T0> x, List<T1> y) {
        return this.plot(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)), false, false);
    }

    @Override
    public OHLCDataSeriesArray ohlcPlot(Comparable seriesName, Date[] time, short[] open, short[] high, short[] low, short[] close) {
        return this.ohlcPlot(seriesName, new IndexableNumericDataArrayDate(time, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(open, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(high, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(low, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(close, new PlotInfo(this, seriesName)));
    }

    @Override
    public OHLCDataSeriesArray ohlcPlot(Comparable seriesName, DateTime[] time, short[] open, short[] high, short[] low, short[] close) {
        return this.ohlcPlot(seriesName, new IndexableNumericDataArrayDateTime(time, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(open, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(high, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(low, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(close, new PlotInfo(this, seriesName)));
    }

    @Override
    public OHLCDataSeriesArray ohlcPlot(Comparable seriesName, Date[] time, int[] open, int[] high, int[] low, int[] close) {
        return this.ohlcPlot(seriesName, new IndexableNumericDataArrayDate(time, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(open, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(high, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(low, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(close, new PlotInfo(this, seriesName)));
    }

    @Override
    public OHLCDataSeriesArray ohlcPlot(Comparable seriesName, DateTime[] time, int[] open, int[] high, int[] low, int[] close) {
        return this.ohlcPlot(seriesName, new IndexableNumericDataArrayDateTime(time, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(open, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(high, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(low, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(close, new PlotInfo(this, seriesName)));
    }

    @Override
    public OHLCDataSeriesArray ohlcPlot(Comparable seriesName, Date[] time, long[] open, long[] high, long[] low, long[] close) {
        return this.ohlcPlot(seriesName, new IndexableNumericDataArrayDate(time, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(open, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(high, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(low, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(close, new PlotInfo(this, seriesName)));
    }

    @Override
    public OHLCDataSeriesArray ohlcPlot(Comparable seriesName, DateTime[] time, long[] open, long[] high, long[] low, long[] close) {
        return this.ohlcPlot(seriesName, new IndexableNumericDataArrayDateTime(time, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(open, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(high, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(low, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(close, new PlotInfo(this, seriesName)));
    }

    @Override
    public OHLCDataSeriesArray ohlcPlot(Comparable seriesName, Date[] time, float[] open, float[] high, float[] low, float[] close) {
        return this.ohlcPlot(seriesName, new IndexableNumericDataArrayDate(time, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(open, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(high, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(low, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(close, new PlotInfo(this, seriesName)));
    }

    @Override
    public OHLCDataSeriesArray ohlcPlot(Comparable seriesName, DateTime[] time, float[] open, float[] high, float[] low, float[] close) {
        return this.ohlcPlot(seriesName, new IndexableNumericDataArrayDateTime(time, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(open, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(high, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(low, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(close, new PlotInfo(this, seriesName)));
    }

    @Override
    public OHLCDataSeriesArray ohlcPlot(Comparable seriesName, Date[] time, double[] open, double[] high, double[] low, double[] close) {
        return this.ohlcPlot(seriesName, new IndexableNumericDataArrayDate(time, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(open, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(high, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(low, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(close, new PlotInfo(this, seriesName)));
    }

    @Override
    public OHLCDataSeriesArray ohlcPlot(Comparable seriesName, DateTime[] time, double[] open, double[] high, double[] low, double[] close) {
        return this.ohlcPlot(seriesName, new IndexableNumericDataArrayDateTime(time, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(open, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(high, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(low, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(close, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T1 extends Number, T2 extends Number, T3 extends Number, T4 extends Number> OHLCDataSeriesArray ohlcPlot(Comparable seriesName, Date[] time, T1[] open, T2[] high, T3[] low, T4[] close) {
        return this.ohlcPlot(seriesName, new IndexableNumericDataArrayDate(time, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(open, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(high, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(low, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(close, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T1 extends Number, T2 extends Number, T3 extends Number, T4 extends Number> OHLCDataSeriesArray ohlcPlot(Comparable seriesName, DateTime[] time, T1[] open, T2[] high, T3[] low, T4[] close) {
        return this.ohlcPlot(seriesName, new IndexableNumericDataArrayDateTime(time, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(open, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(high, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(low, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(close, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T1 extends Number, T2 extends Number, T3 extends Number, T4 extends Number> OHLCDataSeriesArray ohlcPlot(Comparable seriesName, Date[] time, List<T1> open, List<T2> high, List<T3> low, List<T4> close) {
        return this.ohlcPlot(seriesName, new IndexableNumericDataArrayDate(time, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(open, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T2>(high, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T3>(low, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T4>(close, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T1 extends Number, T2 extends Number, T3 extends Number, T4 extends Number> OHLCDataSeriesArray ohlcPlot(Comparable seriesName, DateTime[] time, List<T1> open, List<T2> high, List<T3> low, List<T4> close) {
        return this.ohlcPlot(seriesName, new IndexableNumericDataArrayDateTime(time, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(open, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T2>(high, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T3>(low, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T4>(close, new PlotInfo(this, seriesName)));
    }

    @Override
    public IntervalXYDataSeriesArray histPlot(Comparable seriesName, short[] x, int nbins) {
        return this.histPlot(seriesName, PlotUtils.doubleTable(x, "Y"), "Y", nbins);
    }

    @Override
    public IntervalXYDataSeriesArray histPlot(Comparable seriesName, int[] x, int nbins) {
        return this.histPlot(seriesName, PlotUtils.doubleTable(x, "Y"), "Y", nbins);
    }

    @Override
    public IntervalXYDataSeriesArray histPlot(Comparable seriesName, long[] x, int nbins) {
        return this.histPlot(seriesName, PlotUtils.doubleTable(x, "Y"), "Y", nbins);
    }

    @Override
    public IntervalXYDataSeriesArray histPlot(Comparable seriesName, float[] x, int nbins) {
        return this.histPlot(seriesName, PlotUtils.doubleTable(x, "Y"), "Y", nbins);
    }

    @Override
    public IntervalXYDataSeriesArray histPlot(Comparable seriesName, double[] x, int nbins) {
        return this.histPlot(seriesName, PlotUtils.doubleTable(x, "Y"), "Y", nbins);
    }

    @Override
    public <T0 extends Number> IntervalXYDataSeriesArray histPlot(Comparable seriesName, T0[] x, int nbins) {
        return this.histPlot(seriesName, PlotUtils.doubleTable(x, (String)"Y"), "Y", nbins);
    }

    @Override
    public <T0 extends Number> IntervalXYDataSeriesArray histPlot(Comparable seriesName, List<T0> x, int nbins) {
        return this.histPlot(seriesName, PlotUtils.doubleTable(x, "Y"), "Y", nbins);
    }

    @Override
    public IntervalXYDataSeriesArray histPlot(Comparable seriesName, short[] x, double xmin, double xmax, int nbins) {
        return this.histPlot(seriesName, PlotUtils.doubleTable(x, "Y"), "Y", xmin, xmax, nbins);
    }

    @Override
    public IntervalXYDataSeriesArray histPlot(Comparable seriesName, int[] x, double xmin, double xmax, int nbins) {
        return this.histPlot(seriesName, PlotUtils.doubleTable(x, "Y"), "Y", xmin, xmax, nbins);
    }

    @Override
    public IntervalXYDataSeriesArray histPlot(Comparable seriesName, long[] x, double xmin, double xmax, int nbins) {
        return this.histPlot(seriesName, PlotUtils.doubleTable(x, "Y"), "Y", xmin, xmax, nbins);
    }

    @Override
    public IntervalXYDataSeriesArray histPlot(Comparable seriesName, float[] x, double xmin, double xmax, int nbins) {
        return this.histPlot(seriesName, PlotUtils.doubleTable(x, "Y"), "Y", xmin, xmax, nbins);
    }

    @Override
    public IntervalXYDataSeriesArray histPlot(Comparable seriesName, double[] x, double xmin, double xmax, int nbins) {
        return this.histPlot(seriesName, PlotUtils.doubleTable(x, "Y"), "Y", xmin, xmax, nbins);
    }

    @Override
    public <T0 extends Number> IntervalXYDataSeriesArray histPlot(Comparable seriesName, T0[] x, double xmin, double xmax, int nbins) {
        return this.histPlot(seriesName, PlotUtils.doubleTable(x, (String)"Y"), "Y", xmin, xmax, nbins);
    }

    @Override
    public <T0 extends Number> IntervalXYDataSeriesArray histPlot(Comparable seriesName, List<T0> x, double xmin, double xmax, int nbins) {
        return this.histPlot(seriesName, PlotUtils.doubleTable(x, "Y"), "Y", xmin, xmax, nbins);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, short[] x, short[] xLow, short[] xHigh, short[] y, short[] yLow, short[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(yHigh, new PlotInfo(this, seriesName)), true, true, false, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, int[] x, int[] xLow, int[] xHigh, int[] y, int[] yLow, int[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(yHigh, new PlotInfo(this, seriesName)), true, true, false, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, long[] x, long[] xLow, long[] xHigh, long[] y, long[] yLow, long[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(yHigh, new PlotInfo(this, seriesName)), true, true, false, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, float[] x, float[] xLow, float[] xHigh, float[] y, float[] yLow, float[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(yHigh, new PlotInfo(this, seriesName)), true, true, false, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, double[] x, double[] xLow, double[] xHigh, double[] y, double[] yLow, double[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(yHigh, new PlotInfo(this, seriesName)), true, true, false, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number, T3 extends Number, T4 extends Number, T5 extends Number> XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, T0[] x, T1[] xLow, T2[] xHigh, T3[] y, T4[] yLow, T5[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(yHigh, new PlotInfo(this, seriesName)), true, true, false, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number, T3 extends Number, T4 extends Number, T5 extends Number> XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, List<T0> x, List<T1> xLow, List<T2> xHigh, List<T3> y, List<T4> yLow, List<T5> yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T2>(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T3>(y, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T4>(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T5>(yHigh, new PlotInfo(this, seriesName)), true, true, false, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName)), true, true, true, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, DateTime[] x, DateTime[] xLow, DateTime[] xHigh, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName)), true, true, true, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, short[] y, short[] yLow, short[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(yHigh, new PlotInfo(this, seriesName)), true, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, short[] x, short[] xLow, short[] xHigh, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName)), true, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, int[] y, int[] yLow, int[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(yHigh, new PlotInfo(this, seriesName)), true, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, int[] x, int[] xLow, int[] xHigh, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName)), true, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, long[] y, long[] yLow, long[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(yHigh, new PlotInfo(this, seriesName)), true, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, long[] x, long[] xLow, long[] xHigh, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName)), true, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, float[] y, float[] yLow, float[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(yHigh, new PlotInfo(this, seriesName)), true, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, float[] x, float[] xLow, float[] xHigh, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName)), true, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, double[] y, double[] yLow, double[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(yHigh, new PlotInfo(this, seriesName)), true, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, double[] x, double[] xLow, double[] xHigh, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName)), true, true, false, true);
    }

    @Override
    public <T3 extends Number, T4 extends Number, T5 extends Number> XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, T3[] y, T4[] yLow, T5[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(yHigh, new PlotInfo(this, seriesName)), true, true, true, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number> XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, T0[] x, T1[] xLow, T2[] xHigh, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName)), true, true, false, true);
    }

    @Override
    public <T3 extends Number, T4 extends Number, T5 extends Number> XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, List<T3> y, List<T4> yLow, List<T5> yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T3>(y, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T4>(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T5>(yHigh, new PlotInfo(this, seriesName)), true, true, true, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number> XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, List<T0> x, List<T1> xLow, List<T2> xHigh, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T2>(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName)), true, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, DateTime[] x, DateTime[] xLow, DateTime[] xHigh, short[] y, short[] yLow, short[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(yHigh, new PlotInfo(this, seriesName)), true, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, short[] x, short[] xLow, short[] xHigh, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName)), true, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, DateTime[] x, DateTime[] xLow, DateTime[] xHigh, int[] y, int[] yLow, int[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(yHigh, new PlotInfo(this, seriesName)), true, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, int[] x, int[] xLow, int[] xHigh, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName)), true, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, DateTime[] x, DateTime[] xLow, DateTime[] xHigh, long[] y, long[] yLow, long[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(yHigh, new PlotInfo(this, seriesName)), true, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, long[] x, long[] xLow, long[] xHigh, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName)), true, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, DateTime[] x, DateTime[] xLow, DateTime[] xHigh, float[] y, float[] yLow, float[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(yHigh, new PlotInfo(this, seriesName)), true, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, float[] x, float[] xLow, float[] xHigh, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName)), true, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, DateTime[] x, DateTime[] xLow, DateTime[] xHigh, double[] y, double[] yLow, double[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(yHigh, new PlotInfo(this, seriesName)), true, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, double[] x, double[] xLow, double[] xHigh, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName)), true, true, false, true);
    }

    @Override
    public <T3 extends Number, T4 extends Number, T5 extends Number> XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, DateTime[] x, DateTime[] xLow, DateTime[] xHigh, T3[] y, T4[] yLow, T5[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(yHigh, new PlotInfo(this, seriesName)), true, true, true, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number> XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, T0[] x, T1[] xLow, T2[] xHigh, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName)), true, true, false, true);
    }

    @Override
    public <T3 extends Number, T4 extends Number, T5 extends Number> XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, DateTime[] x, DateTime[] xLow, DateTime[] xHigh, List<T3> y, List<T4> yLow, List<T5> yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T3>(y, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T4>(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T5>(yHigh, new PlotInfo(this, seriesName)), true, true, true, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number> XYErrorBarDataSeriesArray errorBarXY(Comparable seriesName, List<T0> x, List<T1> xLow, List<T2> xHigh, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.errorBarXY(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T2>(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName)), true, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, short[] x, short[] xLow, short[] xHigh, short[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), true, false, false, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, int[] x, int[] xLow, int[] xHigh, int[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), true, false, false, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, long[] x, long[] xLow, long[] xHigh, long[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), true, false, false, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, float[] x, float[] xLow, float[] xHigh, float[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), true, false, false, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, double[] x, double[] xLow, double[] xHigh, double[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), true, false, false, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number, T3 extends Number> XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, T0[] x, T1[] xLow, T2[] xHigh, T3[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), true, false, false, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number, T3 extends Number> XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, List<T0> x, List<T1> xLow, List<T2> xHigh, List<T3> y) {
        return this.errorBarX(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T2>(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T3>(y, new PlotInfo(this, seriesName)), true, false, false, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, Date[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), true, false, true, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, DateTime[] x, DateTime[] xLow, DateTime[] xHigh, DateTime[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), true, false, true, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, short[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), true, false, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, short[] x, short[] xLow, short[] xHigh, Date[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), true, false, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, int[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), true, false, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, int[] x, int[] xLow, int[] xHigh, Date[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), true, false, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, long[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), true, false, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, long[] x, long[] xLow, long[] xHigh, Date[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), true, false, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, float[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), true, false, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, float[] x, float[] xLow, float[] xHigh, Date[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), true, false, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, double[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), true, false, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, double[] x, double[] xLow, double[] xHigh, Date[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), true, false, false, true);
    }

    @Override
    public <T3 extends Number> XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, T3[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), true, false, true, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number> XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, T0[] x, T1[] xLow, T2[] xHigh, Date[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), true, false, false, true);
    }

    @Override
    public <T3 extends Number> XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, List<T3> y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T3>(y, new PlotInfo(this, seriesName)), true, false, true, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number> XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, List<T0> x, List<T1> xLow, List<T2> xHigh, Date[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T2>(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), true, false, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, DateTime[] x, DateTime[] xLow, DateTime[] xHigh, short[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), true, false, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, short[] x, short[] xLow, short[] xHigh, DateTime[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), true, false, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, DateTime[] x, DateTime[] xLow, DateTime[] xHigh, int[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), true, false, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, int[] x, int[] xLow, int[] xHigh, DateTime[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), true, false, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, DateTime[] x, DateTime[] xLow, DateTime[] xHigh, long[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), true, false, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, long[] x, long[] xLow, long[] xHigh, DateTime[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), true, false, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, DateTime[] x, DateTime[] xLow, DateTime[] xHigh, float[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), true, false, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, float[] x, float[] xLow, float[] xHigh, DateTime[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), true, false, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, DateTime[] x, DateTime[] xLow, DateTime[] xHigh, double[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), true, false, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, double[] x, double[] xLow, double[] xHigh, DateTime[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), true, false, false, true);
    }

    @Override
    public <T3 extends Number> XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, DateTime[] x, DateTime[] xLow, DateTime[] xHigh, T3[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), true, false, true, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number> XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, T0[] x, T1[] xLow, T2[] xHigh, DateTime[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), true, false, false, true);
    }

    @Override
    public <T3 extends Number> XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, DateTime[] x, DateTime[] xLow, DateTime[] xHigh, List<T3> y) {
        return this.errorBarX(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T3>(y, new PlotInfo(this, seriesName)), true, false, true, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number> XYErrorBarDataSeriesArray errorBarX(Comparable seriesName, List<T0> x, List<T1> xLow, List<T2> xHigh, DateTime[] y) {
        return this.errorBarX(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(xLow, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T2>(xHigh, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), true, false, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, short[] x, short[] y, short[] yLow, short[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(yHigh, new PlotInfo(this, seriesName)), false, true, false, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, int[] x, int[] y, int[] yLow, int[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(yHigh, new PlotInfo(this, seriesName)), false, true, false, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, long[] x, long[] y, long[] yLow, long[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(yHigh, new PlotInfo(this, seriesName)), false, true, false, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, float[] x, float[] y, float[] yLow, float[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(yHigh, new PlotInfo(this, seriesName)), false, true, false, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, double[] x, double[] y, double[] yLow, double[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(yHigh, new PlotInfo(this, seriesName)), false, true, false, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number, T3 extends Number> XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, T0[] x, T1[] y, T2[] yLow, T3[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(yHigh, new PlotInfo(this, seriesName)), false, true, false, false);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number, T3 extends Number> XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, List<T0> x, List<T1> y, List<T2> yLow, List<T3> yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T2>(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T3>(yHigh, new PlotInfo(this, seriesName)), false, true, false, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, Date[] x, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName)), false, true, true, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, DateTime[] x, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName)), false, true, true, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, Date[] x, short[] y, short[] yLow, short[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(yHigh, new PlotInfo(this, seriesName)), false, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, short[] x, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName)), false, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, Date[] x, int[] y, int[] yLow, int[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(yHigh, new PlotInfo(this, seriesName)), false, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, int[] x, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName)), false, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, Date[] x, long[] y, long[] yLow, long[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(yHigh, new PlotInfo(this, seriesName)), false, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, long[] x, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName)), false, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, Date[] x, float[] y, float[] yLow, float[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(yHigh, new PlotInfo(this, seriesName)), false, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, float[] x, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName)), false, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, Date[] x, double[] y, double[] yLow, double[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(yHigh, new PlotInfo(this, seriesName)), false, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, double[] x, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName)), false, true, false, true);
    }

    @Override
    public <T1 extends Number, T2 extends Number, T3 extends Number> XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, Date[] x, T1[] y, T2[] yLow, T3[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(yHigh, new PlotInfo(this, seriesName)), false, true, true, false);
    }

    @Override
    public <T0 extends Number> XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, T0[] x, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName)), false, true, false, true);
    }

    @Override
    public <T1 extends Number, T2 extends Number, T3 extends Number> XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, Date[] x, List<T1> y, List<T2> yLow, List<T3> yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDate(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T2>(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T3>(yHigh, new PlotInfo(this, seriesName)), false, true, true, false);
    }

    @Override
    public <T0 extends Number> XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, List<T0> x, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName)), false, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, DateTime[] x, short[] y, short[] yLow, short[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(yHigh, new PlotInfo(this, seriesName)), false, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, short[] x, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayShort(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName)), false, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, DateTime[] x, int[] y, int[] yLow, int[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(yHigh, new PlotInfo(this, seriesName)), false, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, int[] x, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayInt(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName)), false, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, DateTime[] x, long[] y, long[] yLow, long[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(yHigh, new PlotInfo(this, seriesName)), false, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, long[] x, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayLong(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName)), false, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, DateTime[] x, float[] y, float[] yLow, float[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(yHigh, new PlotInfo(this, seriesName)), false, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, float[] x, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayFloat(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName)), false, true, false, true);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, DateTime[] x, double[] y, double[] yLow, double[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(yHigh, new PlotInfo(this, seriesName)), false, true, true, false);
    }

    @Override
    public XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, double[] x, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDouble(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName)), false, true, false, true);
    }

    @Override
    public <T1 extends Number, T2 extends Number, T3 extends Number> XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, DateTime[] x, T1[] y, T2[] yLow, T3[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(yHigh, new PlotInfo(this, seriesName)), false, true, true, false);
    }

    @Override
    public <T0 extends Number> XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, T0[] x, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayNumber(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName)), false, true, false, true);
    }

    @Override
    public <T1 extends Number, T2 extends Number, T3 extends Number> XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, DateTime[] x, List<T1> y, List<T2> yLow, List<T3> yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataArrayDateTime(x, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T2>(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T3>(yHigh, new PlotInfo(this, seriesName)), false, true, true, false);
    }

    @Override
    public <T0 extends Number> XYErrorBarDataSeriesArray errorBarY(Comparable seriesName, List<T0> x, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.errorBarY(seriesName, new IndexableNumericDataListNumber<T0>(x, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName)), false, true, false, true);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catErrorBar(Comparable seriesName, T0[] categories, short[] y, short[] yLow, short[] yHigh) {
        return this.catPlot(new CategoryErrorBarDataSeriesMap(this, this.dataSeries.nextId(), seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(yHigh, new PlotInfo(this, seriesName))), null, null, false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catErrorBar(Comparable seriesName, T0[] categories, int[] y, int[] yLow, int[] yHigh) {
        return this.catPlot(new CategoryErrorBarDataSeriesMap(this, this.dataSeries.nextId(), seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(yHigh, new PlotInfo(this, seriesName))), null, null, false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catErrorBar(Comparable seriesName, T0[] categories, long[] y, long[] yLow, long[] yHigh) {
        return this.catPlot(new CategoryErrorBarDataSeriesMap(this, this.dataSeries.nextId(), seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(yHigh, new PlotInfo(this, seriesName))), null, null, false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catErrorBar(Comparable seriesName, T0[] categories, float[] y, float[] yLow, float[] yHigh) {
        return this.catPlot(new CategoryErrorBarDataSeriesMap(this, this.dataSeries.nextId(), seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(yHigh, new PlotInfo(this, seriesName))), null, null, false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catErrorBar(Comparable seriesName, T0[] categories, double[] y, double[] yLow, double[] yHigh) {
        return this.catPlot(new CategoryErrorBarDataSeriesMap(this, this.dataSeries.nextId(), seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(yHigh, new PlotInfo(this, seriesName))), null, null, false);
    }

    @Override
    public <T0 extends Comparable, T1 extends Number, T2 extends Number, T3 extends Number> CategoryDataSeriesInternal catErrorBar(Comparable seriesName, T0[] categories, T1[] y, T2[] yLow, T3[] yHigh) {
        return this.catPlot(new CategoryErrorBarDataSeriesMap(this, this.dataSeries.nextId(), seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(yHigh, new PlotInfo(this, seriesName))), null, null, false);
    }

    @Override
    public <T0 extends Comparable, T1 extends Number, T2 extends Number, T3 extends Number> CategoryDataSeriesInternal catErrorBar(Comparable seriesName, T0[] categories, List<T1> y, List<T2> yLow, List<T3> yHigh) {
        return this.catPlot(new CategoryErrorBarDataSeriesMap(this, this.dataSeries.nextId(), seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T2>(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T3>(yHigh, new PlotInfo(this, seriesName))), null, null, false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catErrorBar(Comparable seriesName, List<T0> categories, short[] y, short[] yLow, short[] yHigh) {
        return this.catPlot(new CategoryErrorBarDataSeriesMap(this, this.dataSeries.nextId(), seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(yHigh, new PlotInfo(this, seriesName))), null, null, false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catErrorBar(Comparable seriesName, List<T0> categories, int[] y, int[] yLow, int[] yHigh) {
        return this.catPlot(new CategoryErrorBarDataSeriesMap(this, this.dataSeries.nextId(), seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(yHigh, new PlotInfo(this, seriesName))), null, null, false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catErrorBar(Comparable seriesName, List<T0> categories, long[] y, long[] yLow, long[] yHigh) {
        return this.catPlot(new CategoryErrorBarDataSeriesMap(this, this.dataSeries.nextId(), seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(yHigh, new PlotInfo(this, seriesName))), null, null, false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catErrorBar(Comparable seriesName, List<T0> categories, float[] y, float[] yLow, float[] yHigh) {
        return this.catPlot(new CategoryErrorBarDataSeriesMap(this, this.dataSeries.nextId(), seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(yHigh, new PlotInfo(this, seriesName))), null, null, false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catErrorBar(Comparable seriesName, List<T0> categories, double[] y, double[] yLow, double[] yHigh) {
        return this.catPlot(new CategoryErrorBarDataSeriesMap(this, this.dataSeries.nextId(), seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(yHigh, new PlotInfo(this, seriesName))), null, null, false);
    }

    @Override
    public <T0 extends Comparable, T1 extends Number, T2 extends Number, T3 extends Number> CategoryDataSeriesInternal catErrorBar(Comparable seriesName, List<T0> categories, T1[] y, T2[] yLow, T3[] yHigh) {
        return this.catPlot(new CategoryErrorBarDataSeriesMap(this, this.dataSeries.nextId(), seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(yHigh, new PlotInfo(this, seriesName))), null, null, false);
    }

    @Override
    public <T0 extends Comparable, T1 extends Number, T2 extends Number, T3 extends Number> CategoryDataSeriesInternal catErrorBar(Comparable seriesName, List<T0> categories, List<T1> y, List<T2> yLow, List<T3> yHigh) {
        return this.catPlot(new CategoryErrorBarDataSeriesMap(this, this.dataSeries.nextId(), seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T2>(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T3>(yHigh, new PlotInfo(this, seriesName))), null, null, false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catErrorBar(Comparable seriesName, T0[] categories, Date[] y, Date[] yLow, Date[] yHigh) {
        return this.catPlot(new CategoryErrorBarDataSeriesMap(this, this.dataSeries.nextId(), seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(yHigh, new PlotInfo(this, seriesName))), null, null, true);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catErrorBar(Comparable seriesName, T0[] categories, DateTime[] y, DateTime[] yLow, DateTime[] yHigh) {
        return this.catPlot(new CategoryErrorBarDataSeriesMap(this, this.dataSeries.nextId(), seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yLow, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(yHigh, new PlotInfo(this, seriesName))), null, null, true);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catPlot(Comparable seriesName, T0[] categories, Date[] y) {
        return this.catPlot(seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), true);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catPlot(Comparable seriesName, T0[] categories, DateTime[] y) {
        return this.catPlot(seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), true);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catPlot(Comparable seriesName, T0[] categories, short[] y) {
        return this.catPlot(seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catPlot(Comparable seriesName, T0[] categories, int[] y) {
        return this.catPlot(seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catPlot(Comparable seriesName, T0[] categories, long[] y) {
        return this.catPlot(seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catPlot(Comparable seriesName, T0[] categories, float[] y) {
        return this.catPlot(seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catPlot(Comparable seriesName, T0[] categories, double[] y) {
        return this.catPlot(seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), false);
    }

    @Override
    public <T0 extends Comparable, T1 extends Number> CategoryDataSeriesInternal catPlot(Comparable seriesName, T0[] categories, T1[] y) {
        return this.catPlot(seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), false);
    }

    @Override
    public <T0 extends Comparable, T1 extends Number> CategoryDataSeriesInternal catPlot(Comparable seriesName, T0[] categories, List<T1> y) {
        return this.catPlot(seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)), false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catPlot(Comparable seriesName, List<T0> categories, Date[] y) {
        return this.catPlot(seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDate(y, new PlotInfo(this, seriesName)), true);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catPlot(Comparable seriesName, List<T0> categories, DateTime[] y) {
        return this.catPlot(seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDateTime(y, new PlotInfo(this, seriesName)), true);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catPlot(Comparable seriesName, List<T0> categories, short[] y) {
        return this.catPlot(seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)), false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catPlot(Comparable seriesName, List<T0> categories, int[] y) {
        return this.catPlot(seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)), false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catPlot(Comparable seriesName, List<T0> categories, long[] y) {
        return this.catPlot(seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)), false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catPlot(Comparable seriesName, List<T0> categories, float[] y) {
        return this.catPlot(seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)), false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal catPlot(Comparable seriesName, List<T0> categories, double[] y) {
        return this.catPlot(seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)), false);
    }

    @Override
    public <T0 extends Comparable, T1 extends Number> CategoryDataSeriesInternal catPlot(Comparable seriesName, List<T0> categories, T1[] y) {
        return this.catPlot(seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)), false);
    }

    @Override
    public <T0 extends Comparable, T1 extends Number> CategoryDataSeriesInternal catPlot(Comparable seriesName, List<T0> categories, List<T1> y) {
        return this.catPlot(seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)), false);
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal piePlot(Comparable seriesName, T0[] categories, short[] y) {
        return this.piePlot(seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), (IndexableNumericData)new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal piePlot(Comparable seriesName, T0[] categories, int[] y) {
        return this.piePlot(seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), (IndexableNumericData)new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal piePlot(Comparable seriesName, T0[] categories, long[] y) {
        return this.piePlot(seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), (IndexableNumericData)new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal piePlot(Comparable seriesName, T0[] categories, float[] y) {
        return this.piePlot(seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), (IndexableNumericData)new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal piePlot(Comparable seriesName, T0[] categories, double[] y) {
        return this.piePlot(seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), (IndexableNumericData)new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T0 extends Comparable, T1 extends Number> CategoryDataSeriesInternal piePlot(Comparable seriesName, T0[] categories, T1[] y) {
        return this.piePlot(seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), (IndexableNumericData)new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T0 extends Comparable, T1 extends Number> CategoryDataSeriesInternal piePlot(Comparable seriesName, T0[] categories, List<T1> y) {
        return this.piePlot(seriesName, new IndexableDataArray<T0>(categories, new PlotInfo(this, seriesName)), (IndexableNumericData)new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal piePlot(Comparable seriesName, List<T0> categories, short[] y) {
        return this.piePlot(seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), (IndexableNumericData)new IndexableNumericDataArrayShort(y, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal piePlot(Comparable seriesName, List<T0> categories, int[] y) {
        return this.piePlot(seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), (IndexableNumericData)new IndexableNumericDataArrayInt(y, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal piePlot(Comparable seriesName, List<T0> categories, long[] y) {
        return this.piePlot(seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), (IndexableNumericData)new IndexableNumericDataArrayLong(y, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal piePlot(Comparable seriesName, List<T0> categories, float[] y) {
        return this.piePlot(seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), (IndexableNumericData)new IndexableNumericDataArrayFloat(y, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T0 extends Comparable> CategoryDataSeriesInternal piePlot(Comparable seriesName, List<T0> categories, double[] y) {
        return this.piePlot(seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), (IndexableNumericData)new IndexableNumericDataArrayDouble(y, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T0 extends Comparable, T1 extends Number> CategoryDataSeriesInternal piePlot(Comparable seriesName, List<T0> categories, T1[] y) {
        return this.piePlot(seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), (IndexableNumericData)new IndexableNumericDataArrayNumber(y, new PlotInfo(this, seriesName)));
    }

    @Override
    public <T0 extends Comparable, T1 extends Number> CategoryDataSeriesInternal piePlot(Comparable seriesName, List<T0> categories, List<T1> y) {
        return this.piePlot(seriesName, new IndexableDataArray<Comparable>(categories.toArray(new Comparable[categories.size()]), new PlotInfo(this, seriesName)), (IndexableNumericData)new IndexableNumericDataListNumber<T1>(y, new PlotInfo(this, seriesName)));
    }
}

