/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import io.deephaven.gui.color.Color;
import io.deephaven.gui.color.Paint;
import io.deephaven.plot.Axis;
import io.deephaven.plot.ChartImpl;
import io.deephaven.plot.Font;
import io.deephaven.plot.axisformatters.AxisFormat;
import io.deephaven.plot.axistransformations.AxisTransform;
import io.deephaven.plot.axistransformations.AxisTransformBusinessCalendar;
import io.deephaven.plot.chartmodifiers.OneClickChartModifier;
import io.deephaven.plot.errors.PlotExceptionCause;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.filters.SelectableDataSet;
import io.deephaven.plot.util.tables.PartitionedTableHandle;
import io.deephaven.plot.util.tables.SwappableTable;
import io.deephaven.time.calendar.BusinessCalendar;
import io.deephaven.time.calendar.Calendars;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class AxisImpl
implements Axis,
PlotExceptionCause {
    private static final long serialVersionUID = -3995577961085156934L;
    private final ChartImpl chart;
    private final int dim;
    private final int id;
    private Type type;
    private boolean log = false;
    private String label;
    private Font labelFont;
    private Font ticksFont;
    private AxisFormat format;
    private String formatPattern;
    private Paint color;
    private double minRange = Double.NaN;
    private double maxRange = Double.NaN;
    private boolean minorTicksVisible = false;
    private boolean majorTicksVisible = true;
    private int minorTickCount = 0;
    private double gapBetweenMajorTicks = -1.0;
    private double[] majorTickLocations;
    private AxisTransform axisTransform;
    private double tickLabelAngle = 0.0;
    private boolean invert = false;
    private boolean isTimeAxis = false;
    private final Set<SwappableTable> swappableTables = new CopyOnWriteArraySet<SwappableTable>();
    private final Set<PartitionedTableHandle> partitionedTableHandles = new CopyOnWriteArraySet<PartitionedTableHandle>();
    public final Set<OneClickChartModifier> oneClickChartModifiers = new CopyOnWriteArraySet<OneClickChartModifier>();

    AxisImpl(ChartImpl chart, int dim, int id) {
        this.chart = chart;
        this.dim = dim;
        this.id = id;
    }

    protected AxisImpl(AxisImpl axis, ChartImpl chart) {
        this(chart, axis.dim, axis.id);
        this.type = axis.type;
        this.log = axis.log;
        this.label = axis.label;
        this.labelFont = axis.labelFont;
        this.ticksFont = axis.ticksFont;
        this.format = axis.format;
        this.formatPattern = axis.formatPattern;
        this.color = axis.color;
        this.minRange = axis.minRange;
        this.maxRange = axis.maxRange;
        this.minorTicksVisible = axis.minorTicksVisible;
        this.majorTicksVisible = axis.majorTicksVisible;
        this.minorTickCount = axis.minorTickCount;
        this.gapBetweenMajorTicks = axis.getGapBetweenMajorTicks();
        this.majorTickLocations = axis.majorTickLocations;
        this.axisTransform = axis.axisTransform;
        this.tickLabelAngle = axis.tickLabelAngle;
        this.invert = axis.invert;
        this.isTimeAxis = axis.isTimeAxis;
        this.swappableTables.addAll(axis.swappableTables);
        this.partitionedTableHandles.addAll(axis.partitionedTableHandles);
        this.oneClickChartModifiers.addAll(axis.oneClickChartModifiers);
    }

    public AxisImpl copy(ChartImpl chart) {
        return new AxisImpl(this, chart);
    }

    @Override
    public PlotInfo getPlotInfo() {
        return this.chart.getPlotInfo();
    }

    public int dim() {
        return this.dim;
    }

    public int id() {
        return this.id;
    }

    public Paint getColor() {
        return this.color;
    }

    void setType(Type type) {
        if (this.type != null && this.type != type) {
            throw new PlotUnsupportedOperationException("Switching axis types is not supported: " + this.type + " " + type, this);
        }
        this.type = type;
    }

    public ChartImpl chart() {
        return this.chart;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isLog() {
        return this.log;
    }

    public String getLabel() {
        return this.label;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public Font getTicksFont() {
        return this.ticksFont;
    }

    public AxisFormat getFormat() {
        return this.format;
    }

    public String getFormatPattern() {
        return this.formatPattern;
    }

    public boolean getInvert() {
        return this.invert;
    }

    public double getMinRange() {
        return this.minRange;
    }

    public double getMaxRange() {
        return this.maxRange;
    }

    public boolean isMinorTicksVisible() {
        return this.minorTicksVisible;
    }

    public boolean isMajorTicksVisible() {
        return this.majorTicksVisible;
    }

    public int getMinorTickCount() {
        return this.minorTickCount;
    }

    public double getGapBetweenMajorTicks() {
        return this.gapBetweenMajorTicks;
    }

    public double[] getMajorTickLocations() {
        return this.majorTickLocations;
    }

    public double getTickLabelAngle() {
        return this.tickLabelAngle;
    }

    public AxisTransform getAxisTransform() {
        return this.axisTransform;
    }

    public boolean isTimeAxis() {
        return this.isTimeAxis;
    }

    public void setTimeAxis(boolean timeAxis) {
        this.isTimeAxis = timeAxis;
    }

    public void addPartitionedTableHandle(PartitionedTableHandle map) {
        this.partitionedTableHandles.add(map);
    }

    public Set<SwappableTable> getSwappableTables() {
        return this.swappableTables;
    }

    public Set<PartitionedTableHandle> getPartitionedTableHandles() {
        return this.partitionedTableHandles;
    }

    public void addSwappableTable(SwappableTable st) {
        this.swappableTables.add(st);
        this.addPartitionedTableHandle(st.getPartitionedTableHandle());
    }

    public void addOneClickChartModifier(OneClickChartModifier oneClickChartModifier) {
        this.oneClickChartModifiers.add(oneClickChartModifier);
    }

    public Set<OneClickChartModifier> getOneClickChartModifiers() {
        return this.oneClickChartModifiers;
    }

    @Override
    public AxisImpl axisFormat(AxisFormat axisFormat) {
        this.format = axisFormat;
        return this;
    }

    @Override
    public AxisImpl axisFormatPattern(String axisFormatPattern) {
        this.formatPattern = axisFormatPattern;
        return this;
    }

    @Override
    public AxisImpl axisColor(Paint color) {
        this.color = color;
        return this;
    }

    @Override
    public AxisImpl axisColor(String color) {
        return this.axisColor((Paint)Color.color((String)color));
    }

    @Override
    public AxisImpl axisLabel(String label) {
        this.label = label;
        return this;
    }

    @Override
    public AxisImpl axisLabelFont(Font font) {
        this.labelFont = font;
        return this;
    }

    @Override
    public AxisImpl axisLabelFont(String family, String style, int size) {
        return this.axisLabelFont(Font.font(family, style, size));
    }

    @Override
    public AxisImpl ticksFont(Font font) {
        this.ticksFont = font;
        return this;
    }

    @Override
    public AxisImpl ticksFont(String family, String style, int size) {
        return this.ticksFont(Font.font(family, style, size));
    }

    @Override
    public AxisImpl transform(AxisTransform transform) {
        this.axisTransform = transform;
        return this;
    }

    @Override
    public AxisImpl log() {
        this.log = true;
        return this;
    }

    @Override
    public Axis log(boolean useLog) {
        this.log = useLog;
        return this;
    }

    @Override
    public AxisImpl businessTime(BusinessCalendar calendar) {
        return this.transform(new AxisTransformBusinessCalendar(calendar));
    }

    @Override
    public AxisImpl businessTime(SelectableDataSet sds, String calendar) {
        throw new PlotUnsupportedOperationException("Selectable business time transformation is not currently supported", this);
    }

    @Override
    public AxisImpl businessTime() {
        return this.businessTime(Calendars.calendar());
    }

    @Override
    public AxisImpl businessTime(boolean useBusinessTime) {
        return useBusinessTime ? this.businessTime() : this.transform(null);
    }

    @Override
    public AxisImpl invert() {
        this.invert(!this.invert);
        return this;
    }

    @Override
    public AxisImpl invert(boolean invert) {
        this.invert = invert;
        return this;
    }

    @Override
    public AxisImpl range(double min, double max) {
        this.min(min);
        this.max(max);
        return this;
    }

    @Override
    public AxisImpl min(double min) {
        this.minRange = min;
        return this;
    }

    @Override
    public AxisImpl max(double max) {
        this.maxRange = max;
        return this;
    }

    @Override
    public AxisImpl min(SelectableDataSet sds, String min) {
        throw new PlotUnsupportedOperationException("Selectable min transformation is not currently supported", this);
    }

    @Override
    public AxisImpl max(SelectableDataSet sds, String max) {
        throw new PlotUnsupportedOperationException("Selectable max transformation is not currently supported", this);
    }

    @Override
    public AxisImpl ticksVisible(boolean visible) {
        this.majorTicksVisible = visible;
        return this;
    }

    @Override
    public AxisImpl ticks(double gapBetweenTicks) {
        this.gapBetweenMajorTicks = gapBetweenTicks;
        this.majorTicksVisible = true;
        return this;
    }

    @Override
    public AxisImpl ticks(double[] tickLocations) {
        this.majorTickLocations = tickLocations;
        return this;
    }

    @Override
    public AxisImpl minorTicksVisible(boolean visible) {
        this.minorTicksVisible = visible;
        return this;
    }

    @Override
    public AxisImpl minorTicks(int nminor) {
        this.minorTickCount = nminor;
        this.minorTicksVisible = true;
        return this;
    }

    @Override
    public AxisImpl tickLabelAngle(double angle) {
        this.tickLabelAngle = angle;
        return this;
    }

    public static enum Type {
        NUMBER,
        CATEGORY;

    }
}

