/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import io.deephaven.api.Selectable;
import io.deephaven.configuration.Configuration;
import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.engine.table.PartitionedTable;
import io.deephaven.engine.table.Table;
import io.deephaven.gui.color.Color;
import io.deephaven.gui.color.Paint;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.BaseFigure;
import io.deephaven.plot.Chart;
import io.deephaven.plot.ChartArray;
import io.deephaven.plot.ChartImpl;
import io.deephaven.plot.DynamicChartTitle;
import io.deephaven.plot.Font;
import io.deephaven.plot.SeriesCollection;
import io.deephaven.plot.errors.PlotExceptionCause;
import io.deephaven.plot.errors.PlotIllegalArgumentException;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.errors.PlotRuntimeException;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.util.functions.FigureImplFunction;
import io.deephaven.plot.util.tables.PartitionedTableHandle;
import io.deephaven.plot.util.tables.TableBackedPartitionedTableHandle;
import io.deephaven.plot.util.tables.TableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class BaseFigureImpl
implements BaseFigure,
PlotExceptionCause {
    private static final long serialVersionUID = 2L;
    private final boolean resizable;
    private final ChartArray charts;
    private int numCols;
    private int numRows;
    private String title;
    private Font titleFont;
    private Paint titleColor;
    private PlotInfo plotInfo;
    private String figureName;
    private int sessionId;
    private long updateInterval = Configuration.getInstance().getLongWithDefault("plot.update.interval", 1000L);
    private transient Map<Table, Set<Function<Table, Table>>> tableFunctionMap;
    private transient Map<PartitionedTable, Set<Function<PartitionedTable, PartitionedTable>>> partitionedTableFunctionMap;
    private transient List<FigureImplFunction> figureFunctionList;

    public BaseFigureImpl() {
        this(1, 1, true);
    }

    public BaseFigureImpl(int numRows, int numCols) {
        this(numRows, numCols, false);
    }

    private BaseFigureImpl(int numRows, int numCols, boolean resizable) {
        this.numCols = numCols;
        this.numRows = numRows;
        this.charts = new ChartArray(numCols, numRows, this.getPlotInfo());
        this.resizable = resizable;
        this.plotInfo = new PlotInfo(this, null, (String)null);
    }

    protected BaseFigureImpl(BaseFigureImpl figure) {
        this.numCols = figure.numCols;
        this.numRows = figure.numRows;
        this.charts = new ChartArray(figure.numCols, figure.numRows, this.getPlotInfo());
        this.resizable = figure.resizable;
        this.updateInterval(figure.updateInterval);
        this.title = figure.title;
        this.titleFont = figure.titleFont;
        this.titleColor = figure.titleColor;
        this.plotInfo = new PlotInfo(this, null, (String)null);
        this.tableFunctionMap = figure.tableFunctionMap;
        this.partitionedTableFunctionMap = figure.partitionedTableFunctionMap;
        this.figureFunctionList = figure.figureFunctionList;
        for (ChartImpl chart : figure.charts.getCharts()) {
            this.charts.addChart(chart.copy(this));
        }
    }

    public BaseFigureImpl copy() {
        return new BaseFigureImpl(this);
    }

    public int getWidth() {
        return this.numCols;
    }

    public int getHeight() {
        return this.numRows;
    }

    public String getTitle() {
        return this.title;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Paint getTitleColor() {
        return this.titleColor;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public ChartArray getCharts() {
        return this.charts;
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public Set<TableHandle> getTableHandles() {
        HashSet<TableHandle> result = new HashSet<TableHandle>();
        for (ChartImpl chart : this.getCharts().getCharts()) {
            for (AxesImpl axes : chart.getAxes()) {
                for (SeriesCollection.SeriesDescription seriesDescription : axes.dataSeries().getSeriesDescriptions().values()) {
                    result.addAll(seriesDescription.getSeries().getTableHandles());
                }
            }
            if (!(chart.getChartTitle() instanceof DynamicChartTitle.ChartTitleTable)) continue;
            result.add(((DynamicChartTitle.ChartTitleTable)chart.getChartTitle()).getTableHandle());
        }
        return result;
    }

    public Set<PartitionedTableHandle> getPartitionedTableHandles() {
        HashSet<PartitionedTableHandle> result = new HashSet<PartitionedTableHandle>();
        for (ChartImpl chart : this.getCharts().getCharts()) {
            for (AxesImpl axes : chart.getAxes()) {
                result.addAll(axes.getPartitionedTableHandles());
            }
            if (!(chart.getChartTitle() instanceof DynamicChartTitle.ChartTitleSwappableTable)) continue;
            result.add(((DynamicChartTitle.ChartTitleSwappableTable)chart.getChartTitle()).getPartitionedTableHandle());
        }
        return result;
    }

    @Override
    public BaseFigureImpl figureRemoveSeries(String ... removeSeriesNames) {
        for (Chart chart : this.charts.getCharts()) {
            chart.chartRemoveSeries(removeSeriesNames);
        }
        return this;
    }

    public void registerTableFunction(Table t, Function<Table, Table> function) {
        if (this.tableFunctionMap == null) {
            this.tableFunctionMap = new HashMap<Table, Set<Function<Table, Table>>>();
        }
        this.tableFunctionMap.putIfAbsent(t, new LinkedHashSet());
        this.tableFunctionMap.get(t).add(function);
    }

    public Map<Table, Set<Function<Table, Table>>> getTableFunctionMap() {
        if (this.tableFunctionMap == null) {
            this.tableFunctionMap = new HashMap<Table, Set<Function<Table, Table>>>();
        }
        return this.tableFunctionMap;
    }

    public void registerPartitionedTableFunction(PartitionedTableHandle partitionedTableHandle, Function<Table, Table> tableTransform) {
        if (this.partitionedTableFunctionMap == null) {
            this.partitionedTableFunctionMap = new HashMap<PartitionedTable, Set<Function<PartitionedTable, PartitionedTable>>>();
        }
        PartitionedTable partitionedTable = partitionedTableHandle.getPartitionedTable();
        partitionedTableHandle.applyFunction(tableTransform);
        this.partitionedTableFunctionMap.computeIfAbsent(partitionedTable, pt -> new LinkedHashSet()).add(pt -> pt.transform(tableTransform::apply));
    }

    public Map<PartitionedTable, Set<Function<PartitionedTable, PartitionedTable>>> getPartitionedTableFunctionMap() {
        if (this.partitionedTableFunctionMap == null) {
            this.partitionedTableFunctionMap = new HashMap<PartitionedTable, Set<Function<PartitionedTable, PartitionedTable>>>();
        }
        return this.partitionedTableFunctionMap;
    }

    public void registerFigureFunction(FigureImplFunction function) {
        if (this.figureFunctionList == null) {
            this.figureFunctionList = new ArrayList<FigureImplFunction>();
        }
        this.figureFunctionList.add(function);
    }

    public List<FigureImplFunction> getFigureFunctionList() {
        if (this.figureFunctionList == null) {
            this.figureFunctionList = new ArrayList<FigureImplFunction>();
        }
        return this.figureFunctionList;
    }

    @Override
    public BaseFigureImpl updateInterval(long updateIntervalMillis) {
        this.updateInterval = updateIntervalMillis;
        return this;
    }

    @Override
    public BaseFigureImpl figureTitle(String title) {
        this.title = title;
        this.plotInfo = new PlotInfo(this, null, (String)null);
        return this;
    }

    @Override
    public BaseFigureImpl figureTitleFont(Font font) {
        this.titleFont = font;
        return this;
    }

    @Override
    public BaseFigureImpl figureTitleFont(String family, String style, int size) {
        return this.figureTitleFont(Font.font(family, style, size));
    }

    @Override
    public BaseFigureImpl figureTitleColor(Paint color) {
        this.titleColor = color;
        return this;
    }

    @Override
    public BaseFigureImpl figureTitleColor(String color) {
        this.titleColor = Color.color((String)color);
        return this;
    }

    @Override
    public ChartImpl newChart() {
        int index = this.charts.nextOpenIndex();
        if (index < 0) {
            if (this.resizable) {
                this.resize();
                return this.newChart();
            }
            throw new PlotRuntimeException("No open space for chart in figure", this);
        }
        return this.newChart(index);
    }

    @Override
    public ChartImpl newChart(int index) {
        int col = this.toCoordinate(index, 0, this.numCols);
        int row = this.toCoordinate(index, 1, this.numCols);
        return this.newChart(row, col);
    }

    @Override
    public ChartImpl newChart(int rowNum, int colNum) {
        ChartImpl c = new ChartImpl(this, rowNum, colNum);
        this.charts.addChart(c);
        return c;
    }

    @Override
    public BaseFigureImpl removeChart(int removeChartIndex) {
        return this.removeChart(this.toCoordinate(removeChartIndex, 0), this.toCoordinate(removeChartIndex, 1));
    }

    @Override
    public BaseFigureImpl removeChart(int removeChartRowNum, int removeChartColNum) {
        if (this.charts == null) {
            throw new PlotIllegalArgumentException("No charts created yet.", this);
        }
        this.charts.removeChart(removeChartRowNum, removeChartColNum);
        return this;
    }

    @Override
    public ChartImpl chart(int index) {
        int colNum = this.toCoordinate(index, 0, this.numCols);
        int rowNum = this.toCoordinate(index, 1, this.numCols);
        return this.charts.getChart(rowNum, colNum);
    }

    @Override
    public ChartImpl chart(int rowNum, int colNum) {
        return this.charts.getChart(rowNum, colNum);
    }

    void resizePlot(int rowNum, int colNum, int rowspan, int colspan) {
        if (this.charts == null) {
            throw new PlotIllegalArgumentException("No charts created yet.", this);
        }
        this.charts.resizeChart(rowNum, colNum, rowspan, colspan);
    }

    private int toCoordinate(int chart, int coord) {
        return this.toCoordinate(chart, coord, this.numCols);
    }

    private int toCoordinate(int chart, int coord, int gridWidth) {
        if (gridWidth == 0) {
            throw new PlotIllegalArgumentException("Can not determine chart location in grid; chart = " + chart, this);
        }
        switch (coord) {
            case 0: {
                return chart % gridWidth;
            }
            case 1: {
                return chart / gridWidth;
            }
        }
        throw new PlotIllegalArgumentException("Can not determine chart location in grid; coord = " + coord, this);
    }

    private void resize() {
        if (!this.resizable) {
            throw new PlotUnsupportedOperationException("Can't resize figure!", this);
        }
        if (this.numRows >= this.numCols) {
            ++this.numCols;
        } else {
            ++this.numRows;
        }
        this.charts.resize(this.numCols, this.numRows);
    }

    public void validateInitialization() {
        if (this.charts == null) {
            throw new PlotRuntimeException("No charts created yet.", this);
        }
        if (!this.charts.isInitialized()) {
            throw new PlotRuntimeException("No plots created yet.", this);
        }
    }

    @Override
    public PlotInfo getPlotInfo() {
        return this.plotInfo;
    }

    public void setName(String figureName) {
        this.figureName = figureName;
    }

    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    public String getName() {
        return this.figureName;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void consolidatePartitionedTables() {
        long updateInterval = this.getUpdateInterval();
        IdentityHashMap<Table, Set> thMap = new IdentityHashMap<Table, Set>();
        for (PartitionedTableHandle partitionedTableHandle : this.getPartitionedTableHandles()) {
            if (!(partitionedTableHandle instanceof TableBackedPartitionedTableHandle)) continue;
            thMap.computeIfAbsent(((TableBackedPartitionedTableHandle)partitionedTableHandle).getTable(), t -> new HashSet()).add(partitionedTableHandle);
        }
        for (Map.Entry entry : thMap.entrySet()) {
            Table table = (Table)entry.getKey();
            Set hs = (Set)entry.getValue();
            HashMap<Set, PartitionedTable> byColMap = new HashMap<Set, PartitionedTable>();
            for (PartitionedTableHandle h : hs) {
                Set<String> keyColumns = h.getKeyColumns();
                String[] keyColumnsArray = keyColumns.toArray(CollectionUtil.ZERO_LENGTH_STRING_ARRAY);
                PartitionedTable partitionedTable = byColMap.computeIfAbsent(keyColumns, x -> {
                    PartitionedTable handlePartitionedTable = h.getPartitionedTable();
                    return handlePartitionedTable == null ? table.partitionBy(keyColumnsArray) : handlePartitionedTable;
                });
                h.setPartitionedTable(partitionedTable);
                h.setKeyColumnsOrdered(keyColumnsArray);
            }
        }
    }

    public void consolidateTables() {
        IdentityHashMap<Table, Set> colMap = new IdentityHashMap<Table, Set>();
        IdentityHashMap<Table, Set> thMap = new IdentityHashMap<Table, Set>();
        for (TableHandle h : this.getTableHandles()) {
            Table table = h.getTable();
            colMap.computeIfAbsent(table, t -> new HashSet()).addAll(h.getColumns());
            thMap.computeIfAbsent(table, t -> new HashSet()).add(h);
        }
        for (Table table : colMap.keySet()) {
            Set cols = (Set)colMap.get(table);
            Set hs = (Set)thMap.get(table);
            Table t2 = (Table)table.view((Collection)Selectable.from((Collection)cols));
            for (TableHandle h : hs) {
                h.setTable(t2);
            }
        }
    }
}

