/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import io.deephaven.plot.ChartImpl;
import io.deephaven.plot.errors.PlotIllegalArgumentException;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ChartArray
implements Serializable {
    private static final long serialVersionUID = 4786818836320350714L;
    private final List<ChartImpl> charts = new ArrayList<ChartImpl>();
    private int[][] takenIndices;
    private final PlotInfo plotInfo;
    private static int EMPTY_INDEX = -1;

    ChartArray(int width, int height, PlotInfo plotInfo) {
        if (height < 1 || width < 1) {
            throw new PlotIllegalArgumentException("Grid must be at least 1x1", plotInfo);
        }
        this.takenIndices = new int[height][width];
        this.plotInfo = plotInfo;
        ChartArray.markAllNoCheck(this.takenIndices, 0, height, 0, width, EMPTY_INDEX);
    }

    public List<ChartImpl> getCharts() {
        return this.charts;
    }

    void addChart(ChartImpl chart) {
        int index = this.charts.size();
        this.markIndices(chart.row(), chart.column(), chart.rowSpan(), chart.colSpan(), index);
        this.charts.add(chart);
    }

    public int getIndex(int row, int col) {
        this.checkBounds(row, col);
        return this.takenIndices[row][col];
    }

    public static boolean isEmpty(int index) {
        return index == EMPTY_INDEX;
    }

    int nextOpenIndex() {
        int index = 0;
        int[][] nArray = this.takenIndices;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] takenIndice;
            for (int aTakenIndice : takenIndice = nArray[i]) {
                if (aTakenIndice == EMPTY_INDEX) {
                    return index;
                }
                ++index;
            }
        }
        return EMPTY_INDEX;
    }

    void resize(int width, int height) {
        if (width < this.takenIndices[0].length || height < this.takenIndices.length) {
            throw new PlotUnsupportedOperationException("Can not resize ChartArray to be smaller", this.plotInfo);
        }
        int[][] newArray = new int[height][width];
        ChartArray.markAllNoCheck(newArray, 0, height, 0, width, EMPTY_INDEX);
        for (int i = 0; i < this.takenIndices.length; ++i) {
            System.arraycopy(this.takenIndices[i], 0, newArray[i], 0, this.takenIndices[i].length);
        }
        this.takenIndices = newArray;
    }

    public ChartImpl getChart(int row, int col) {
        this.checkBounds(row, col);
        int index = this.takenIndices[row][col];
        if (index < 0 || index >= this.charts.size()) {
            return null;
        }
        return this.charts.get(index);
    }

    void removeChart(int row, int col) {
        this.checkBounds(row, col);
        int index = this.takenIndices[row][col];
        if (index < 0 || index > this.charts.size() - 1) {
            throw new PlotIllegalArgumentException("Can not remove chart at (" + row + ", " + col + ")- chart does not exist!", this.plotInfo);
        }
        ChartImpl chart = this.charts.get(index);
        if (chart == null) {
            throw new PlotIllegalArgumentException("Can not remove chart at (" + row + ", " + col + ")- chart does not exist!", this.plotInfo);
        }
        ChartArray.markAllNoCheck(this.takenIndices, chart.row(), chart.row() + chart.rowSpan(), chart.column(), chart.column() + chart.colSpan(), EMPTY_INDEX);
    }

    void resizeChart(int row, int col, int rowspan, int colspan) {
        this.checkBounds(row + rowspan - 1, col + colspan - 1);
        int index = this.takenIndices[row][col];
        this.markIndices(row, col, rowspan, colspan, index);
    }

    private void markIndices(int row, int col, int rowspan, int colspan, int index) {
        ChartImpl chart;
        int maxRow = row + rowspan;
        int maxCol = col + colspan;
        this.checkBounds(maxRow - 1, maxCol - 1);
        for (int i = row; i < maxRow; ++i) {
            for (int j = col; j < maxCol; ++j) {
                if (this.takenIndices[i][j] == index || this.takenIndices[i][j] == EMPTY_INDEX) continue;
                this.removeChart(row, col);
            }
        }
        if (index >= 0 && index <= this.charts.size() - 1 && (chart = this.charts.get(index)) != null && (rowspan < chart.rowSpan() || colspan < chart.colSpan())) {
            ChartArray.markAllNoCheck(this.takenIndices, chart.row(), chart.row() + chart.rowSpan(), chart.column(), chart.column() + chart.colSpan(), EMPTY_INDEX);
        }
        ChartArray.markAllNoCheck(this.takenIndices, row, maxRow, col, maxCol, index);
    }

    private static void markAllNoCheck(int[][] matrix, int rowMin, int rowMax, int colMin, int colMax, int index) {
        for (int i = rowMin; i < rowMax; ++i) {
            for (int j = colMin; j < colMax; ++j) {
                matrix[i][j] = index;
            }
        }
    }

    private void checkBounds(int row, int col) {
        if (row < 0 || col < 0) {
            throw new PlotIllegalArgumentException("Chart indices must be >0. row:" + row + " col:" + col, this.plotInfo);
        }
        if (row >= this.takenIndices.length || col >= this.takenIndices[0].length) {
            throw new PlotIllegalArgumentException("Chart is not in grid. Trying to access chart at position [" + (row + 1) + "x" + (col + 1) + "], chart grid is [" + this.takenIndices.length + "x" + this.takenIndices[0].length + "]", this.plotInfo);
        }
    }

    boolean isInitialized() {
        boolean initialized = true;
        for (ChartImpl chart : this.charts) {
            initialized &= chart.isInitialized();
        }
        return initialized;
    }
}

