/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import io.deephaven.configuration.Configuration;
import io.deephaven.plot.errors.PlotInfo;
import java.io.Serializable;

public class ChartTitle
implements Serializable {
    private String staticTitle;
    private PlotInfo plotInfo;
    static final String MAX_VISIBLE_ROWS_COUNT_PROP = "Plot.chartTitle.maxRowsInTitle";
    int maxVisibleRowsCount;

    ChartTitle(PlotInfo plotInfo) {
        this(plotInfo, Configuration.getInstance().getIntegerWithDefault(MAX_VISIBLE_ROWS_COUNT_PROP, 3));
    }

    ChartTitle(PlotInfo plotInfo, int maxVisibleRowsCount) {
        this.plotInfo = plotInfo;
        this.maxVisibleRowsCount = maxVisibleRowsCount;
    }

    void copy(ChartTitle chartTitle) {
        this.staticTitle = chartTitle.staticTitle;
        this.plotInfo = chartTitle.plotInfo;
        this.maxVisibleRowsCount = chartTitle.maxVisibleRowsCount;
    }

    public PlotInfo getPlotInfo() {
        return this.plotInfo;
    }

    void setStaticTitle(String staticTitle) {
        this.staticTitle = staticTitle;
    }

    synchronized String getTitle() {
        return this.staticTitle == null ? "" : this.staticTitle;
    }
}

