/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import java.awt.GraphicsEnvironment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class Font
implements Serializable {
    private static final long serialVersionUID = -524274466614096214L;
    private static final Map<String, FontStyle> extraFontStyles = new LinkedHashMap<String, FontStyle>();
    private final String family;
    private final FontStyle style;
    private final int size;
    private final java.awt.Font font;

    public static FontStyle fontStyle(String style) {
        if (style == null) {
            throw new IllegalArgumentException("Style can not be null");
        }
        style = style.toUpperCase().trim();
        try {
            return FontStyle.valueOf(style);
        }
        catch (Exception exception) {
            FontStyle fontStyle = extraFontStyles.get(style);
            if (fontStyle != null) {
                return fontStyle;
            }
            throw new UnsupportedOperationException("FontStyle " + style + " not defined");
        }
    }

    public static String[] fontStyleNames() {
        ArrayList<String> names = new ArrayList<String>();
        Arrays.stream(FontStyle.values()).forEach(x -> names.add(x.name()));
        names.addAll(extraFontStyles.keySet());
        return (String[])names.stream().toArray(String[]::new);
    }

    public Font(String family, FontStyle style, int size) {
        this.family = family == null ? "Arial" : family;
        this.style = style == null ? FontStyle.PLAIN : style;
        this.size = size;
        this.font = new java.awt.Font(this.family, this.style.mask(), this.size);
    }

    public Font(String family, String style, int size) {
        this(family, Font.fontStyle(style), size);
    }

    public String toString() {
        return "Font{" + this.family + "," + this.style + "," + this.size + "}";
    }

    public static Font font(String family, FontStyle style, int size) {
        return new Font(family, style, size);
    }

    public static Font font(String family, String style, int size) {
        return new Font(family, style, size);
    }

    public static String[] fontFamilyNames() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    public Font refamily(String family) {
        return new Font(family, this.style, this.size);
    }

    public Font restyle(FontStyle style) {
        return new Font(this.family, style, this.size);
    }

    public Font restyle(String style) {
        return new Font(this.family, style, this.size);
    }

    public Font resize(int size) {
        return new Font(this.family, this.style, size);
    }

    public java.awt.Font javaFont() {
        return this.font;
    }

    public boolean equals(Object obj) {
        return obj instanceof Font && ((Font)obj).font.equals(this.font);
    }

    public int hashCode() {
        return this.font.hashCode();
    }

    static {
        extraFontStyles.put("P", FontStyle.PLAIN);
        extraFontStyles.put("B", FontStyle.BOLD);
        extraFontStyles.put("I", FontStyle.ITALIC);
        extraFontStyles.put("BI", FontStyle.BOLD_ITALIC);
        extraFontStyles.put("IB", FontStyle.BOLD_ITALIC);
    }

    public static enum FontStyle {
        PLAIN(0),
        BOLD(1),
        ITALIC(2),
        BOLD_ITALIC(3);

        private final int mask;

        private FontStyle(int mask) {
            this.mask = mask;
        }

        public int mask() {
            return this.mask;
        }
    }
}

